/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.cache;

import java.io.Serializable;
import java.util.Properties;

/**
 * Provides cache(s) that can be used throughout the system. The actual
 * internal implementation can vary (e.g. a simple Map-mechanism could
 * be used, or something more complex like JCS).
 * 
 * @author afe
 *
 */
public interface CacheManager {
	/**
	 * Creates a cache for given key and value classes using a given ID. If
	 * properties is not specified (<code>null</code>), the cache manager will
	 * look in the USM configuration file for a property called com.openexchange.usm.cache.properties.&lt;id&gt;,
	 * where id equals the first parameter. If this property is set, is specifies the properties file to use
	 * for the cache. If it is not set, the manager will look for a property called
	 * com.openexchange.usm.cache.properties.default and use the properties file specified
	 * there. If this is also not available, the CacheManager will use default fallback properties.
	 * 
	 * @param <K> type that is valid for keys for the generated cache
	 * @param <V> type that is valid for values for the generated cache
	 * @param id identifier to use for the cache (for monitoring/logging purposes)
	 * @param keyClass Class that identifies the key type
	 * @param valueClass Class that identifies the value type
	 * @param properties additional properties to configure the cache 
	 *        if <code>null</code> than default cache properties are used
	 *        for each cache ID, the keys in the properties should start with: "jcs.region." + ID or "jcs.default" for using default properties
	 * @return Newly created cache
	 */
	<K extends Serializable, V extends Serializable> Cache<K, V> createCache(String id, Class<K> keyClass,
			Class<V> valueClass, Properties properties);

	/**
	 * Creates a cache for given key and value classes using a given ID. 
	 * Behaves as <code>createCache(id, keyClass, valueClass, null)</code>.
	 * 
	 * @param <K>
	 * @param <V>
	 * @param id
	 * @param keyClass
	 * @param valueClass
	 * @return
	 */
	<K extends Serializable, V extends Serializable> Cache<K, V> createCache(String id, Class<K> keyClass,
			Class<V> valueClass);
}
