/*
 *  Copyright 2010, Plutext Pty Ltd.
 *
 *  This file is part of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.

    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

 */


package org.xlsx4j.sml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for CT_TableStyles complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="CT_TableStyles">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="tableStyle" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}CT_TableStyle" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="count" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" />
 *       &lt;attribute name="defaultTableStyle" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="defaultPivotStyle" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_TableStyles", propOrder = {
    "tableStyle"
})
public class CTTableStyles {

    protected List<CTTableStyle> tableStyle;
    @XmlAttribute
    @XmlSchemaType(name = "unsignedInt")
    protected Long count;
    @XmlAttribute
    protected String defaultTableStyle;
    @XmlAttribute
    protected String defaultPivotStyle;

    /**
     * Gets the value of the tableStyle property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the tableStyle property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTableStyle().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CTTableStyle }
     *
     *
     */
    public List<CTTableStyle> getTableStyle() {
        if (tableStyle == null) {
            tableStyle = new ArrayList<CTTableStyle>();
        }
        return this.tableStyle;
    }

    /**
     * Gets the value of the defaultTableStyle property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public String getDefaultTableStyle() {
        return defaultTableStyle;
    }

    /**
     * Sets the value of the defaultTableStyle property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setDefaultTableStyle(String value) {
        this.defaultTableStyle = value;
    }

    /**
     * Gets the value of the defaultPivotStyle property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public String getDefaultPivotStyle() {
        return defaultPivotStyle;
    }

    /**
     * Sets the value of the defaultPivotStyle property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setDefaultPivotStyle(String value) {
        this.defaultPivotStyle = value;
    }

    @SuppressWarnings("unused")
    public void beforeMarshal(Marshaller marshaller) {
        this.count = tableStyle!=null?(long)tableStyle.size():0;
    }
}
