/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package org.docx4j.wml;

import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlTransient;
import org.jvnet.jaxb2_commons.ppp.Child;

@XmlTransient
public abstract class RPrBase implements Child
{
    protected RStyle rStyle;
    protected RFonts rFonts;
    protected BooleanDefaultTrue b;
    protected BooleanDefaultTrue bCs;
    protected BooleanDefaultTrue i;
    protected BooleanDefaultTrue iCs;
    protected BooleanDefaultTrue caps;
    protected BooleanDefaultTrue smallCaps;
    protected BooleanDefaultTrue strike;
    protected BooleanDefaultTrue dstrike;
    protected BooleanDefaultTrue outline;
    protected BooleanDefaultTrue shadow;
    protected BooleanDefaultTrue emboss;
    protected BooleanDefaultTrue imprint;
    protected BooleanDefaultTrue noProof;
    protected BooleanDefaultTrue snapToGrid;
    protected BooleanDefaultTrue vanish;
    protected BooleanDefaultTrue webHidden;
    protected Color color;
    protected CTSignedTwipsMeasure spacing;
    protected CTTextScale w;
    protected HpsMeasure kern;
    protected CTSignedHpsMeasure position;
    protected HpsMeasure sz;
    protected HpsMeasure szCs;
    protected Highlight highlight;
    protected U u;
    protected CTTextEffect effect;
    protected CTBorder bdr;
    protected CTShd shd;
    protected CTFitText fitText;
    protected CTVerticalAlignRun vertAlign;
    protected BooleanDefaultTrue rtl;
    protected BooleanDefaultTrue cs;
    protected CTEm em;
    protected CTLanguage lang;
    protected CTEastAsianLayout eastAsianLayout;
    protected BooleanDefaultTrue specVanish;
    protected BooleanDefaultTrue oMath;
    @XmlTransient
    private Object parent;

    /**
     * Gets the value of the rStyle property.
     *
     * @return
     *     possible object is
     *     {@link RStyle }
     *
     */
    public RStyle getRStyle() {
        return rStyle;
    }

    /**
     * Sets the value of the rStyle property.
     *
     * @param value
     *     allowed object is
     *     {@link RStyle }
     *
     */
    public void setRStyle(RStyle value) {
        this.rStyle = value;
    }

    /**
     * Gets the value of the rFonts property.
     *
     * @return
     *     possible object is
     *     {@link RFonts }
     *
     */
    public RFonts getRFonts() {
        return rFonts;
    }

    /**
     * Sets the value of the rFonts property.
     *
     * @param value
     *     allowed object is
     *     {@link RFonts }
     *
     */
    public void setRFonts(RFonts value) {
        this.rFonts = value;
    }

    /**
     * Gets the value of the b property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getB() {
        return b;
    }

    /**
     * Sets the value of the b property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setB(BooleanDefaultTrue value) {
        this.b = value;
    }

    /**
     * Gets the value of the bCs property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getBCs() {
        return bCs;
    }

    /**
     * Sets the value of the bCs property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setBCs(BooleanDefaultTrue value) {
        this.bCs = value;
    }

    /**
     * Gets the value of the i property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getI() {
        return i;
    }

    /**
     * Sets the value of the i property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setI(BooleanDefaultTrue value) {
        this.i = value;
    }

    /**
     * Gets the value of the iCs property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getICs() {
        return iCs;
    }

    /**
     * Sets the value of the iCs property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setICs(BooleanDefaultTrue value) {
        this.iCs = value;
    }

    /**
     * Gets the value of the caps property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getCaps() {
        return caps;
    }

    /**
     * Sets the value of the caps property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setCaps(BooleanDefaultTrue value) {
        this.caps = value;
    }

    /**
     * Gets the value of the smallCaps property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getSmallCaps() {
        return smallCaps;
    }

    /**
     * Sets the value of the smallCaps property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setSmallCaps(BooleanDefaultTrue value) {
        this.smallCaps = value;
    }

    /**
     * Gets the value of the strike property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getStrike() {
        return strike;
    }

    /**
     * Sets the value of the strike property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setStrike(BooleanDefaultTrue value) {
        this.strike = value;
    }

    /**
     * Gets the value of the dstrike property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getDstrike() {
        return dstrike;
    }

    /**
     * Sets the value of the dstrike property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setDstrike(BooleanDefaultTrue value) {
        this.dstrike = value;
    }

    /**
     * Gets the value of the outline property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getOutline() {
        return outline;
    }

    /**
     * Sets the value of the outline property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setOutline(BooleanDefaultTrue value) {
        this.outline = value;
    }

    /**
     * Gets the value of the shadow property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getShadow() {
        return shadow;
    }

    /**
     * Sets the value of the shadow property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setShadow(BooleanDefaultTrue value) {
        this.shadow = value;
    }

    /**
     * Gets the value of the emboss property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getEmboss() {
        return emboss;
    }

    /**
     * Sets the value of the emboss property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setEmboss(BooleanDefaultTrue value) {
        this.emboss = value;
    }

    /**
     * Gets the value of the imprint property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getImprint() {
        return imprint;
    }

    /**
     * Sets the value of the imprint property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setImprint(BooleanDefaultTrue value) {
        this.imprint = value;
    }

    /**
     * Gets the value of the noProof property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getNoProof() {
        return noProof;
    }

    /**
     * Sets the value of the noProof property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setNoProof(BooleanDefaultTrue value) {
        this.noProof = value;
    }

    /**
     * Gets the value of the snapToGrid property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getSnapToGrid() {
        return snapToGrid;
    }

    /**
     * Sets the value of the snapToGrid property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setSnapToGrid(BooleanDefaultTrue value) {
        this.snapToGrid = value;
    }

    /**
     * Gets the value of the vanish property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getVanish() {
        return vanish;
    }

    /**
     * Sets the value of the vanish property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setVanish(BooleanDefaultTrue value) {
        this.vanish = value;
    }

    /**
     * Gets the value of the webHidden property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getWebHidden() {
        return webHidden;
    }

    /**
     * Sets the value of the webHidden property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setWebHidden(BooleanDefaultTrue value) {
        this.webHidden = value;
    }

    /**
     * Gets the value of the color property.
     *
     * @return
     *     possible object is
     *     {@link Color }
     *
     */
    public Color getColor() {
        return color;
    }

    /**
     * Sets the value of the color property.
     *
     * @param value
     *     allowed object is
     *     {@link Color }
     *
     */
    public void setColor(Color value) {
        this.color = value;
    }

    /**
     * Gets the value of the spacing property.
     *
     * @return
     *     possible object is
     *     {@link CTSignedTwipsMeasure }
     *
     */
    public CTSignedTwipsMeasure getSpacing() {
        return spacing;
    }

    /**
     * Sets the value of the spacing property.
     *
     * @param value
     *     allowed object is
     *     {@link CTSignedTwipsMeasure }
     *
     */
    public void setSpacing(CTSignedTwipsMeasure value) {
        this.spacing = value;
    }

    /**
     * Gets the value of the w property.
     *
     * @return
     *     possible object is
     *     {@link CTTextScale }
     *
     */
    public CTTextScale getW() {
        return w;
    }

    /**
     * Sets the value of the w property.
     *
     * @param value
     *     allowed object is
     *     {@link CTTextScale }
     *
     */
    public void setW(CTTextScale value) {
        this.w = value;
    }

    /**
     * Gets the value of the kern property.
     *
     * @return
     *     possible object is
     *     {@link HpsMeasure }
     *
     */
    public HpsMeasure getKern() {
        return kern;
    }

    /**
     * Sets the value of the kern property.
     *
     * @param value
     *     allowed object is
     *     {@link HpsMeasure }
     *
     */
    public void setKern(HpsMeasure value) {
        this.kern = value;
    }

    /**
     * Gets the value of the position property.
     *
     * @return
     *     possible object is
     *     {@link CTSignedHpsMeasure }
     *
     */
    public CTSignedHpsMeasure getPosition() {
        return position;
    }

    /**
     * Sets the value of the position property.
     *
     * @param value
     *     allowed object is
     *     {@link CTSignedHpsMeasure }
     *
     */
    public void setPosition(CTSignedHpsMeasure value) {
        this.position = value;
    }

    /**
     * Gets the value of the sz property.
     *
     * @return
     *     possible object is
     *     {@link HpsMeasure }
     *
     */
    public HpsMeasure getSz() {
        return sz;
    }

    /**
     * Sets the value of the sz property.
     *
     * @param value
     *     allowed object is
     *     {@link HpsMeasure }
     *
     */
    public void setSz(HpsMeasure value) {
        this.sz = value;
    }

    /**
     * Gets the value of the szCs property.
     *
     * @return
     *     possible object is
     *     {@link HpsMeasure }
     *
     */
    public HpsMeasure getSzCs() {
        return szCs;
    }

    /**
     * Sets the value of the szCs property.
     *
     * @param value
     *     allowed object is
     *     {@link HpsMeasure }
     *
     */
    public void setSzCs(HpsMeasure value) {
        this.szCs = value;
    }

    /**
     * Gets the value of the highlight property.
     *
     * @return
     *     possible object is
     *     {@link Highlight }
     *
     */
    public Highlight getHighlight() {
        return highlight;
    }

    /**
     * Sets the value of the highlight property.
     *
     * @param value
     *     allowed object is
     *     {@link Highlight }
     *
     */
    public void setHighlight(Highlight value) {
        this.highlight = value;
    }

    /**
     * Gets the value of the u property.
     *
     * @return
     *     possible object is
     *     {@link U }
     *
     */
    public U getU() {
        return u;
    }

    /**
     * Sets the value of the u property.
     *
     * @param value
     *     allowed object is
     *     {@link U }
     *
     */
    public void setU(U value) {
        this.u = value;
    }

    /**
     * Gets the value of the effect property.
     *
     * @return
     *     possible object is
     *     {@link CTTextEffect }
     *
     */
    public CTTextEffect getEffect() {
        return effect;
    }

    /**
     * Sets the value of the effect property.
     *
     * @param value
     *     allowed object is
     *     {@link CTTextEffect }
     *
     */
    public void setEffect(CTTextEffect value) {
        this.effect = value;
    }

    /**
     * Gets the value of the bdr property.
     *
     * @return
     *     possible object is
     *     {@link CTBorder }
     *
     */
    public CTBorder getBdr() {
        return bdr;
    }

    /**
     * Sets the value of the bdr property.
     *
     * @param value
     *     allowed object is
     *     {@link CTBorder }
     *
     */
    public void setBdr(CTBorder value) {
        this.bdr = value;
    }

    /**
     * Gets the value of the shd property.
     *
     * @return
     *     possible object is
     *     {@link CTShd }
     *
     */
    public CTShd getShd() {
        return shd;
    }

    /**
     * Sets the value of the shd property.
     *
     * @param value
     *     allowed object is
     *     {@link CTShd }
     *
     */
    public void setShd(CTShd value) {
        this.shd = value;
    }

    /**
     * Gets the value of the fitText property.
     *
     * @return
     *     possible object is
     *     {@link CTFitText }
     *
     */
    public CTFitText getFitText() {
        return fitText;
    }

    /**
     * Sets the value of the fitText property.
     *
     * @param value
     *     allowed object is
     *     {@link CTFitText }
     *
     */
    public void setFitText(CTFitText value) {
        this.fitText = value;
    }

    /**
     * Gets the value of the vertAlign property.
     *
     * @return
     *     possible object is
     *     {@link CTVerticalAlignRun }
     *
     */
    public CTVerticalAlignRun getVertAlign() {
        return vertAlign;
    }

    /**
     * Sets the value of the vertAlign property.
     *
     * @param value
     *     allowed object is
     *     {@link CTVerticalAlignRun }
     *
     */
    public void setVertAlign(CTVerticalAlignRun value) {
        this.vertAlign = value;
    }

    /**
     * Gets the value of the rtl property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getRtl() {
        return rtl;
    }

    /**
     * Sets the value of the rtl property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setRtl(BooleanDefaultTrue value) {
        this.rtl = value;
    }

    /**
     * Gets the value of the cs property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getCs() {
        return cs;
    }

    /**
     * Sets the value of the cs property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setCs(BooleanDefaultTrue value) {
        this.cs = value;
    }

    /**
     * Gets the value of the em property.
     *
     * @return
     *     possible object is
     *     {@link CTEm }
     *
     */
    public CTEm getEm() {
        return em;
    }

    /**
     * Sets the value of the em property.
     *
     * @param value
     *     allowed object is
     *     {@link CTEm }
     *
     */
    public void setEm(CTEm value) {
        this.em = value;
    }

    /**
     * Gets the value of the lang property.
     *
     * @return
     *     possible object is
     *     {@link CTLanguage }
     *
     */
    public CTLanguage getLang() {
        return lang;
    }

    /**
     * Sets the value of the lang property.
     *
     * @param value
     *     allowed object is
     *     {@link CTLanguage }
     *
     */
    public void setLang(CTLanguage value) {
        this.lang = value;
    }

    /**
     * Gets the value of the eastAsianLayout property.
     *
     * @return
     *     possible object is
     *     {@link CTEastAsianLayout }
     *
     */
    public CTEastAsianLayout getEastAsianLayout() {
        return eastAsianLayout;
    }

    /**
     * Sets the value of the eastAsianLayout property.
     *
     * @param value
     *     allowed object is
     *     {@link CTEastAsianLayout }
     *
     */
    public void setEastAsianLayout(CTEastAsianLayout value) {
        this.eastAsianLayout = value;
    }

    /**
     * Gets the value of the specVanish property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getSpecVanish() {
        return specVanish;
    }

    /**
     * Sets the value of the specVanish property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setSpecVanish(BooleanDefaultTrue value) {
        this.specVanish = value;
    }

    /**
     * Gets the value of the oMath property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getOMath() {
        return oMath;
    }

    /**
     * Sets the value of the oMath property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setOMath(BooleanDefaultTrue value) {
        this.oMath = value;
    }

    /**
     * Gets the parent object in the object tree representing the unmarshalled xml document.
     *
     * @return
     *     The parent object.
     */
    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Object parent) {
        this.parent = parent;
    }

    /**
     * This method is invoked by the JAXB implementation on each instance when unmarshalling completes.
     *
     * @param parent
     *     The parent object in the object tree.
     * @param unmarshaller
     *     The unmarshaller that generated the instance.
     */
    public void afterUnmarshal(Unmarshaller unmarshaller, Object _parent) {
        setParent(_parent);
    }

}
