/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.odf;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.json.JSONObject;
import com.openexchange.log.LogFactory;
import com.openexchange.office.DocumentProperties;
import com.openexchange.office.FilterException;
import com.openexchange.office.FilterException.ErrorCode;
import com.openexchange.office.IImporter;
import com.openexchange.server.ServiceLookup;

/**
 * {@link Importer}
 *
 * @author <a href="mailto:svante.schubert@open-xchange.com">Svante Schubert</a>
 */
public class Importer implements IImporter {

    private final static Log LOG = LogFactory.getLog(Importer.class);

    final ServiceLookup services;

    /**
     * Initializes a new {@link Importer}.
     */
    public Importer(ServiceLookup _services) {
        super();
        services = _services;
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.office.IImporter#createOperations(java.io.InputStream)
     */
    @Override
    public JSONObject createOperations(InputStream inputDocumentStm, DocumentProperties documentProperties) throws FilterException {

        JSONObject result = null;

        if (null != inputDocumentStm) {
            OdfOperationDoc odfdomDocument = null;

            try {

                odfdomDocument = new OdfOperationDoc(services, inputDocumentStm, null, documentProperties.optString(
                    DocumentProperties.PROP_USER_LANGUAGE,
                    ""));
                result = odfdomDocument.getOperations();
                /*
                 * document size is no longer needed, the editor is calculating loading time on its own // add documentSize element to
                 * result if (null != result) { final long documentSize = odfdomDocument.getContentSize(); result.put("documentSize",
                 * documentSize <= 0 ? -1 : documentSize); }
                 */
            } catch (Throwable e) {
                LOG.error("ODF Filter could not load the given document:", e);
                if (e instanceof FilterException) {
                    throw (FilterException) e;
                } else if (e instanceof java.util.zip.ZipException && e.getMessage().contains(
                    "only DEFLATED entries can have EXT descriptor")) {
                    throw new FilterException(e, ErrorCode.UNSUPPORTED_ENCRYPTION_USED);
                } else {
                    throw new FilterException(e, ErrorCode.CRITICAL_ERROR);
                }
            } finally {
                try {
                    inputDocumentStm.close();
                } catch (IOException e) {
                    LOG.error("Document stream could not be closed:", e);
                }

                if (null != odfdomDocument) {
                    odfdomDocument.close();
                }
            }
        }

        return result;
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.office.IImporter#getDefaultDocument(com.openexchange.office.DocumentType)
     */
    @Override
    public InputStream getDefaultDocument(String documentTypeName, InputStream templateDocument, DocumentProperties docProps) {
        return templateDocument;
    }
}
