/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */


package org.xlsx4j.sml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.docx4j.jaxb.Context;


/**
 * <p>Java class for CT_DataValidation complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 *
 * http://schemas.microsoft.com/office/spreadsheetml/2009/9/main
 *
 * <xsd:complexType name="CT_DataValidation">
 *   <xsd:sequence>
 *     <xsd:element name="formula1" type="CT_DataValidationFormula" minOccurs="0" maxOccurs="1"/>
 *     <xsd:element name="formula2" type="CT_DataValidationFormula" minOccurs="0" maxOccurs="1"/>
 *     <xsd:element ref="xm:sqref" minOccurs="1" maxOccurs="1"/>
 *   </xsd:sequence>
 *   <xsd:attribute name="type" type="x:ST_DataValidationType" use="optional" default="none"/>
 *   <xsd:attribute name="errorStyle" type="x:ST_DataValidationErrorStyle" use="optional" default="stop"/>
 *   <xsd:attribute name="imeMode" type="x:ST_DataValidationImeMode" use="optional" default="noControl"/>
 *   <xsd:attribute name="operator" type="x:ST_DataValidationOperator" use="optional" default="between"/>
 *   <xsd:attribute name="allowBlank" type="xsd:boolean" use="optional" default="false"/>
 *   <xsd:attribute name="showDropDown" type="xsd:boolean" use="optional" default="false"/>
 *   <xsd:attribute name="showInputMessage" type="xsd:boolean" use="optional" default="false"/>
 *   <xsd:attribute name="showErrorMessage" type="xsd:boolean" use="optional" default="false"/>
 *   <xsd:attribute name="errorTitle" type="x:ST_Xstring" use="optional"/>
 *   <xsd:attribute name="error" type="x:ST_Xstring" use="optional"/>
 *   <xsd:attribute name="promptTitle" type="x:ST_Xstring" use="optional"/>
 *   <xsd:attribute name="prompt" type="x:ST_Xstring" use="optional"/>
 * </xsd:complexType> *
 *
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "dataValidation", namespace="http://schemas.microsoft.com/office/spreadsheetml/2009/9/main",
    propOrder = {
    "formula1",
    "formula2",
    "sqref"
})
public class CTDataValidation_legacy implements DataValidation {

    protected CTDataValidationFormula_legacy formula1;
    protected CTDataValidationFormula_legacy formula2;
    @XmlElement(namespace="http://schemas.microsoft.com/office/excel/2006/main")
    protected String sqref;
    @XmlTransient
    protected List<String> sqrefList;
    @XmlAttribute
    protected STDataValidationType type;
    @XmlAttribute
    protected STDataValidationErrorStyle errorStyle;
    @XmlAttribute
    protected STDataValidationImeMode imeMode;
    @XmlAttribute
    protected STDataValidationOperator operator;
    @XmlAttribute
    protected Boolean allowBlank;
    @XmlAttribute
    protected Boolean showDropDown;
    @XmlAttribute
    protected Boolean showInputMessage;
    @XmlAttribute
    protected Boolean showErrorMessage;
    @XmlAttribute
    protected String errorTitle;
    @XmlAttribute
    protected String error;
    @XmlAttribute
    protected String promptTitle;
    @XmlAttribute
    protected String prompt;

    /**
     * Gets the value of the formula1 property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    @Override
    public String getFormula1() {
        return formula1!=null ? formula1.getF() : null;
    }

    /**
     * Sets the value of the formula1 property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    @Override
    public void setFormula1(String value) {
        if(formula1==null) {
            formula1 = Context.getsmlObjectFactory().createCTDataValidationFormula_legacy();
        }
        formula1.setF(value);
    }

    /**
     * Gets the value of the formula2 property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    @Override
    public String getFormula2() {
        return formula2!=null ? formula2.getF() : null;
    }

    /**
     * Sets the value of the formula2 property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    @Override
    public void setFormula2(String value) {
        if(formula2==null) {
            formula2 = Context.getsmlObjectFactory().createCTDataValidationFormula_legacy();
        }
        formula2.setF(value);
    }

    /**
     * Gets the value of the type property.
     *
     * @return
     *     possible object is
     *     {@link STDataValidationType }
     *
     */
    @Override
    public STDataValidationType getType() {
        if (type == null) {
            return STDataValidationType.NONE;
        }
        return type;
    }

    /**
     * Sets the value of the type property.
     *
     * @param value
     *     allowed object is
     *     {@link STDataValidationType }
     *
     */
    @Override
    public void setType(STDataValidationType value) {
        this.type = value;
    }

    /**
     * Gets the value of the errorStyle property.
     *
     * @return
     *     possible object is
     *     {@link STDataValidationErrorStyle }
     *
     */
    @Override
    public STDataValidationErrorStyle getErrorStyle() {
        if (errorStyle == null) {
            return STDataValidationErrorStyle.STOP;
        }
        return errorStyle;
    }

    /**
     * Sets the value of the errorStyle property.
     *
     * @param value
     *     allowed object is
     *     {@link STDataValidationErrorStyle }
     *
     */
    @Override
    public void setErrorStyle(STDataValidationErrorStyle value) {
        this.errorStyle = value;
    }

    /**
     * Gets the value of the imeMode property.
     *
     * @return
     *     possible object is
     *     {@link STDataValidationImeMode }
     *
     */
    @Override
    public STDataValidationImeMode getImeMode() {
        if (imeMode == null) {
            return STDataValidationImeMode.NO_CONTROL;
        }
        return imeMode;
    }

    /**
     * Sets the value of the imeMode property.
     *
     * @param value
     *     allowed object is
     *     {@link STDataValidationImeMode }
     *
     */
    @Override
    public void setImeMode(STDataValidationImeMode value) {
        this.imeMode = value;
    }

    /**
     * Gets the value of the operator property.
     *
     * @return
     *     possible object is
     *     {@link STDataValidationOperator }
     *
     */
    @Override
    public STDataValidationOperator getOperator() {
        if (operator == null) {
            return STDataValidationOperator.BETWEEN;
        }
        return operator;
    }

    /**
     * Sets the value of the operator property.
     *
     * @param value
     *     allowed object is
     *     {@link STDataValidationOperator }
     *
     */
    @Override
    public void setOperator(STDataValidationOperator value) {
        this.operator = value;
    }

    /**
     * Gets the value of the allowBlank property.
     *
     * @return
     *     possible object is
     *     {@link Boolean }
     *
     */
    @Override
    public boolean isAllowBlank() {
        if (allowBlank == null) {
            return false;
        }
        return allowBlank;
    }

    /**
     * Sets the value of the allowBlank property.
     *
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *
     */
    @Override
    public void setAllowBlank(Boolean value) {
        this.allowBlank = value;
    }

    /**
     * Gets the value of the showDropDown property.
     *
     * @return
     *     possible object is
     *     {@link Boolean }
     *
     */
    @Override
    public boolean isShowDropDown() {
        if (showDropDown == null) {
            return false;
        }
        return showDropDown;
    }

    /**
     * Sets the value of the showDropDown property.
     *
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *
     */
    @Override
    public void setShowDropDown(Boolean value) {
        this.showDropDown = value;
    }

    /**
     * Gets the value of the showInputMessage property.
     *
     * @return
     *     possible object is
     *     {@link Boolean }
     *
     */
    @Override
    public boolean isShowInputMessage() {
        if (showInputMessage == null) {
            return false;
        }
        return showInputMessage;
    }

    /**
     * Sets the value of the showInputMessage property.
     *
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *
     */
    @Override
    public void setShowInputMessage(Boolean value) {
        this.showInputMessage = value;
    }

    /**
     * Gets the value of the showErrorMessage property.
     *
     * @return
     *     possible object is
     *     {@link Boolean }
     *
     */
    @Override
    public boolean isShowErrorMessage() {
        if (showErrorMessage == null) {
            return false;
        }
        return showErrorMessage;
    }

    /**
     * Sets the value of the showErrorMessage property.
     *
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *
     */
    @Override
    public void setShowErrorMessage(Boolean value) {
        this.showErrorMessage = value;
    }

    /**
     * Gets the value of the errorTitle property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    @Override
    public String getErrorTitle() {
        return errorTitle;
    }

    /**
     * Sets the value of the errorTitle property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    @Override
    public void setErrorTitle(String value) {
        this.errorTitle = value;
    }

    /**
     * Gets the value of the error property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    @Override
    public String getError() {
        return error;
    }

    /**
     * Sets the value of the error property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    @Override
    public void setError(String value) {
        this.error = value;
    }

    /**
     * Gets the value of the promptTitle property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    @Override
    public String getPromptTitle() {
        return promptTitle;
    }

    /**
     * Sets the value of the promptTitle property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    @Override
    public void setPromptTitle(String value) {
        this.promptTitle = value;
    }

    /**
     * Gets the value of the prompt property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    @Override
    public String getPrompt() {
        return prompt;
    }

    /**
     * Sets the value of the prompt property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    @Override
    public void setPrompt(String value) {
        this.prompt = value;
    }

    /**
     * Gets the value of the sqref property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the sqref property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSqref().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     *
     *
     */
    @Override
    public List<String> getsqref() {
        return this.sqrefList;
    }

    @SuppressWarnings("unused")
    public void beforeMarshal(Marshaller marshaller) {
        final StringBuffer buf = new StringBuffer();
        for(String sqrefEntry:sqrefList) {
            if(buf.length()>0) {
                buf.append(' ');
            }
            buf.append(sqrefEntry);
        }
        sqref = buf.toString();
    }

    /**
     * This method is invoked by the JAXB implementation on each instance when unmarshalling completes.
     *
     * @param parent
     *     The parent object in the object tree.
     * @param unmarshaller
     *     The unmarshaller that generated the instance.
     */
    public void afterUnmarshal(Unmarshaller unmarshaller, @SuppressWarnings("unused") Object _parent) {
        sqrefList = new ArrayList<String>();
        final StringTokenizer tokenizer = new StringTokenizer(sqref);
        while(tokenizer.hasMoreTokens()) {
            sqrefList.add(tokenizer.nextToken());
        }
    }
}
