
package com.openexchange.office.ooxml.tools.json;

import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import com.openexchange.office.ooxml.tools.interfaces.Percentage;

public class JSONHelper {

    public static JSONArray toJSONArray(List<? extends JSONAble> list) throws JSONException {
        final JSONArray res = new JSONArray();
        for (JSONAble l : list) {
            res.put(l.toJSON());
        }
        return res;
    }

    private static JSONArray getTransformations(List<JAXBElement<?>> trans) throws JSONException {
        JSONArray transformations = null;
        for (JAXBElement<?> jax : trans) {
            final QName name = jax.getName();
            final Percentage perc = (Percentage) jax.getValue();
            if (transformations == null) {
                transformations = new JSONArray();
            }
            final JSONObject transformation = new JSONObject();
            transformation.put("type", name.getLocalPart());
            transformation.put("value", perc.getVal());
            transformations.put(transformation);
        }
        return transformations;
    }

    public static String toHex(int one, int two, int three) {
        return toHex(one) + toHex(two) + toHex(three);
    }

    public static String toHex(int value) {
        String res = Integer.toHexString(value);
        while (res.length() < 2) {
            res = "0" + res;
        }
        return res;
    }

    public static JSONObject makeColor(String type, Object value, List<JAXBElement<?>> egColorTransform) throws JSONException {
        final JSONObject res = new JSONObject();

        if (value != null) {
            res.put("type", type);
            res.put("value", value);
        }

        if (egColorTransform != null && egColorTransform.size() > 0) {
            res.put("transformations", JSONHelper.getTransformations(egColorTransform));
        }
        return res;

    }

    public static JSONObject optPut(String name, JSONObject target, JSONAble... jsons) throws JSONException {
        JSONObject res = target;
        for (JSONAble json : jsons) {
            if (json != null) {
                final JSONValue file = json.toJSON();
                if (file != null) {
                    if (res == null) {
                        res = new JSONObject();
                    }
                    res.put(name, file);
                    break;
                }
            }
        }
        return res;

    }
    
    public static JSONObject optPut(String name, JSONObject target, Number data) throws JSONException {
        if(data!=null){
            JSONObject res = target;
            if(res == null){
                res = new JSONObject();
            }
            res.put(name, data);
            return res;
        }
        return null;
    }

    public static JSONObject makeJSON(String key1, Object value1, String key2, Object value2, String key3, Object value3) throws JSONException {
        JSONObject res = new JSONObject();
        res.put(key1, value1);
        res.put(key2, value2);
        res.put(key3, value3);
        return res;
    }

    public static byte gammaChannel(int channel) {
        double corr = Math.pow(channel / 100000D, 1 / 2.3);
        return (byte) (corr * 255);
    }

}
