package com.openexchange.office.ooxml.xlsx.tools;

import java.util.List;
import java.util.Map;
import org.docx4j.dml.chart.CTAxDataSource;
import org.docx4j.dml.chart.CTBubbleSer;
import org.docx4j.dml.chart.CTChartSpace;
import org.docx4j.dml.chart.CTNumDataSource;
import org.docx4j.dml.chart.CTNumRef;
import org.docx4j.dml.chart.CTSerTx;
import org.docx4j.dml.chart.CTStrRef;
import org.docx4j.dml.chart.ListSer;
import org.docx4j.dml.chart.SerContent;
import org.docx4j.dml.spreadsheetdrawing.CellAnchor;
import org.docx4j.openpackaging.parts.DrawingML.Drawing;
import org.xlsx4j.sml.Cell;
import org.xlsx4j.sml.Cell.CellRef;
import org.xlsx4j.sml.Cell.CellRefRange;
import com.openexchange.office.ooxml.drawingml.DMLGraphic;

public class ChartUtils {

	public static void handleInsertDeleteColRow(Drawing drawing, String drawingSheetName, String sheetName, int start, int count, ColRow colrow, int rel) {
		final List<CellAnchor> drawings = drawing.getJaxbElement().getEGAnchor();
		for (final CellAnchor ca : drawings) {
			final Map<String, Object> drawingPropertyMap = DMLGraphic.getDrawingType(drawing, ca);
			final CTChartSpace chartSpace = (CTChartSpace) drawingPropertyMap.get("chartObject");
			if (chartSpace != null) {
				final List<ListSer> series = chartSpace.getChart().getPlotArea().getAreaChartOrArea3DChartOrLineChart();
				for (final ListSer serie : series) {
					for (final SerContent content : serie.getSer()) {
						handleSeries(sheetName, drawingSheetName, start, count, colrow, rel, content);
					}
				}
			}
		}
	}

	private static void handleSeries(String sheetName, String drawingSheetName, int start, int count, ColRow colrow, int rel, SerContent content) {
		handleFormula(sheetName, drawingSheetName, start, count, colrow, rel, content.getTx());
		handleFormula(sheetName, drawingSheetName, start, count, colrow, rel, content.getVal());
		handleFormula(sheetName, drawingSheetName, start, count, colrow, rel, content.getCat());
		if (content instanceof CTBubbleSer) {
			final CTBubbleSer bubble = (CTBubbleSer) content;
			handleFormula(sheetName, drawingSheetName, start, count, colrow, rel, bubble.getBubbleSize());
		}
	}

	private static void handleFormula(String sheetName, String drawingSheetName, int start, int count, ColRow colrow, int rel, CTAxDataSource cat) {
		final String formula = handleFormula(sheetName, drawingSheetName, start, count, colrow, rel, getValue(cat));
		if (formula != null) {
			final CTStrRef ref = new CTStrRef();
			ref.setF(formula);

			cat.setMultiLvlStrRef(null);
			cat.setNumLit(null);
			cat.setNumRef(null);
			cat.setStrLit(null);
			cat.setStrRef(ref);
		}
	}

	private static void handleFormula(String sheetName, String drawingSheetName, int start, int count, ColRow colrow, int rel, CTNumDataSource val) {
		String formula = handleFormula(sheetName, drawingSheetName, start, count, colrow, rel, getValue(val));
		if (formula != null) {
			CTNumRef ref = new CTNumRef();
			ref.setF(formula);

			val.setNumLit(null);
			val.setNumRef(ref);
		}
	}

	private static void handleFormula(String sheetName, String drawingSheetName, int start, int count, ColRow colrow, int rel, CTSerTx tx) {
		final String formula = handleFormula(sheetName, drawingSheetName, start, count, colrow, rel, getValue(tx));

		if (formula != null) {
			final CTStrRef ref = new CTStrRef();
			ref.setF(formula);

			tx.setV(null);
			tx.setStrRef(ref);
		}
	}

	private static String handleFormula(String sheetName, String drawingSheetName, int start, int count, ColRow colrow, int rel, String iFormula) {
		if (iFormula != null && iFormula.length() > 0) {

			final String formula;
			if (!iFormula.contains("!")) {
				formula = drawingSheetName + "!" + iFormula;
			} else {
				formula = iFormula;
			}

			if (formula.startsWith(sheetName)) {

				CellRefRange ref = Cell.createCellRefRangeWithSheet(formula);

				final int sif = get(ref.getStart(), colrow);
				final int sil = get(ref.getEnd(), colrow);
				final int oif = start;
				int tif = sif;
				int til = sil;

				boolean change = false;
				if (rel > 0) {
					// insert rows/columns (shift, or enlarge the range)
					if (oif <= sif) {
						tif = sif + count;
						change = true;
					}
					if (oif <= sil) {
						til = sil + count;
						change = true;
					}
				} else {
					// delete rows/columns (shift, shrink, or delete the range)
					if (oif < sif) {
						tif = Math.max(oif, sif - count);
						change = true;
					}
					if (oif <= sil) {
						til = Math.max(sil - count, oif - 1);
						change = true;
					}
				}

				if (change) {
					set(ref.getStart(), colrow, tif);
					set(ref.getEnd(), colrow, til);

					return sheetName + '!' + Cell.getAbsoluteCellRefRange(ref);
				}
			}
		}
		return null;

	}

	private static String getValue(Object cellData) {
		if (cellData instanceof CTStrRef) {
			final CTStrRef str = (CTStrRef) cellData;
			return str.getF();
		} else if (cellData instanceof CTNumRef) {
			final CTNumRef num = (CTNumRef) cellData;
			return num.getF();
		} else if (cellData instanceof CTSerTx) {
			CTSerTx tx = (CTSerTx) cellData;
			if (tx.getStrRef() != null) {
				return tx.getStrRef().getF();
			}
			return tx.getV();
		} else if (cellData instanceof CTNumDataSource) {
			final CTNumDataSource num = (CTNumDataSource) cellData;
			if (num.getNumRef() != null) {
				return num.getNumRef().getF();
			} else if (num.getNumLit() != null) {
				return num.getNumLit().getFormatCode();
			}
		} else if (cellData instanceof CTAxDataSource) {
			final CTAxDataSource cta = (CTAxDataSource) cellData;
			if (cta.getNumRef() != null) {
				return cta.getNumRef().getF();
			} else if (cta.getNumLit() != null) {
				return cta.getNumLit().getFormatCode();
			} else if (cta.getStrRef() != null) {
				return cta.getStrRef().getF();
			} else if (cta.getMultiLvlStrRef() != null) {
				return cta.getMultiLvlStrRef().getF();
			}
		}
		return null;
	}

	private static int get(CellRef cell, ColRow colrow) {
		if (colrow == ColRow.Column) {
			return cell.getColumn();
		}
		return cell.getRow();
	}

	private static void set(CellRef cell, ColRow colrow, int value) {
		if (colrow == ColRow.Column) {
			cell.setColumn(value);
		} else {
			cell.setRow(value);
		}
	}

	public enum ColRow {
		Column, Row;
	}

}
