/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/tk/object/triggerobject',
    ['io.ox/core/event',
     'io.ox/office/tk/object/baseobject'
    ], function (Events, BaseObject) {

    'use strict';

    // class TriggerObject ====================================================

    /**
     * An abstract base class for all classes that want to trigger events to
     * listeners.
     *
     * @constructor
     *
     * @extends BaseObject
     * @extends Events
     */
    var TriggerObject = BaseObject.extend({ constructor: function () {

        // base constructors --------------------------------------------------

        BaseObject.call(this);
        Events.extend(this);

        // initialization -----------------------------------------------------

        // destroy the core events mix-in
        this.registerDestructor(_.bind(this.events.destroy, this.events));

    }}); // class TriggerObject

    // exports ================================================================

    return TriggerObject;

});
