/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/drawing/axismodel',
    ['io.ox/office/editframework/model/format/attributedmodel'
    ], function (AttributedModel) {

    'use strict';

    // class AxisModel =====================================================

    /**
     * visualisation model for chart axes,
     * it defines colors and textual colors
     */
    function AxisModel(app, attrs, dataAxis) {

        // base constructor ---------------------------------------------------

        AttributedModel.call(this, app, attrs, { additionalFamilies: ['axis', 'line'] });

        // methods ------------------------------------------------------------

        this.refreshInfo = function () {
            if (!dataAxis) {
                return;
            }
            var attrs = this.getMergedAttributes();
            var styles = app.getModel().getDocumentStyles();

            if (!attrs.axis.visible) {
                dataAxis.labelFontColor = 'transparent';
                dataAxis.lineColor = 'transparent';
                dataAxis.tickColor = 'transparent';
            } else if (attrs.line.type === 'none') {
                dataAxis.labelFontColor = 'black';
                dataAxis.lineColor = 'transparent';
                dataAxis.tickColor = 'transparent';
            } else {
                dataAxis.labelFontColor = 'black';
                dataAxis.lineColor = styles.getCssColor(attrs.line.color, 'line');
                dataAxis.tickColor = dataAxis.labelFontColor;
            }

            dataAxis.gridThickness = 1;
            dataAxis.gridColor = styles.getCssColor(attrs.axis.gridlineColor, 'fill');

        };


    } // class AxisModel

    // exports ================================================================

//    return AxisModel;
    return AttributedModel.extend({ constructor: AxisModel });

});
