/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/app/config',
    ['io.ox/office/tk/utils',
     'io.ox/office/tk/config',
     'settings!io.ox/office'
     ], function (Utils, Config, settings) {

    'use strict';

    var // the configuration items of the spreadsheet module
        moduleConfig = settings.get('spreadsheet', {});

    // static class SpreadsheetConfig =========================================

    var SpreadsheetConfig = _.clone(Config);

    /**
     * Returns the configured maximum number of non-empty cells allowed to be
     * contained in a complete spreadsheet document.
     *
     * @returns {Number}
     *  The maximum number of non-empty cells in a spreadsheet document.
     */
    SpreadsheetConfig.getMaxCellCount = function () {
        return Utils.getIntegerOption(moduleConfig, 'maxCells', 400000);
    };

    /**
     * Returns the configured maximum number of sheets allowed to be contained
     * in a spreadsheet document.
     *
     * @returns {Number}
     *  The maximum number of sheets in a spreadsheet document.
     */
    SpreadsheetConfig.getMaxSheetCount = function () {
        return Utils.getIntegerOption(moduleConfig, 'maxSheets', 256);
    };

    // exports ================================================================

    return SpreadsheetConfig;

});
