/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Carsten Driesner <carsten.driesner@open-xchange.com>
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/drawing/drawingmodel',
        ['io.ox/office/tk/utils',
         'io.ox/office/drawinglayer/model/drawingmodel',
         'io.ox/office/spreadsheet/model/drawing/drawingmodelmixin'
        ], function (Utils, DrawingModel, DrawingModelMixin) {

    'use strict';

    // class SheetDrawingModel ================================================

    /**
     * A generic drawing model with spreadsheet specific extensions.
     *
     * @constructor
     *
     * @extends DrawingModel
     * @extends DrawingModelMixin
     *
     * @param {SpreadsheetApplication} app
     *  The application containing this drawing object.
     *
     * @param {SheetModel} sheetModel
     *  The model instance of the sheet that contains this drawing object.
     *
     * @param {Object} [initAttributes]
     *  An attribute set with initial formatting attributes for the drawing
     *  object.
     *
     * @param {Object} [initOptions]
     *  A map with additional options for the drawing object. Supports all
     *  options supported by the base class DrawingModel.
     */
    function SheetDrawingModel(app, sheetModel, type, initAttributes, initOptions) {

        // base constructors --------------------------------------------------

        DrawingModel.call(this, app, type, initAttributes, initOptions);
        DrawingModelMixin.call(this, app, sheetModel);

        // initialization -----------------------------------------------------

        // constructor called from BaseObject.clone()
        this.registerCloneConstructor(function (newSheetModel) {
            return new SheetDrawingModel(app, newSheetModel, type, this.getExplicitAttributes(), initOptions);
        });

    } // class SheetDrawingModel

    // exports ================================================================

    // derive this class from class DrawingModel
    return DrawingModel.extend({ constructor: SheetDrawingModel });

});
