/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/presentation/app/controller', ['io.ox/office/editframework/app/editcontroller'], function (EditController) {

    'use strict';

    // class PresentationController ===========================================

    /**
     * The controller of an OX Presentation application.
     *
     * @constructor
     *
     * @extends EditController
     */
    function PresentationController(app) {

        var // the spreadsheet model
            model = null,

            // the spreadsheet view
            view = null,

            // all the little controller items
            items = {};

        // base constructor ---------------------------------------------------

        EditController.call(this, app);

        // initialization -----------------------------------------------------

        // register item definitions
        this.registerDefinitions(items);

        // initialization after construction
        app.on('docs:init', function () {
            // model and view are not available at construction time
            model = app.getModel();
            view = app.getView();
        });

    } // class PresentationController

    // exports ================================================================

    // derive this class from class EditController
    return EditController.extend({ constructor: PresentationController });

});
