/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.batch;

import com.google.gdata.client.batch.BatchInterruptedException;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.Feed;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.IFeed;
import com.google.gdata.data.batch.BatchOperationType;
import com.google.gdata.data.batch.IBatchInterrupted;
import com.google.gdata.data.batch.IBatchStatus;
import com.google.gdata.model.Element;
import com.google.gdata.model.atom.Entry;
import com.google.gdata.model.batch.BatchId;
import com.google.gdata.model.batch.BatchInterrupted;
import com.google.gdata.model.batch.BatchOperation;
import com.google.gdata.model.batch.BatchStatus;

public class BatchUtils {
    public static String getBatchId(IEntry entry) {
        if (entry instanceof Entry) {
            return BatchId.getIdFrom((Entry)entry);
        }
        return com.google.gdata.data.batch.BatchUtils.getBatchId((BaseEntry)entry);
    }

    public static void setBatchId(IEntry entry, String id) {
        if (entry instanceof Element) {
            ((Element)((Object)entry)).setElement(BatchId.KEY, (Element)(id == null ? null : new BatchId(id)));
        } else {
            com.google.gdata.data.batch.BatchUtils.setBatchId((ExtensionPoint)((Object)entry), id);
        }
    }

    public static BatchOperationType getBatchOperationType(IEntry entry) {
        if (entry instanceof Element) {
            return BatchUtils.getBatchOperationType((Element)((Object)entry));
        }
        return com.google.gdata.data.batch.BatchUtils.getBatchOperationType((ExtensionPoint)((Object)entry));
    }

    public static BatchOperationType getBatchOperationType(IFeed feed) {
        if (feed instanceof Element) {
            return BatchUtils.getBatchOperationType((Element)((Object)feed));
        }
        return com.google.gdata.data.batch.BatchUtils.getBatchOperationType((ExtensionPoint)((Object)feed));
    }

    private static BatchOperationType getBatchOperationType(Element element) {
        BatchOperation op = element.getElement(BatchOperation.KEY);
        return op == null ? null : op.getType();
    }

    public static void setBatchOperationType(IEntry entry, BatchOperationType op) {
        if (entry instanceof Element) {
            BatchUtils.setBatchOperationType((Element)((Object)entry), op);
        } else {
            com.google.gdata.data.batch.BatchUtils.setBatchOperationType((ExtensionPoint)((Object)entry), op);
        }
    }

    public static void setBatchOperationType(IFeed feed, BatchOperationType op) {
        if (feed instanceof Element) {
            BatchUtils.setBatchOperationType((Element)((Object)feed), op);
        } else {
            com.google.gdata.data.batch.BatchUtils.setBatchOperationType((ExtensionPoint)((Object)feed), op);
        }
    }

    private static void setBatchOperationType(Element entry, BatchOperationType op) {
        entry.setElement(BatchOperation.KEY, (Element)(op == null ? null : new BatchOperation(op)));
    }

    public static IBatchInterrupted getInterrupted(IEntry entry) {
        if (entry instanceof Element) {
            return ((Element)((Object)entry)).getElement(BatchInterrupted.KEY);
        }
        return com.google.gdata.data.batch.BatchUtils.getBatchInterrupted((ExtensionPoint)((Object)entry));
    }

    public static IBatchStatus getStatus(IEntry entry) {
        if (entry instanceof Element) {
            return ((Element)((Object)entry)).getElement(BatchStatus.KEY);
        }
        return com.google.gdata.data.batch.BatchUtils.getBatchStatus((ExtensionPoint)((Object)entry));
    }

    public static boolean isSuccess(IEntry entry) {
        int code = BatchUtils.getRequiredBatchStatusCode(entry);
        return code >= 200 && code < 300;
    }

    public static boolean isFailure(IEntry entry) {
        return !BatchUtils.isSuccess(entry);
    }

    private static int getRequiredBatchStatusCode(IEntry entry) {
        IBatchStatus batchStatus = BatchUtils.getStatus(entry);
        if (batchStatus == null) {
            throw new IllegalArgumentException("Not a batch response entry; Missing BatchStatus extension.");
        }
        return batchStatus.getCode();
    }

    public static void throwIfInterrupted(IFeed ifeed) throws BatchInterruptedException {
        int count = ifeed.getEntries().size();
        if (count > 0) {
            IBatchInterrupted interrupted;
            IEntry ientry = ifeed.getEntries().get(count - 1);
            if (ientry instanceof Entry) {
                Entry entry = (Entry)ientry;
                Feed feed = (Feed)ifeed;
                interrupted = entry.getElement(BatchInterrupted.KEY);
            } else if (ientry instanceof BaseEntry) {
                BaseEntry baseEntry = (BaseEntry)ientry;
                BaseFeed baseFeed = (BaseFeed)ifeed;
                interrupted = com.google.gdata.data.batch.BatchUtils.getBatchInterrupted(baseEntry);
            } else {
                throw new IllegalStateException("Unrecognized entry type:" + ientry.getClass());
            }
            if (interrupted != null) {
                throw new BatchInterruptedException(ifeed, interrupted);
            }
        }
    }

    private BatchUtils() {
    }
}

