/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.model.Element;
import com.google.gdata.util.ErrorContent;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.common.base.Join;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationContext {
    private Map<Element, List<ErrorContent>> errors = Maps.newLinkedHashMap();

    public Map<Element, List<ErrorContent>> getErrors() {
        return Collections.unmodifiableMap(this.errors);
    }

    public void addError(Element element, String error) {
        this.addError(element, CoreErrorDomain.ERR.invalidExtension.withInternalReason(error));
    }

    public void addError(Element element, ErrorContent error) {
        ArrayList list = this.errors.get(element);
        if (list == null) {
            list = Lists.newArrayList();
            this.errors.put(element, list);
        }
        list.add(error);
    }

    public boolean isValid() {
        return this.errors.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Element, List<ErrorContent>> error : this.errors.entrySet()) {
            sb.append(error.getKey().getElementId());
            sb.append(" { ");
            ArrayList errors = Lists.newArrayList();
            for (ErrorContent element : error.getValue()) {
                errors.add(new ParseException(element).toXmlErrorMessage());
            }
            sb.append(Join.join(", ", errors));
            sb.append(" }");
        }
        return sb.toString();
    }
}

