/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.odf;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OmaDrmCommonHeadersBox
extends AbstractFullBox
implements ContainerBox {
    public static final String TYPE = "ohdr";
    private List<Box> extendedHeaders = new LinkedList<Box>();
    private int encryptionMethod;
    private int paddingScheme;
    private long plaintextLength;
    private String contentId = "";
    private String rightsIssuerUrl = "";
    private String textualHeaders = "";

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz, boolean recursive) {
        ArrayList<T> boxesToBeReturned = new ArrayList<T>();
        for (Box boxe : this.extendedHeaders) {
            if (!clazz.isInstance(boxe)) continue;
            boxesToBeReturned.add(clazz.cast(boxe));
        }
        return boxesToBeReturned;
    }

    public OmaDrmCommonHeadersBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    @Override
    public List<Box> getBoxes() {
        return this.extendedHeaders;
    }

    public void setTextualHeaders(Map<String, String> m) {
        this.textualHeaders = "";
        if (m != null) {
            for (String key : m.keySet()) {
                String value = m.get(key);
                this.textualHeaders = this.textualHeaders + key + ":";
                this.textualHeaders = this.textualHeaders + value + "\u0000";
            }
        }
    }

    public void setRightsIssuerUrl(String rightsIssuerUrl) {
        assert (rightsIssuerUrl != null);
        this.rightsIssuerUrl = rightsIssuerUrl;
    }

    public void setContentId(String contentId) {
        assert (contentId != null);
        this.contentId = contentId;
    }

    public void setPlaintextLength(long plaintextLength) {
        this.plaintextLength = plaintextLength;
    }

    public void setPaddingScheme(int paddingScheme) {
        assert (paddingScheme == 0 || paddingScheme == 1);
        this.paddingScheme = paddingScheme;
    }

    public void setEncryptionMethod(int encryptionMethod) {
        assert (encryptionMethod == 0 || encryptionMethod == 1 || encryptionMethod == 2);
        this.encryptionMethod = encryptionMethod;
    }

    public int getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public int getPaddingScheme() {
        return this.paddingScheme;
    }

    public long getPlaintextLength() {
        return this.plaintextLength;
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getRightsIssuerUrl() {
        return this.rightsIssuerUrl;
    }

    public String getTextualHeaders() {
        return this.textualHeaders;
    }

    @Override
    protected long getContentSize() {
        long contentLength;
        try {
            contentLength = 16 + this.contentId.getBytes("UTF-8").length + (this.rightsIssuerUrl != null ? this.rightsIssuerUrl.getBytes("UTF-8").length : 0) + (this.textualHeaders != null ? this.textualHeaders.getBytes("UTF-8").length : 0);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        for (Box boxe : this.extendedHeaders) {
            contentLength += boxe.getSize();
        }
        return contentLength;
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.encryptionMethod = in.readUInt8();
        this.paddingScheme = in.readUInt8();
        this.plaintextLength = in.readUInt64();
        int contentIdLength = in.readUInt16();
        int rightsIssuerUrlLength = in.readUInt16();
        int textualHeadersLength = in.readUInt16();
        this.contentId = new String(in.read(contentIdLength), "UTF-8");
        this.rightsIssuerUrl = new String(in.read(rightsIssuerUrlLength), "UTF-8");
        this.textualHeaders = new String(in.read(textualHeadersLength), "UTF-8");
        long remainingContentSize = size;
        remainingContentSize -= 20L;
        remainingContentSize -= (long)(contentIdLength + rightsIssuerUrlLength + textualHeadersLength);
        while (remainingContentSize > 0L) {
            Box box = boxParser.parseBox(in, this, lastMovieFragmentBox);
            remainingContentSize -= box.getSize();
            this.extendedHeaders.add((AbstractBox)box);
        }
        assert (remainingContentSize == 0L);
    }

    @Override
    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeUInt8(this.encryptionMethod);
        isos.writeUInt8(this.paddingScheme);
        isos.writeUInt64(this.plaintextLength);
        isos.writeUInt16(OmaDrmCommonHeadersBox.utf8StringLengthInBytes(this.contentId));
        isos.writeUInt16(this.rightsIssuerUrl != null ? OmaDrmCommonHeadersBox.utf8StringLengthInBytes(this.rightsIssuerUrl) : 0);
        isos.writeUInt16(this.textualHeaders != null ? OmaDrmCommonHeadersBox.utf8StringLengthInBytes(this.textualHeaders) : 0);
        isos.writeStringNoTerm(this.contentId);
        isos.writeStringNoTerm(this.rightsIssuerUrl);
        isos.writeStringNoTerm(this.textualHeaders);
        for (Box boxe : this.extendedHeaders) {
            boxe.getBox(isos);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("OmaDrmCommonHeadersBox[");
        buffer.append("encryptionMethod=").append(this.getEncryptionMethod()).append(";");
        buffer.append("paddingScheme=").append(this.getPaddingScheme()).append(";");
        buffer.append("plaintextLength=").append(this.getPlaintextLength()).append(";");
        buffer.append("contentId=").append(this.getContentId()).append(";");
        buffer.append("rightsIssuerUrl=").append(this.getRightsIssuerUrl()).append(";");
        buffer.append("textualHeaders=").append(this.getTextualHeaders());
        for (Box box : this.getBoxes()) {
            buffer.append(";");
            buffer.append(box.toString());
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public void setBoxes(List<Box> extendedHeaders) {
        this.extendedHeaders = extendedHeaders;
    }

    @Override
    public long getNumOfBytesToFirstChild() {
        long sizeOfChildren = 0L;
        for (Box extendedHeader : this.extendedHeaders) {
            sizeOfChildren += extendedHeader.getSize();
        }
        return this.getSize() - sizeOfChildren;
    }
}

