/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class ItemDataBox
extends AbstractFullBox {
    byte[] data;
    public static final String TYPE = "idat";

    public ItemDataBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    protected long getContentSize() {
        return this.data.length;
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.write(this.data);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        long a = in.remaining();
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        long b = in.remaining();
        assert ((size -= a - b) < Integer.MAX_VALUE);
        this.data = new byte[(int)size];
        in.read(this.data);
    }
}

