/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http.util.Parameters;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.WebSocketApplication;

public abstract class HandShake {
    private static final Logger logger = Logger.getLogger("websocket");
    private boolean secure;
    private String origin;
    private String serverHostName;
    private int port = 80;
    private String resourcePath;
    private String location;
    private final Map<String, String[]> queryParams = new TreeMap<String, String[]>();
    private List<String> subProtocol = new ArrayList<String>();
    private List<String> extensions = new ArrayList<String>();

    public HandShake() {
    }

    public HandShake(URI url) {
        this.resourcePath = url.getPath();
        if ("".equals(this.resourcePath)) {
            this.resourcePath = "/";
        }
        if (url.getQuery() != null) {
            this.resourcePath = this.resourcePath + "?" + url.getQuery();
        }
        this.serverHostName = url.getHost();
        this.secure = "wss://".equals(url.getScheme());
        this.port = url.getPort();
        this.origin = this.appendPort(new StringBuilder(url.getHost())).toString();
        this.buildLocation();
    }

    public HandShake(HttpRequestPacket request) {
        MimeHeaders mimeHeaders = request.getHeaders();
        this.checkForHeader((HttpHeader)request, "Upgrade", "WebSocket");
        this.checkForHeader((HttpHeader)request, "Connection", "Upgrade");
        this.origin = this.readHeader(mimeHeaders, "Sec-WebSocket-Origin");
        if (this.origin == null) {
            this.origin = this.readHeader(mimeHeaders, "Origin");
        }
        this.determineHostAndPort(mimeHeaders);
        this.subProtocol = this.split(mimeHeaders.getHeader("Sec-WebSocket-Protocol"));
        if (this.serverHostName == null) {
            throw new HandshakeException("Missing required headers for WebSocket negotiation");
        }
        this.resourcePath = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString != null) {
            if (!queryString.isEmpty()) {
                this.resourcePath = this.resourcePath + "?" + queryString;
            }
            Parameters queryParameters = new Parameters();
            queryParameters.processParameters(queryString);
            Set names = queryParameters.getParameterNames();
            for (String name : names) {
                this.queryParams.put(name, queryParameters.getParameterValues(name));
            }
        }
        this.buildLocation();
    }

    protected final void buildLocation() {
        StringBuilder builder = new StringBuilder((this.isSecure() ? "wss" : "ws") + "://" + this.serverHostName);
        this.appendPort(builder);
        if (this.resourcePath == null || !this.resourcePath.startsWith("/") && !"".equals(this.resourcePath)) {
            builder.append("/");
        }
        builder.append(this.resourcePath);
        this.location = builder.toString();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getServerHostName() {
        return this.serverHostName;
    }

    public void setServerHostName(String serverHostName) {
        this.serverHostName = serverHostName;
    }

    public List<String> getSubProtocol() {
        return this.subProtocol;
    }

    public void setSubProtocol(List<String> subProtocol) {
        this.subProtocol = subProtocol;
    }

    private void sanitize(List<String> strings) {
        if (strings != null) {
            for (int i = 0; i < strings.size(); ++i) {
                strings.set(i, strings.get(i) == null ? null : strings.get(i).trim());
            }
        }
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<String> extensions) {
        this.sanitize(extensions);
        this.extensions = extensions;
    }

    protected String join(List<String> values) {
        StringBuilder builder = new StringBuilder();
        for (String s : values) {
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(s);
        }
        return builder.toString();
    }

    private void checkForHeader(HttpHeader headers, String header, String validValue) {
        this.validate(header, validValue, headers.getHeader(header));
    }

    private void validate(String header, String validValue, String value) {
        boolean found = false;
        if (value.contains(",")) {
            for (String part : value.split(",")) {
                found |= part.trim().equalsIgnoreCase(validValue);
            }
        } else {
            found = value.equalsIgnoreCase(validValue);
        }
        if (!found) {
            throw new HandshakeException(String.format("Invalid %s header returned: '%s'", header, value));
        }
    }

    public final String readHeader(MimeHeaders headers, String name) {
        DataChunk value = headers.getValue(name);
        return value == null ? null : value.toString();
    }

    private void determineHostAndPort(MimeHeaders headers) {
        int i;
        String header = this.readHeader(headers, "host");
        int n = i = header == null ? -1 : header.indexOf(":");
        if (i == -1) {
            this.setServerHostName(header);
            this.setPort(80);
        } else {
            this.setServerHostName(header.substring(0, i));
            this.setPort(Integer.valueOf(header.substring(i + 1)));
        }
    }

    public HttpContent composeHeaders() {
        String host = this.getServerHostName();
        if (this.port != -1 && this.port != 80 && this.port != 443) {
            host = host + ":" + this.getPort();
        }
        HttpRequestPacket.Builder builder = (HttpRequestPacket.Builder)((HttpRequestPacket.Builder)((HttpRequestPacket.Builder)((HttpRequestPacket.Builder)HttpRequestPacket.builder().method("GET").uri(this.getResourcePath()).protocol(Protocol.HTTP_1_1)).header("Host", host)).header("Connection", "Upgrade")).upgrade("WebSocket");
        if (!this.getSubProtocol().isEmpty()) {
            builder.header("Sec-WebSocket-Protocol", this.join(this.getSubProtocol()));
        }
        return HttpContent.builder((HttpHeader)builder.build()).build();
    }

    public void validateServerResponse(HttpResponsePacket headers) {
        if (101 != headers.getStatus()) {
            throw new HandshakeException(String.format("Response code was not %s: %s", 101, headers.getStatus()));
        }
        this.checkForHeader((HttpHeader)headers, "upgrade", "websocket");
        this.checkForHeader((HttpHeader)headers, "connection", "upgrade");
        if (!this.getSubProtocol().isEmpty()) {
            this.checkForHeader((HttpHeader)headers, "Sec-WebSocket-Protocol", "Sec-WebSocket-Protocol");
        }
    }

    public void respond(FilterChainContext ctx, WebSocketApplication application, HttpResponsePacket response) {
        response.setProtocol(Protocol.HTTP_1_1);
        response.setStatus(101);
        response.setReasonPhrase("Web Socket Protocol Handshake");
        response.setHeader("Upgrade", "websocket");
        response.setHeader("Connection", "Upgrade");
        this.setHeaders(response);
        if (!this.getSubProtocol().isEmpty()) {
            response.setHeader("Sec-WebSocket-Protocol", this.join(application.getSupportedProtocols(this.getSubProtocol())));
        }
        ctx.write((Object)HttpContent.builder((HttpHeader)response).build());
    }

    protected abstract void setHeaders(HttpResponsePacket var1);

    protected final List<String> split(String header) {
        if (header == null) {
            return Collections.emptyList();
        }
        List<String> list = Arrays.asList(header.split(","));
        this.sanitize(list);
        return list;
    }

    public void initiate(FilterChainContext ctx) throws IOException {
        ctx.write((Object)this.composeHeaders());
    }

    private StringBuilder appendPort(StringBuilder builder) {
        if (this.isSecure()) {
            if (this.port != 443 && this.port != -1) {
                builder.append(':').append(this.port);
            }
        } else if (this.port != 80 && this.port != -1) {
            builder.append(':').append(this.port);
        }
        return builder;
    }
}

