/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDBUtils {
    private static String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public static String encodeZeroPadding(int number, int maxNumDigits) {
        String integerString = Integer.toString(number);
        int numZeroes = maxNumDigits - integerString.length();
        StringBuffer strBuffer = new StringBuffer(numZeroes + integerString.length());
        for (int i = 0; i < numZeroes; ++i) {
            strBuffer.insert(i, '0');
        }
        strBuffer.append(integerString);
        return strBuffer.toString();
    }

    public static String encodeZeroPadding(long number, int maxNumDigits) {
        String longString = Long.toString(number);
        int numZeroes = maxNumDigits - longString.length();
        StringBuffer strBuffer = new StringBuffer(numZeroes + longString.length());
        for (int i = 0; i < numZeroes; ++i) {
            strBuffer.insert(i, '0');
        }
        strBuffer.append(longString);
        return strBuffer.toString();
    }

    public static String encodeZeroPadding(float number, int maxNumDigits) {
        String floatString = Float.toString(number);
        int numBeforeDecimal = floatString.indexOf(46);
        numBeforeDecimal = numBeforeDecimal >= 0 ? numBeforeDecimal : floatString.length();
        int numZeroes = maxNumDigits - numBeforeDecimal;
        StringBuffer strBuffer = new StringBuffer(numZeroes + floatString.length());
        for (int i = 0; i < numZeroes; ++i) {
            strBuffer.insert(i, '0');
        }
        strBuffer.append(floatString);
        return strBuffer.toString();
    }

    public static int decodeZeroPaddingInt(String value) {
        return Integer.parseInt(value, 10);
    }

    public static long decodeZeroPaddingLong(String value) {
        return Long.parseLong(value, 10);
    }

    public static float decodeZeroPaddingFloat(String value) {
        return Float.valueOf(value).floatValue();
    }

    public static String encodeRealNumberRange(int number, int maxNumDigits, int offsetValue) {
        long offsetNumber = number + offsetValue;
        String longString = Long.toString(offsetNumber);
        int numZeroes = maxNumDigits - longString.length();
        StringBuffer strBuffer = new StringBuffer(numZeroes + longString.length());
        for (int i = 0; i < numZeroes; ++i) {
            strBuffer.insert(i, '0');
        }
        strBuffer.append(longString);
        return strBuffer.toString();
    }

    public static String encodeRealNumberRange(long number, int maxNumDigits, long offsetValue) {
        long offsetNumber = number + offsetValue;
        String longString = Long.toString(offsetNumber);
        int numZeroes = maxNumDigits - longString.length();
        StringBuffer strBuffer = new StringBuffer(numZeroes + longString.length());
        for (int i = 0; i < numZeroes; ++i) {
            strBuffer.insert(i, '0');
        }
        strBuffer.append(longString);
        return strBuffer.toString();
    }

    public static String encodeRealNumberRange(float number, int maxDigitsLeft, int maxDigitsRight, int offsetValue) {
        int shiftMultiplier = (int)Math.pow(10.0, maxDigitsRight);
        long shiftedNumber = Math.round(number * (float)shiftMultiplier);
        long shiftedOffset = offsetValue * shiftMultiplier;
        long offsetNumber = shiftedNumber + shiftedOffset;
        String longString = Long.toString(offsetNumber);
        int numBeforeDecimal = longString.length();
        int numZeroes = maxDigitsLeft + maxDigitsRight - numBeforeDecimal;
        StringBuffer strBuffer = new StringBuffer(numZeroes + longString.length());
        for (int i = 0; i < numZeroes; ++i) {
            strBuffer.insert(i, '0');
        }
        strBuffer.append(longString);
        return strBuffer.toString();
    }

    public static int decodeRealNumberRangeInt(String value, int offsetValue) {
        long offsetNumber = Long.parseLong(value, 10);
        return (int)(offsetNumber - (long)offsetValue);
    }

    public static long decodeRealNumberRangeLong(String value, long offsetValue) {
        long offsetNumber = Long.parseLong(value, 10);
        return offsetNumber - offsetValue;
    }

    public static float decodeRealNumberRangeFloat(String value, int maxDigitsRight, int offsetValue) {
        long offsetNumber = Long.parseLong(value, 10);
        int shiftMultiplier = (int)Math.pow(10.0, maxDigitsRight);
        double tempVal = offsetNumber - (long)(offsetValue * shiftMultiplier);
        return (float)(tempVal / (double)shiftMultiplier);
    }

    public static String encodeDate(Date date) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(dateFormat);
        String result = dateFormatter.format(date);
        return result.substring(0, result.length() - 2) + ":" + result.substring(result.length() - 2);
    }

    public static Date decodeDate(String value) throws ParseException {
        String javaValue = value.substring(0, value.length() - 3) + value.substring(value.length() - 2);
        SimpleDateFormat dateFormatter = new SimpleDateFormat(dateFormat);
        return dateFormatter.parse(javaValue);
    }

    public static String quoteValues(Collection<String> values) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : values) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(SimpleDBUtils.quoteValue(s));
        }
        return sb.toString();
    }

    public static String quoteValue(String value) {
        return "'" + SimpleDBUtils.replaceChar(value, "'", "''") + "'";
    }

    public static String quoteName(String name) {
        return "`" + SimpleDBUtils.replaceChar(name, "`", "``") + "`";
    }

    protected static String replaceChar(String value, String termToFind, String replacementTerm) {
        StringBuilder buffer = new StringBuilder(value);
        for (int searchIndex = 0; searchIndex < buffer.length() && (searchIndex = buffer.indexOf(termToFind, searchIndex)) != -1; searchIndex += replacementTerm.length()) {
            buffer.replace(searchIndex, searchIndex + termToFind.length(), replacementTerm);
        }
        return buffer.toString();
    }
}

