/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.counters;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.counters.Counter;
import org.apache.cxf.management.counters.MessageHandlingTimeRecorder;
import org.apache.cxf.management.counters.ResponseTimeCounter;
import org.apache.cxf.management.interceptor.ResponseTimeMessageInInterceptor;
import org.apache.cxf.management.interceptor.ResponseTimeMessageInvokerInterceptor;
import org.apache.cxf.management.interceptor.ResponseTimeMessageOutInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CounterRepository {
    private static final Logger LOG = LogUtils.getL7dLogger(CounterRepository.class);
    private Map<ObjectName, Counter> counters;
    private Bus bus;
    private Lock counterCreationLock = new ReentrantLock();

    public CounterRepository() {
        this.counters = new ConcurrentHashMap<ObjectName, Counter>();
    }

    public void setBus(Bus b) {
        this.bus = b;
        if (this.bus != null) {
            this.registerInterceptorsToBus();
        }
    }

    public Bus getBus() {
        return this.bus;
    }

    public Map<ObjectName, Counter> getCounters() {
        return this.counters;
    }

    void registerInterceptorsToBus() {
        ResponseTimeMessageInInterceptor in = new ResponseTimeMessageInInterceptor();
        ResponseTimeMessageInvokerInterceptor invoker = new ResponseTimeMessageInvokerInterceptor();
        ResponseTimeMessageOutInterceptor out = new ResponseTimeMessageOutInterceptor();
        this.bus.getInInterceptors().add(in);
        this.bus.getInInterceptors().add(invoker);
        this.bus.getOutInterceptors().add(out);
        this.bus.setExtension(this, CounterRepository.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseCounter(ObjectName on, MessageHandlingTimeRecorder mhtr) {
        Counter counter = this.getCounter(on);
        if (null == counter) {
            this.counterCreationLock.lock();
            try {
                counter = this.getCounter(on);
                if (counter == null) {
                    counter = this.createCounter(on, mhtr);
                    this.counters.put(on, counter);
                }
            }
            finally {
                this.counterCreationLock.unlock();
            }
        }
        counter.increase(mhtr);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Increase counter " + on + " with " + mhtr);
        }
    }

    public Counter getCounter(ObjectName on) {
        return this.counters.get(on);
    }

    public Counter createCounter(ObjectName on, MessageHandlingTimeRecorder mhtr) {
        ResponseTimeCounter counter = null;
        counter = new ResponseTimeCounter(on);
        InstrumentationManager im = this.bus.getExtension(InstrumentationManager.class);
        if (null != im) {
            try {
                im.register(counter);
            }
            catch (JMException e) {
                LOG.log(Level.WARNING, "INSTRUMENTATION_REGISTER_FAULT_MSG", new Object[]{on, e});
            }
        }
        return counter;
    }
}

