/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.filecache;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DateFormat;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.filecache.FileCacheEntry;
import org.glassfish.grizzly.http.server.filecache.FileCacheKey;
import org.glassfish.grizzly.http.server.filecache.FileCacheProbe;
import org.glassfish.grizzly.http.server.filecache.LazyFileCacheKey;
import org.glassfish.grizzly.http.server.util.SimpleDateFormats;
import org.glassfish.grizzly.http.util.FastHttpDateFormat;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.monitoring.jmx.AbstractJmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringAware;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.glassfish.grizzly.utils.DelayedExecutor;

public class FileCache
implements JmxMonitoringAware<FileCacheProbe> {
    private static final Logger logger = Grizzly.logger(FileCache.class);
    private final AtomicInteger cacheSize = new AtomicInteger();
    private final ConcurrentHashMap<FileCacheKey, FileCacheEntry> fileCacheMap = new ConcurrentHashMap();
    private final FileCacheEntry NULL_CACHE_ENTRY = new FileCacheEntry(this);
    private int secondsMaxAge = -1;
    private volatile int maxCacheEntries = 1024;
    private long minEntrySize = Long.MIN_VALUE;
    private long maxEntrySize = Long.MAX_VALUE;
    private volatile long maxLargeFileCacheSize = Long.MAX_VALUE;
    private volatile long maxSmallFileCacheSize = 0x100000L;
    private AtomicLong mappedMemorySize = new AtomicLong();
    private AtomicLong heapSize = new AtomicLong();
    private boolean enabled = true;
    private MemoryManager memoryManager;
    private DelayedExecutor.DelayQueue<FileCacheEntry> delayQueue;
    protected final AbstractJmxMonitoringConfig<FileCacheProbe> monitoringConfig = new AbstractJmxMonitoringConfig<FileCacheProbe>(FileCacheProbe.class){

        public JmxObject createManagementObject() {
            return FileCache.this.createJmxManagementObject();
        }
    };

    public void initialize(MemoryManager memoryManager, DelayedExecutor delayedExecutor) {
        this.memoryManager = memoryManager;
        this.delayQueue = delayedExecutor.createDelayQueue((DelayedExecutor.Worker)new EntryWorker(), (DelayedExecutor.Resolver)new EntryResolver());
    }

    public CacheResult add(HttpRequestPacket request, File cacheFile) {
        String requestURI = request.getRequestURI();
        if (requestURI == null) {
            return CacheResult.FAILED;
        }
        String host = request.getHeader(Header.Host);
        FileCacheKey key = new FileCacheKey(host, requestURI);
        if (this.fileCacheMap.putIfAbsent(key, this.NULL_CACHE_ENTRY) != null) {
            key.recycle();
            return CacheResult.FAILED_ENTRY_EXISTS;
        }
        int size = this.cacheSize.incrementAndGet();
        if (size > this.getMaxCacheEntries()) {
            this.cacheSize.decrementAndGet();
            this.fileCacheMap.remove(key);
            key.recycle();
            return CacheResult.FAILED_CACHE_FULL;
        }
        FileCacheEntry entry = this.mapFile(cacheFile);
        if (entry == null) {
            entry = new FileCacheEntry(this);
            entry.type = CacheType.TIMESTAMP;
        }
        HttpResponsePacket response = request.getResponse();
        MimeHeaders headers = response.getHeaders();
        entry.key = key;
        entry.requestURI = requestURI;
        entry.lastModified = cacheFile.lastModified();
        entry.contentType = response.getContentType();
        entry.xPoweredBy = headers.getHeader(Header.XPoweredBy);
        entry.date = headers.getHeader(Header.Date);
        entry.lastModifiedHeader = headers.getHeader(Header.LastModified);
        entry.contentLength = response.getContentLength();
        entry.host = host;
        entry.Etag = headers.getHeader(Header.ETag);
        entry.server = headers.getHeader(Header.Server);
        this.fileCacheMap.put(key, entry);
        FileCache.notifyProbesEntryAdded(this, entry);
        int secondsMaxAgeLocal = this.getSecondsMaxAge();
        if (secondsMaxAgeLocal > 0) {
            this.delayQueue.add((Object)entry, (long)secondsMaxAgeLocal, TimeUnit.SECONDS);
        }
        return entry.type == CacheType.TIMESTAMP ? CacheResult.OK_CACHED_TIMESTAMP : CacheResult.OK_CACHED;
    }

    public HttpPacket get(HttpRequestPacket request) {
        if (this.cacheSize.get() == 0) {
            return null;
        }
        LazyFileCacheKey key = LazyFileCacheKey.create(request);
        FileCacheEntry entry = this.fileCacheMap.get(key);
        key.recycle();
        try {
            if (entry != null && entry != this.NULL_CACHE_ENTRY) {
                FileCache.notifyProbesEntryHit(this, entry);
                return this.makeResponse(entry, request);
            }
            FileCache.notifyProbesEntryMissed(this, request);
        }
        catch (Exception e) {
            FileCache.notifyProbesError(this, e);
            logger.log(Level.WARNING, "File Cache exception", e);
        }
        return null;
    }

    protected void remove(FileCacheEntry entry) {
        if (this.fileCacheMap.remove(entry.key) != null) {
            this.cacheSize.decrementAndGet();
        }
        if (entry.type == CacheType.MAPPED) {
            this.subMappedMemorySize(entry.bb.remaining());
        } else {
            this.subHeapSize(entry.bb.remaining());
        }
        FileCache.notifyProbesEntryRemoved(this, entry);
    }

    protected JmxObject createJmxManagementObject() {
        return new org.glassfish.grizzly.http.server.filecache.jmx.FileCache(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileCacheEntry mapFile(File file) {
        MappedByteBuffer bb;
        CacheType type;
        long size;
        FileChannel fileChannel = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            fileChannel = stream.getChannel();
            size = fileChannel.size();
            if (size > this.getMaxEntrySize()) {
                FileCacheEntry fileCacheEntry = null;
                return fileCacheEntry;
            }
            if (size > this.getMinEntrySize()) {
                if (this.addMappedMemorySize(size) > this.getMaxLargeFileCacheSize()) {
                    this.subMappedMemorySize(size);
                    FileCacheEntry fileCacheEntry = null;
                    return fileCacheEntry;
                }
                type = CacheType.MAPPED;
            } else {
                if (this.addHeapSize(size) > this.getMaxSmallFileCacheSize()) {
                    this.subHeapSize(size);
                    FileCacheEntry fileCacheEntry = null;
                    return fileCacheEntry;
                }
                type = CacheType.HEAP;
            }
            bb = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            if (type == CacheType.HEAP) {
                bb.load();
            }
        }
        catch (Exception e) {
            FileCache.notifyProbesError(this, e);
            FileCacheEntry fileCacheEntry = null;
            return fileCacheEntry;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ignored) {
                    FileCache.notifyProbesError(this, ignored);
                }
            }
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException ignored) {
                    FileCache.notifyProbesError(this, ignored);
                }
            }
        }
        FileCacheEntry entry = new FileCacheEntry(this);
        entry.type = type;
        entry.fileSize = size;
        entry.bb = bb;
        return entry;
    }

    protected HttpPacket makeResponse(FileCacheEntry entry, HttpRequestPacket request) throws IOException {
        HttpResponsePacket response = request.getResponse();
        HttpStatus.OK_200.setValues(request.getResponse());
        boolean flushBody = this.checkIfHeaders(entry, request);
        response.setContentType(entry.contentType);
        if (entry.server != null) {
            response.addHeader(Header.Server, entry.server);
        }
        if (flushBody) {
            if (entry.type == CacheType.TIMESTAMP) {
                return null;
            }
            this.addCachingHeaders(entry, response);
            response.setContentLengthLong(entry.contentLength);
            ByteBuffer sliced = entry.bb.slice();
            Buffer buffer = Buffers.wrap((MemoryManager)this.memoryManager, (ByteBuffer)sliced);
            return HttpContent.builder((HttpHeader)response).content(buffer).last(true).build();
        }
        response.setContentLength(0);
        response.setChunked(false);
        return response;
    }

    public int getSecondsMaxAge() {
        return this.secondsMaxAge;
    }

    public void setSecondsMaxAge(int secondsMaxAge) {
        this.secondsMaxAge = secondsMaxAge;
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMaxCacheEntries(int maxCacheEntries) {
        this.maxCacheEntries = maxCacheEntries;
    }

    public long getMinEntrySize() {
        return this.minEntrySize;
    }

    public void setMinEntrySize(long minEntrySize) {
        this.minEntrySize = minEntrySize;
    }

    public long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public void setMaxEntrySize(long maxEntrySize) {
        this.maxEntrySize = maxEntrySize;
    }

    public long getMaxLargeFileCacheSize() {
        return this.maxLargeFileCacheSize;
    }

    public void setMaxLargeFileCacheSize(long maxLargeFileCacheSize) {
        this.maxLargeFileCacheSize = maxLargeFileCacheSize;
    }

    public long getMaxSmallFileCacheSize() {
        return this.maxSmallFileCacheSize;
    }

    public void setMaxSmallFileCacheSize(long maxSmallFileCacheSize) {
        this.maxSmallFileCacheSize = maxSmallFileCacheSize;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected final long addHeapSize(long size) {
        return this.heapSize.addAndGet(size);
    }

    protected final long subHeapSize(long size) {
        return this.heapSize.addAndGet(-size);
    }

    public long getHeapCacheSize() {
        return this.heapSize.get();
    }

    protected final long addMappedMemorySize(long size) {
        return this.mappedMemorySize.addAndGet(size);
    }

    protected final long subMappedMemorySize(long size) {
        return this.mappedMemorySize.addAndGet(-size);
    }

    public long getMappedCacheSize() {
        return this.mappedMemorySize.get();
    }

    protected boolean checkIfHeaders(FileCacheEntry entry, HttpRequestPacket request) throws IOException {
        return this.checkIfMatch(entry, request) && this.checkIfModifiedSince(entry, request) && this.checkIfNoneMatch(entry, request) && this.checkIfUnmodifiedSince(entry, request);
    }

    private boolean checkIfModifiedSince(FileCacheEntry entry, HttpRequestPacket request) throws IOException {
        try {
            HttpResponsePacket response = request.getResponse();
            String reqModified = request.getHeader(Header.IfModifiedSince);
            if (reqModified != null) {
                if (reqModified.equals(entry.lastModifiedHeader)) {
                    HttpStatus.NOT_MODIFIED_304.setValues(response);
                    return false;
                }
                long headerValue = FileCache.convertToLong(reqModified);
                if (headerValue != -1L) {
                    long lastModified = entry.lastModified;
                    if (request.getHeader(Header.IfNoneMatch) == null && headerValue - lastModified <= 1000L) {
                        HttpStatus.NOT_MODIFIED_304.setValues(response);
                        return false;
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            FileCache.notifyProbesError(this, illegalArgument);
            return true;
        }
        return true;
    }

    private boolean checkIfNoneMatch(FileCacheEntry entry, HttpRequestPacket request) throws IOException {
        HttpResponsePacket response = request.getResponse();
        String headerValue = request.getHeader(Header.IfNoneMatch);
        if (headerValue != null) {
            String eTag = entry.Etag;
            boolean conditionSatisfied = false;
            if (!headerValue.equals("*")) {
                StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
                while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                    String currentToken = commaTokenizer.nextToken();
                    if (!currentToken.trim().equals(eTag)) continue;
                    conditionSatisfied = true;
                }
            } else {
                conditionSatisfied = true;
            }
            if (conditionSatisfied) {
                Method method = request.getMethod();
                if (Method.GET.equals(method) || Method.HEAD.equals(method)) {
                    HttpStatus.NOT_MODIFIED_304.setValues(response);
                    return false;
                }
                HttpStatus.PRECONDITION_FAILED_412.setValues(response);
                return false;
            }
        }
        return true;
    }

    protected boolean checkIfUnmodifiedSince(FileCacheEntry entry, HttpRequestPacket request) throws IOException {
        try {
            HttpResponsePacket response = request.getResponse();
            long lastModified = entry.lastModified;
            String h = request.getHeader(Header.IfUnmodifiedSince);
            if (h != null) {
                if (h.equals(entry.lastModifiedHeader)) {
                    HttpStatus.PRECONDITION_FAILED_412.setValues(response);
                    return false;
                }
                long headerValue = FileCache.convertToLong(h);
                if (headerValue != -1L && headerValue - lastModified <= 1000L) {
                    HttpStatus.PRECONDITION_FAILED_412.setValues(response);
                    return false;
                }
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            FileCache.notifyProbesError(this, illegalArgument);
            return true;
        }
        return true;
    }

    protected boolean checkIfMatch(FileCacheEntry entry, HttpRequestPacket request) throws IOException {
        HttpResponsePacket response = request.getResponse();
        String headerValue = request.getHeader(Header.IfMatch);
        if (headerValue != null && headerValue.indexOf(42) == -1) {
            String eTag = entry.Etag;
            StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
            boolean conditionSatisfied = false;
            while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                String currentToken = commaTokenizer.nextToken();
                if (!currentToken.trim().equals(eTag)) continue;
                conditionSatisfied = true;
            }
            if (!conditionSatisfied) {
                HttpStatus.PRECONDITION_FAILED_412.setValues(response);
                return false;
            }
        }
        return true;
    }

    public JmxMonitoringConfig<FileCacheProbe> getMonitoringConfig() {
        return this.monitoringConfig;
    }

    protected static void notifyProbesEntryAdded(FileCache fileCache, FileCacheEntry entry) {
        FileCacheProbe[] probes = (FileCacheProbe[])fileCache.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (FileCacheProbe probe : probes) {
                probe.onEntryAddedEvent(fileCache, entry);
            }
        }
    }

    protected static void notifyProbesEntryRemoved(FileCache fileCache, FileCacheEntry entry) {
        FileCacheProbe[] probes = (FileCacheProbe[])fileCache.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (FileCacheProbe probe : probes) {
                probe.onEntryRemovedEvent(fileCache, entry);
            }
        }
    }

    protected static void notifyProbesEntryHit(FileCache fileCache, FileCacheEntry entry) {
        FileCacheProbe[] probes = (FileCacheProbe[])fileCache.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (FileCacheProbe probe : probes) {
                probe.onEntryHitEvent(fileCache, entry);
            }
        }
    }

    protected static void notifyProbesEntryMissed(FileCache fileCache, HttpRequestPacket request) {
        FileCacheProbe[] probes = (FileCacheProbe[])fileCache.monitoringConfig.getProbesUnsafe();
        if (probes != null && probes.length > 0) {
            for (FileCacheProbe probe : probes) {
                probe.onEntryMissedEvent(fileCache, request.getHeader(Header.Host), request.getRequestURI());
            }
        }
    }

    protected static void notifyProbesError(FileCache fileCache, Throwable error) {
        FileCacheProbe[] probes = (FileCacheProbe[])fileCache.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (FileCacheProbe probe : probes) {
                probe.onErrorEvent(fileCache, error);
            }
        }
    }

    protected static long convertToLong(String dateHeader) {
        if (dateHeader == null) {
            return -1L;
        }
        SimpleDateFormats formats = SimpleDateFormats.create();
        try {
            long result = FastHttpDateFormat.parseDate((String)dateHeader, (DateFormat[])formats.getFormats());
            if (result != -1L) {
                long l = result;
                return l;
            }
            throw new IllegalArgumentException(dateHeader);
        }
        finally {
            formats.recycle();
        }
    }

    protected void addCachingHeaders(FileCacheEntry entry, HttpResponsePacket response) {
        response.addHeader(Header.ETag, entry.Etag);
        response.addHeader(Header.LastModified, entry.lastModifiedHeader);
    }

    private static class EntryResolver
    implements DelayedExecutor.Resolver<FileCacheEntry> {
        private EntryResolver() {
        }

        public boolean removeTimeout(FileCacheEntry element) {
            if (element.timeoutMillis != -1L) {
                element.timeoutMillis = -1L;
                return true;
            }
            return false;
        }

        public Long getTimeoutMillis(FileCacheEntry element) {
            return element.timeoutMillis;
        }

        public void setTimeoutMillis(FileCacheEntry element, long timeoutMillis) {
            element.timeoutMillis = timeoutMillis;
        }
    }

    private static class EntryWorker
    implements DelayedExecutor.Worker<FileCacheEntry> {
        private EntryWorker() {
        }

        public boolean doWork(FileCacheEntry element) {
            element.run();
            return true;
        }
    }

    public static enum CacheResult {
        OK_CACHED,
        OK_CACHED_TIMESTAMP,
        FAILED_CACHE_FULL,
        FAILED_ENTRY_EXISTS,
        FAILED;

    }

    public static enum CacheType {
        HEAP,
        MAPPED,
        TIMESTAMP;

    }
}

