/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteMessageBatchRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String queueUrl;
    private ListWithAutoConstructFlag<DeleteMessageBatchRequestEntry> entries;

    public DeleteMessageBatchRequest() {
    }

    public DeleteMessageBatchRequest(String queueUrl) {
        this.setQueueUrl(queueUrl);
    }

    public DeleteMessageBatchRequest(String queueUrl, List<DeleteMessageBatchRequestEntry> entries) {
        this.setQueueUrl(queueUrl);
        this.setEntries(entries);
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public DeleteMessageBatchRequest withQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
        return this;
    }

    public List<DeleteMessageBatchRequestEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ListWithAutoConstructFlag();
            this.entries.setAutoConstruct(true);
        }
        return this.entries;
    }

    public void setEntries(Collection<DeleteMessageBatchRequestEntry> entries) {
        if (entries == null) {
            this.entries = null;
            return;
        }
        ListWithAutoConstructFlag entriesCopy = new ListWithAutoConstructFlag(entries.size());
        entriesCopy.addAll(entries);
        this.entries = entriesCopy;
    }

    public DeleteMessageBatchRequest withEntries(DeleteMessageBatchRequestEntry ... entries) {
        if (this.getEntries() == null) {
            this.setEntries(new ArrayList<DeleteMessageBatchRequestEntry>(entries.length));
        }
        for (DeleteMessageBatchRequestEntry value : entries) {
            this.getEntries().add(value);
        }
        return this;
    }

    public DeleteMessageBatchRequest withEntries(Collection<DeleteMessageBatchRequestEntry> entries) {
        if (entries == null) {
            this.entries = null;
        } else {
            ListWithAutoConstructFlag entriesCopy = new ListWithAutoConstructFlag(entries.size());
            entriesCopy.addAll(entries);
            this.entries = entriesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueueUrl() != null) {
            sb.append("QueueUrl: " + this.getQueueUrl() + ",");
        }
        if (this.getEntries() != null) {
            sb.append("Entries: " + this.getEntries());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueueUrl() == null ? 0 : this.getQueueUrl().hashCode());
        hashCode = 31 * hashCode + (this.getEntries() == null ? 0 : this.getEntries().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMessageBatchRequest)) {
            return false;
        }
        DeleteMessageBatchRequest other = (DeleteMessageBatchRequest)obj;
        if (other.getQueueUrl() == null ^ this.getQueueUrl() == null) {
            return false;
        }
        if (other.getQueueUrl() != null && !other.getQueueUrl().equals(this.getQueueUrl())) {
            return false;
        }
        if (other.getEntries() == null ^ this.getEntries() == null) {
            return false;
        }
        return other.getEntries() == null || other.getEntries().equals(this.getEntries());
    }
}

