/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.model.ComponentReference;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.util.xml.ExTagListener;
import org.eclipse.equinox.internal.util.xml.Tag;
import org.eclipse.equinox.internal.util.xml.XMLParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class DeclarationParser
implements ExTagListener {
    private static final String XMLNS = "http://www.osgi.org/xmlns/scr/v1.0.0";
    private static final String ATTR_XMLNS = "xmlns";
    private static final String COMPONENT_TAG_NAME = "component";
    private static final String ATTR_AUTOENABLE = "enabled";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_FACTORY = "factory";
    private static final String ATTR_IMMEDIATE = "immediate";
    private static final String TAG_IMPLEMENTATION = "implementation";
    private static final String ATTR_CLASS = "class";
    private static final String TAG_PROPERTY = "property";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_TYPE = "type";
    private static final String TAG_PROPERTIES = "properties";
    private static final String ATTR_ENTRY = "entry";
    private static final String TAG_SERVICE = "service";
    private static final String ATTR_SERVICEFACTORY = "servicefactory";
    private static final String TAG_PROVIDE = "provide";
    private static final String ATTR_INTERFACE = "interface";
    private static final String TAG_REFERENCE = "reference";
    private static final String ATTR_CARDINALITY = "cardinality";
    private static final String ATTR_POLICY = "policy";
    private static final String ATTR_TARGET = "target";
    private static final String ATTR_BIND = "bind";
    private static final String ATTR_UNBIND = "unbind";
    public Vector components;
    private Bundle bundle;
    private BundleContext bc;
    private ServiceComponent currentComponent;
    private String closeTag;
    boolean immediateSet = false;
    private Hashtable namespaces = null;
    private boolean rootPassed = false;
    private String currentURL = null;

    public void parse(InputStream in, Bundle bundle, Vector components, String processingURL) throws Exception {
        this.components = components;
        this.bundle = bundle;
        this.bc = bundle.getBundleContext();
        this.currentURL = processingURL;
        this.rootPassed = false;
        XMLParser.parseXML(in, (ExTagListener)this, -1);
        this.bundle = null;
        this.bc = null;
        this.currentComponent = null;
        this.currentURL = null;
        this.closeTag = null;
        this.namespaces = null;
    }

    public final void startTag(Tag tag) {
        try {
            try {
                this.processNamespacesEnter(tag);
                String tagName = tag.getName();
                if (this.isCorrectComponentTag(tagName)) {
                    this.doCorrectComponentTag(tag, tagName);
                }
            }
            catch (Throwable e) {
                Activator.log.error("[SCR] Error occurred while processing start tag of XML '" + this.currentURL + "' in bundle " + this.bundle, e);
                if (!this.rootPassed) {
                    this.rootPassed = true;
                }
            }
        }
        finally {
            if (!this.rootPassed) {
                this.rootPassed = true;
            }
        }
    }

    private void doEndTag(Tag tag) throws InvalidSyntaxException {
        String tagName = tag.getName().intern();
        if (this.currentComponent != null) {
            if (tagName == TAG_IMPLEMENTATION) {
                this.doImplementation(tag);
            } else if (tagName == TAG_PROPERTY) {
                this.doProperty(tag);
            } else if (tagName == TAG_PROPERTIES) {
                this.doProperties(tag);
            } else if (tagName == TAG_SERVICE) {
                this.doService(tag);
            } else if (tagName == TAG_REFERENCE) {
                this.doReference(tag);
            } else if (tagName != TAG_PROVIDE) {
                if (tagName == this.closeTag) {
                    if (!this.immediateSet && this.currentComponent.factory == null) {
                        this.currentComponent.setImmediate(this.currentComponent.serviceInterfaces == null);
                    }
                    this.currentComponent.validate(tag.getLine());
                    if (this.components == null) {
                        this.components = new Vector(1, 1);
                    }
                    this.components.addElement(this.currentComponent);
                    this.currentComponent = null;
                    this.closeTag = null;
                } else {
                    IllegalArgumentException e = new IllegalArgumentException("Found illegal tag named '" + tagName + "' in component XML, at line " + tag.getLine());
                    throw e;
                }
            }
        }
    }

    public final void endTag(Tag tag) {
        try {
            this.doEndTag(tag);
            this.processNamespacesLeave(tag);
        }
        catch (Throwable e) {
            this.currentComponent = null;
            this.closeTag = null;
            Activator.log.error("[SCR] Error occurred while processing end tag of XML '" + this.currentURL + "' in bundle " + this.bundle, e);
        }
    }

    private int getCardinality(String value) {
        if ("0..1".equals(value)) {
            return 0;
        }
        if ("0..n".equals(value)) {
            return 1;
        }
        if ("1..1".equals(value)) {
            return 2;
        }
        if ("1..n".equals(value)) {
            return 3;
        }
        return -1;
    }

    private void doReference(Tag tag) throws InvalidSyntaxException {
        String name = tag.getAttribute(ATTR_NAME);
        if (name == null) {
            IllegalArgumentException e = new IllegalArgumentException("The 'reference' tag must have 'name' attribute, at line " + tag.getLine());
            throw e;
        }
        String iface = tag.getAttribute(ATTR_INTERFACE);
        if (iface == null) {
            IllegalArgumentException e = new IllegalArgumentException("The 'reference' tag must have 'interface' attribute, at line " + tag.getLine());
            throw e;
        }
        String cardinalityS = tag.getAttribute(ATTR_CARDINALITY);
        int cardinality = 2;
        if (cardinalityS != null && (cardinality = this.getCardinality(cardinalityS)) < 0) {
            IllegalArgumentException e = new IllegalArgumentException("The 'cardinality' attribute has invalid value '" + cardinalityS + "' at line " + tag.getLine());
            throw e;
        }
        String policyS = tag.getAttribute(ATTR_POLICY);
        int policy = 0;
        if (policyS != null) {
            if (policyS.equals("static")) {
                policy = 0;
            } else if (policyS.equals("dynamic")) {
                policy = 1;
            } else {
                IllegalArgumentException e = new IllegalArgumentException("The 'policy' attribute has invalid value '" + policyS + "' at line " + tag.getLine());
                throw e;
            }
        }
        String bind = tag.getAttribute(ATTR_BIND);
        String unbind = tag.getAttribute(ATTR_UNBIND);
        if (bind != null && (unbind == null || bind.equals("") || bind.equals(unbind)) || unbind != null && (bind == null || unbind.equals("") || unbind.equals(bind))) {
            IllegalArgumentException e = new IllegalArgumentException("The 'reference' tag at line " + tag.getLine() + " is invalid: you must specify both but different 'bind' and 'unbind' attributes!");
            throw e;
        }
        ComponentReference ref = new ComponentReference(this.currentComponent);
        ref.name = name;
        ref.interfaceName = iface;
        ref.cardinality = cardinality;
        ref.policy = policy;
        ref.bind = bind;
        ref.unbind = unbind;
        ref.target = tag.getAttribute(ATTR_TARGET);
        if (ref.target != null) {
            Activator.createFilter(ref.target);
        }
    }

    private void doImplementation(Tag tag) {
        if (this.currentComponent.implementation != null) {
            IllegalArgumentException e = new IllegalArgumentException("The 'component' tag must have exactly one 'implementation' attribute at line " + tag.getLine());
            throw e;
        }
        String tmp = tag.getAttribute(ATTR_CLASS);
        if (tmp == null) {
            IllegalArgumentException e = new IllegalArgumentException("The 'implementation' element must have 'class' attribute set at line " + tag.getLine());
            throw e;
        }
        this.currentComponent.implementation = tmp;
    }

    private void doService(Tag tag) {
        int size;
        String tmp = tag.getAttribute(ATTR_SERVICEFACTORY);
        if (tmp != null) {
            this.currentComponent.serviceFactory = Boolean.valueOf(tmp);
        }
        if ((size = tag.size()) == 0) {
            IllegalArgumentException e = new IllegalArgumentException("The 'service' tag must have one 'provide' tag set at line " + tag.getLine());
            Activator.log.error("[SCR] " + e.getMessage(), (Throwable)e);
            throw e;
        }
        int i = 0;
        while (i < size) {
            String iFace;
            Tag p = tag.getTagAt(i);
            String pName = p.getName().intern();
            if (pName == TAG_PROVIDE) {
                iFace = p.getAttribute(ATTR_INTERFACE);
                if (iFace == null) {
                    IllegalArgumentException e = new IllegalArgumentException("The 'provide' tag must have 'interface' attribute set at line " + tag.getLine());
                    Activator.log.error("[SCR] " + e.getMessage(), (Throwable)e);
                    throw e;
                }
                if (this.currentComponent.serviceInterfaces == null) {
                    this.currentComponent.serviceInterfaces = new Vector(size);
                }
            } else {
                IllegalArgumentException e = new IllegalArgumentException("Found illegal element '" + pName + "' for tag 'service' at line " + tag.getLine());
                Activator.log.error("[SCR] " + e.getMessage(), (Throwable)e);
                throw e;
            }
            this.currentComponent.serviceInterfaces.addElement(iFace);
            ++i;
        }
    }

    private void doProperty(Tag tag) {
        String name = null;
        try {
            Object _value;
            int mtType;
            name = tag.getAttribute(ATTR_NAME);
            if (name == null) {
                IllegalArgumentException e = new IllegalArgumentException("The 'property' tag must have 'name' attribute set at line " + tag.getLine());
                throw e;
            }
            String type = tag.getAttribute(ATTR_TYPE);
            if (type == null || "String".equals(type)) {
                mtType = 1;
            } else if ("Boolean".equals(type)) {
                mtType = 11;
            } else if ("Integer".equals(type)) {
                mtType = 3;
            } else if ("Long".equals(type)) {
                mtType = 2;
            } else if ("Char".equals(type) || "Character".equals(type)) {
                mtType = 5;
            } else if ("Double".equals(type)) {
                mtType = 7;
            } else if ("Float".equals(type)) {
                mtType = 8;
            } else if ("Byte".equals(type)) {
                mtType = 6;
            } else if ("Short".equals(type)) {
                mtType = 4;
            } else {
                IllegalArgumentException e = new IllegalArgumentException("Illegal property type '" + type + "' on line " + tag.getLine());
                throw e;
            }
            String value = tag.getAttribute(ATTR_VALUE);
            if (value != null) {
                _value = DeclarationParser.makeObject(value, mtType);
            } else {
                value = tag.getContent();
                if (value == null) {
                    IllegalArgumentException e = new IllegalArgumentException("The 'property' tag must have body content if 'value' attribute is not specified!");
                    throw e;
                }
                StringTokenizer tok = new StringTokenizer(value, "\n\r");
                Vector<String> el = new Vector<String>(10);
                while (tok.hasMoreTokens()) {
                    String next = tok.nextToken().trim();
                    if (next.length() <= 0) continue;
                    el.addElement(next);
                }
                if (el.size() == 0) {
                    IllegalArgumentException e = new IllegalArgumentException("The 'property' tag must have body content if 'value' attribute is not specified!");
                    throw e;
                }
                Object[] values = new String[el.size()];
                el.copyInto(values);
                _value = DeclarationParser.makeArr((String[])values, mtType);
            }
            if (this.currentComponent.properties == null) {
                this.currentComponent.properties = new Properties();
            }
            this.currentComponent.properties.put(name, _value);
        }
        catch (Throwable e) {
            Activator.log.error("[SCR - DeclarationParser.doProperty()] Error while processing property '" + name + "' in XML " + this.currentURL, e);
        }
    }

    private void doProperties(Tag tag) {
        String fileEntry = tag.getAttribute(ATTR_ENTRY);
        if (fileEntry == null) {
            IllegalArgumentException e = new IllegalArgumentException("The 'properties' tag must include 'entry' attribute, at line " + tag.getLine());
            throw e;
        }
        InputStream is = null;
        try {
            URL resource = this.bundle.getResource(fileEntry);
            is = resource != null ? resource.openStream() : null;
        }
        catch (IOException iOException) {}
        boolean invalid = true;
        if (is != null) {
            if (this.currentComponent.properties == null) {
                this.currentComponent.properties = new Properties();
            }
            try {
                this.currentComponent.properties.load(is);
                invalid = false;
            }
            catch (IOException e) {
                Activator.log.error("[SCR - DeclarationParser.doProperties()] Error while loading properties file", (Throwable)e);
            }
        }
        if (invalid) {
            IllegalArgumentException e = new IllegalArgumentException("The specified 'entry' for the 'properties' tag at line " + tag.getLine() + " doesn't contain valid reference to a property file: " + fileEntry);
            Activator.log.error("[SCR] " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void doCorrectComponentTag(Tag tag, String tagName) {
        this.closeTag = tagName.intern();
        String tmp = tag.getAttribute(ATTR_NAME);
        if (tmp == null || tmp.equals("")) {
            throw new IllegalArgumentException("The 'component' tag MUST have 'name' tag set, at line " + tag.getLine());
        }
        this.immediateSet = false;
        this.currentComponent = new ServiceComponent();
        this.currentComponent.bundle = this.bundle;
        this.currentComponent.bc = this.bc;
        this.currentComponent.name = tmp;
        tmp = tag.getAttribute(ATTR_AUTOENABLE);
        if (tmp != null) {
            this.currentComponent.autoenable = Boolean.valueOf(tmp);
        }
        if ((tmp = tag.getAttribute(ATTR_FACTORY)) != null && tmp.length() == 0) {
            tmp = null;
        }
        this.currentComponent.factory = tmp;
        tmp = tag.getAttribute(ATTR_IMMEDIATE);
        if (tmp != null && tmp.length() == 0) {
            tmp = null;
        }
        if (tmp != null) {
            this.currentComponent.immediate = Boolean.valueOf(tmp);
            this.immediateSet = true;
        }
    }

    private boolean isCorrectComponentTag(String tagName) {
        String localTagName;
        String qualifier = this.getNamespaceQualifier(tagName);
        String string = localTagName = qualifier.length() == 0 ? tagName : tagName.substring(qualifier.length() + 1);
        if (!localTagName.equals(COMPONENT_TAG_NAME)) {
            return false;
        }
        String namespace = this.getCurrentNamespace(qualifier);
        if (!this.rootPassed) {
            return namespace.length() == 0 || namespace.equals(XMLNS);
        }
        return namespace.equals(XMLNS);
    }

    public static Object makeObject(String string, int syntax) throws IllegalArgumentException {
        try {
            switch (syntax) {
                case 1: {
                    return string;
                }
                case 3: {
                    return new Integer(string);
                }
                case 2: {
                    return new Long(string);
                }
                case 8: {
                    return new Float(string);
                }
                case 7: {
                    return new Double(string);
                }
                case 6: {
                    return new Byte(string);
                }
                case 4: {
                    return new Short(string);
                }
                case 5: {
                    if (string.length() == 0) {
                        throw new IllegalArgumentException("Missing character ");
                    }
                    return new Character(string.charAt(0));
                }
                case 11: {
                    return Boolean.valueOf(string);
                }
            }
            throw new IllegalArgumentException("Unsupported type: ".concat(String.valueOf(syntax)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Value: " + string + " does not fit its type!");
        }
    }

    public static Object makeArr(String[] array, int syntax) throws IllegalArgumentException {
        switch (syntax) {
            case 1: {
                return array;
            }
            case 3: {
                int[] ints = new int[array.length];
                int i = 0;
                while (i < array.length) {
                    ints[i] = Integer.parseInt(array[i]);
                    ++i;
                }
                return ints;
            }
            case 2: {
                long[] longs = new long[array.length];
                int i = 0;
                while (i < array.length) {
                    longs[i] = Long.parseLong(array[i]);
                    ++i;
                }
                return longs;
            }
            case 8: {
                float[] floats = new float[array.length];
                int i = 0;
                while (i < array.length) {
                    floats[i] = Float.valueOf(array[i]).floatValue();
                    ++i;
                }
                return floats;
            }
            case 7: {
                double[] doubles = new double[array.length];
                int i = 0;
                while (i < array.length) {
                    doubles[i] = Double.valueOf(array[i]);
                    ++i;
                }
                return doubles;
            }
            case 6: {
                byte[] bytes = new byte[array.length];
                int i = 0;
                while (i < array.length) {
                    bytes[i] = Byte.parseByte(array[i]);
                    ++i;
                }
                return bytes;
            }
            case 4: {
                short[] shorts = new short[array.length];
                int i = 0;
                while (i < array.length) {
                    shorts[i] = Short.parseShort(array[i]);
                    ++i;
                }
                return shorts;
            }
            case 5: {
                char[] chars = new char[array.length];
                int i = 0;
                while (i < array.length) {
                    chars[i] = array[i].charAt(0);
                    ++i;
                }
                return chars;
            }
            case 11: {
                boolean[] booleans = new boolean[array.length];
                int i = 0;
                while (i < array.length) {
                    booleans[i] = Boolean.valueOf(array[i]);
                    ++i;
                }
                return booleans;
            }
        }
        throw new IllegalArgumentException("Unsupported type: ".concat(String.valueOf(syntax)));
    }

    private void processNamespacesEnter(Tag tag) {
        Enumeration en = tag.getAttributeNames();
        while (en.hasMoreElements()) {
            String qualifier;
            String attrName = (String)en.nextElement();
            if (!attrName.startsWith(ATTR_XMLNS) || (qualifier = attrName.substring(ATTR_XMLNS.length())).length() != 0 && (qualifier.charAt(0) != ':' || (qualifier = qualifier.substring(1)).length() <= 0)) continue;
            if (this.namespaces == null) {
                this.namespaces = new Hashtable();
            }
            Stack<String> stack = null;
            stack = (Stack<String>)this.namespaces.get(qualifier);
            if (stack == null) {
                stack = new Stack<String>();
                this.namespaces.put(qualifier, stack);
            }
            stack.push(tag.getAttribute(attrName));
        }
    }

    private String getCurrentNamespace(String qualifier) {
        if (this.namespaces == null || qualifier == null) {
            return "";
        }
        Stack stack = (Stack)this.namespaces.get(qualifier);
        if (stack == null || stack.empty()) {
            return "";
        }
        return (String)stack.peek();
    }

    private void processNamespacesLeave(Tag tag) {
        if (this.namespaces == null) {
            return;
        }
        Enumeration en = tag.getAttributeNames();
        while (en.hasMoreElements()) {
            Stack stack;
            String qualifier;
            String attrName = (String)en.nextElement();
            if (!attrName.startsWith(ATTR_XMLNS) || (qualifier = attrName.substring(ATTR_XMLNS.length())).length() != 0 && (qualifier.charAt(0) != ':' || (qualifier = qualifier.substring(1)).length() <= 0) || (stack = (Stack)this.namespaces.get(qualifier)) == null) continue;
            if (!stack.empty()) {
                stack.pop();
            }
            if (!stack.empty()) continue;
            this.namespaces.remove(qualifier);
        }
    }

    private String getNamespaceQualifier(String name) {
        int index = name.indexOf(58);
        if (index < 0) {
            return "";
        }
        return name.substring(0, index);
    }
}

