/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.server.servlets;

import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.openexchange.office.calcengine.CalcEngineConst;
import com.openexchange.office.calcengine.client.CalcEngineClientFactory;
import com.openexchange.office.calcengine.client.CalcEngineDescriptor;
import com.openexchange.office.calcengine.client.CalcEngineHandleGenerator;
import com.openexchange.office.calcengine.client.ECalcEngineMode;
import com.openexchange.office.calcengine.client.ICalcEngineClient;

//=============================================================================
/** bind the calc engine JNI code to REST.
*/
@Path(CalcEngineConst.CALCENGINE_SERVLETPATH)
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
public class CalcEngineWorkerServlet
{
    //-------------------------------------------------------------------------
    private static final Log LOG = LogFactory.getLog(CalcEngineWorkerServlet.class);

    //-------------------------------------------------------------------------
    public static boolean SIMULATION_MODE = false;
    
    //-------------------------------------------------------------------------
    public static final String INITPARAM_CALCENGINE_MODE = "calcengine.mode";

    //-------------------------------------------------------------------------
    public CalcEngineWorkerServlet ()
    {
    	System.out.println("CalcEngineWorkerServlet constructed ...");
    }
    
    //-------------------------------------------------------------------------
    @GET
    public Response createDocument()
        throws Exception
    {
        try
        {
    		final ICalcEngineClient iImpl   = mem_Impl ();
        	final String            sHandle = iImpl.createDocument();
            final String            sJson   = CalcEngineHandleGenerator.toJSON(sHandle);
            return Response.ok (sJson).build();
        }
        catch (Throwable ex)
        {
            LOG.error(ex.getMessage(), ex);
            return Response.serverError().entity(ex.getMessage()).build();
        }
    }

    //-------------------------------------------------------------------------
    @DELETE
    @Path("{handle}")
    public Response destroyDocument(@PathParam("handle") final String sHandle)
        throws Exception
    {
    	try
    	{
    		final ICalcEngineClient iImpl = mem_Impl ();
    		iImpl.destroyDocument(sHandle);
            return Response.ok ().build();
    	}
    	catch (Throwable ex)
    	{
            LOG.error(ex.getMessage(), ex);
            return Response.serverError().entity(ex.getMessage()).build();
    	}
    }

    //-------------------------------------------------------------------------
    @POST
    @Path("{handle}/"+CalcEngineConst.RELPATH_EXECUTE)
    public Response executeOperation(@PathParam("handle") final String sHandle,
                                                          final String sOpJSON)
        throws Exception
    {
    	try
    	{
    		final ICalcEngineClient iImpl     = mem_Impl ();
    		final String            sOpResult = iImpl.executeOperation(sHandle, sOpJSON);
            Validate.notEmpty(sOpResult, "state=true ... but no JSON result available !");

            return Response.ok (sOpResult).build();
    	}
    	catch (Throwable ex)
    	{
            LOG.error(ex.getMessage(), ex);
            return Response.serverError().entity(ex.getMessage()).build();
    	}
    }

    //-------------------------------------------------------------------------
    private ICalcEngineClient mem_Impl ()
        throws Exception
    {
        if (m_iImpl == null)
        {
    		final String               sMode         = m_aContext.getInitParameter(INITPARAM_CALCENGINE_MODE);
            final CalcEngineDescriptor aDesc         = new CalcEngineDescriptor ();
            
            if (SIMULATION_MODE)
            	aDesc.m_eMode = ECalcEngineMode.E_SIMULATOR;
            else
            	aDesc.m_eMode = ECalcEngineMode.from(sMode, ECalcEngineMode.E_INLINE);

            m_iImpl = CalcEngineClientFactory.getDirect(aDesc);
        }
        return m_iImpl;
    }

    //-------------------------------------------------------------------------
    private ICalcEngineClient m_iImpl = null;

    //-------------------------------------------------------------------------
    private @Context ServletContext m_aContext = null;
}
