/*
 *  Copyright 2010, Plutext Pty Ltd.
 *
 *  This file is part of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.

    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

 */


package org.xlsx4j.sml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.logging.Log;
import org.docx4j.jaxb.Context;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.xlsx4j.sml.Cell.CellRef;
import com.openexchange.log.LogFactory;



/**
 * <p>Java class for CT_SheetData complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="CT_SheetData">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="row" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}CT_Row" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_SheetData", propOrder = {
    "row"
})
public class SheetData implements Child {

    @XmlTransient
    protected static Log log = LogFactory.getLog(SheetData.class);
    protected List<Row> row;
    @XmlTransient
    private Map<Long, Row> rows_impl;
    @XmlTransient
    private Object parent;

    /**
     * Gets the value of the row property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the row property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRow().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Row }
     *
     *
     */

    // this method is now private to ensure that Map<Long, Row> stays up to date..
    private List<Row> getRow() {
        if (row == null) {
            row = new ArrayList<Row>();
        }
        return this.row;
    }

    // the List<Row> may include multiple Rows addressing the same row index, so our Map<Long, Row>
    // takes care only of the first (TODO merging of rows with the same index)
    // if a row is not having an explicit index its index is always previous rowIndex + 1..
    // if a rowIndex is greater than the index of the previous row we have an invalid document
    private Map<Long, Row> getMap() {
        if(rows_impl==null) {
            rows_impl = new HashMap<Long, Row>();
            long lastRowIndex = 0;
            for(Row r:getRow()) {
                Long rowIndex = r.getR();
                if(rowIndex==null) {
                    rowIndex = lastRowIndex + 1;
                }
                else if(rowIndex==0||rowIndex<lastRowIndex) {
                    throw new RuntimeException("XLSX import: SheetData, invalid row index found!!");
                }
                else {
                    if(rowIndex==lastRowIndex) {
                        // TODO: merging has to be done
                        log.warn("XLSX import: SheetData, multiple rows are containing the same row index");
                    }
                    rows_impl.put(rowIndex - 1, r);
                    lastRowIndex = rowIndex;
                }
            }
        }
        return rows_impl;
    }

    public Row getRow(long index, boolean forceCreate) {
        final Map<Long, Row> hashRows = getMap();
        Row r = hashRows.get(index);
        if(forceCreate&&r==null) {

            // creating a new row...

            r = org.docx4j.jaxb.Context.getsmlObjectFactory().createRow();
            r.setParent(this);
            r.setR(index + 1);
            hashRows.put(index, r);

            // applying changes to the list<row> which is
            // the only serialized member here

            int i = 0;
            List<Row> listRows = getRow();
            for(;i<listRows.size();i++) {
                Long rowIndex = listRows.get(i).getR();
                if(rowIndex!=null&&rowIndex>=1) {
                    rowIndex--;
                    if(rowIndex>=index)
                        break;
                }
            }
            listRows.add(i, r);
        }
        return r;
    }

    public void insertRows(int start, int insertCount) {
        final List<Row> rows = getRow();

        int i;
        long lastRowRef = 0;

        for(i=0; i<rows.size();) {
            Row r = rows.get(i);
            Long rowRef = r.getR();
            if(rowRef==null) {
                rowRef = lastRowRef + 1;
            }
            else if(rowRef==0||rowRef<lastRowRef) {
                throw new RuntimeException("XLSX import: SheetData, invalid row index found while inserting new Rows!!");
            }
            if((rowRef-1)>=start) {
                break;  // we get the right index...
            }
            if(++i<row.size()) {
                lastRowRef = rowRef;
            }
        }

        int insertIndex = i;

        // now each following row and cell ref behind our insert position
        // is to be increased by the insertCount
        for(;i<rows.size();i++) {
            Row r = rows.get(i);
            Long rowRef = r.getR();
            if(rowRef!=null) {
                rowRef += insertCount;
                r.setR(rowRef);
            }
            Iterator<Cell> cellIter = r.getCellIter();
            while(cellIter.hasNext()) {
                Cell cell = cellIter.next();
                String stringRef = cell.getR();
                if(stringRef!=null) {
                    CellRef cellRef = Cell.createCellRef(stringRef);
                    cell.setR(Cell.getCellRef(cellRef.getColumn(), cellRef.getRow() + insertCount));
                }
            }
        }

        Row precedingRow = null;
        // check if we can inherit row properties from the preceding row
        if(insertIndex>0&&lastRowRef==start) {
            precedingRow = rows.get(insertIndex-1);
        }

        // now we create and insert our new rows
        for(i=0; i<insertCount; i++) {
            Row newRow = Context.getsmlObjectFactory().createRow();
            if(precedingRow!=null) {
                newRow.setCollapsed(precedingRow.isCollapsed());
                newRow.setCustomFormat(precedingRow.isCustomFormat());
                newRow.setCustomHeight(precedingRow.isCustomHeight());
                newRow.setHidden(false);
                newRow.setHt(precedingRow.getHt());
                newRow.setOutlineLevel(precedingRow.getOutlineLevel());
                newRow.setParent(precedingRow.getParent());
                newRow.setPh(precedingRow.isPh());
                newRow.setS(precedingRow.getS());
                newRow.setThickBot(precedingRow.isThickBot());
                newRow.setThickTop(precedingRow.isThickTop());
            }
            newRow.setR(new Long(start+1+i));
            rows.add(insertIndex+i, newRow);

            // TODO: get info from OS if cell formatting (border etc) is to be inherited
        }
        // resetting our hash map
        rows_impl = null;
    }

    public void deleteRows(int start, int deleteCount) {
        final List<Row> rows = getRow();

        int i;
        long lastRowRef = 0;

        for(i=0; i<rows.size();) {
            Row r = rows.get(i);
            Long rowRef = r.getR();
            if(rowRef==null) {
                rowRef = lastRowRef + 1;
            }
            else if(rowRef==0||rowRef<lastRowRef) {
                throw new RuntimeException("XLSX import: SheetData, invalid row index found while deleting new Rows!!");
            }
            lastRowRef = rowRef;

            long cR = rowRef-1;

            if(cR<start) {
                i++;
            }
            else if (((cR-start)+1)<=deleteCount) {
                rows.remove(i);
            }
            else {
                if(r.getR()!=null) {
                    rowRef -= deleteCount;
                    r.setR(rowRef);
                }
                Iterator<Cell> cellIter = r.getCellIter();
                while(cellIter.hasNext()) {
                    Cell cell = cellIter.next();
                    String stringRef = cell.getR();
                    if(stringRef!=null) {
                        CellRef cellRef = Cell.createCellRef(stringRef);
                        cell.setR(Cell.getCellRef(cellRef.getColumn(), cellRef.getRow() - deleteCount));
                    }
                }
                i++;
            }
        }
        rows_impl = null;
    }

    public Iterator<Row> getRowIter() {
        return getRow().iterator();
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Object parent) {
        this.parent = parent;
    }

    /**
     * This method is invoked by the JAXB implementation on each instance when unmarshalling completes.
     *
     * @param parent
     *     The parent object in the object tree.
     * @param unmarshaller
     *     The unmarshaller that generated the instance.
     */
    public void afterUnmarshal(Unmarshaller unmarshaller, Object _parent) {
        setParent(_parent);
    }
}
