/*
 * Copyright 2012 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.odftoolkit.odfdom.component;

import java.util.List;
import org.odftoolkit.odfdom.pkg.OdfElement;
/**
 *
 * @author svante.schubertATgmail.com
 */
public class TextFieldSelection extends TextSelection implements Comparable {

	private String mReplacementText;
	
	/**
	 * Constructor.
	 *
	 * @param fieldElement the fieldElement of the Field element.
	 * @param startPosition the startPosition of the Field element.
	 */
	TextFieldSelection(OdfElement fieldElement, List<Integer> startPosition) {
		mSelectionElement = fieldElement;
		mStartPosition = startPosition;
	}
	
	/**
	 * Constructor.
	 *
	 * @param fieldElement the fieldElement of the Field element.
	 * @param startPosition the startPosition of the Field element.
	 */
	TextFieldSelection(OdfElement fieldElement, List<Integer> startPosition, String replacementText) {
		mSelectionElement = fieldElement;
		mStartPosition = startPosition;
		mReplacementText = replacementText;
	}	
	
	/**
	 * Constructor.
	 *
	 * @param fieldElement the fieldElement of the Field element.
	 * @param startPosition the startPosition of the Field element.
	 */
	TextFieldSelection(OdfElement fieldElement, List<Integer> startPosition, List<Integer> endPosition) {
		mSelectionElement = fieldElement;
		mStartPosition = startPosition;
		mEndPosition = endPosition;
	}		

	public String getReplacementText(){
		return mReplacementText;
	}

	@Override
	public String toString(){
		return mStartPosition.toString() + "-URL" + mUrl + "-" + mEndPosition.toString() + mSelectionElement.toString();		
	}
	
}
