/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/sheetdrawingmodel', ['io.ox/office/tk/utils'], function (Utils) {

    'use strict';

    // class SheetDrawingModel ================================================

    /**
     * A mix-in class that extends the public API of any drawing model object
     * that has been inserted into a sheet of a spreadsheet document.
     *
     * @constructor
     *
     * @extends DrawingModel
     *
     * @internal
     *  This is a mix-in class supposed to extend an existing instance of the
     *  class DrawingModel. Expects the symbol 'this' to be bound to an
     *  instance of DrawingModel.
     *
     * @param {SpreadsheetApplication} app
     *  The application containing this drawing model.
     */
    function SheetDrawingModel(app) {

        // methods ------------------------------------------------------------

        /**
         * Returns the logical address of the range covered by this drawing
         * model object.
         *
         * @returns {Object}
         *  The logical address of the range covered by this drawing model.
         */
        this.getRange = function () {

            var // the drawing attributes of this drawing object
                drawingAttrs = this.getMergedAttributes().drawing;

            return {
                start: [drawingAttrs.startCol, drawingAttrs.startRow],
                end: [drawingAttrs.endCol, drawingAttrs.endRow]
            };
        };

    } // class SheetDrawingModel

    // exports ================================================================

    return SheetDrawingModel;

});
