/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define('io.ox/office/drawinglayer/model/drawingstyles',
    ['io.ox/office/tk/utils',
     'io.ox/office/editframework/model/format/stylesheets'
    ], function (Utils, StyleSheets) {

    'use strict';

    var // definitions for common drawing attributes
        DEFINITIONS = {

            /**
             * The name of the drawing object.
             */
            name: { def: '' },

            /**
             * A detailed description for the drawing object.
             */
            description: { def: '' },

            /**
             * Flip the drawing horizontally (swap left and right side).
             */
            flipH: { def: false },

            /**
             * Flip the drawing vertically (swap top and bottom side).
             */
            flipV: { def: false },

            /**
             * Replacement image for unsupported drawing objects. The string
             * contains either Base64 encoded bitmap data, or SVG mark-up.
             */
            replacementData: { def: '', scope: 'element' },

            // image specific attributes --------------------------------------

            /**
             * URL pointing to the image data. If the image is embedded in the
             * document file, the URL will be relative to the document.
             */
            imageUrl: { def: '', scope: 'element' },

            /**
             * Image data.
             */
            imageData: { def: '', scope: 'element' },

            /**
             * Amount of left part of the image cropped outside the object
             * border, in percent.
             */
            cropLeft: { def: 0 },

            /**
             * Amount of right part of the image cropped outside the object
             * border, in percent.
             */
            cropRight: { def: 0 },

            /**
             * Amount of top part of the image cropped outside the object
             * border, in percent.
             */
            cropTop: { def: 0 },

            /**
             * Amount of bottom part of the image cropped outside the object
             * border, in percent.
             */
            cropBottom: { def: 0 }

        };

    // class DrawingStyles =====================================================

    /**
     * Contains the style sheets for drawing formatting attributes.
     *
     * @constructor
     *
     * @extends StyleSheets
     *
     * @param {TextApplication} app
     *  The root application instance.
     *
     * @param {DocumentStyles} documentStyles
     *  Collection with the style containers of all style families.
     *
     * @param {Object} definitions
     *  Additional application specific attribute definitions.
     */
    function DrawingStyles(app, documentStyles, definitions, options) {

        // base constructor ---------------------------------------------------

        StyleSheets.call(this, app, documentStyles, 'drawing', _({}).extend(DEFINITIONS, definitions), options);

    } // class DrawingStyles

    // exports ================================================================

    // derive this class from class StyleSheets
    return StyleSheets.extend({ constructor: DrawingStyles });

});
