/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.management.JMException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientLifeCycleListener;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.apache.cxf.ws.addressing.impl.AddressingPropertiesImpl;
import org.apache.cxf.ws.rm.BindingFaultFactory;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.ManagedRMManager;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.Proxy;
import org.apache.cxf.ws.rm.RM10Constants;
import org.apache.cxf.ws.rm.RM11Constants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.RetransmissionQueue;
import org.apache.cxf.ws.rm.SequenceIdentifierGenerator;
import org.apache.cxf.ws.rm.Servant;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.WrappedEndpoint;
import org.apache.cxf.ws.rm.manager.DeliveryAssuranceType;
import org.apache.cxf.ws.rm.manager.DestinationPolicyType;
import org.apache.cxf.ws.rm.manager.ObjectFactory;
import org.apache.cxf.ws.rm.manager.RM10AddressingNamespaceType;
import org.apache.cxf.ws.rm.manager.SourcePolicyType;
import org.apache.cxf.ws.rm.persistence.RMMessage;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.soap.RetransmissionQueueImpl;
import org.apache.cxf.ws.rm.soap.SoapFaultFactory;
import org.apache.cxf.ws.rm.v200702.CloseSequenceType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceType;
import org.apache.cxf.ws.rmp.v200502.RMAssertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMManager {
    public static final String WSRM_VERSION_PROPERTY = "org.apache.cxf.ws.rm.namespace";
    public static final String WSRM_WSA_VERSION_PROPERTY = "org.apache.cxf.ws.rm.wsa-namespace";
    public static final String WSRM_LAST_MESSAGE_PROPERTY = "org.apache.cxf.ws.rm.last-message";
    private static final Logger LOG = LogUtils.getL7dLogger(RMManager.class);
    private Bus bus;
    private RMStore store;
    private SequenceIdentifierGenerator idGenerator;
    private RetransmissionQueue retransmissionQueue;
    private Map<Endpoint, RMEndpoint> reliableEndpoints = new HashMap<Endpoint, RMEndpoint>();
    private AtomicReference<Timer> timer = new AtomicReference();
    private RMAssertion rmAssertion;
    private DeliveryAssuranceType deliveryAssurance;
    private SourcePolicyType sourcePolicy;
    private DestinationPolicyType destinationPolicy;
    private InstrumentationManager instrumentationManager;
    private ManagedRMManager managedManager;
    private String rmNamespace = "http://schemas.xmlsoap.org/ws/2005/02/rm";
    private RM10AddressingNamespaceType rm10AddressingNamespace;

    public void startServer(Server server) {
        this.recoverReliableEndpoint(server.getEndpoint(), null);
    }

    public void stopServer(Server server) {
        this.shutdownReliableEndpoint(server.getEndpoint());
    }

    public void clientCreated(Client client) {
        if (null == this.store || null == this.retransmissionQueue) {
            return;
        }
        String id = RMUtils.getEndpointIdentifier(client.getEndpoint(), this.getBus());
        Collection<SourceSequence> sss = this.store.getSourceSequences(id);
        if (null == sss || 0 == sss.size()) {
            return;
        }
        LOG.log(Level.FINE, "Number of source sequences: {0}", sss.size());
        this.recoverReliableEndpoint(client.getEndpoint(), client.getConduit());
    }

    private ProtocolVariation getConfiguredProtocol() {
        String addrns = this.rm10AddressingNamespace == null ? null : this.rm10AddressingNamespace.getUri();
        return ProtocolVariation.findVariant(this.getRMNamespace(), addrns);
    }

    public void clientDestroyed(Client client) {
        this.shutdownReliableEndpoint(client.getEndpoint());
    }

    public String getRMNamespace() {
        return this.rmNamespace;
    }

    public void setRMNamespace(String uri) {
        this.rmNamespace = uri;
    }

    public RM10AddressingNamespaceType getRMAddressingNamespace() {
        return this.rm10AddressingNamespace;
    }

    public void setRM10AddressingNamespace(RM10AddressingNamespaceType addrns) {
        this.rm10AddressingNamespace = addrns;
    }

    public Bus getBus() {
        return this.bus;
    }

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
        if (null != this.bus) {
            this.bus.setExtension(this, RMManager.class);
        }
    }

    public RMStore getStore() {
        return this.store;
    }

    public void setStore(RMStore s) {
        this.store = s;
    }

    public RetransmissionQueue getRetransmissionQueue() {
        return this.retransmissionQueue;
    }

    public void setRetransmissionQueue(RetransmissionQueue rq) {
        this.retransmissionQueue = rq;
    }

    public SequenceIdentifierGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(SequenceIdentifierGenerator generator) {
        this.idGenerator = generator;
    }

    private Timer getTimer(boolean create) {
        Timer newt;
        Timer ret = this.timer.get();
        if (ret == null && create && !this.timer.compareAndSet(null, newt = new Timer("RMManager-Timer-" + System.identityHashCode(this), true))) {
            newt.cancel();
        }
        return this.timer.get();
    }

    public Timer getTimer() {
        return this.getTimer(true);
    }

    public BindingFaultFactory getBindingFaultFactory(Binding binding) {
        return new SoapFaultFactory(binding);
    }

    public DeliveryAssuranceType getDeliveryAssurance() {
        return this.deliveryAssurance;
    }

    public void setDeliveryAssurance(DeliveryAssuranceType deliveryAssurance) {
        this.deliveryAssurance = deliveryAssurance;
    }

    public DestinationPolicyType getDestinationPolicy() {
        return this.destinationPolicy;
    }

    public void setDestinationPolicy(DestinationPolicyType destinationPolicy) {
        this.destinationPolicy = destinationPolicy;
    }

    public RMAssertion getRMAssertion() {
        return this.rmAssertion;
    }

    public void setRMAssertion(RMAssertion rma) {
        RMAssertion.BaseRetransmissionInterval bri;
        if (null == rma) {
            rma = new RMAssertion();
            rma.setExponentialBackoff(new RMAssertion.ExponentialBackoff());
        }
        if (null == (bri = rma.getBaseRetransmissionInterval())) {
            bri = new RMAssertion.BaseRetransmissionInterval();
            rma.setBaseRetransmissionInterval(bri);
        }
        if (null == bri.getMilliseconds()) {
            bri.setMilliseconds(new Long("3000"));
        }
        this.rmAssertion = rma;
    }

    public SourcePolicyType getSourcePolicy() {
        return this.sourcePolicy;
    }

    public void setSourcePolicy(SourcePolicyType sp) {
        ObjectFactory factory = new ObjectFactory();
        if (null == sp) {
            sp = factory.createSourcePolicyType();
        }
        if (sp.getSequenceTerminationPolicy() == null) {
            sp.setSequenceTerminationPolicy(factory.createSequenceTerminationPolicyType());
        }
        this.sourcePolicy = sp;
    }

    public synchronized RMEndpoint getReliableEndpoint(Message message) throws RMException {
        String addrUri;
        String rmUri;
        ProtocolVariation protocol;
        Endpoint endpoint = message.getExchange().get(Endpoint.class);
        QName name = endpoint.getEndpointInfo().getName();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Getting RMEndpoint for endpoint with info: " + name);
        }
        if (name.equals(RM10Constants.PORT_NAME) || name.equals(RM11Constants.PORT_NAME)) {
            WrappedEndpoint wrappedEndpoint = (WrappedEndpoint)endpoint;
            endpoint = wrappedEndpoint.getWrappedEndpoint();
        }
        if ((protocol = ProtocolVariation.findVariant(rmUri = this.getRMNamespace(message), addrUri = this.getAddressingNamespace(message))) == null) {
            org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("UNSUPPORTED_NAMESPACE", LOG, addrUri, rmUri);
            LOG.log(Level.INFO, msg.toString());
            throw new RMException(msg);
        }
        RMEndpoint rme = this.reliableEndpoints.get(endpoint);
        if (null == rme) {
            Endpoint ei;
            rme = this.createReliableEndpoint(endpoint);
            org.apache.cxf.transport.Destination destination = message.getExchange().getDestination();
            EndpointReferenceType replyTo = null;
            if (null != destination) {
                AddressingProperties maps = RMContextUtils.retrieveMAPs(message, false, false);
                replyTo = maps.getReplyTo();
            }
            org.apache.cxf.transport.Destination dest = (ei = message.getExchange().get(Endpoint.class)) == null ? null : ei.getEndpointInfo().getProperty(MAPAggregator.DECOUPLED_DESTINATION, org.apache.cxf.transport.Destination.class);
            rme.initialise(message.getExchange().getConduit(message), replyTo, dest);
            this.reliableEndpoints.put(endpoint, rme);
            LOG.fine("Created new RMEndpoint.");
        }
        return rme;
    }

    public String getAddressingNamespace(Message message) {
        String addrUri = (String)message.getContextualProperty(WSRM_WSA_VERSION_PROPERTY);
        if (addrUri == null) {
            AddressingProperties maps = ContextUtils.retrieveMAPs(message, false, false, false);
            if (maps != null) {
                addrUri = maps.getNamespaceURI();
            }
            if (addrUri == null) {
                addrUri = this.getConfiguredProtocol().getWSANamespace();
            }
        }
        return addrUri;
    }

    String getRMNamespace(Message message) {
        String rmUri = (String)message.getContextualProperty(WSRM_VERSION_PROPERTY);
        if (rmUri == null) {
            RMProperties rmps = RMContextUtils.retrieveRMProperties(message, false);
            if (rmps != null) {
                rmUri = rmps.getNamespaceURI();
            }
            if (rmUri == null) {
                rmUri = this.getRMNamespace();
            }
        }
        return rmUri;
    }

    public Destination getDestination(Message message) throws RMException {
        RMEndpoint rme = this.getReliableEndpoint(message);
        if (null != rme) {
            return rme.getDestination();
        }
        return null;
    }

    public Source getSource(Message message) throws RMException {
        RMEndpoint rme = this.getReliableEndpoint(message);
        if (null != rme) {
            return rme.getSource();
        }
        return null;
    }

    public SourceSequence getSequence(Identifier inSeqId, Message message, AddressingProperties maps) throws RMException {
        Source source = this.getSource(message);
        SourceSequence seq = source.getCurrent(inSeqId);
        ProtocolVariation protocol = RMContextUtils.getProtocolVariation(message);
        if (null == seq || seq.isExpired()) {
            EndpointReferenceType to = null;
            boolean isServer = RMContextUtils.isServerSide(message);
            EndpointReferenceType acksTo = null;
            RelatesToType relatesTo = null;
            if (isServer) {
                AddressingProperties inMaps = RMContextUtils.retrieveMAPs(message, false, false);
                inMaps.exposeAs(this.getConfiguredProtocol().getWSANamespace());
                acksTo = RMUtils.createReference(inMaps.getTo().getValue());
                to = inMaps.getReplyTo();
                source.getReliableEndpoint().getServant().setUnattachedIdentifier(inSeqId);
                relatesTo = new org.apache.cxf.ws.addressing.ObjectFactory().createRelatesToType();
                Destination destination = this.getDestination(message);
                DestinationSequence inSeq = inSeqId == null ? null : destination.getSequence(inSeqId);
                relatesTo.setValue(inSeq != null ? inSeq.getCorrelationID() : null);
            } else {
                to = RMUtils.createReference(maps.getTo().getValue());
                acksTo = maps.getReplyTo();
                if (RMUtils.getAddressingConstants().getNoneURI().equals(acksTo.getAddress().getValue())) {
                    Endpoint ei = message.getExchange().get(Endpoint.class);
                    org.apache.cxf.transport.Destination dest = ei == null ? null : ei.getEndpointInfo().getProperty(MAPAggregator.DECOUPLED_DESTINATION, org.apache.cxf.transport.Destination.class);
                    acksTo = null == dest ? RMUtils.createAnonymousReference() : dest.getAddress();
                }
            }
            if (ContextUtils.isGenericAddress(to)) {
                org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("CREATE_SEQ_ANON_TARGET", LOG, to != null && to.getAddress() != null ? to.getAddress().getValue() : null);
                LOG.log(Level.INFO, msg.toString());
                throw new RMException(msg);
            }
            Proxy proxy = source.getReliableEndpoint().getProxy();
            CreateSequenceResponseType createResponse = proxy.createSequence(acksTo, relatesTo, isServer, protocol);
            if (!isServer) {
                Servant servant = source.getReliableEndpoint().getServant();
                servant.createSequenceResponse(createResponse, protocol);
            }
            seq = source.awaitCurrent(inSeqId);
            seq.setTarget(to);
        }
        return seq;
    }

    @PreDestroy
    public void shutdown() {
        Timer t;
        if (this.reliableEndpoints.size() > 0) {
            LOG.log(Level.FINE, "Shutting down RMManager with {0} remaining endpoints.", new Object[]{new Integer(this.reliableEndpoints.size())});
            for (RMEndpoint rme : this.reliableEndpoints.values()) {
                rme.shutdown();
            }
        }
        if ((t = this.getTimer(false)) != null) {
            t.purge();
            t.cancel();
        }
    }

    synchronized void shutdownReliableEndpoint(Endpoint e) {
        RMEndpoint rme = null;
        rme = this.reliableEndpoints.get(e);
        if (rme == null) {
            return;
        }
        rme.shutdown();
        Timer t = this.getTimer(false);
        if (t != null) {
            t.purge();
        }
        this.reliableEndpoints.remove(e);
    }

    void recoverReliableEndpoint(Endpoint endpoint, Conduit conduit) {
        if (null == this.store || null == this.retransmissionQueue) {
            return;
        }
        String id = RMUtils.getEndpointIdentifier(endpoint, this.getBus());
        Collection<SourceSequence> sss = this.store.getSourceSequences(id);
        Collection<DestinationSequence> dss = this.store.getDestinationSequences(id);
        if (!(null != sss && 0 != sss.size() || null != dss && 0 != dss.size())) {
            return;
        }
        LOG.log(Level.FINE, "Number of source sequences: {0}", sss.size());
        LOG.log(Level.FINE, "Number of destination sequences: {0}", dss.size());
        LOG.log(Level.FINE, "Recovering {0} endpoint with id: {1}", new Object[]{null == conduit ? "client" : "server", id});
        RMEndpoint rme = this.createReliableEndpoint(endpoint);
        rme.initialise(conduit, null, null);
        this.reliableEndpoints.put(endpoint, rme);
        for (SourceSequence ss : sss) {
            this.recoverSourceSequence(endpoint, conduit, rme.getSource(), ss);
        }
        for (DestinationSequence ds : dss) {
            this.reconverDestinationSequence(endpoint, conduit, rme.getDestination(), ds);
        }
        this.retransmissionQueue.start();
    }

    private void recoverSourceSequence(Endpoint endpoint, Conduit conduit, Source s, SourceSequence ss) {
        Collection<RMMessage> ms = this.store.getMessages(ss.getIdentifier(), true);
        if (null == ms || 0 == ms.size()) {
            this.store.removeSourceSequence(ss.getIdentifier());
            return;
        }
        LOG.log(Level.FINE, "Number of messages in sequence: {0}", ms.size());
        s.addSequence(ss, false);
        if (s.getAssociatedSequence(null) == null && !ss.isExpired() && !ss.isLastMessage()) {
            s.setCurrent(ss);
        }
        for (RMMessage m : ms) {
            MessageImpl message = new MessageImpl();
            ExchangeImpl exchange = new ExchangeImpl();
            message.setExchange(exchange);
            if (null != conduit) {
                exchange.setConduit(conduit);
                message.put("org.apache.cxf.client", Boolean.TRUE);
            }
            exchange.put(Endpoint.class, endpoint);
            exchange.put(Service.class, endpoint.getService());
            if (endpoint.getEndpointInfo().getService() != null) {
                exchange.put(ServiceInfo.class, endpoint.getEndpointInfo().getService());
                exchange.put(InterfaceInfo.class, endpoint.getEndpointInfo().getService().getInterface());
            }
            exchange.put(Binding.class, endpoint.getBinding());
            exchange.put(BindingInfo.class, endpoint.getEndpointInfo().getBinding());
            exchange.put(Bus.class, this.bus);
            SequenceType st = new SequenceType();
            st.setIdentifier(ss.getIdentifier());
            st.setMessageNumber(m.getMessageNumber());
            RMProperties rmps = new RMProperties();
            rmps.setSequence(st);
            if (ss.isLastMessage() && ss.getCurrentMessageNr() == m.getMessageNumber()) {
                CloseSequenceType close = new CloseSequenceType();
                close.setIdentifier(ss.getIdentifier());
                rmps.setCloseSequence(close);
            }
            RMContextUtils.storeRMProperties(message, rmps, true);
            if (null == conduit) {
                String to = m.getTo();
                AddressingPropertiesImpl maps = new AddressingPropertiesImpl();
                maps.setTo(RMUtils.createReference(to));
                RMContextUtils.storeMAPs(maps, message, true, false);
            }
            message.put("org.apache.cxf.ws.rm.content", m.getCachedOutputStream());
            RMContextUtils.setProtocolVariation(message, ss.getProtocol());
            this.retransmissionQueue.addUnacknowledged(message);
        }
    }

    private void reconverDestinationSequence(Endpoint endpoint, Conduit conduit, Destination d, DestinationSequence ds) {
        d.addSequence(ds, false);
    }

    RMEndpoint createReliableEndpoint(Endpoint endpoint) {
        return new RMEndpoint(this, endpoint);
    }

    public void init(Bus b) {
        this.setBus(b);
        this.initialise();
        this.registerListeners();
    }

    @PostConstruct
    void initialise() {
        if (null == this.rmAssertion) {
            this.setRMAssertion(null);
        }
        ObjectFactory factory = new ObjectFactory();
        DeliveryAssuranceType da = factory.createDeliveryAssuranceType();
        if (null == this.deliveryAssurance) {
            da.setAtLeastOnce(factory.createDeliveryAssuranceTypeAtLeastOnce());
            this.setDeliveryAssurance(da);
        } else if (this.deliveryAssurance.getExactlyOnce() != null) {
            if (this.deliveryAssurance.getAtMostOnce() == null) {
                this.deliveryAssurance.setAtMostOnce(factory.createDeliveryAssuranceTypeAtMostOnce());
            }
            if (this.deliveryAssurance.getAtLeastOnce() == null) {
                this.deliveryAssurance.setAtLeastOnce(factory.createDeliveryAssuranceTypeAtLeastOnce());
            }
        }
        if (null == this.sourcePolicy) {
            this.setSourcePolicy(null);
        }
        if (null == this.destinationPolicy) {
            DestinationPolicyType dp = factory.createDestinationPolicyType();
            dp.setAcksPolicy(factory.createAcksPolicyType());
            this.setDestinationPolicy(dp);
        }
        if (null == this.retransmissionQueue) {
            this.retransmissionQueue = new RetransmissionQueueImpl(this);
        }
        if (null == this.idGenerator) {
            this.idGenerator = new DefaultSequenceIdentifierGenerator();
        }
        if (null != this.bus) {
            this.managedManager = new ManagedRMManager(this);
            this.instrumentationManager = this.bus.getExtension(InstrumentationManager.class);
            if (this.instrumentationManager != null) {
                try {
                    this.instrumentationManager.register(this.managedManager);
                }
                catch (JMException jmex) {
                    LOG.log(Level.WARNING, "Registering ManagedRMManager failed.", jmex);
                }
            }
        }
    }

    @PostConstruct
    void registerListeners() {
        ClientLifeCycleManager clm;
        if (null == this.bus) {
            return;
        }
        ServerLifeCycleManager slm = this.bus.getExtension(ServerLifeCycleManager.class);
        if (null != slm) {
            slm.registerListener(new ServerLifeCycleListener(){

                public void startServer(Server server) {
                    RMManager.this.startServer(server);
                }

                public void stopServer(Server server) {
                    RMManager.this.stopServer(server);
                }
            });
        }
        if (null != (clm = this.bus.getExtension(ClientLifeCycleManager.class))) {
            clm.registerListener(new ClientLifeCycleListener(){

                public void clientCreated(Client client) {
                    RMManager.this.clientCreated(client);
                }

                public void clientDestroyed(Client client) {
                    RMManager.this.clientDestroyed(client);
                }
            });
        }
    }

    Map<Endpoint, RMEndpoint> getReliableEndpointsMap() {
        return this.reliableEndpoints;
    }

    void setReliableEndpointsMap(Map<Endpoint, RMEndpoint> map) {
        this.reliableEndpoints = map;
    }

    class DefaultSequenceIdentifierGenerator
    implements SequenceIdentifierGenerator {
        DefaultSequenceIdentifierGenerator() {
        }

        public Identifier generateSequenceIdentifier() {
            String sequenceID = RMContextUtils.generateUUID();
            Identifier sid = new Identifier();
            sid.setValue(sequenceID);
            return sid;
        }
    }
}

