/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import gnu.inet.encoding.IDNAException;
import javax.mail.internet.AddressException;
import org.apache.commons.logging.LogFactory;

public final class IDNA {
    private static final String ACE_PREFIX = "xn--";
    private static final String SCHEME_DELIM = "://";
    private static final char[] CHARS = new char[]{':', '/', '?'};

    private IDNA() {
    }

    public static String toACE(String idnAddress) throws AddressException {
        if (null == idnAddress || IDNA.isAscii(idnAddress)) {
            return idnAddress;
        }
        try {
            int pos = idnAddress.indexOf(64);
            if (pos < 0) {
                return idnAddress;
            }
            int length = idnAddress.length();
            if (pos == length - 1) {
                return idnAddress;
            }
            return new StringBuilder(length + 8).append(idnAddress.substring(0, pos)).append('@').append(gnu.inet.encoding.IDNA.toASCII((String)idnAddress.substring(pos + 1), (boolean)true)).toString();
        }
        catch (IDNAException e) {
            throw new AddressException(e.getMessage() + ": " + idnAddress);
        }
    }

    public static String toIDN(String aceAddress) {
        if (null == aceAddress) {
            return null;
        }
        int pos = aceAddress.indexOf(64);
        if (pos < 0 || aceAddress.indexOf(ACE_PREFIX) < 0) {
            return aceAddress;
        }
        return new StringBuilder(aceAddress.length()).append(aceAddress.substring(0, pos)).append('@').append(gnu.inet.encoding.IDNA.toUnicode((String)aceAddress.substring(pos + 1), (boolean)true)).toString();
    }

    public static String toASCII(String unicodeHostName) {
        if (null == unicodeHostName || IDNA.isAscii(unicodeHostName)) {
            return unicodeHostName;
        }
        try {
            int pos = unicodeHostName.indexOf(SCHEME_DELIM);
            if (pos < 0) {
                return gnu.inet.encoding.IDNA.toASCII((String)unicodeHostName, (boolean)true);
            }
            StringBuilder b = new StringBuilder(unicodeHostName.length() + 16);
            b.append(unicodeHostName.substring(0, pos += SCHEME_DELIM.length()));
            String host = unicodeHostName.substring(pos);
            pos = -1;
            for (int k = 0; pos < 0 && k < CHARS.length; ++k) {
                pos = host.indexOf(CHARS[k]);
            }
            if (pos < 0) {
                b.append(gnu.inet.encoding.IDNA.toASCII((String)host, (boolean)true));
            } else {
                b.append(gnu.inet.encoding.IDNA.toASCII((String)host.substring(0, pos), (boolean)true)).append(host.substring(pos));
            }
            return b.toString();
        }
        catch (IDNAException e) {
            LogFactory.getLog(IDNA.class).warn((Object)("Couldn't create ASCII representation for host name: " + unicodeHostName), (Throwable)e);
            return unicodeHostName;
        }
    }

    public static String toUnicode(String asciiHostName) {
        if (null == asciiHostName || asciiHostName.indexOf(ACE_PREFIX) < 0) {
            return asciiHostName;
        }
        int pos = asciiHostName.indexOf(SCHEME_DELIM);
        if (pos < 0) {
            return gnu.inet.encoding.IDNA.toUnicode((String)asciiHostName, (boolean)true);
        }
        StringBuilder b = new StringBuilder(asciiHostName.length());
        b.append(asciiHostName.substring(0, pos += SCHEME_DELIM.length()));
        String host = asciiHostName.substring(pos);
        pos = -1;
        for (int k = 0; pos < 0 && k < CHARS.length; ++k) {
            pos = host.indexOf(CHARS[k]);
        }
        if (pos < 0) {
            b.append(gnu.inet.encoding.IDNA.toUnicode((String)host, (boolean)true));
        } else {
            b.append(gnu.inet.encoding.IDNA.toUnicode((String)host.substring(0, pos), (boolean)true)).append(host.substring(pos));
        }
        return b.toString();
    }

    private static boolean isAscii(String s) {
        int length = s.length();
        boolean isAscci = true;
        for (int i = 0; isAscci && i < length; ++i) {
            isAscci = s.charAt(i) < '\u0080';
        }
        return isAscci;
    }
}

