/*
 * Decompiled with CFR 0.152.
 */
package de.kippdata.cria.solrext;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;

public class SimpleSearchComponent
extends SearchComponent {
    private final String TAG = "__simple_search_component__";
    private final String DESCRIPTION = "Experimental SearchComponent that modifies the filter list";
    private final String REF = "$Revision: 1.6 $";
    private static final Logger log = Logger.getLogger(SimpleSearchComponent.class);

    public String getDescription() {
        return "Experimental SearchComponent that modifies the filter list";
    }

    public String getSource() {
        return null;
    }

    public String getSourceId() {
        return null;
    }

    public String getVersion() {
        return "$Revision: 1.6 $";
    }

    public void prepare(ResponseBuilder rb) throws IOException {
        log.debug((Object)"[prepare]: nothing to be done");
    }

    public void process(ResponseBuilder rb) throws IOException {
        log.debug((Object)"[process]: Start");
        log.debug((Object)("[process]: query before = " + rb.getQuery().toString()));
        SolrQueryRequest request = rb.req;
        SolrParams params = request.getParams();
        log.debug((Object)("[process]: Parameter \"First\" is: " + params.get("First")));
        String defType = params.get("defType");
        defType = defType == null ? QParserPlugin.DEFAULT_QTYPE : defType;
        StringBuffer queryBuffer = new StringBuffer();
        queryBuffer.append("type:" + params.get("First", "plain") + " ");
        queryBuffer.append("to:" + params.get("Second", "immo"));
        String queryString = queryBuffer.toString();
        try {
            QParser parser = QParser.getParser((String)queryString, (String)defType, (SolrQueryRequest)request);
            rb.setQuery(parser.getQuery());
            rb.setQparser(parser);
            log.debug((Object)("[process]: query = " + rb.getQuery().toString()));
        }
        catch (ParseException e) {
            log.warn((Object)"[process]: ERROR building query");
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        Term ft = new Term("from", "de");
        TermQuery filterQuery = new TermQuery(ft);
        ArrayList<TermQuery> filters = new ArrayList<TermQuery>(1);
        filters.add(filterQuery);
        rb.setFilters(filters);
        log.debug((Object)("[process]: Filter = " + ((Query)rb.getFilters().get(0)).toString()));
        rb.rsp.add("__simple_search_component__", (Object)rb.req.getParamString());
        log.debug((Object)"[process]: Done.");
    }
}

