/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.obs.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Test;

/**
 * {@link SourceFileParserTest}
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public final class SourceFileParserTest {

    public SourceFileParserTest() {
        super();
    }

    @SuppressWarnings("static-method")
    @Test
    public void testParseWithError() throws BuildServiceException, IOException {
        final InputStream is = new ByteArrayInputStream(SOURCE_LIST_WITH_ERROR.getBytes("UTF-8"));
        SourceFileParser.parse(is);
        is.close();
    }

    private static final String SOURCE_LIST_WITH_ERROR = "<directory name=\"open-xchange-soap-cxf\" rev=\"82\" vrev=\"82\" srcmd5=\"e655c313e8f9e13283cce2bc775d2d43\">\n" +
        "  <entry name=\"open-xchange-soap-cxf.spec\" md5=\"ccb64d8e40c819191cb8a9c25832216f\" error=\"No such file or directory\"/>\n" +
        "  <entry name=\"open-xchange-soap-cxf_6.21.0-0.debian.tar.bz2\" md5=\"176da6a5645e8e308d25635205c30f66\" size=\"1878\" mtime=\"1341912987\"/>\n" +
        "  <entry name=\"open-xchange-soap-cxf_6.21.0-0.dsc\" md5=\"1c93261534020634d6f10c394c96a0c3\" size=\"1005\" mtime=\"1341912988\"/>\n" +
        "  <entry name=\"open-xchange-soap-cxf_6.21.0.orig.tar.bz2\" md5=\"0aa3d5ea131c20955d18bd24ad0250f3\" size=\"23429840\" mtime=\"1341912994\"/>\n" +
        "</directory>\n";

}
