/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.usm.ox_json.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.service.component.ComponentContext;
import com.openexchange.usm.api.contenttypes.ResourceInputStream;
import com.openexchange.usm.api.exceptions.AuthenticationFailedException;
import com.openexchange.usm.api.exceptions.OXCommunicationException;
import com.openexchange.usm.api.exceptions.USMStartupException;
import com.openexchange.usm.api.io.InputStreamProvider;
import com.openexchange.usm.api.session.OXConnectionInformation;
import com.openexchange.usm.api.session.Session;
import com.openexchange.usm.configuration.ConfigurationManager;
import com.openexchange.usm.configuration.ConfigurationProperties;
import com.openexchange.usm.configuration.USMInvalidConfigurationException;
import com.openexchange.usm.journal.Journal;
import com.openexchange.usm.ox_json.JSONResult;
import com.openexchange.usm.ox_json.OXJSONAccess;
import com.openexchange.usm.ox_json.OXResource;

public class OXJSONAccessService implements OXJSONAccess {

    private final OXJSONAccessImpl _delegate = new OXJSONAccessImpl();

    /*
     * (non-Javadoc)
     * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
     */
    public void activate(ComponentContext context) {
        Journal journal = (Journal) context.locateService(Journal.class.getName());
		ConfigurationManager configurationManager = (ConfigurationManager) context
				.locateService(ConfigurationManager.class.getName());
        try {
			String accessUrl = configurationManager.getProperty(ConfigurationProperties.OX_ACCESS_URL_PROPERTY,
					ConfigurationProperties.OX_ACCESS_URL_DEFAULT, true);
            int maxConnections = configurationManager.getProperty(
                ConfigurationProperties.OX_ACCESS_MAX_CONNECTIONS_PROPERTY,
					ConfigurationProperties.OX_ACCESS_MAX_CONNECTIONS_DEFAULT, false);
            int connectionTimeout = configurationManager.getProperty(
                ConfigurationProperties.OX_ACCESS_CONNECTION_TIMEOUT_PROPERTY,
					ConfigurationProperties.OX_ACCESS_CONNECTION_TIMEOUT_DEFAULT, false);
            boolean performStaleChecking = configurationManager.getProperty(
                ConfigurationProperties.OX_ACCESS_PERFORM_STALE_CHECKING_PROPERTY,
					ConfigurationProperties.OX_ACCESS_PERFORM_STALE_CHECKING_DEFAULT, false);
            boolean passHostHeaderFromClient = configurationManager.getProperty(
                ConfigurationProperties.OX_ACCESS_PASS_HOST_HEADER_FROM_CLIENT,
                    ConfigurationProperties.OX_ACCESS_PASS_HOST_HEADER_FROM_CLIENT_DEFAULT, false);
			_delegate.activate(journal.getLog(OXJSONAccess.class), accessUrl, maxConnections,
					connectionTimeout, performStaleChecking, passHostHeaderFromClient);
        } catch (USMInvalidConfigurationException e) {
			throw new USMStartupException(OXJSONErrorCode.CONFIGURATION_ERROR,
					"Could't read OX server access properties", e);
        }
    }

    /*
     * (non-Javadoc)
     * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
     */
    public void deactivate(ComponentContext context) {
        _delegate.deactivate();
    }

    public void login(Session session) throws AuthenticationFailedException, OXCommunicationException {
        _delegate.login(session);
    }

    public void logout(Session session) {
        _delegate.logout(session);
    }

    public void logout(OXConnectionInformation data) {
        _delegate.logout(data);
    }

	public JSONResult doGet(String path, String action, Session session, Map<String, String> parameters)
			throws AuthenticationFailedException, OXCommunicationException {
        return _delegate.doGet(path, action, session, parameters);
    }

	public JSONResult doPut(String path, String action, Session session, Map<String, String> parameters, byte[] data)
			throws AuthenticationFailedException, OXCommunicationException {
        return _delegate.doPut(path, action, session, parameters, data);
    }

	public JSONResult doPut(String path, String action, Session session, Map<String, String> parameters, JSONArray array)
			throws AuthenticationFailedException, OXCommunicationException {
        return _delegate.doPut(path, action, session, parameters, array);
    }

	public JSONResult doPut(String path, String action, Session session, Map<String, String> parameters,
			JSONObject object) throws AuthenticationFailedException, OXCommunicationException {
        return _delegate.doPut(path, action, session, parameters, object);
    }

	public JSONResult doPut(String path, String action, Session session, Map<String, String> parameters, String data)
			throws AuthenticationFailedException, OXCommunicationException {
        return _delegate.doPut(path, action, session, parameters, data);
    }

    public JSONResult doPut(String path, String action, Session session, Map<String, String> parameters, InputStreamProvider streamProvider) throws AuthenticationFailedException, OXCommunicationException {
        return _delegate.doPut(path, action, session, parameters, streamProvider);
    }

	public OXResource getResource(Session session, String path, Map<String, String> parameters)
			throws AuthenticationFailedException, OXCommunicationException {
        return _delegate.getResource(session, path, parameters);
    }

    public ResourceInputStream getResourceAsStream(Session session, String oxAjaxPath, Map<String, String> parameters) throws AuthenticationFailedException, OXCommunicationException {
        return _delegate.getResourceAsStream(session, oxAjaxPath, parameters);
    }

	public JSONResult storeResource(String path, String action, Session session, Map<String, String> parameters,
			JSONObject jsonData, byte[] imageByteData, String fileContentType) throws AuthenticationFailedException,
			OXCommunicationException {
        return _delegate.storeResource(path, action, session, parameters, jsonData, imageByteData, fileContentType);
    }

	public JSONObject getConfiguration(Session session, String... path) throws AuthenticationFailedException,
			OXCommunicationException {
        return _delegate.getConfiguration(session, path);
    }

    public JSONResult storeResource(String path, String action, Session session, Map<String, String> params, JSONObject json, byte[] data, String contentType, String jsonPartName, String fileName) throws AuthenticationFailedException, OXCommunicationException {
        return _delegate.storeResource(path, action, session, params, json, data, contentType, jsonPartName, fileName);
    }

    public JSONResult storeResourceFromStream(String path, String action, Session session, Map<String, String> params, JSONObject json, String contentType, String jsonPartName, String fileName, long size, InputStreamProvider streamProvider) throws AuthenticationFailedException, OXCommunicationException {
        return _delegate.storeResourceFromStream(path, action, session, params, json, contentType, jsonPartName, fileName, size, streamProvider);
    }

	public JSONResult doPost(String path, String action, Session session, Map<String, String> parameters)
			throws AuthenticationFailedException, OXCommunicationException {
        return _delegate.doPost(path, action, session, parameters);
    }

    public MultiThreadedHttpConnectionManager getHttpConnectionManager() {
        return _delegate.getHttpConnectionManager();
    }
}
