/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.connector.commands;

import static com.openexchange.usm.connector.commands.CommandConstants.*;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import com.openexchange.usm.json.ConnectorBundleErrorCodes;
import com.openexchange.usm.json.USMJSONAPIException;
import com.openexchange.usm.json.USMJSONServlet;
import com.openexchange.usm.json.USMSessionCredentials;
import com.openexchange.usm.json.push.PushNotificationService;
import com.openexchange.usm.json.response.ResponseObject;
import com.openexchange.usm.json.response.ResponseStatusCode;
import com.openexchange.usm.util.Toolkit;

/**
 * Handler for the SetPushNotification USM-JSON-Command.
 * @author ldo
 *
 */
public class SetPushNotificationHandler extends NormalCommandHandler {
	private static final String[] REQUIRED_PARAMETERS = { SESSIONID, TYPE };
	private static final String[] OPTIONAL_PARAMETERS = { HOST, PORT };

    public SetPushNotificationHandler(USMJSONServlet servlet, HttpServletRequest request) throws USMJSONAPIException {
        super(servlet, request);
    }

	@Override
	public ResponseObject handleRequest() throws USMJSONAPIException {
		USMSessionCredentials usmSessionID = (USMSessionCredentials) getHttpSession().getAttribute(getStringParameter(SESSIONID));
		String type = getStringParameter(TYPE);
		//DEBUG 
		// the service must be started by initialization
		PushNotificationService.getInstance().startup();
		if (PUSH_TYPE_NONE.equals(type)) {
			//  find and remove tapeInfo for key usmSessionID from  the map
			if (PushNotificationService.getInstance().isRun()) {
				if (PushNotificationService.getInstance().containKey(usmSessionID)) {
					PushNotificationType ti = PushNotificationService.getInstance().removeValue(usmSessionID);
					_session.removeChangeListener(ti);
				}
				return new ResponseObject(ResponseStatusCode.SUCCESS);
			}
			return new ResponseObject(ResponseStatusCode.INTERNAL_ERROR, null,
					ConnectorBundleErrorCodes.SET_PUSH_NOTIFICATION_SERVER_ISNOT_RUN_ERROR,
					"the push notification service is't running", null, null, null);
		} else if (PUSH_TYPE_UDP.equals(type)) {
			String host = getStringParameter(HOST);
			if (isHostInvalid(host))
				throw new USMJSONAPIException(ConnectorBundleErrorCodes.SET_PUSH_NOTIFICATION_INVALID_HOST_ERROR,
						ResponseStatusCode.WRONG_MISSING_PARAMETERS, "invalid host parameter for SetPushNotification");

			int portInt = convertToInt(getStringParameter(PORT));
			if (portInt < 0)
				throw new USMJSONAPIException(ConnectorBundleErrorCodes.SET_PUSH_NOTIFICATION_INVALID_PORT_ERROR,
						ResponseStatusCode.WRONG_MISSING_PARAMETERS, "invalid port parameter for SetPushNotification");
			PushNotificationTypeUDP typeInfo = new PushNotificationTypeUDP(host, portInt, _session);

			// set typeInfo by service with key usmSessionID
			if (PushNotificationService.getInstance().isRun()) {
				_session.addChangeListener(typeInfo);
				PushNotificationService.getInstance().setValue(usmSessionID, typeInfo);
				return new ResponseObject(ResponseStatusCode.SUCCESS);
			}
			return new ResponseObject(ResponseStatusCode.INTERNAL_ERROR, null,
					ConnectorBundleErrorCodes.SET_PUSH_NOTIFICATION_SERVER_ISNOT_RUN_ERROR,
					"the push notification service is't running", null, null, null);
		} else
			throw new USMJSONAPIException(ConnectorBundleErrorCodes.SET_PUSH_NOTIFICATION_INVALID_TYPE_ERROR,
					ResponseStatusCode.WRONG_MISSING_PARAMETERS, "invalid type parameter for SetPushNotification");
	}

	@Override
	protected String[] getOptionalParameters() {
		return OPTIONAL_PARAMETERS;
	}

	@Override
	protected String[] getRequiredParameters() {
		return REQUIRED_PARAMETERS;
	}

	private int convertToInt(String port) {
		if (Toolkit.isNullOrEmpty(port))
			return -1;
		try {
			return Integer.valueOf(port);
		} catch (NumberFormatException e) {
			return -1;
		}
	}

	private boolean isHostInvalid(String host) {

		try {
			InetAddress.getByName(host);
		} catch (UnknownHostException e) {
			return true;
		}

		return false;
	}
}
//TODO: use com.openexchange.push.udp.RegisterHandler.addRegisterObject(registerObject) where registerObject - com.openexchange.push.udp.RegisterObject