/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
/*
 * Copyright (C) 2009 MicroDoc GmbH, Munich, Germany
 */

package com.openexchange.usm.connector.commands;

public enum ErrorStatusCode {

    // Specific error codes for MoveItems command

    /**
     * Move Items destination doesn't exist on the server.
     */
    DESTINATION_NOT_EXIST,

    /**
     * Move Items source doesn't exist on the server.
     */
    SOURCE_NOT_EXIST,

    /**
     * No create objects permission in the destination folder (Move Items) for all objects
     */
    DESTINATION_NO_PERMISSION,

    /**
     * No delete permission in the source folder (Move Items) for all objects
     */
    SOURCE_NO_PERMISSION_ALL_OBJECTS,

    /**
     * No delete permission in the source folder (Move Items) for own objects
     */
    SOURCE_NO_PERMISSION_OWN_OBJECTS,

    // Common error codes

    /**
     * Other error.
     */
    OTHER,

    /**
     * No data object has been found for the given UUID
     */
    UNKNOWN_UUID,

    // Specific error codes for SyncInit/SyncUpdate command

    /**
     * No create permissions for objects in the folder or for a sub-folder with the given parent folder
     */
    NO_CREATE_PERMISSION,

    /**
     * No change permissions for objects in the folder or for a given folder
     */
    NO_CHANGE_PERMISSION,

    /**
     * No delete permissions for objects in the folder or for a given folder
     */
    NO_DELETE_PERMISSION,

    /**
     * A PIM attachment couldn't be created in the OX server
     */
    PIM_ATTACHMENT_CREATION_FAILED,

    /**
     * A folder could not be created because its parent folder is not accessible (i.e. it probably has been deleted)
     */
    PARENT_FOLDER_NOT_FOUND,

    /**
     * A mail folder could not be found on the server.
     */
    MAIL_FOLDER_NOT_FOUND,

    /**
     * Some problem with permissions which can not be uniquely determined based on the permission flags.
     */
    PERMISSION_DENIED_BY_SERVER,

    /**
     * The UID (calendar/tasks) already exists on server and can not be created again.
     */
    UID_ALREADY_EXISTS,

    /**
     * A PIM attachment couldn't be created in the OX server because of a limit on the number of attachments to an object
     */
    PIM_ATTACHMENT_CREATION_DENIED_COUNT,

    /**
     * A PIM attachment couldn't be created in the OX server because of a limit on the maximum size of all attachments for an object
     */
    PIM_ATTACHMENT_CREATION_DENIED_SIZE,

    /**
     * The client requested multiple operations on the same UUID. This code will be reported for all operations with that UUID, and none
     * will be executed
     */
    MULTIPLE_OPERATIONS_ON_SAME_UUID;

    public int getStatusCode() {
        return ordinal() + 1;
    }
}
