/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.connector.commands;

public class CommandConstants {

	public static final String CLIENT_FIELD_PREFIX = "CL_";
	public static final String EXTRA_PROPERTIES_PREFIX = "EP_";

	public static final String ZERO_STR = "0";

	public static final String SESSIONID = "sessionid";
	public static final String USER = "user";
	public static final String PASSWORD = "password";
	public static final String DEVICE = "device";
	public static final String TIME_ZONE = "timezone";
	public static final String START_DATE = "startDate";
	public static final String END_DATE = "endDate";
	public static final String FOLDER_TREE = "tree";
	public static final String CONFLICT_RESOLUTION = "conflictResolution";
	public static final String CUSTOM_PROPERTIES = "customProperties";
	public static final String FOLDERID = "folderid";
	public static final String SYNCID = "syncid";
	public static final String CREATED = "created";
	public static final String MODIFIED = "modified";
	public static final String DELETED = "deleted";
	public static final String DELETED_IF_EXIST = "deletedifexist";
	public static final String LIMIT = "limit";
	public static final String MORE_AVAILABLE = "moreAvailable";
	public static final String CONFIGURATION = "configuration";
	public static final String SYNC_CONTENT_TYPES = "syncContentTypes";
	public static final String AVAILABLE_CONTENT_TYPES = "availableContentTypes";
	public static final String END_SYNCHRONIZATION = "endSynchronization";
	public static final String HOST = "host";
	public static final String PORT = "port";
	public static final String OBJECTID = "objectid";
	public static final String OBJECTIDS = "objectids";
	public static final String OBJECT_UUIDS = "object_uuids";
	public static final String PROPERTIES = "properties";
	public static final String MAIL = "mail";
	public static final String CONTACT_IMAGE_DATA = "image1";
	public static final String CONTACT_IMAGE_LAST_MODIFIED = "image_last_modified";
	public static final String CONTACT_IMAGE_URL = "image1_url";
	public static final String CONTACT_IMAGE_CONTENT_TYPE = "image1_content_type";
	public static final String IMAGE1 = "image1";
	public static final String JPEG_CONTENTTYPE = "jpeg";
	public static final String IMAGE_JPEG = "image/jpeg";
	public static final String NAMES = "names";
	public static final String SOURCEFOLDERID = "sourcefolderid";
	public static final String SOURCESYNCID = "sourcesyncid";
	public static final String DESTINATIONFOLDERID = "destinationfolderid";
	public static final String DESTINATIONSYNCID = "destinationsyncid";
	public static final String TYPE = "type";
	public static final String CONTEXT_UUID = "context_uuid";
	public static final String CONTEXT_ID = "context_id";
	public static final String PUSH_TYPE_NONE = "none";
	public static final String PUSH_TYPE_UDP = "udp";
	public static final String ERRORS = "errors";
	public static final String VERSION = "version";
	public static final String USERID = "userid";
	public static final String LOCAL_TIME = "local_time";

	public static final int KEY_SIZE = 13;

	public static final String UUID_KEY = "uuid";
	public static final String OBJECT_TYPE = "objectType";
	public static final String CLIENT = "client";
	public static final String SERVER = "server";
	public static final String CONFLICTS = "conflicts";

	public static final String FOLDER_ID = "folder_id";
	public static final String FOLDER_UUID = "folder_uuid";

	public static final String CHANGE_EXCEPTIONS = "change_exceptions";

	public static final String RECURRENCE_ID = "recurrence_id";
	public static final String FLAGS = "flags";
	public static final String ATTACHMENTS = "attachments";
	public static final String ATTACHMENTS_LAST_MODIFIED = "lastModifiedOfNewestAttachmentUTC";
	public static final String DATA_KEY = "data";
	public static final String MAIL_HEADER_OX_MODULE_APPOINTMENTS = "Appointments";
	public static final String MAIL_HEADER_OX_MODULE_TASKS = "Tasks";
	public static final String MAIL_HEADER_OX_TYPE_NEW = "New";
	public static final String MAIL_HEADER_OX_TYPE_MODIFIED = "Modified";
	public static final String MAIL_HEADER_OX_TYPE_DELETED = "Deleted";
	public static final String MEETING_REQUEST = "meeting_request";
	public static final String MEETING_CANCELATION = "meeting_cancelation";
	public static final String MEETING_REPLY = "meeting_reply";
	public static final String TASK_REQUEST = "task_request";
	public static final String MEETING_UPDATE = "meeting_update";
	public static final String TASK_UPDATE = "task_update";
	public static final String MAIL_HEADER_OX_OBJ_ID = "x-open-xchange-object";
	public static final String MAIL_HEADER_OX_OBJ_UID = "x-open-xchange-uid";
	public static final String MAIL_HEADER_OX_OBJ_RDATE = "x-open-xchange-rdate";
	public static final String MAIL_HEADER_OX_TYPE = "x-open-xchange-type";
	public static final String MAIL_HEADER_OX_MODULE = "x-open-xchange-module";
	public static final String MAIL_HEADER_OX_REMINDER = "x-ox-reminder";
	public static final String MAIL_HEADERS = "headers";
	public static final String NUMBER_OF_ATTACHMENTS = "number_of_attachments";
	public static final String DISTRIBUTION_LIST = "distribution_list";
	public static final String CONFIRMATIONS = "confirmations";
	public static final String SERVER_INFO_ERROR_ON_READING_EMAIL = "SERVER INFO: Error on reading email";
	public static final String BASE64 = "base64";
	public static final String ATTACHMENT = "attachment";
	public static final String ORIGINAL_MAIL_EML = "originalMail.eml";
	public static final String FILENAME = "filename";
	public static final String NAME = "name";
	public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
	public static final String UTF_8 = "UTF-8";
	public static final String TEXT_PLAIN = "text/plain";
	public static final String MULTIPART_MIXED = "multipart/mixed";
	public static final String CONTENT_TRANSFER_ENCODING = "content-transfer-encoding";
	public static final String CONTENT_DISPOSITION = "content-disposition";
	public static final String ID = "id";
	public static final String BODY = "body";
	public static final String PARAMS = "params";
	public static final String CHARSET = "charset";
	public static final String HEADERS = "headers";
	public static final String SUBJECT = "subject";
	public static final String CONTENT_TYPE = "content-type";
	public static final String UID = "uid";
	public static final String TITLE = "title";
	public static final String REFRESH = "refresh";
    public static final String TEMPID = "tempid";
    public static final String OFFSET = "offset";
    public static final String LENGTH = "length";
    public static final String EXACT_SIZE = "exact_size";
}
