/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.contenttypes.util;

import java.io.Serializable;
import com.openexchange.usm.api.contenttypes.ContentType;
import com.openexchange.usm.api.contenttypes.ContentTypeField;
import com.openexchange.usm.api.contenttypes.ContentTypeTransferHandler;
import com.openexchange.usm.api.exceptions.DeserializationFailedException;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.Session;

/**
 * Abstract base class for simple wrapper classes that provide an extra layer between the OSGi service
 * interface and internal implementation classes for ContentTypes.
 * 
 * @author afe
 *
 */
public abstract class AbstractContentTypeService implements ContentType {

	public void deserializeData(Serializable[] data, int i, Object[] fieldContent)
			throws DeserializationFailedException {
		getDelegate().deserializeData(data, i, fieldContent);
	}

	public int getCode() {
		return getDelegate().getCode();
	}

	public ContentTypeField[] getFields() {
		return getDelegate().getFields();
	}

	public String getID() {
		return getDelegate().getID();
	}

	public int getMatchRating(DataObject client, DataObject server) {
		return getDelegate().getMatchRating(client, server);
	}

	public ContentTypeTransferHandler getTransferHandler() {
		return getDelegate().getTransferHandler();
	}

	public DataObject newDataObject(Session session) {
		return getDelegate().newDataObject(session);
	}

	@Override
	public int hashCode() {
		return getDelegate().hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		return getDelegate().equals(obj);
	}

	protected abstract ContentType getDelegate();
	
	public boolean supportsPIMAttachments() {
		return getDelegate().supportsPIMAttachments();
	}
	
	public Object getObjectGroupOwner(DataObject object) {
		return getDelegate().getObjectGroupOwner(object);
	}
	
	public boolean canBeFolderElementsContentType() {
		return getDelegate().canBeFolderElementsContentType();
	}
}
