/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.datatypes.mail;

import java.io.Serializable;
import java.util.*;
import java.util.Map.Entry;

import org.json.*;

/**
 * This class realizes an object with a field for every non-standard header. 
 * The header name is the field name. The header value is the value of the field as string. 
 * @author ibr
 *
 */
public class Headers implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private final Map<String, String[]> _map;

	public Map<String, String[]> getMap() {
		return _map;
	}

	public Headers(Map<String, String[]> map) {
		if (map == null)
			_map = Collections.emptyMap();
		else
			_map = Collections.unmodifiableMap(map);
	}

	public Headers(JSONObject jSONObject) throws JSONException {
		if (jSONObject != null) {
			Map<String, String[]> map = new HashMap<String, String[]>();
			for (Iterator<?> iterator = jSONObject.keys(); iterator.hasNext();) {
				String key = (String) iterator.next();
				Object value = jSONObject.get(key);
				if (value instanceof String) {
					String[] strings = new String[1];
					strings[0] = value.toString();
					map.put(key, strings);
				} else if (value instanceof JSONArray) {
					JSONArray array = (JSONArray) value;
					String[] strings = new String[array.length()];
					for (int i = 0; i < strings.length; i++)
						strings[i] = array.isNull(i) ? "" : array.getString(i);
					map.put(key, strings);
				}

			}
			_map = Collections.unmodifiableMap(map);
		} else {
			_map = Collections.emptyMap();
		}
	}

	public Headers() {
		_map = Collections.emptyMap();
	}

	@Override
	public int hashCode() {
		return _map.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Headers other = (Headers) obj;

		//return _map.equals(other.getMap());
		return isMapEqual(other.getMap());
	}

	private boolean isMapEqual(Map<String, String[]> otherMap) {
		// TODO Improve the quality of the code in this method
		if (_map.size() != otherMap.size())
			return false;
		try {
			Iterator<Entry<String, String[]>> iterator = _map.entrySet().iterator();
			while (iterator.hasNext()) {
				Entry<String, String[]> entry = iterator.next();
				String key = entry.getKey();
				String[] element = entry.getValue();
				if (element == null) {
					if (!(otherMap.get(key) == null && otherMap.containsKey(key)))
						return false;
				} else {
					if (!Arrays.equals(element, otherMap.get(key)))
						return false;
				}
			}
		} catch (NullPointerException e1) {
			return false;
		}

		return true;
	}

	@Override
	public String toString() {
		if (_map == null)
			return "";
		StringBuilder sb = new StringBuilder(1000);
		for (String key : _map.keySet()) {
			if (sb.length() > 0)
				sb.append(';');
			String[] strings = _map.get(key);
			sb.append(key).append(':').append('[').append(strings[0]);
			if (strings.length > 1) {
				for (int i = 1; i < strings.length; i++) {
					sb.append(',').append(strings[i]);
				}
			}
			sb.append(']');
		}
		return sb.toString();
	}

	public JSONObject toJSONObject() throws JSONException {
		JSONObject result = new JSONObject();
		for (Map.Entry<String, String[]> entry : _map.entrySet()) {
			String key = entry.getKey();
			String[] data = entry.getValue();
			if (data == null || data.length == 0) {
				result.put(key, "");
			} else if (data.length == 1) {
				result.put(key, data[0]);
			} else {
				JSONArray array = new JSONArray();
				for (String s : data)
					array.put(s);
				result.put(key, array);
			}
		}
		return result;
	}
}
