/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.usm.json.streaming;

import static com.openexchange.usm.connector.commands.CommandConstants.*;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.contenttypes.util.UtilConstants;
import com.openexchange.usm.util.JSONToolkit;

/**
 * {@link MailAttachmentStreamingUtil} Helper class that parses a structured mail JSONObject as returned from OX, and replaces all "data"
 * fields with a new value with a "tempid" field that can later be used to download the attachment via the "downloadData" command.
 * 
 * @author <a href="mailto:afe@microdoc.de">Alexander Feess</a>
 */
public final class MailAttachmentStreamingUtil {

    public static void replaceEmptyDataWithTempId(DataObject mail, JSONObject structuredMail, boolean supportsAttachmentStreaming) {
        if (structuredMail.has(ID) && structuredMail.has(DATA_KEY) && structuredMail.has(EXACT_SIZE) && structuredMail.isNull(DATA_KEY) && !structuredMail.has(TEMPID)) {
            try {
                if (supportsAttachmentStreaming) {
                    String attachmentId = structuredMail.optString(UtilConstants.ID);
                    long exactSize = structuredMail.optLong(EXACT_SIZE);
                    structuredMail.put(TEMPID, new AttachmentTempId(mail, attachmentId, exactSize));
                    structuredMail.remove(DATA_KEY);
                    structuredMail.remove(EXACT_SIZE);
                } else {
                    structuredMail.put(DATA_KEY, "");
                }
            } catch (JSONException ignored) {
                // can not happen
            }
        }
        for (String key : JSONToolkit.keys(structuredMail)) {
            Object o = structuredMail.opt(key);
            if (o instanceof JSONObject)
                replaceEmptyDataWithTempId(mail, (JSONObject) o, supportsAttachmentStreaming);
            else if (o instanceof JSONArray)
                checkMailSubArray(mail, (JSONArray) o, supportsAttachmentStreaming);
        }
    }

    private static void checkMailSubArray(DataObject mail, JSONArray array, boolean supportsAttachmentStreaming) {
        for (int i = 0; i < array.length(); i++) {
            Object o = array.opt(i);
            if (o instanceof JSONObject)
                replaceEmptyDataWithTempId(mail, (JSONObject) o, supportsAttachmentStreaming);
            else if (o instanceof JSONArray)
                checkMailSubArray(mail, (JSONArray) o, supportsAttachmentStreaming);
        }
    }

    private MailAttachmentStreamingUtil() {
    }
}
