/*
 * Copyright 2012 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.odftoolkit.odfdom.component;

import java.io.FileInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.odftoolkit.odfdom.doc.LoadSaveTest;
import org.odftoolkit.odfdom.utils.ResourceUtilities;

/**
 * Test operations on a text component
 * @author svanteschubert
 */
public class TextComponentTest {

	private static final Logger LOG = Logger.getLogger(TextComponentTest.class.getName());

	public TextComponentTest() {
	}


	@Test
	public void sizeTest() {
		final String SOURCE_FILE_NAME_TRUNC = "TextLineBreakText";
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
		final String TARGET_FILE_NAME_1 = "_OUT_2.odt";



		try {
			//**********LOAD
			// read the (known) operation from the test document
			TextOperationDocument doc = new TextOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));

			//**********GET OPS
			JSONObject ops = doc.getOperations();
			System.out.println("ops:" + ops);
			//**********APPLY
//			TextOperationDocument doc2 = new TextOperationDocument();
//			int opCount = doc2.applyOperations(ops);
//			LOG.log(Level.INFO, "opCount: {0}", opCount);
//
////   UUID uniqueKey = UUID.randomUUID(); 			
//			
//			//**********SAVE		
//			File testFile = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_1);
//			doc2.getDocument().save(testFile);
//
//			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());

//			// read the (known) operation from the test document			
//			OdfContentDom contentDom2 = doc2.getDocument().getContentDom();
//			XPath xpath = contentDom2.getXPath();
//			Node rootNode = contentDom2.getRootElement();
//
//			// heading with no automatic properties should only bear a style reference
//			TextHElement header1 = (TextHElement) xpath.evaluate(".//text:h[1]", rootNode, XPathConstants.NODE);
//			if (header1 == null || !header1.getTextStyleNameAttribute().equals("Heading2")) {
//				Assert.fail("The first heading does not have the expected style 'Heading2'!");
//			}
//
//			TextHElement header = (TextHElement) xpath.evaluate(".//text:h[contains(text(), 'Paragraph Borders Outside')]", rootNode, XPathConstants.NODE);
//			if (header == null) {
//				Assert.fail("The test heading with 'Paragraph Borders Outside' could not be found!");
//			}
//			Node nextSibling = header.getNextSibling();
//			while (!(nextSibling instanceof OdfElement)) {
//				nextSibling = header.getNextSibling();
//			}
//			TextPElement testParagraph = (TextPElement) nextSibling;
//			OdfStyleProperty borderProp = OdfParagraphProperties.Border;
//			OdfStyleProperty borderBottomProp = OdfParagraphProperties.BorderBottom;
//			OdfStyleProperty borderLeftProp = OdfParagraphProperties.BorderLeft;
//			OdfStyleProperty borderRightProp = OdfParagraphProperties.BorderRight;
//			OdfStyleProperty borderTopProp = OdfParagraphProperties.BorderTop;
////			String border = testParagraph.getProperty(borderProp);
//			String borderBottom = testParagraph.getProperty(borderBottomProp);
//			String borderLeft = testParagraph.getProperty(borderLeftProp);
//			String borderRight = testParagraph.getProperty(borderRightProp);
//			String borderTop = testParagraph.getProperty(borderTopProp);

//			System.out.println("STYLENAME: " + testParagraph.getStyleName());
//			
////			System.out.println("******************************CONTENT:" + nextSibling.getTextContent());
//			System.out.println("******************************border:" + border);
//			System.out.println("******************************borderBottom:" + borderBottom);
//			System.out.println("******************************borderLeft:" + borderLeft);
//			System.out.println("******************************borderRight:" + borderRight);
//			System.out.println("******************************borderTop:" + borderTop);


//			NodeList header = odfContent2.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "h");
//			Node node2 = header.
//			String paragraphText2 = node2.getTextContent();			


		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

}