/*
 * Copyright 2012 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.odftoolkit.odfdom.component;

import org.odftoolkit.odfdom.component.TextOperationDocument;
import java.io.File;
import java.io.FileInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.odftoolkit.odfdom.doc.LoadSaveTest;
import org.odftoolkit.odfdom.utils.ResourceUtilities;

/**
 * Loads a document with lists and gathers its operations.
 * Gathered operations will be applied to an empty text document.
 * The changed text document will be saved and reloaded. 
 * New gathered operations will be compared with the original ones, expected to be identical!
 * 
 * @author svanteschubert
 */
public class RoundtripListTest extends RoundtripTestTemplate {

	private static final Logger LOG = Logger.getLogger(RoundtripListTest.class.getName());
	private static final String OUTPUT_DIRECTORY = "regression-tests" + File.separatorChar;

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		// Creating the output directory for the tests
		File outputDir = ResourceUtilities.newTestOutputFile(OUTPUT_DIRECTORY);
		outputDir.mkdir();
	}

	public RoundtripListTest() {
	}


	@Test
	@Ignore
	// FIX ME
	public void simpleListHandling() {
		final String SOURCE_FILE_NAME_TRUNC = "HelloWorld";		
//		final String INITIAL_OPS_SUFFIX = "_odt_inital-ops-ascii.txt";		
//		final String RELOADED_OPS_SUFFIX = "_odt_reloaded-ops-ascii.txt";
		final String TARGET_FILE_NAME_SUFFIX = "_OUT.odt";
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";		
		
		final String OPS = "["+
			 "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"?\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel6\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"?\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel7\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"?\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel5\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"?\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel4\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"?\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel3\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"?\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel2\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"?\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel1\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"?\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel0\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"?\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L10009\"}," + 
			 "{\"styleId\":\"ListParagraph\",\"styleName\":\"List Paragraph\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"contextualSpacing\":true},\"next\":\"ListParagraph\"},\"name\":\"insertStyleSheet\",\"parent\":\"default_paragraph_style\",\"uiPriority\":34,\"type\":\"paragraph\"}," + 
			 "{\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L10009\",\"listLevel\":0}},\"name\":\"setAttributes\"}," + 
			 "{\"start\":[1],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L10009\",\"listLevel\":0}},\"name\":\"setAttributes\"}," + 
			 "{\"start\":[2],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L10009\",\"listLevel\":0}},\"name\":\"setAttributes\"}," + 
			 "{\"start\":[1],\"attrs\":{\"paragraph\":{\"listLevel\":1}},\"name\":\"setAttributes\"}," + 
			 "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9)\",\"indentLeft\":11430,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7)\",\"indentLeft\":8890,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8)\",\"indentLeft\":10160,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6)\",\"indentLeft\":7620,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5)\",\"indentLeft\":6350,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4)\",\"indentLeft\":5080,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3)\",\"indentLeft\":3810,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2)\",\"indentLeft\":2540,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1)\",\"indentLeft\":1270,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L10004\"}," + 
			 "{\"start\":[3],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L10004\",\"listLevel\":0}},\"name\":\"setAttributes\"}," + 
			 "{\"start\":[4],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L10004\",\"listLevel\":0}},\"name\":\"setAttributes\"}," + 
			 "{\"start\":[4,12],\"name\":\"splitParagraph\"}," + 
			 "{\"text\":\"S\",\"start\":[5,0],\"name\":\"insertText\"}]";
		
		try {
			//**********LOAD
			TextOperationDocument doc = new TextOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));
//			// read the (known) operations from the test document			
//			JSONObject ops = doc.getOperations();
//			LOG.log(Level.INFO, "The Operation in ASCII are: {0}", ops.toString(true));
			// FOR LATER TEST ADOPTIONS:
			//ResourceUtilities.saveFileAsString(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + INITIAL_OPS_SUFFIX), ops.toString(true));
			
//			String initalOpsFromFile = ResourceUtilities.loadFileAsString(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + INITIAL_OPS_SUFFIX));
//			LOG.log(Level.INFO, "The ops from file :{0}", initalOpsFromFile);						
//			Assert.assertTrue(ops.toString(true).equals(initalOpsFromFile));
		
			//**********APPLY
			TextOperationDocument doc2 = new TextOperationDocument();
			int opCount = doc2.applyOperations(OPS);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE		
			File testFile = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_SUFFIX);
			doc2.getDocument().save(testFile);
			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());


		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}		
	
	@Test
	@Ignore
	public void roundTripLists() {
		//final String SOURCE_FILE_NAME_TRUNC = "ListTest_AO_MSO15-where_is-blue";
		final String SOURCE_FILE_NAME_TRUNC = "ListStyleResolution";		
		//final String SOURCE_FILE_NAME_TRUNC = "ContinueListTest";
		final String INITIAL_OPS_SUFFIX = "_odt_inital-ops-ascii.txt";		
		final String RELOADED_OPS_SUFFIX = "_odt_reloaded-ops-ascii.txt";
		final String TARGET_FILE_NAME_SUFFIX = "_OUT.odt";
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";		
		
		try {
			//**********LOAD
			TextOperationDocument doc = new TextOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));
			// read the (known) operations from the test document			
			JSONObject ops = doc.getOperations();
			LOG.log(Level.INFO, "The Operation in ASCII are: {0}", ops.toString(true).replace("},{", "},\n{"));
			// FOR REGRESSION TEST REFERENCE CREATION - THE OPERATION OF THE ORIGINAL DOCUMENT
			ResourceUtilities.saveStringToFile(ResourceUtilities.newTestOutputFile(OUTPUT_DIRECTORY + SOURCE_FILE_NAME_TRUNC + INITIAL_OPS_SUFFIX), ops.toString(true).replace("},{", "},\n{"));
			String initalOpsFromFile = ResourceUtilities.loadFileAsString(ResourceUtilities.getReferenceFile(OUTPUT_DIRECTORY + SOURCE_FILE_NAME_TRUNC + INITIAL_OPS_SUFFIX));
			LOG.log(Level.INFO, "The ops from file :{0}", initalOpsFromFile);						
			Assert.assertTrue(ops.toString(true).replace("},{", "},\n{").equals(initalOpsFromFile));
		
			//**********APPLY
			TextOperationDocument doc2 = new TextOperationDocument();
			int opCount = doc2.applyOperations(ops);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE		
			File testFile = ResourceUtilities.newTestOutputFile(OUTPUT_DIRECTORY + SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_SUFFIX);
			doc2.getDocument().save(testFile);
			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());

			//**********RELOAD
			TextOperationDocument doc3 = new TextOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(OUTPUT_DIRECTORY + SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_SUFFIX)));
			// read the (known) operation from the test document			
			JSONObject ops2 = doc3.getOperations();
			LOG.log(Level.INFO, "The reloaded Ops are:{0}", ops2.toString());			
			
			// FOR REGRESSION TEST REFERENCE CREATION - THE OPERATION OF THE RELOADED DOCUMENT
			ResourceUtilities.saveStringToFile(ResourceUtilities.newTestOutputFile(OUTPUT_DIRECTORY + SOURCE_FILE_NAME_TRUNC + RELOADED_OPS_SUFFIX), ops2.toString(true).replace("},{", "},\n{"));			
			String reloadedOpsFromFile = ResourceUtilities.loadFileAsString(ResourceUtilities.getReferenceFile(OUTPUT_DIRECTORY + SOURCE_FILE_NAME_TRUNC + RELOADED_OPS_SUFFIX));
			LOG.log(Level.INFO, "The ops from file :{0}", reloadedOpsFromFile);			
			
			// Test the known read operations with the above one - using ASCII-compare, e.g. UTF-8 character for list bullets 		
			Assert.assertTrue(ops2.toString(true).replace("},{", "},\n{").equals(reloadedOpsFromFile));


//			//**********GET OPS
//			JSONObject ops = doc.getOperations();
//			System.out.println("ops:" + ops);
//			//**********APPLY
////			TextOperationDocument doc2 = new TextOperationDocument();
////			int opCount = doc2.applyOperations(ops);
////			LOG.log(Level.INFO, "opCount: {0}", opCount);
////
//////   UUID uniqueKey = UUID.randomUUID(); 			
////			
////			//**********SAVE		
////			File testFile = ResourceUtilities.newTestOutputFile(OUTPUT_DIRECTORY + SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_1);
////			doc2.getDocument().save(testFile);
////
////			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());
//
////			// read the (known) operation from the test document			
////			OdfContentDom contentDom2 = doc2.getDocument().getContentDom();
////			XPath xpath = contentDom2.getXPath();
////			Node rootNode = contentDom2.getRootElement();
////
////			// heading with no automatic properties should only bear a style reference
////			TextHElement header1 = (TextHElement) xpath.evaluate(".//text:h[1]", rootNode, XPathConstants.NODE);
////			if (header1 == null || !header1.getTextStyleNameAttribute().equals("Heading2")) {
////				Assert.fail("The first heading does not have the expected style 'Heading2'!");
////			}
////
////			TextHElement header = (TextHElement) xpath.evaluate(".//text:h[contains(text(), 'Paragraph Borders Outside')]", rootNode, XPathConstants.NODE);
////			if (header == null) {
////				Assert.fail("The test heading with 'Paragraph Borders Outside' could not be found!");
////			}
////			Node nextSibling = header.getNextSibling();
////			while (!(nextSibling instanceof OdfElement)) {
////				nextSibling = header.getNextSibling();
////			}
////			TextPElement testParagraph = (TextPElement) nextSibling;
////			OdfStyleProperty borderProp = OdfParagraphProperties.Border;
////			OdfStyleProperty borderBottomProp = OdfParagraphProperties.BorderBottom;
////			OdfStyleProperty borderLeftProp = OdfParagraphProperties.BorderLeft;
////			OdfStyleProperty borderRightProp = OdfParagraphProperties.BorderRight;
////			OdfStyleProperty borderTopProp = OdfParagraphProperties.BorderTop;
//////			String border = testParagraph.getProperty(borderProp);
////			String borderBottom = testParagraph.getProperty(borderBottomProp);
////			String borderLeft = testParagraph.getProperty(borderLeftProp);
////			String borderRight = testParagraph.getProperty(borderRightProp);
////			String borderTop = testParagraph.getProperty(borderTopProp);
//
////			System.out.println("STYLENAME: " + testParagraph.getStyleName());
////			
//////			System.out.println("******************************CONTENT:" + nextSibling.getTextContent());
////			System.out.println("******************************border:" + border);
////			System.out.println("******************************borderBottom:" + borderBottom);
////			System.out.println("******************************borderLeft:" + borderLeft);
////			System.out.println("******************************borderRight:" + borderRight);
////			System.out.println("******************************borderTop:" + borderTop);
//
//
////			NodeList header = odfContent2.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "h");
////			Node node2 = header.
////			String paragraphText2 = node2.getTextContent();			
//

		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}	
}