/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.io.BaseReader;
import com.fasterxml.jackson.core.io.IOContext;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;

public class UTF32Reader
extends BaseReader {
    protected final boolean _bigEndian;
    protected char _surrogate = '\u0000';
    protected int _charCount = 0;
    protected int _byteCount = 0;
    protected final boolean _managedBuffers;

    public UTF32Reader(IOContext ctxt, InputStream in, byte[] buf, int ptr, int len, boolean isBigEndian) {
        super(ctxt, in, buf, ptr, len);
        this._bigEndian = isBigEndian;
        this._managedBuffers = in != null;
    }

    /*
     * Unable to fully structure code
     */
    public int read(char[] cbuf, int start, int len) throws IOException {
        block7: {
            if (this._buffer == null) {
                return -1;
            }
            if (len < 1) {
                return len;
            }
            if (start < 0 || start + len > cbuf.length) {
                this.reportBounds(cbuf, start, len);
            }
            len += start;
            outPtr = start;
            if (this._surrogate == '\u0000') break block7;
            cbuf[outPtr++] = this._surrogate;
            this._surrogate = '\u0000';
            ** GOTO lbl30
        }
        left = this._length - this._ptr;
        if (left >= 4 || this.loadMore(left)) ** GOTO lbl30
        return -1;
lbl-1000:
        // 1 sources

        {
            ptr = this._ptr;
            ch = this._bigEndian != false ? this._buffer[ptr] << 24 | (this._buffer[ptr + 1] & 255) << 16 | (this._buffer[ptr + 2] & 255) << 8 | this._buffer[ptr + 3] & 255 : this._buffer[ptr] & 255 | (this._buffer[ptr + 1] & 255) << 8 | (this._buffer[ptr + 2] & 255) << 16 | this._buffer[ptr + 3] << 24;
            this._ptr += 4;
            if (ch > 65535) {
                if (ch > 0x10FFFF) {
                    this.reportInvalid(ch, outPtr - start, "(above " + Integer.toHexString(0x10FFFF) + ") ");
                }
                cbuf[outPtr++] = (char)(55296 + ((ch -= 65536) >> 10));
                ch = 56320 | ch & 1023;
                if (outPtr >= len) {
                    this._surrogate = (char)ch;
                    break;
                }
            }
            cbuf[outPtr++] = (char)ch;
            if (this._ptr >= this._length) break;
lbl30:
            // 3 sources

            ** while (outPtr < len)
        }
lbl31:
        // 3 sources

        len = outPtr - start;
        this._charCount += len;
        return len;
    }

    private void reportUnexpectedEOF(int gotBytes, int needed) throws IOException {
        int bytePos = this._byteCount + gotBytes;
        int charPos = this._charCount;
        throw new CharConversionException("Unexpected EOF in the middle of a 4-byte UTF-32 char: got " + gotBytes + ", needed " + needed + ", at char #" + charPos + ", byte #" + bytePos + ")");
    }

    private void reportInvalid(int value, int offset, String msg) throws IOException {
        int bytePos = this._byteCount + this._ptr - 1;
        int charPos = this._charCount + offset;
        throw new CharConversionException("Invalid UTF-32 character 0x" + Integer.toHexString(value) + msg + " at char #" + charPos + ", byte #" + bytePos + ")");
    }

    private boolean loadMore(int available) throws IOException {
        int count;
        this._byteCount += this._length - available;
        if (available > 0) {
            if (this._ptr > 0) {
                int i = 0;
                while (i < available) {
                    this._buffer[i] = this._buffer[this._ptr + i];
                    ++i;
                }
                this._ptr = 0;
            }
            this._length = available;
        } else {
            this._ptr = 0;
            int n = count = this._in == null ? -1 : this._in.read(this._buffer);
            if (count < 1) {
                this._length = 0;
                if (count < 0) {
                    if (this._managedBuffers) {
                        this.freeBuffers();
                    }
                    return false;
                }
                this.reportStrangeStream();
            }
            this._length = count;
        }
        while (this._length < 4) {
            int n = count = this._in == null ? -1 : this._in.read(this._buffer, this._length, this._buffer.length - this._length);
            if (count < 1) {
                if (count < 0) {
                    if (this._managedBuffers) {
                        this.freeBuffers();
                    }
                    this.reportUnexpectedEOF(this._length, 4);
                }
                this.reportStrangeStream();
            }
            this._length += count;
        }
        return true;
    }
}

