package com.openexchange.office.calcengine.client;

import org.apache.commons.lang.StringUtils;
import com.openexchange.config.ConfigurationService;
import com.openexchange.server.ServiceLookup;


//=============================================================================
public class CalcEngineConfig
{
    //-------------------------------------------------------------------------
    /** define the mode how calc engine has to be used.
     *  possible modes are : 
     *  - inline
     *  - remote
     */
    public static final String PROP_CALCENGINE_MODE = "calcengine.mode";

    //-------------------------------------------------------------------------
    /** define the server base URI where the remote calc engine
     *  Rest server is running.
     */
    public static final String PROP_CALCENGINE_SERVER_BASEURI = "calcengine.server.baseuri";

    //-------------------------------------------------------------------------
    public static final String CFGVALUE_MODE_REMOTE = "remote";
    public static final String CFGVALUE_MODE_INLINE = "inline";

    //-------------------------------------------------------------------------
    public static final ECalcEngineMode DEFAULT_MODE           = ECalcEngineMode.E_INLINE;
    public static final String          DEFAULT_SERVER_BASEURI = "http://localhost:8088";
    
    //-------------------------------------------------------------------------
    /** Use factory method {@link get()} to create new instances.
     *  We want to force using our singleton .-)
     */
    private CalcEngineConfig ()
        throws Exception
    {}
    
    //-------------------------------------------------------------------------
    public synchronized static CalcEngineConfig get ()
        throws Exception
    {
        if (m_gSingleton == null)
            m_gSingleton = new CalcEngineConfig ();
        return m_gSingleton;
    }

    //-------------------------------------------------------------------------
    protected void setContext (ServiceLookup aSmgr)
        throws Exception
    {
        m_aSmgr = aSmgr;
    }

    //-------------------------------------------------------------------------
    public ECalcEngineMode getMode ()
        throws Exception
    {
        String          sMode = mem_CfgSrv ().getProperty(PROP_CALCENGINE_MODE);
        ECalcEngineMode eMode = DEFAULT_MODE;
        
        if (StringUtils.equalsIgnoreCase(sMode, CalcEngineConfig.CFGVALUE_MODE_INLINE))
            eMode = ECalcEngineMode.E_INLINE;

        else
        if (StringUtils.equalsIgnoreCase(sMode, CalcEngineConfig.CFGVALUE_MODE_REMOTE))
            eMode = ECalcEngineMode.E_REMOTE;
        
        return eMode;
    }

    //-------------------------------------------------------------------------
    public String getServerBaseURI ()
        throws Exception
    {
        String sURI = mem_CfgSrv ().getProperty(PROP_CALCENGINE_SERVER_BASEURI, DEFAULT_SERVER_BASEURI);
        return sURI;
    }
    
    //-------------------------------------------------------------------------
    private ConfigurationService mem_CfgSrv ()
        throws Exception
    {
        if (m_aCfgSrv == null)
            m_aCfgSrv = m_aSmgr.getService(ConfigurationService.class);
        return m_aCfgSrv;
    }

    //-------------------------------------------------------------------------
    private static CalcEngineConfig m_gSingleton = null;
    
    //-------------------------------------------------------------------------
    private ServiceLookup m_aSmgr = null;
    
    //-------------------------------------------------------------------------
    private ConfigurationService m_aCfgSrv = null;
}
