/*
 * Copyright 2012 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.odftoolkit.odfdom.component;

import java.io.File;
import java.io.FileInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.odftoolkit.odfdom.doc.LoadSaveTest;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.style.props.OdfParagraphProperties;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.utils.ResourceUtilities;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Loads a document and creates a queue of create operations for the first level
 * paragraphs and their text.
 *
 * @author svanteschubert
 */
public class OperationJsonTest {
	
	private static final Logger LOG = Logger.getLogger(OperationJsonTest.class.getName());
	private static final String SOURCE_DEMO = "FruitDepot-SeasonalFruits4.odt";
	private static final String SOURCE_DEMO_2 = "FruitDepot-SeasonalFruits5.odt";
	private static final String TARGET_DEMO_1 = "FruitDepot-SeasonalFruits4-changed1.odt";
	private static final String TARGET_DEMO_2 = "FruitDepot-SeasonalFruits4-changed2.odt";
	private static final String TARGET_DEMO_STRING = "FruitDepot-SeasonalFruits4-byStringOps.odt";
	private static final String TARGET_DEMO_STRING2 = "FruitDepot-SeasonalFruits4-byStringOps2.odt";
	private static final String TARGET_DEMO_STRING3 = "FruitDepot-SeasonalFruits4-byStringOps3.odt";
	private static final String TARGET_DEMO_STRING4 = "FruitDepot-SeasonalFruits4-byStringOps4.odt";
	private static final String JSON_REFERENCE_OPERATIONS_DEMO = "{\"operations\":[{\"name\":\"initDocument\"},{\"start\":[0],\"name\":\"insertParagraph\"},{\"text\":\"Seasonal Fruits\",\"start\":[0,0],\"name\":\"insertText\"},{\"start\":[1],\"name\":\"insertParagraph\"},{\"text\":\"Ich bin Blindtext. Von Geburt an. Es hat lange, bis ich begriffen habe, was es bedeutet, ein blinder Text zu sein: Man macht keinen Sinn. Man wirkt hier und da aus dem Zusammenhang gerissen. Oft wird man gar nicht erst gelesen. Aber bin ich deshalb ein schlechter Text?Ich weiß, dass ich nie die Chance haben werde im Stern zu erscheinen. Aber bin ich darum weniger wichtig? Ich bin blind! Aber ich bin gerne Text. Und sollten Sie mich jetzt tatsächlich zu Ende lesen, dann habe ich etwas geschafft, was den meisten \"normalen\" Texten nicht gelingt. Ich bin Blindtext. Von Geburt an. Es hat lange gedauert, bis ich begriffen habe, was es bedeutet, ein blinder Text zu sein: Man macht keinen Sinn. Man wirkt hier und da aus dem Zusammenhang gerissen. Oft wird man gar nicht erst gelesen. Aber bin ich darum weniger wichtig? Ich bin blind! Aber ich bin gerne Text. Und sollten Sie mich jetzt tatsächlich zu Ende lesen, dann habe ich etwas geschafft, was den meisten \"normalen\" Texten nicht gelingt. Ich bin Blindtext.\",\"start\":[1,0],\"name\":\"insertText\"},{\"start\":[2],\"name\":\"insertParagraph\"},{\"text\":\"Ich bin blind! Aber ich bin gerne Text. Und sollten Sie mich jetzt tatsächlich zu Ende lesen, dann habe ich etwas geschafft, was den meisten \"normalen\" Texten nicht gelingt. Ich bin Blindtext. Von Geburt an. Es hat lange gedauert, bis ich begriffen habe, was es bedeutet, ein blinder Text zu sein: Man macht keinen Sinn. Man wirkt hier und da aus dem Zusammenhang gerissen. Oft wird man gar nicht erst gelesen. Aber bin ich darum weniger wichtig? Ich bin blind! Aber ich bin gerne Text. Und sollten Sie mich jetzt tatsächlich zu Ende lesen, dann habe ich etwas geschafft, was den meisten \"normalen\" Texten nicht gelingt. Ich bin Blindtext.\",\"start\":[2,0],\"name\":\"insertText\"},{\"start\":[3],\"name\":\"insertParagraph\"},{\"start\":[4],\"name\":\"insertParagraph\"},{\"text\":\"Von Geburt an. Es hat lange gedauert, bis ich begriffen habe, was es bedeutet, ein blinder Text zu sein: Man macht keinen Sinn. Man wirkt hier und da aus dem Zusammenhang gerissen. Oft wird man gar nicht erst gelesen. Aber bin ich darum weniger wichtig? Ich bin blind! Aber ich bin gerne Text. Und sollten Sie mich jetzt tatsächlich zu Ende lesen, dann habe ich etwas geschafft, was den meisten \"normalen\" Texten nicht gelingt. \",\"start\":[4,0],\"name\":\"insertText\"},{\"start\":[5],\"name\":\"insertParagraph\"},{\"start\":[6],\"name\":\"insertParagraph\"},{\"start\":[7],\"name\":\"insertParagraph\"},{\"start\":[8],\"name\":\"insertParagraph\"},{\"start\":[9],\"name\":\"insertParagraph\"},{\"start\":[10],\"name\":\"insertParagraph\"},{\"text\":\"Ich bin Blindtext. Von Geburt an. Es hat lange, bis ich begriffen habe, was es bedeutet, ein blinder Text zu sein: Man macht keinen Sinn. Man wirkt hier und da aus dem Zusammenhang gerissen. Oft wird man gar nicht erst gelesen. Aber bin ich deshalb ein schlechter Text?\",\"start\":[10,0],\"name\":\"insertText\"},{\"start\":[11],\"name\":\"insertParagraph\"},{\"text\":\"Ich weiß, dass ich nie die Chance haben werde im Stern zu erscheinen. Aber bin ich darum weniger wichtig? Ich bin blind! Aber ich bin gerne Text. Und sollten Sie mich jetzt tatsächlich zu Ende lesen, dann habe ich etwas geschafft, was den meisten \"normalen\" Texten nicht gelingt. Ich bin Blindtext.\",\"start\":[11,0],\"name\":\"insertText\"},{\"start\":[12],\"name\":\"insertParagraph\"},{\"start\":[13],\"name\":\"insertParagraph\"},{\"start\":[14],\"name\":\"insertParagraph\"},{\"start\":[15],\"name\":\"insertParagraph\"},{\"start\":[16],\"name\":\"insertParagraph\"},{\"start\":[17],\"name\":\"insertParagraph\"},{\"start\":[18],\"name\":\"insertParagraph\"},{\"start\":[19],\"name\":\"insertParagraph\"},{\"start\":[20],\"name\":\"insertParagraph\"},{\"start\":[21],\"name\":\"insertParagraph\"}]}";
	private static final String JSON_REFERENCE_OPERATIONS = "{\"operations\":[{\"name\":\"initDocument\"},{\"start\":[0],\"name\":\"insertParagraph\"},{\"text\":\"0-Normal\",\"start\":[0,0],\"name\":\"insertText\"},{\"text\":\"8-Bold\",\"start\":[0,8],\"name\":\"insertText\"},{\"text\":\"14-BoldItalic\",\"start\":[0,14],\"name\":\"insertText\"},{\"text\":\"27-Bold-italic-underline\",\"start\":[0,27],\"name\":\"insertText\"},{\"text\":\"51-Bold-underline\",\"start\":[0,51],\"name\":\"insertText\"},{\"text\":\"68-Bold-italic-underline2\",\"start\":[0,68],\"name\":\"insertText\"},{\"text\":\"93-Bold\",\"start\":[0,93],\"name\":\"insertText\"},{\"text\":\"100-Normal!!\",\"start\":[0,100],\"name\":\"insertText\"},{\"start\":[0,8],\"name\":\"setAttribute\",\"value\":true,\"attr\":\"bold\",\"end\":[0,100]},{\"start\":[0,8],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"italic\",\"end\":[0,100]},{\"start\":[0,8],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"underline\",\"end\":[0,100]},{\"start\":[0,14],\"name\":\"setAttribute\",\"value\":true,\"attr\":\"bold\",\"end\":[0,27]},{\"start\":[0,14],\"name\":\"setAttribute\",\"value\":true,\"attr\":\"italic\",\"end\":[0,27]},{\"start\":[0,14],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"underline\",\"end\":[0,27]},{\"start\":[0,27],\"name\":\"setAttribute\",\"value\":true,\"attr\":\"bold\",\"end\":[0,93]},{\"start\":[0,27],\"name\":\"setAttribute\",\"value\":true,\"attr\":\"italic\",\"end\":[0,93]},{\"start\":[0,27],\"name\":\"setAttribute\",\"value\":true,\"attr\":\"underline\",\"end\":[0,93]},{\"start\":[0,51],\"name\":\"setAttribute\",\"value\":true,\"attr\":\"bold\",\"end\":[0,68]},{\"start\":[0,51],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"italic\",\"end\":[0,68]},{\"start\":[0,51],\"name\":\"setAttribute\",\"value\":true,\"attr\":\"underline\",\"end\":[0,68]},{\"start\":[1],\"name\":\"insertParagraph\"},{\"start\":[2],\"name\":\"insertParagraph\"},{\"start\":[3],\"name\":\"insertParagraph\"},{\"start\":[4],\"name\":\"insertParagraph\"},{\"start\":[5],\"name\":\"insertParagraph\"},{\"start\":[6],\"name\":\"insertParagraph\"},{\"start\":[7],\"name\":\"insertParagraph\"},{\"start\":[8],\"name\":\"insertParagraph\"},{\"text\":\"Sdfdfdf\",\"start\":[8,0],\"name\":\"insertText\"},{\"start\":[9],\"name\":\"insertParagraph\"},{\"text\":\"Deleted table\",\"start\":[9,0],\"name\":\"insertText\"},{\"start\":[10],\"name\":\"insertParagraph\"},{\"start\":[11],\"name\":\"insertParagraph\"},{\"text\":\"sample table to delete column \",\"start\":[11,0],\"name\":\"insertText\"},{\"start\":[12],\"name\":\"insertParagraph\"}]}";
	private static final String STRING_REFERENCE_OPERATIONS = "[{\"name\":\"initDocument\"},{\"name\":\"insertText\",\"text\":\"juicy \",\"start\":[0,9]},{\"name\":\"insertText\",\"text\":\"u\",\"start\":[0,10]},{\"name\":\"insertText\",\"text\":\"i\",\"start\":[0,11]},{\"name\":\"insertText\",\"text\":\"c\",\"start\":[0,12]},{\"name\":\"insertText\",\"text\":\"y\",\"start\":[0,13]},{\"name\":\"insertText\",\"text\":\" \",\"start\":[0,14]}]";
	private static final String STRING_REFERENCE_OPERATIONS2 = "[{\"name\":\"initDocument\"},{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"bold\",\"start\":[0,1],\"end\":[0,15]}]";
	// Step 1. <text:p text:style-name="P3">Seasonal juicy uicy Fruits</text:p>
	// Step 2. <text:p text:style-name="P2">S<text:span text:style-name="T1">easonal juicy </text:span>uicy Fruits</text:p>
	// Step 3. <text:p text:style-name="P2">S<text:span text:style-name="T1">easonal</text:span>ruits</text:p>	
	private static final String NEW_TEXT_BY_STRING = "Seasonal juicy uicy Fruits";
	private static final String NEW_TEXT = "**This is my new added Text!**";
	// ******** MULTIPLE_SPAN_SOURCE: Test paragraph content: 
	// "0-Normal" "8-Bold"																								"93-Bold" "100-Normal"
	//						"14-BoldItalic"	
	//										 "27-Bold-italic-underline"						"68-Bold-italic-underline2"
	//																	"51-Bold-underline"	
	/*
	 * <text:p text:style-name="Default_20_Text">0-Normal <text:span
	 * text:style-name="T1">8-Bold <text:span
	 * text:style-name="T2">14-BoldItalic</text:span> <text:span
	 * text:style-name="T3">27-Bold-italic-underline <text:span
	 * text:style-name="T4">51-Bold-underline</text:span>
	 * 68-Bold-italic-underline2</text:span> 93-Bold</text:span>
	 * 100-Normal!!</text:p>
	 */
	private static final String MULTIPLE_SPAN_SOURCE = "not-only-odf-with-spans.odt";
	private static final String MULTIPLE_PARAGRAPH_SOURCE = "multiple-paragraphs-and-spans.odt";
//	private static final String TARGET_JSON_DELETE = "DeleteOperationApplied.odt";
	private static final String TARGET_1 = "JsonOperationApplied-plus-text.odt";
//	private static final String JSON_CHANGE_OPERATIONS = "{\"operations\":[{\"start\":[1],\"name\":\"insertParagraph\"},{\"text\":\"" + NEW_TEXT + "\",\"start\":[1,0],\"name\":\"insertText\"}]";
	private static final String REFERENCE_PARAGRAPH_TEXT = "0SThirdecondFirst-Normal8-Bold14-BoldItalic27-BEFORE_BOLDBold-italic-underline51-Bold-underline68-Bold-italic-underline293-Bold100-Normal!!";
	//private static final String STRING_REFERENCE_OPERATIONS_A = "[{\"name\":\"insertText\",\"text\":\"0123456789abcdefghijklmnopqrstuvwxyz \",\"start\":[0,9]}]";
	//private static final String STRING_REFERENCE_OPERATIONS_B = "[{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"bold\",\"start\":[0,5],\"end\":[0,10]}]";
	//	<text:p text:style-name="P2">Seaso<text:span text:style-name="T1">nal 0</text:span>123456789abcdefghijklmnopqrstuvwxyz Fruits</text:p>
	private static final String STRING_REFERENCE_OPERATIONS_C = "[{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"italic\",\"start\":[0,11],\"end\":[0,13]}]";
	//  			<text:p text:style-name="P2">Seaso<text:span text:style-name="T1">nal 0</text:span>123456789ab<text:span text:style-name="T2">cd</text:span>efghijklmnopqrstuvwxyz Fruits</text:p>
	// ToDO: Same SPAN -- private static final String STRING_REFERENCE_OPERATIONS_C= "[{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"italic\",\"start\":[0,5],\"end\":[0,10]}]";
	private static final String STRING_REFERENCE_OPERATIONS_A = "[{\"name\":\"deleteText\",\"start\":[0,16],\"end\":[0,29]}]";
	private static final String MULTIPLE_SPAN_DELETE_B = "[{\"name\":\"deleteText\",\"start\":[0,16],\"end\":[0,29]}]";
	private static final String MULTIPLE_SPAN_DELETE_WITHIN = "[{\"name\":\"deleteText\",\"start\":[0,16],\"end\":[0,29]}]";

	public OperationJsonTest() {
	}

		
	@Test
	@Ignore
	public void editingRoundtrip() {
		final String SOURCE_FILE_NAME_TRUNC = "feature_attributes_character_MSO15";
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
		final String TARGET_FILE_NAME_1 = "_OUT.odt";
		final String OPS = 
			"[" +
//			 "{\"text\":\"S\",\"start\":[0,10],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"v\",\"start\":[0,11],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"a\",\"start\":[0,12],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"n\",\"start\":[0,13],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"t\",\"start\":[0,14],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"e\",\"start\":[0,15],\"name\":\"insertText\"}," + 
			 "{\"text\":\" \",\"start\":[0,16],\"name\":\"insertText\"}," +
			 "{\"text\":\" \",\"start\":[0,17],\"name\":\"insertText\"}," +	
//			 "{\"text\":\"2\",\"start\":[0,28],\"name\":\"insertText\"} +
			 "]";

		/** String was generated by operation returned as ASCII only String to the output */
//		final String EXPECTED_OPS = ""; 
		
		try {
			//**********LOAD						
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));
			// read the (known) operation from the test document
			JSONObject ops = doc.getOperations();
			LOG.log(Level.INFO, "The Ops are: {0}", ops.toString());

			//**********APPLY
			int opCount = doc.applyOperations(OPS);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE		
			File testFile = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_1);
			doc.getDocument().save(testFile);
//
//			//**********RELOAD
//			// read the (known) operation from the test document
//			OdfOperationDocument doc3 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_1)));
//			JSONObject ops2 = doc3.getOperations();
//			LOG.log(Level.INFO, "The reloaded Ops are:{0}", ops2.toString());						
//			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());			
//			Assert.assertTrue(ops2.toString(true).equals(EXPECTED_OPS.toString()));
		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}	
		
	@Test
	@Ignore
	public void whiteSpaceHandling() {
		
		
//		final String OPS = "[{\"name\":\"insertStyleSheet\",\"styleId\":\"default_paragraph_style\",\"type\":\"paragraph\",\"attrs\":{\"character\":{\"fontSizeAsian\":12,\"fontSize\":12,\"fontNameAsian\":\"SimSun\",\"fontName\":\"Times New Roman\",\"fontNameComplex\":\"Mangal\"}},\"default\":true,\"hidden\":true}," + 
//			 "{\"name\":\"insertStyleSheet\",\"styleId\":\"Standard\",\"type\":\"paragraph\",\"attrs\":{},\"parent\":\"default_paragraph_style\"}," + 
//			 "{\"name\":\"insertStyleSheet\",\"styleId\":\"Table_20_Contents\",\"type\":\"paragraph\",\"styleName\":\"Table Contents\",\"attrs\":{},\"parent\":\"Standard\"}," + 
//			 "{\"name\":\"insertStyleSheet\",\"styleId\":\"Text_20_body\",\"type\":\"paragraph\",\"styleName\":\"Text body\",\"attrs\":{\"paragraph\":{\"marginTop\":0,\"marginBottom\":212}},\"parent\":\"Standard\"}," + 
//			 "{\"name\":\"insertStyleSheet\",\"styleId\":\"Caption\",\"type\":\"paragraph\",\"attrs\":{\"paragraph\":{\"marginTop\":212,\"marginBottom\":212},\"character\":{\"fontSizeAsian\":12,\"italicComplex\":true,\"fontSize\":12,\"fontNameComplex\":\"Mangal1\",\"italic\":true,\"italicAsian\":true}},\"parent\":\"Standard\"}," + 
//			 "{\"name\":\"insertStyleSheet\",\"styleId\":\"Index\",\"type\":\"paragraph\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Mangal1\"}},\"parent\":\"Standard\"}," + 
//			 "{\"name\":\"insertStyleSheet\",\"styleId\":\"Heading\",\"type\":\"paragraph\",\"attrs\":{\"paragraph\":{\"marginTop\":423,\"marginBottom\":212},\"character\":{\"fontSizeAsian\":14,\"fontSize\":14,\"fontNameComplex\":\"Mangal\",\"fontName\":\"Arial\",\"fontNameAsian\":\"Microsoft YaHei\"}},\"parent\":\"Standard\",\"next\":\"Text_20_body\"}," + 
//			 "{\"name\":\"insertStyleSheet\",\"styleId\":\"List\",\"type\":\"paragraph\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Mangal1\"}},\"parent\":\"Text_20_body\"}," + 
//			 "{\"name\":\"insertStyleSheet\",\"styleId\":\"Line_20_numbering\",\"type\":\"character\",\"styleName\":\"Line numbering\",\"attrs\":{},\"parent\":\"default_character_style\"}," + 
//			 "{\"name\":\"insertStyleSheet\",\"styleId\":\"Bullet_20_Symbols\",\"type\":\"character\",\"styleName\":\"Bullet Symbols\",\"attrs\":{\"character\":{\"fontNameComplex\":\"OpenSymbol\",\"fontName\":\"OpenSymbol\",\"fontNameAsian\":\"OpenSymbol\"}},\"parent\":\"default_character_style\"}," + 
//			 "{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_Symbols\",\"type\":\"character\",\"styleName\":\"Numbering Symbols\",\"attrs\":{},\"parent\":\"default_character_style\"}," + 
//			 "{\"name\":\"insertListStyle\",\"listStyleId\":\"Numbering_20_1\",\"listDefinition\":{\"listLevel0\":{\"levelText\":\"%1.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":1270,\"indentFirstLine\":-635,\"tabPosition\":1270,\"labelFollowedBy\":\"listtab\"},\"listLevel1\":{\"levelText\":\"%2.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":1905,\"indentFirstLine\":-635,\"tabPosition\":1905,\"labelFollowedBy\":\"listtab\"},\"listLevel2\":{\"levelText\":\"%3.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":2540,\"indentFirstLine\":-635,\"tabPosition\":2540,\"labelFollowedBy\":\"listtab\"},\"listLevel3\":{\"levelText\":\"%4.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":3175,\"indentFirstLine\":-635,\"tabPosition\":3175,\"labelFollowedBy\":\"listtab\"},\"listLevel4\":{\"levelText\":\"%5.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":3810,\"indentFirstLine\":-635,\"tabPosition\":3810,\"labelFollowedBy\":\"listtab\"},\"listLevel5\":{\"levelText\":\"%6.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":4445,\"indentFirstLine\":-635,\"tabPosition\":4445,\"labelFollowedBy\":\"listtab\"},\"listLevel6\":{\"levelText\":\"%7.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":5080,\"indentFirstLine\":-635,\"tabPosition\":5080,\"labelFollowedBy\":\"listtab\"},\"listLevel7\":{\"levelText\":\"%8.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":5715,\"indentFirstLine\":-635,\"tabPosition\":5715,\"labelFollowedBy\":\"listtab\"},\"listLevel8\":{\"levelText\":\"%9.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":6350,\"indentFirstLine\":-635,\"tabPosition\":6350,\"labelFollowedBy\":\"listtab\"},\"listLevel9\":{\"levelText\":\"%10.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":6985,\"indentFirstLine\":-635,\"tabPosition\":6985,\"labelFollowedBy\":\"listtab\"}}}," + 
//			 "{\"attrs\":{\"page\":{\"height\":29700,\"numberFormat\":\"1\",\"indentLeft\":2000,\"marginTop\":2000,\"indentRight\":2000,\"marginBottom\":2000,\"printOrientation\":\"portrait\",\"width\":21001}},\"name\":\"setDocumentAttributes\"}," + 
//			 "{\"name\":\"insertFontDescription\",\"fontName\":\"Mangal1\",\"family\":\"Mangal\"}," + 
//			 "{\"name\":\"insertFontDescription\",\"fontName\":\"OpenSymbol\",\"family\":\"OpenSymbol\"}," + 
//			 "{\"name\":\"insertFontDescription\",\"fontName\":\"Segoe UI\",\"family\":\"'Segoe UI'\"}," + 
//			 "{\"name\":\"insertFontDescription\",\"fontName\":\"Times New Roman\",\"family\":\"'Times New Roman'\",\"pitch\":\"variable\"}," + 
//			 "{\"name\":\"insertFontDescription\",\"fontName\":\"Arial\",\"family\":\"Arial\",\"pitch\":\"variable\"}," + 
//			 "{\"name\":\"insertFontDescription\",\"fontName\":\"Mangal\",\"family\":\"Mangal\",\"pitch\":\"variable\"}," + 
//			 "{\"name\":\"insertFontDescription\",\"fontName\":\"Microsoft YaHei\",\"family\":\"'Microsoft YaHei'\",\"pitch\":\"variable\"}," + 
//			 "{\"name\":\"insertFontDescription\",\"fontName\":\"SimSun\",\"family\":\"SimSun\",\"pitch\":\"variable\"}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}}}," + 
//			 "{\"text\":\"2\",\"start\":[0,0],\"name\":\"insertText\"}," + 
//			 "{\"text\":\" 3\",\"start\":[0,1],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"   \",\"start\":[0,3],\"name\":\"insertText\"}," + 
//			 "{\"text\":\" 4 \",\"start\":[0,6],\"name\":\"insertText\"}," + 
//			 "{\"name\":\"setAttributes\",\"start\":[0,0],\"end\":[0,0],\"attrs\":{\"character\":{\"boldComplex\":true,\"boldAsian\":true,\"bold\":true,\"fillColor\":{\"value\":\"3deb3d\",\"type\":\"rgb\"}}}}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[1],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}}}," + 
//			 "{\"text\":\"1 \",\"start\":[1,0],\"name\":\"insertText\"}," + 
//			 "{\"text\":\" 2\",\"start\":[1,2],\"name\":\"insertText\"}," + 
//			 "{\"text\":\" 3\",\"start\":[1,4],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"   \",\"start\":[1,6],\"name\":\"insertText\"}," + 
//			 "{\"text\":\" 4 \",\"start\":[1,9],\"name\":\"insertText\"}," + 
//			 "{\"name\":\"setAttributes\",\"start\":[1,2],\"end\":[1,3],\"attrs\":{\"character\":{\"boldComplex\":true,\"boldAsian\":true,\"bold\":true,\"fillColor\":{\"value\":\"3deb3d\",\"type\":\"rgb\"}}}}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[2],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}}}," + 
//			 "{\"text\":\"   \",\"start\":[2,0],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"Three count space element with surrounding space\\\"\",\"start\":[2,3],\"name\":\"insertText\"}," + 
//			 "{\"text\":\" \",\"start\":[2,52],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"   \",\"start\":[2,53],\"name\":\"insertText\"}," + 
//			 "{\"text\":\" \\\"! (expected 4 due to spec, but why should an app only gather not all spaces?Because the app can!\",\"start\":[2,56],\"name\":\"insertText\"}," + 
//			 "{\"name\":\"setAttributes\",\"start\":[2,52],\"end\":[2,52],\"attrs\":{\"character\":{\"boldComplex\":true,\"boldAsian\":true,\"bold\":true,\"fillColor\":{\"value\":\"3deb3d\",\"type\":\"rgb\"}}}}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[3],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}}}," + 
//			 "{\"text\":\"   \",\"start\":[3,0],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"ThreeSpaces and Tab preceding and following1\",\"start\":[3,3],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"   \",\"start\":[3,47],\"name\":\"insertText\"}," + 
//			 "{\"text\":\" \",\"start\":[3,50],\"name\":\"insertText\"}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[4],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}}}," + 
//			 "{\"text\":\"   \",\"start\":[4,0],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"ThreeSpaces and Tab preceding and following2\",\"start\":[4,3],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"   \",\"start\":[4,47],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"      \",\"start\":[4,50],\"name\":\"insertText\"}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[5],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}}}," + 
//			 "{\"text\":\"   \",\"start\":[5,0],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"ThreeSpaces and Tab preceding and following3\",\"start\":[5,3],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"   \",\"start\":[5,47],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"      \",\"start\":[5,50],\"name\":\"insertText\"}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[6],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}}}," + 
//			 "{\"text\":\"   \",\"start\":[6,0],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"ThreeSpaces and Tab preceding and following4\",\"start\":[6,3],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"   \",\"start\":[6,47],\"name\":\"insertText\"}," + 
//			 "{\"text\":\" \",\"start\":[6,50],\"name\":\"insertText\"}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[7],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}}}," + 
//			 "{\"text\":\"   \",\"start\":[7,0],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"Tab and ThreeSpaces preceding and following\",\"start\":[7,3],\"name\":\"insertText\"}," + 
//			 "{\"text\":\" \\t\\t\",\"start\":[7,46],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"   \",\"start\":[7,49],\"name\":\"insertText\"}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[8],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}}}," + 
//			 "{\"text\":\"Tab preceding and following:\",\"start\":[8,0],\"name\":\"insertText\"}," + 
//			 "{\"text\":\" \",\"start\":[8,28],\"name\":\"insertText\"}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[9],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}}}," + 
//			 "{\"text\":\"   \",\"start\":[9,0],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"ThreeSpaces preceding and following:\",\"start\":[9,3],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"   \",\"start\":[9,39],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"    \\t\\n\\t\\t\\t\",\"start\":[9,42],\"name\":\"insertText\"}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[10],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}}}," + 
//			 "{\"text\":\"Nothing: \\n\\t\\t\\t\\n\\t\\t\\t\",\"start\":[10,0],\"name\":\"insertText\"}," + 
//			 "{\"name\":\"insertListStyle\",\"listStyleId\":\"L1\",\"listDefinition\":{\"listLevel0\":{\"levelText\":\"%1.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":1270,\"indentFirstLine\":-635,\"tabPosition\":1270,\"labelFollowedBy\":\"listtab\"},\"listLevel1\":{\"levelText\":\"%2.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":1905,\"indentFirstLine\":-635,\"tabPosition\":1905,\"labelFollowedBy\":\"listtab\"},\"listLevel2\":{\"levelText\":\"%3.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":2540,\"indentFirstLine\":-635,\"tabPosition\":2540,\"labelFollowedBy\":\"listtab\"},\"listLevel3\":{\"levelText\":\"%4.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":3175,\"indentFirstLine\":-635,\"tabPosition\":3175,\"labelFollowedBy\":\"listtab\"},\"listLevel4\":{\"levelText\":\"%5.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":3810,\"indentFirstLine\":-635,\"tabPosition\":3810,\"labelFollowedBy\":\"listtab\"},\"listLevel5\":{\"levelText\":\"%6.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":4445,\"indentFirstLine\":-635,\"tabPosition\":4445,\"labelFollowedBy\":\"listtab\"},\"listLevel6\":{\"levelText\":\"%7.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":5080,\"indentFirstLine\":-635,\"tabPosition\":5080,\"labelFollowedBy\":\"listtab\"},\"listLevel7\":{\"levelText\":\"%8.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":5715,\"indentFirstLine\":-635,\"tabPosition\":5715,\"labelFollowedBy\":\"listtab\"},\"listLevel8\":{\"levelText\":\"%9.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":6350,\"indentFirstLine\":-635,\"tabPosition\":6350,\"labelFollowedBy\":\"listtab\"},\"listLevel9\":{\"levelText\":\"%10.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":6985,\"indentFirstLine\":-635,\"tabPosition\":6985,\"labelFollowedBy\":\"listtab\"}}}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[11],\"attrs\":{\"paragraph\":{\"style\":\"Standard\",\"listLevel\":0,\"listId\":\"list5258827825152924607\",\"listXmlId\":\"list5258827825152924607\",\"listStart\":true,\"listStyleId\":\"L1\"}}}," + 
//			 "{\"text\":\"ListItem    –   \\t\\t\\t expected: 1. \\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\",\"start\":[11,0],\"name\":\"insertText\"}," +
//		"{\"name\":\"insertTable\",\"start\":[12],\"attrs\":{\"table\":{\"tableGrid\":[32767,32768]}}}," + 
//		"{\"name\":\"insertRows\",\"start\":[12,0]}," + 
//		"{\"name\":\"insertCells\",\"start\":[12,0,0],\"attrs\":{\"cell\":{\"borderLeft\":{\"width\":2,\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"}},\"borderTop\":{\"width\":2,\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"}},\"borderRight\":{\"style\":\"none\"},\"borderBottom\":{\"width\":2,\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"}},\"paddingLeft\":97,\"paddingTop\":97,\"paddingRight\":97,\"paddingBottom\":97}}}," + 
//		"{\"name\":\"insertListStyle\",\"listStyleId\":\"L2\",\"listDefinition\":{\"listLevel0\":{\"levelText\":\"%1.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":1270,\"indentFirstLine\":-635,\"tabPosition\":1270,\"labelFollowedBy\":\"listtab\"},\"listLevel1\":{\"levelText\":\"%2.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":1905,\"indentFirstLine\":-635,\"tabPosition\":1905,\"labelFollowedBy\":\"listtab\"},\"listLevel2\":{\"levelText\":\"%3.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":2540,\"indentFirstLine\":-635,\"tabPosition\":2540,\"labelFollowedBy\":\"listtab\"},\"listLevel3\":{\"levelText\":\"%4.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":3175,\"indentFirstLine\":-635,\"tabPosition\":3175,\"labelFollowedBy\":\"listtab\"},\"listLevel4\":{\"levelText\":\"%5.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":3810,\"indentFirstLine\":-635,\"tabPosition\":3810,\"labelFollowedBy\":\"listtab\"},\"listLevel5\":{\"levelText\":\"%6.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":4445,\"indentFirstLine\":-635,\"tabPosition\":4445,\"labelFollowedBy\":\"listtab\"},\"listLevel6\":{\"levelText\":\"%7.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":5080,\"indentFirstLine\":-635,\"tabPosition\":5080,\"labelFollowedBy\":\"listtab\"},\"listLevel7\":{\"levelText\":\"%8.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":5715,\"indentFirstLine\":-635,\"tabPosition\":5715,\"labelFollowedBy\":\"listtab\"},\"listLevel8\":{\"levelText\":\"%9.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":6350,\"indentFirstLine\":-635,\"tabPosition\":6350,\"labelFollowedBy\":\"listtab\"},\"listLevel9\":{\"levelText\":\"%10.\",\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentLeft\":6985,\"indentFirstLine\":-635,\"tabPosition\":6985,\"labelFollowedBy\":\"listtab\"}}}," +
//		"{\"name\":\"insertParagraph\",\"start\":[12,0,0,0],\"attrs\":{\"paragraph\":{\"style\":\"Table_20_Contents\",\"listLevel\":0,\"listId\":\"list890117513524608267\",\"listXmlId\":\"list890117513524608267\",\"listStart\":true,\"listStyleId\":\"L2\"}}}," + 
//		"{\"text\":\"a \",\"start\":[12,0,0,0,0],\"name\":\"insertText\"}," + 
//			 "{\"name\":\"insertCells\",\"start\":[12,0,1],\"attrs\":{\"cell\":{\"paddingLeft\":97,\"paddingTop\":97,\"paddingRight\":97,\"paddingBottom\":97,\"borderLeft\":{\"width\":2,\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"}},\"borderTop\":{\"width\":2,\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"}},\"borderRight\":{\"width\":2,\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"}},\"borderBottom\":{\"width\":2,\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"}}}}}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[12,0,1,0],\"attrs\":{\"paragraph\":{\"style\":\"Table_20_Contents\",\"listLevel\":0,\"listId\":\"list32175023\",\"listXmlId\":\"list32175023\",\"listStart\":true,\"listStyleId\":\"L2\"}}}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[13],\"attrs\":{\"paragraph\":{\"style\":\"Standard\",\"listLevel\":0,\"listId\":\"list5258827825152924607\",\"listXmlId\":\"list32198560\",\"listStart\":true,\"listStyleId\":\"L1\"}}}," + 
//			 "{\"text\":\"ListItem – expected: 6.\",\"start\":[13,0],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"  \\t\\t\\t\",\"start\":[13,23],\"name\":\"insertText\"}," + 
//			 "{\"text\":\" \",\"start\":[13,28],\"name\":\"insertText\"}," + 
//			 "{\"text\":\" \\t\\t\\n\\t\\t\\t\\t\\t\",\"start\":[13,29],\"name\":\"insertText\"}," + 
//			 "{\"name\":\"setAttributes\",\"start\":[13,0],\"end\":[13,-1],\"attrs\":{}}," + 
//			 "{\"name\":\"setAttributes\",\"start\":[13,23],\"end\":[13,27],\"attrs\":{\"character\":{\"boldComplex\":true,\"boldAsian\":true,\"bold\":true,\"fillColor\":{\"value\":\"3deb3d\",\"type\":\"rgb\"}}}}," + 
//			 "{\"name\":\"setAttributes\",\"start\":[13,29],\"end\":[13,37],\"attrs\":{}}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[14],\"attrs\":{\"paragraph\":{\"style\":\"Standard\",\"listLevel\":0,\"listLabelHidden\":true,\"listId\":\"list5258827825152924607\",\"listXmlId\":\"list32198560\",\"listStart\":true,\"listStyleId\":\"L1\"}}}," + 
//			 "{\"text\":\"ListItem – expected: 6.  \",\"start\":[14,0],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"  \\t\\t\\t\",\"start\":[14,25],\"name\":\"insertText\"}," + 
//			 "{\"text\":\" \",\"start\":[14,30],\"name\":\"insertText\"}," + 
//			 "{\"text\":\" \\t\\t\\n\\t\\t\\t\\t\\t\",\"start\":[14,31],\"name\":\"insertText\"}," + 
//			 "{\"name\":\"setAttributes\",\"start\":[14,0],\"end\":[14,-1],\"attrs\":{}}," + 
//			 "{\"name\":\"setAttributes\",\"start\":[14,25],\"end\":[14,29],\"attrs\":{\"character\":{\"boldComplex\":true,\"boldAsian\":true,\"bold\":true,\"fillColor\":{\"value\":\"3deb3d\",\"type\":\"rgb\"}}}}," + 
//			 "{\"name\":\"setAttributes\",\"start\":[14,31],\"end\":[14,39],\"attrs\":{}}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[15],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}}}," + 
//			 "{\"text\":\"New   \\n\\t\\t\\t\\t\",\"start\":[15,0],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"\\n\\t\\t\\t\\t\\t\",\"start\":[15,11],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"\\n\\t\\t\\t\\t\\t\\t\",\"start\":[15,17],\"name\":\"insertText\"}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[15,24],\"attrs\":{\"paragraph\":{}}}," + 
//			 "{\"text\":\"FRAME  \",\"start\":[15,24,0],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"\\n\\t\\t\\t\\t\\t\\t\",\"start\":[15,24,7],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"\\n\\t\\t\\t\\t\\t\",\"start\":[15,25],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"\\n\\t\\t\\t\\t\",\"start\":[15,31],\"name\":\"insertText\"}," + 
//			 "{\"text\":\"\\n\\t\\t\\t\\t\\tWorld1\",\"start\":[15,36],\"name\":\"insertText\"}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[16],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}}}," + 
//			 "{\"name\":\"insertParagraph\",\"start\":[16,0],\"attrs\":{\"paragraph\":{}}}," + 
//			 "{\"text\":\"World3! \\n\\t\\t\\t\",\"start\":[16,1],\"name\":\"insertText\"}]";		

		//final String SOURCE_FILE_NAME_TRUNC = "a4-hoch-und-quer";
		//final String SOURCE_FILE_NAME_TRUNC = "WhitespaceTest";
		final String SOURCE_FILE_NAME_TRUNC = "TextLineBreakText";
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
		final String TARGET_FILE_NAME_1 = "_OUT.odt";
		final String OPS = 
			"[{\"name\":\"insertStyleSheet\",\"styleId\":\"default_paragraph_style\",\"type\":\"paragraph\",\"attrs\":{\"character\":{\"fontSizeAsian\":12,\"fontSize\":12,\"fontNameAsian\":\"SimSun\",\"fontName\":\"Times New Roman\",\"fontNameComplex\":\"Mangal\"}},\"default\":true,\"hidden\":true}," + 
			 "{\"name\":\"insertStyleSheet\",\"styleId\":\"Standard\",\"type\":\"paragraph\",\"attrs\":{},\"parent\":\"default_paragraph_style\"}," + 
			 "{\"name\":\"insertStyleSheet\",\"styleId\":\"Text_20_body\",\"type\":\"paragraph\",\"styleName\":\"Text body\",\"attrs\":{\"paragraph\":{\"marginTop\":0,\"marginBottom\":212}},\"parent\":\"Standard\"}," + 
			 "{\"name\":\"insertStyleSheet\",\"styleId\":\"Caption\",\"type\":\"paragraph\",\"attrs\":{\"paragraph\":{\"marginTop\":212,\"marginBottom\":212},\"character\":{\"fontSizeAsian\":12,\"italicComplex\":true,\"fontSize\":12,\"fontNameComplex\":\"Mangal1\",\"italic\":true,\"italicAsian\":true}},\"parent\":\"Standard\"}," + 
			 "{\"name\":\"insertStyleSheet\",\"styleId\":\"Index\",\"type\":\"paragraph\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Mangal1\"}},\"parent\":\"Standard\"}," + 
			 "{\"name\":\"insertStyleSheet\",\"styleId\":\"Heading\",\"type\":\"paragraph\",\"attrs\":{\"paragraph\":{\"marginTop\":423,\"marginBottom\":212},\"character\":{\"fontSizeAsian\":14,\"fontSize\":14,\"fontNameComplex\":\"Mangal\",\"fontName\":\"Arial\",\"fontNameAsian\":\"Microsoft YaHei\"}},\"parent\":\"Standard\",\"next\":\"Text_20_body\"}," + 
			 "{\"name\":\"insertStyleSheet\",\"styleId\":\"List\",\"type\":\"paragraph\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Mangal1\"}},\"parent\":\"Text_20_body\"}," + 
			 "{\"attrs\":{\"page\":{\"height\":29700,\"numberFormat\":\"1\",\"indentLeft\":2000,\"marginTop\":2000,\"indentRight\":2000,\"marginBottom\":2000,\"printOrientation\":\"portrait\",\"width\":21001}},\"name\":\"setDocumentAttributes\"}," + 
			 "{\"name\":\"insertFontDescription\",\"fontName\":\"Mangal1\",\"family\":\"Mangal\"}," + 
			 "{\"name\":\"insertFontDescription\",\"fontName\":\"Times New Roman\",\"family\":\"'Times New Roman'\",\"pitch\":\"variable\"}," + 
			 "{\"name\":\"insertFontDescription\",\"fontName\":\"Arial\",\"family\":\"Arial\",\"pitch\":\"variable\"}," + 
			 "{\"name\":\"insertFontDescription\",\"fontName\":\"Mangal\",\"family\":\"Mangal\",\"pitch\":\"variable\"}," + 
			 "{\"name\":\"insertFontDescription\",\"fontName\":\"Microsoft YaHei\",\"family\":\"'Microsoft YaHei'\",\"pitch\":\"variable\"}," + 
			 "{\"name\":\"insertFontDescription\",\"fontName\":\"SimSun\",\"family\":\"SimSun\",\"pitch\":\"variable\"}," + 
			 "{\"name\":\"insertParagraph\",\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"Standard1\"}}}," + 
			 "{\"text\":\"1\",\"start\":[0,0],\"name\":\"insertText\"}," + 
			 "{\"name\":\"insertParagraph\",\"start\":[0,1],\"attrs\":{\"paragraph\":{\"style\":\"Standard2\"}}}," + 
			 "{\"text\":\"222\",\"start\":[0,1,0],\"name\":\"insertText\"}," + 
			 "{\"name\":\"insertParagraph\",\"start\":[0,1,3],\"attrs\":{\"paragraph\":{\"style\":\"Standard3\"}}}," + 
			 "{\"text\":\"3\",\"start\":[0,1,3,0],\"name\":\"insertText\"}," + 
			 "{\"name\":\"insertParagraph\",\"start\":[0,1,3,1],\"attrs\":{\"paragraph\":{\"style\":\"Standard4\"}}}," + 
			 "{\"text\":\"Svante\",\"start\":[0,1,3,1,0],\"name\":\"insertText\"}," + 
			 "{\"text\":\"3\",\"start\":[0,1,3,2],\"name\":\"insertText\"}," + 
			 "{\"text\":\"222\",\"start\":[0,1,4],\"name\":\"insertText\"}," + 
			 "{\"text\":\"1\",\"start\":[0,2],\"name\":\"insertText\"}]";

		final String EXPECTED_OPS = "{\"operations\":[{\"name\":\"insertStyleSheet\",\"styleId\":\"Standard\",\"type\":\"paragraph\",\"styleName\":\"\",\"attrs\":{},\"parent\":\"default_paragraph_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Footer\",\"type\":\"paragraph\",\"attrs\":{},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Index\",\"type\":\"paragraph\",\"styleName\":\"\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Mangal1\"}},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Index_20_3\",\"type\":\"paragraph\",\"styleName\":\"Index 3\",\"attrs\":{\"paragraph\":{\"indentLeft\":998,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Heading\",\"type\":\"paragraph\",\"styleName\":\"\",\"attrs\":{\"paragraph\":{\"marginTop\":423,\"marginBottom\":212,\"outlineLevel\":0},\"character\":{\"fontSizeAsian\":14,\"fontSize\":14,\"fontNameComplex\":\"Mangal\",\"fontName\":\"Arial\",\"fontNameAsian\":\"Microsoft YaHei\"}},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Index_20_Heading\",\"type\":\"paragraph\",\"styleName\":\"Index Heading\",\"attrs\":{\"paragraph\":{\"indentLeft\":0,\"indentRight\":0},\"character\":{\"fontSizeAsian\":16,\"fontSize\":16,\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"Heading\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Index_20_2\",\"type\":\"paragraph\",\"styleName\":\"Index 2\",\"attrs\":{\"paragraph\":{\"indentLeft\":499,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Index_20_1\",\"type\":\"paragraph\",\"styleName\":\"Index 1\",\"attrs\":{\"paragraph\":{\"indentLeft\":0,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Endnote\",\"type\":\"paragraph\",\"attrs\":{\"paragraph\":{\"indentLeft\":499,\"indentRight\":0},\"character\":{\"fontSizeAsian\":10,\"fontSize\":10}},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_Contents\",\"type\":\"paragraph\",\"styleName\":\"List Contents\",\"attrs\":{\"paragraph\":{\"indentLeft\":1000,\"indentRight\":0}},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Preformatted_20_Text\",\"type\":\"paragraph\",\"styleName\":\"Preformatted Text\",\"attrs\":{\"paragraph\":{\"marginTop\":0,\"marginBottom\":0},\"character\":{\"fontSizeAsian\":10,\"fontSize\":10,\"fontNameComplex\":\"Courier New\",\"fontName\":\"Courier New\",\"fontNameAsian\":\"Courier New\"}},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Text_20_body\",\"type\":\"paragraph\",\"styleName\":\"Text body\",\"attrs\":{\"paragraph\":{\"marginTop\":0,\"marginBottom\":212,\"outlineLevel\":0}},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List\",\"type\":\"paragraph\",\"styleName\":\"\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Mangal1\"}},\"parent\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_2\",\"type\":\"paragraph\",\"styleName\":\"List 2\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_3\",\"type\":\"paragraph\",\"styleName\":\"List 3\",\"attrs\":{\"paragraph\":{\"indentLeft\":1905,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_1\",\"type\":\"paragraph\",\"styleName\":\"List 1\",\"attrs\":{\"paragraph\":{\"indentLeft\":635,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_4\",\"type\":\"paragraph\",\"styleName\":\"List 4\",\"attrs\":{\"paragraph\":{\"indentLeft\":2540,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_5\",\"type\":\"paragraph\",\"styleName\":\"List 5\",\"attrs\":{\"paragraph\":{\"indentLeft\":3175,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Heading_20_10\",\"type\":\"paragraph\",\"styleName\":\"Heading 10\",\"attrs\":{\"paragraph\":{\"outlineLevel\":9},\"character\":{\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"Heading\",\"next\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Salutation\",\"type\":\"paragraph\",\"attrs\":{},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_1_20_Cont.\",\"type\":\"paragraph\",\"styleName\":\"List 1 Cont.\",\"attrs\":{\"paragraph\":{\"indentLeft\":635,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Object_20_index_20_heading\",\"type\":\"paragraph\",\"styleName\":\"Object index heading\",\"attrs\":{\"paragraph\":{\"indentLeft\":0,\"indentRight\":0},\"character\":{\"fontSizeAsian\":16,\"fontSize\":16,\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"Heading\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_5_20_Start\",\"type\":\"paragraph\",\"styleName\":\"Numbering 5 Start\",\"attrs\":{\"paragraph\":{\"indentLeft\":3175,\"marginTop\":423,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_1_20_Cont.\",\"type\":\"paragraph\",\"styleName\":\"Numbering 1 Cont.\",\"attrs\":{\"paragraph\":{\"indentLeft\":635,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Caption\",\"type\":\"paragraph\",\"styleName\":\"\",\"attrs\":{\"paragraph\":{\"marginTop\":212,\"marginBottom\":212,\"outlineLevel\":0},\"character\":{\"fontSizeAsian\":12,\"italicComplex\":true,\"fontSize\":12,\"fontNameComplex\":\"Mangal1\",\"italic\":true,\"italicAsian\":true}},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Illustration\",\"type\":\"paragraph\",\"attrs\":{},\"parent\":\"Caption\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_4_20_Start\",\"type\":\"paragraph\",\"styleName\":\"Numbering 4 Start\",\"attrs\":{\"paragraph\":{\"indentLeft\":2540,\"marginTop\":423,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Addressee\",\"type\":\"paragraph\",\"attrs\":{\"paragraph\":{\"marginTop\":0,\"marginBottom\":106}},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Drawing\",\"type\":\"paragraph\",\"attrs\":{},\"parent\":\"Caption\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Heading_20_3\",\"type\":\"paragraph\",\"styleName\":\"Heading 3\",\"attrs\":{\"paragraph\":{\"outlineLevel\":2},\"character\":{\"fontSizeAsian\":14,\"fontSize\":14,\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"Heading\",\"next\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Header_20_right\",\"type\":\"paragraph\",\"styleName\":\"Header right\",\"attrs\":{},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Heading_20_2\",\"type\":\"paragraph\",\"styleName\":\"Heading 2\",\"attrs\":{\"paragraph\":{\"outlineLevel\":1},\"character\":{\"fontSizeAsian\":14,\"italicComplex\":true,\"fontSize\":14,\"boldComplex\":true,\"italic\":true,\"boldAsian\":true,\"bold\":true,\"italicAsian\":true}},\"parent\":\"Heading\",\"next\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Heading_20_1\",\"type\":\"paragraph\",\"styleName\":\"Heading 1\",\"attrs\":{\"paragraph\":{\"outlineLevel\":0},\"character\":{\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"Heading\",\"next\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Table\",\"type\":\"paragraph\",\"attrs\":{},\"parent\":\"Caption\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Footer_20_right\",\"type\":\"paragraph\",\"styleName\":\"Footer right\",\"attrs\":{},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_3_20_Cont.\",\"type\":\"paragraph\",\"styleName\":\"Numbering 3 Cont.\",\"attrs\":{\"paragraph\":{\"indentLeft\":1905,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Heading_20_8\",\"type\":\"paragraph\",\"styleName\":\"Heading 8\",\"attrs\":{\"paragraph\":{\"outlineLevel\":7},\"character\":{\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"Heading\",\"next\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Heading_20_9\",\"type\":\"paragraph\",\"styleName\":\"Heading 9\",\"attrs\":{\"paragraph\":{\"outlineLevel\":8},\"character\":{\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"Heading\",\"next\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Heading_20_6\",\"type\":\"paragraph\",\"styleName\":\"Heading 6\",\"attrs\":{\"paragraph\":{\"outlineLevel\":5},\"character\":{\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"Heading\",\"next\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_5_20_End\",\"type\":\"paragraph\",\"styleName\":\"List 5 End\",\"attrs\":{\"paragraph\":{\"indentLeft\":3175,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":423}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Header\",\"type\":\"paragraph\",\"attrs\":{},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Heading_20_7\",\"type\":\"paragraph\",\"styleName\":\"Heading 7\",\"attrs\":{\"paragraph\":{\"outlineLevel\":6},\"character\":{\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"Heading\",\"next\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_2_20_Cont.\",\"type\":\"paragraph\",\"styleName\":\"List 2 Cont.\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Heading_20_4\",\"type\":\"paragraph\",\"styleName\":\"Heading 4\",\"attrs\":{\"paragraph\":{\"outlineLevel\":3},\"character\":{\"italicComplex\":true,\"boldComplex\":true,\"italic\":true,\"boldAsian\":true,\"bold\":true,\"italicAsian\":true}},\"parent\":\"Heading\",\"next\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Heading_20_5\",\"type\":\"paragraph\",\"styleName\":\"Heading 5\",\"attrs\":{\"paragraph\":{\"outlineLevel\":4},\"character\":{\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"Heading\",\"next\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_Indent\",\"type\":\"paragraph\",\"styleName\":\"List Indent\",\"attrs\":{\"paragraph\":{\"indentLeft\":5001,\"indentRight\":0}},\"parent\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"User_20_Index_20_10\",\"type\":\"paragraph\",\"styleName\":\"User Index 10\",\"attrs\":{\"paragraph\":{\"indentLeft\":4493,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Table_20_index_20_heading\",\"type\":\"paragraph\",\"styleName\":\"Table index heading\",\"attrs\":{\"paragraph\":{\"indentLeft\":0,\"indentRight\":0},\"character\":{\"fontSizeAsian\":16,\"fontSize\":16,\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"Heading\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Text_20_body_20_indent\",\"type\":\"paragraph\",\"styleName\":\"Text body indent\",\"attrs\":{\"paragraph\":{\"indentLeft\":499,\"indentRight\":0}},\"parent\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_2_20_Start\",\"type\":\"paragraph\",\"styleName\":\"Numbering 2 Start\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"marginTop\":423,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_5_20_Cont.\",\"type\":\"paragraph\",\"styleName\":\"Numbering 5 Cont.\",\"attrs\":{\"paragraph\":{\"indentLeft\":3175,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_1_20_Start\",\"type\":\"paragraph\",\"styleName\":\"List 1 Start\",\"attrs\":{\"paragraph\":{\"indentLeft\":635,\"marginTop\":423,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Title\",\"type\":\"paragraph\",\"attrs\":{\"paragraph\":{\"alignment\":\"center\"},\"character\":{\"fontSizeAsian\":18,\"fontSize\":18,\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"Heading\",\"next\":\"Subtitle\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_1_20_Start\",\"type\":\"paragraph\",\"styleName\":\"Numbering 1 Start\",\"attrs\":{\"paragraph\":{\"indentLeft\":635,\"marginTop\":423,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_3_20_End\",\"type\":\"paragraph\",\"styleName\":\"Numbering 3 End\",\"attrs\":{\"paragraph\":{\"indentLeft\":1905,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":423}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Hanging_20_indent\",\"type\":\"paragraph\",\"styleName\":\"Hanging indent\",\"attrs\":{\"paragraph\":{\"indentLeft\":1000,\"indentRight\":0}},\"parent\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_1_20_End\",\"type\":\"paragraph\",\"styleName\":\"Numbering 1 End\",\"attrs\":{\"paragraph\":{\"indentLeft\":635,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":423}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Table_20_Contents\",\"type\":\"paragraph\",\"styleName\":\"Table Contents\",\"attrs\":{},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Quotations\",\"type\":\"paragraph\",\"attrs\":{\"paragraph\":{\"indentLeft\":1000,\"marginTop\":0,\"indentRight\":1000,\"marginBottom\":499}},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_4_20_Cont.\",\"type\":\"paragraph\",\"styleName\":\"List 4 Cont.\",\"attrs\":{\"paragraph\":{\"indentLeft\":2540,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_1_20_End\",\"type\":\"paragraph\",\"styleName\":\"List 1 End\",\"attrs\":{\"paragraph\":{\"indentLeft\":635,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":423}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Index_20_Separator\",\"type\":\"paragraph\",\"styleName\":\"Index Separator\",\"attrs\":{\"paragraph\":{\"indentLeft\":0,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Frame_20_contents\",\"type\":\"paragraph\",\"styleName\":\"Frame contents\",\"attrs\":{},\"parent\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_4_20_End\",\"type\":\"paragraph\",\"styleName\":\"List 4 End\",\"attrs\":{\"paragraph\":{\"indentLeft\":2540,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":423}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_5_20_Cont.\",\"type\":\"paragraph\",\"styleName\":\"List 5 Cont.\",\"attrs\":{\"paragraph\":{\"indentLeft\":3175,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_3_20_End\",\"type\":\"paragraph\",\"styleName\":\"List 3 End\",\"attrs\":{\"paragraph\":{\"indentLeft\":1905,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":423}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"First_20_line_20_indent\",\"type\":\"paragraph\",\"styleName\":\"First line indent\",\"attrs\":{\"paragraph\":{\"indentLeft\":0,\"indentRight\":0}},\"parent\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_Heading\",\"type\":\"paragraph\",\"styleName\":\"List Heading\",\"attrs\":{\"paragraph\":{\"indentLeft\":0,\"indentRight\":0}},\"parent\":\"Standard\",\"next\":\"List_20_Contents\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Marginalia\",\"type\":\"paragraph\",\"attrs\":{\"paragraph\":{\"indentLeft\":4001,\"indentRight\":0}},\"parent\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_4_20_Cont.\",\"type\":\"paragraph\",\"styleName\":\"Numbering 4 Cont.\",\"attrs\":{\"paragraph\":{\"indentLeft\":2540,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_4_20_End\",\"type\":\"paragraph\",\"styleName\":\"Numbering 4 End\",\"attrs\":{\"paragraph\":{\"indentLeft\":2540,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":423}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_2\",\"type\":\"paragraph\",\"styleName\":\"Numbering 2\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_1\",\"type\":\"paragraph\",\"styleName\":\"Numbering 1\",\"attrs\":{\"paragraph\":{\"indentLeft\":635,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_3_20_Start\",\"type\":\"paragraph\",\"styleName\":\"List 3 Start\",\"attrs\":{\"paragraph\":{\"indentLeft\":1905,\"marginTop\":423,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Footnote\",\"type\":\"paragraph\",\"attrs\":{\"paragraph\":{\"indentLeft\":499,\"indentRight\":0},\"character\":{\"fontSizeAsian\":10,\"fontSize\":10}},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_4\",\"type\":\"paragraph\",\"styleName\":\"Numbering 4\",\"attrs\":{\"paragraph\":{\"indentLeft\":2540,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_3\",\"type\":\"paragraph\",\"styleName\":\"Numbering 3\",\"attrs\":{\"paragraph\":{\"indentLeft\":1905,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_5\",\"type\":\"paragraph\",\"styleName\":\"Numbering 5\",\"attrs\":{\"paragraph\":{\"indentLeft\":3175,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Contents_20_Heading\",\"type\":\"paragraph\",\"styleName\":\"Contents Heading\",\"attrs\":{\"paragraph\":{\"indentLeft\":0,\"indentRight\":0},\"character\":{\"fontSizeAsian\":16,\"fontSize\":16,\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"Heading\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Footer_20_left\",\"type\":\"paragraph\",\"styleName\":\"Footer left\",\"attrs\":{},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Horizontal_20_Line\",\"type\":\"paragraph\",\"styleName\":\"Horizontal Line\",\"attrs\":{\"paragraph\":{\"borderLeft\":{\"style\":\"none\"},\"borderTop\":{\"style\":\"none\"},\"borderRight\":{\"style\":\"none\"},\"borderBottom\":{\"width\":39,\"style\":\"double\",\"color\":{\"value\":\"808080\",\"type\":\"rgb\"}},\"paddingLeft\":0,\"paddingTop\":0,\"paddingRight\":0,\"paddingBottom\":0,\"marginTop\":0,\"marginBottom\":499},\"character\":{\"fontSizeAsian\":6,\"fontSize\":6}},\"parent\":\"Standard\",\"next\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Contents_20_10\",\"type\":\"paragraph\",\"styleName\":\"Contents 10\",\"attrs\":{\"paragraph\":{\"indentLeft\":4493,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_5_20_End\",\"type\":\"paragraph\",\"styleName\":\"Numbering 5 End\",\"attrs\":{\"paragraph\":{\"indentLeft\":3175,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":423}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Bibliography_20_Heading\",\"type\":\"paragraph\",\"styleName\":\"Bibliography Heading\",\"attrs\":{\"paragraph\":{\"indentLeft\":0,\"indentRight\":0},\"character\":{\"fontSizeAsian\":16,\"fontSize\":16,\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"Heading\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_4_20_Start\",\"type\":\"paragraph\",\"styleName\":\"List 4 Start\",\"attrs\":{\"paragraph\":{\"indentLeft\":2540,\"marginTop\":423,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"User_20_Index_20_8\",\"type\":\"paragraph\",\"styleName\":\"User Index 8\",\"attrs\":{\"paragraph\":{\"indentLeft\":3494,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"User_20_Index_20_7\",\"type\":\"paragraph\",\"styleName\":\"User Index 7\",\"attrs\":{\"paragraph\":{\"indentLeft\":2995,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Illustration_20_Index_20_1\",\"type\":\"paragraph\",\"styleName\":\"Illustration Index 1\",\"attrs\":{\"paragraph\":{\"indentLeft\":0,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"User_20_Index_20_9\",\"type\":\"paragraph\",\"styleName\":\"User Index 9\",\"attrs\":{\"paragraph\":{\"indentLeft\":3993,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Signature\",\"type\":\"paragraph\",\"attrs\":{},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_3_20_Start\",\"type\":\"paragraph\",\"styleName\":\"Numbering 3 Start\",\"attrs\":{\"paragraph\":{\"indentLeft\":1905,\"marginTop\":423,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Sender\",\"type\":\"paragraph\",\"attrs\":{\"paragraph\":{\"marginTop\":0,\"marginBottom\":106}},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_2_20_Start\",\"type\":\"paragraph\",\"styleName\":\"List 2 Start\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"marginTop\":423,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Bibliography_20_1\",\"type\":\"paragraph\",\"styleName\":\"Bibliography 1\",\"attrs\":{\"paragraph\":{\"indentLeft\":0,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_5_20_Start\",\"type\":\"paragraph\",\"styleName\":\"List 5 Start\",\"attrs\":{\"paragraph\":{\"indentLeft\":3175,\"marginTop\":423,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"User_20_Index_20_1\",\"type\":\"paragraph\",\"styleName\":\"User Index 1\",\"attrs\":{\"paragraph\":{\"indentLeft\":0,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"User_20_Index_20_2\",\"type\":\"paragraph\",\"styleName\":\"User Index 2\",\"attrs\":{\"paragraph\":{\"indentLeft\":499,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_2_20_End\",\"type\":\"paragraph\",\"styleName\":\"List 2 End\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":423}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"User_20_Index_20_3\",\"type\":\"paragraph\",\"styleName\":\"User Index 3\",\"attrs\":{\"paragraph\":{\"indentLeft\":998,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"User_20_Index_20_4\",\"type\":\"paragraph\",\"styleName\":\"User Index 4\",\"attrs\":{\"paragraph\":{\"indentLeft\":1498,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"User_20_Index_20_5\",\"type\":\"paragraph\",\"styleName\":\"User Index 5\",\"attrs\":{\"paragraph\":{\"indentLeft\":1997,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"User_20_Index_20_6\",\"type\":\"paragraph\",\"styleName\":\"User Index 6\",\"attrs\":{\"paragraph\":{\"indentLeft\":2496,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Header_20_left\",\"type\":\"paragraph\",\"styleName\":\"Header left\",\"attrs\":{},\"parent\":\"Standard\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Subtitle\",\"type\":\"paragraph\",\"attrs\":{\"paragraph\":{\"alignment\":\"center\"},\"character\":{\"fontSizeAsian\":14,\"italicComplex\":true,\"fontSize\":14,\"italic\":true,\"italicAsian\":true}},\"parent\":\"Heading\",\"next\":\"Text_20_body\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"User_20_Index_20_Heading\",\"type\":\"paragraph\",\"styleName\":\"User Index Heading\",\"attrs\":{\"paragraph\":{\"indentLeft\":0,\"indentRight\":0},\"character\":{\"fontSizeAsian\":16,\"fontSize\":16,\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"Heading\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Table_20_Heading\",\"type\":\"paragraph\",\"styleName\":\"Table Heading\",\"attrs\":{\"paragraph\":{\"alignment\":\"center\"},\"character\":{\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"Table_20_Contents\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_2_20_End\",\"type\":\"paragraph\",\"styleName\":\"Numbering 2 End\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":423}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Contents_20_4\",\"type\":\"paragraph\",\"styleName\":\"Contents 4\",\"attrs\":{\"paragraph\":{\"indentLeft\":1498,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Text\",\"type\":\"paragraph\",\"attrs\":{},\"parent\":\"Caption\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Object_20_index_20_1\",\"type\":\"paragraph\",\"styleName\":\"Object index 1\",\"attrs\":{\"paragraph\":{\"indentLeft\":0,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Contents_20_5\",\"type\":\"paragraph\",\"styleName\":\"Contents 5\",\"attrs\":{\"paragraph\":{\"indentLeft\":1997,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"List_20_3_20_Cont.\",\"type\":\"paragraph\",\"styleName\":\"List 3 Cont.\",\"attrs\":{\"paragraph\":{\"indentLeft\":1905,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Contents_20_6\",\"type\":\"paragraph\",\"styleName\":\"Contents 6\",\"attrs\":{\"paragraph\":{\"indentLeft\":2496,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Contents_20_7\",\"type\":\"paragraph\",\"styleName\":\"Contents 7\",\"attrs\":{\"paragraph\":{\"indentLeft\":2995,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Contents_20_8\",\"type\":\"paragraph\",\"styleName\":\"Contents 8\",\"attrs\":{\"paragraph\":{\"indentLeft\":3494,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Contents_20_9\",\"type\":\"paragraph\",\"styleName\":\"Contents 9\",\"attrs\":{\"paragraph\":{\"indentLeft\":3993,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Table_20_index_20_1\",\"type\":\"paragraph\",\"styleName\":\"Table index 1\",\"attrs\":{\"paragraph\":{\"indentLeft\":0,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_2_20_Cont.\",\"type\":\"paragraph\",\"styleName\":\"Numbering 2 Cont.\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"marginTop\":0,\"indentRight\":0,\"marginBottom\":212}},\"parent\":\"List\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Contents_20_1\",\"type\":\"paragraph\",\"styleName\":\"Contents 1\",\"attrs\":{\"paragraph\":{\"indentLeft\":0,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Contents_20_2\",\"type\":\"paragraph\",\"styleName\":\"Contents 2\",\"attrs\":{\"paragraph\":{\"indentLeft\":499,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Illustration_20_Index_20_Heading\",\"type\":\"paragraph\",\"styleName\":\"Illustration Index Heading\",\"attrs\":{\"paragraph\":{\"indentLeft\":0,\"indentRight\":0},\"character\":{\"fontSizeAsian\":16,\"fontSize\":16,\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"Heading\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Contents_20_3\",\"type\":\"paragraph\",\"styleName\":\"Contents 3\",\"attrs\":{\"paragraph\":{\"indentLeft\":998,\"indentRight\":0}},\"parent\":\"Index\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Strong_20_Emphasis\",\"type\":\"character\",\"styleName\":\"Strong Emphasis\",\"attrs\":{\"character\":{\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Index_20_Link\",\"type\":\"character\",\"styleName\":\"Index Link\",\"attrs\":{},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Teletype\",\"type\":\"character\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Courier New\",\"fontName\":\"Courier New\",\"fontNameAsian\":\"Courier New\"}},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Emphasis\",\"type\":\"character\",\"attrs\":{\"character\":{\"italicComplex\":true,\"italic\":true,\"italicAsian\":true}},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Page_20_Number\",\"type\":\"character\",\"styleName\":\"Page Number\",\"attrs\":{},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Vertical_20_Numbering_20_Symbols\",\"type\":\"character\",\"styleName\":\"Vertical Numbering Symbols\",\"attrs\":{},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Example\",\"type\":\"character\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Courier New\",\"fontName\":\"Courier New\",\"fontNameAsian\":\"Courier New\"}},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Visited_20_Internet_20_Link\",\"type\":\"character\",\"styleName\":\"Visited Internet Link\",\"attrs\":{\"character\":{\"underline\":true,\"color\":{\"value\":\"800000\",\"type\":\"rgb\"}}},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Main_20_index_20_entry\",\"type\":\"character\",\"styleName\":\"Main index entry\",\"attrs\":{\"character\":{\"boldComplex\":true,\"boldAsian\":true,\"bold\":true}},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Rubies\",\"type\":\"character\",\"attrs\":{\"character\":{\"underline\":false,\"fontSizeAsian\":6,\"fontSize\":6}},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Footnote_20_Symbol\",\"type\":\"character\",\"styleName\":\"Footnote Symbol\",\"attrs\":{},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Variable\",\"type\":\"character\",\"attrs\":{\"character\":{\"italicComplex\":true,\"italic\":true,\"italicAsian\":true}},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"User_20_Entry\",\"type\":\"character\",\"styleName\":\"User Entry\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Courier New\",\"fontName\":\"Courier New\",\"fontNameAsian\":\"Courier New\"}},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Bullet_20_Symbols\",\"type\":\"character\",\"styleName\":\"Bullet Symbols\",\"attrs\":{\"character\":{\"fontSizeAsian\":9,\"fontSize\":9,\"fontNameComplex\":\"StarSymbol\",\"fontName\":\"StarSymbol\",\"fontNameAsian\":\"StarSymbol\"}},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Placeholder\",\"type\":\"character\",\"attrs\":{\"character\":{\"underline\":true,\"color\":{\"value\":\"008080\",\"type\":\"rgb\"}}},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Drop_20_Caps\",\"type\":\"character\",\"styleName\":\"Drop Caps\",\"attrs\":{},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Citation\",\"type\":\"character\",\"attrs\":{\"character\":{\"italicComplex\":true,\"italic\":true,\"italicAsian\":true}},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Endnote_20_anchor\",\"type\":\"character\",\"styleName\":\"Endnote anchor\",\"attrs\":{\"character\":{\"vertAlign\":\"super\"}},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Caption_20_characters\",\"type\":\"character\",\"styleName\":\"Caption characters\",\"attrs\":{},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Footnote_20_anchor\",\"type\":\"character\",\"styleName\":\"Footnote anchor\",\"attrs\":{\"character\":{\"vertAlign\":\"super\"}},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Line_20_numbering\",\"type\":\"character\",\"styleName\":\"Line numbering\",\"attrs\":{},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Endnote_20_Symbol\",\"type\":\"character\",\"styleName\":\"Endnote Symbol\",\"attrs\":{},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Source_20_Text\",\"type\":\"character\",\"styleName\":\"Source Text\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Courier New\",\"fontName\":\"Courier New\",\"fontNameAsian\":\"Courier New\"}},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Internet_20_link\",\"type\":\"character\",\"styleName\":\"Internet link\",\"attrs\":{\"character\":{\"underline\":true,\"color\":{\"value\":\"000080\",\"type\":\"rgb\"}}},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Numbering_20_Symbols\",\"type\":\"character\",\"styleName\":\"Numbering Symbols\",\"attrs\":{},\"parent\":\"default_character_style\"},{\"name\":\"insertStyleSheet\",\"styleId\":\"Definition\",\"type\":\"character\",\"attrs\":{},\"parent\":\"default_character_style\"},{\"name\":\"insertListStyle\",\"listStyleId\":\"List_20_2\",\"listDefinition\":{\"listLevel0\":{\"levelText\":\"\\u2013\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.3cm\"},\"listLevel1\":{\"levelText\":\"\\u2013\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.3cm\",\"spaceBefore\":\"0.3cm\"},\"listLevel2\":{\"levelText\":\"\\u2013\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.3cm\",\"spaceBefore\":\"0.6cm\"},\"listLevel3\":{\"levelText\":\"\\u2013\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.3cm\",\"spaceBefore\":\"0.899cm\"},\"listLevel4\":{\"levelText\":\"\\u2013\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.3cm\",\"spaceBefore\":\"1.199cm\"},\"listLevel5\":{\"levelText\":\"\\u2013\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.3cm\",\"spaceBefore\":\"1.499cm\"},\"listLevel6\":{\"levelText\":\"\\u2013\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.3cm\",\"spaceBefore\":\"1.801cm\"},\"listLevel7\":{\"levelText\":\"\\u2013\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.3cm\",\"spaceBefore\":\"2.101cm\"},\"listLevel8\":{\"levelText\":\"\\u2013\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.3cm\",\"spaceBefore\":\"2.401cm\"},\"listLevel9\":{\"levelText\":\"\\u2013\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.3cm\",\"spaceBefore\":\"2.7cm\"}}},{\"name\":\"insertListStyle\",\"listStyleId\":\"List_20_3\",\"listDefinition\":{\"listLevel0\":{\"levelText\":\"\\u2611\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.395cm\"},\"listLevel1\":{\"levelText\":\"\\u25A1\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.395cm\",\"spaceBefore\":\"0.395cm\"},\"listLevel2\":{\"levelText\":\"\\u2611\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.395cm\"},\"listLevel3\":{\"levelText\":\"\\u25A1\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.395cm\",\"spaceBefore\":\"0.395cm\"},\"listLevel4\":{\"levelText\":\"\\u2611\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.395cm\"},\"listLevel5\":{\"levelText\":\"\\u25A1\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.395cm\",\"spaceBefore\":\"0.395cm\"},\"listLevel6\":{\"levelText\":\"\\u2611\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.395cm\"},\"listLevel7\":{\"levelText\":\"\\u25A1\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.395cm\",\"spaceBefore\":\"0.395cm\"},\"listLevel8\":{\"levelText\":\"\\u2611\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.395cm\"},\"listLevel9\":{\"levelText\":\"\\u25A1\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.395cm\",\"spaceBefore\":\"0.395cm\"}}},{\"name\":\"insertListStyle\",\"listStyleId\":\"Numbering_20_2\",\"listDefinition\":{\"listLevel0\":{\"levelText\":\"%1\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\"},\"listLevel1\":{\"levelText\":\"%2\",\"listStartValue\":\"2\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"0.499cm\"},\"listLevel2\":{\"levelText\":\"%3\",\"listStartValue\":\"3\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"1cm\",\"spaceBefore\":\"0.998cm\"},\"listLevel3\":{\"levelText\":\"%4\",\"listStartValue\":\"4\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"1.251cm\",\"spaceBefore\":\"1.998cm\"},\"listLevel4\":{\"levelText\":\"%5\",\"listStartValue\":\"5\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"1.499cm\",\"spaceBefore\":\"3.249cm\"},\"listLevel5\":{\"levelText\":\"%6\",\"listStartValue\":\"6\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"1.801cm\",\"spaceBefore\":\"4.748cm\"},\"listLevel6\":{\"levelText\":\"%7\",\"listStartValue\":\"7\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"2.3cm\",\"spaceBefore\":\"6.549cm\"},\"listLevel7\":{\"levelText\":\"%8\",\"listStartValue\":\"8\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"2.6cm\",\"spaceBefore\":\"8.849cm\"},\"listLevel8\":{\"levelText\":\"%9\",\"listStartValue\":\"9\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"2.801cm\",\"spaceBefore\":\"11.449cm\"},\"listLevel9\":{\"levelText\":\"%10\",\"listStartValue\":\"10\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"3.101cm\",\"spaceBefore\":\"14.25cm\"}}},{\"name\":\"insertListStyle\",\"listStyleId\":\"List_20_1\",\"listDefinition\":{\"listLevel0\":{\"levelText\":\"\\u2022\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\"},\"listLevel1\":{\"levelText\":\"\\u2022\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"0.401cm\"},\"listLevel2\":{\"levelText\":\"\\u2022\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"0.799cm\"},\"listLevel3\":{\"levelText\":\"\\u2022\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"1.2cm\"},\"listLevel4\":{\"levelText\":\"\\u2022\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"1.6cm\"},\"listLevel5\":{\"levelText\":\"\\u2022\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"2.001cm\"},\"listLevel6\":{\"levelText\":\"\\u2022\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"2.399cm\"},\"listLevel7\":{\"levelText\":\"\\u2022\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"2.8cm\"},\"listLevel8\":{\"levelText\":\"\\u2022\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"3.2cm\"},\"listLevel9\":{\"levelText\":\"\\u2022\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"3.601cm\"}}},{\"name\":\"insertListStyle\",\"listStyleId\":\"Numbering_20_1\",\"listDefinition\":{\"listLevel0\":{\"levelText\":\"%1.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\"},\"listLevel1\":{\"levelText\":\"%2.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"0.501cm\"},\"listLevel2\":{\"levelText\":\"%3.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"1cm\"},\"listLevel3\":{\"levelText\":\"%4.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"1.501cm\"},\"listLevel4\":{\"levelText\":\"%5.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"2cm\"},\"listLevel5\":{\"levelText\":\"%6.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"2.501cm\"},\"listLevel6\":{\"levelText\":\"%7.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"3.001cm\"},\"listLevel7\":{\"levelText\":\"%8.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"3.502cm\"},\"listLevel8\":{\"levelText\":\"%9.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"4.001cm\"},\"listLevel9\":{\"levelText\":\"%10.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"4.502cm\"}}},{\"name\":\"insertListStyle\",\"listStyleId\":\"List_20_4\",\"listDefinition\":{\"listLevel0\":{\"levelText\":\"\\u27A2\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\"},\"listLevel1\":{\"levelText\":\"\\uE006\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"0.401cm\"},\"listLevel2\":{\"levelText\":\"\\uE004\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"0.799cm\"},\"listLevel3\":{\"levelText\":\"\\uE004\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"1.2cm\"},\"listLevel4\":{\"levelText\":\"\\uE004\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"1.6cm\"},\"listLevel5\":{\"levelText\":\"\\uE004\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"2.001cm\"},\"listLevel6\":{\"levelText\":\"\\uE004\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"2.399cm\"},\"listLevel7\":{\"levelText\":\"\\uE004\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"2.8cm\"},\"listLevel8\":{\"levelText\":\"\\uE004\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"3.2cm\"},\"listLevel9\":{\"levelText\":\"\\uE004\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"3.601cm\"}}},{\"name\":\"insertListStyle\",\"listStyleId\":\"List_20_5\",\"listDefinition\":{\"listLevel0\":{\"levelText\":\"\\u2717\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\"},\"listLevel1\":{\"levelText\":\"\\u2717\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"0.401cm\"},\"listLevel2\":{\"levelText\":\"\\u2717\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"0.799cm\"},\"listLevel3\":{\"levelText\":\"\\u2717\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"1.2cm\"},\"listLevel4\":{\"levelText\":\"\\u2717\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"1.6cm\"},\"listLevel5\":{\"levelText\":\"\\u2717\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"2.001cm\"},\"listLevel6\":{\"levelText\":\"\\u2717\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"2.399cm\"},\"listLevel7\":{\"levelText\":\"\\u2717\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"2.8cm\"},\"listLevel8\":{\"levelText\":\"\\u2717\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"3.2cm\"},\"listLevel9\":{\"levelText\":\"\\u2717\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\",\"spaceBefore\":\"3.601cm\"}}},{\"name\":\"insertListStyle\",\"listStyleId\":\"Numbering_20_4\",\"listDefinition\":{\"listLevel0\":{\"levelText\":\"%1.\",\"numberFormat\":\"upperRoman\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\"},\"listLevel1\":{\"levelText\":\"%2.\",\"listStartValue\":\"2\",\"numberFormat\":\"upperRoman\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"0.501cm\"},\"listLevel2\":{\"levelText\":\"%3.\",\"listStartValue\":\"3\",\"numberFormat\":\"upperRoman\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"1cm\"},\"listLevel3\":{\"levelText\":\"%4.\",\"listStartValue\":\"4\",\"numberFormat\":\"upperRoman\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"1.501cm\"},\"listLevel4\":{\"levelText\":\"%5.\",\"listStartValue\":\"5\",\"numberFormat\":\"upperRoman\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"2cm\"},\"listLevel5\":{\"levelText\":\"%6.\",\"listStartValue\":\"6\",\"numberFormat\":\"upperRoman\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"2.501cm\"},\"listLevel6\":{\"levelText\":\"%7.\",\"listStartValue\":\"7\",\"numberFormat\":\"upperRoman\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"3.001cm\"},\"listLevel7\":{\"levelText\":\"%8.\",\"listStartValue\":\"8\",\"numberFormat\":\"upperRoman\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"3.502cm\"},\"listLevel8\":{\"levelText\":\"%9.\",\"listStartValue\":\"9\",\"numberFormat\":\"upperRoman\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"4.001cm\"},\"listLevel9\":{\"levelText\":\"%10.\",\"listStartValue\":\"10\",\"numberFormat\":\"upperRoman\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.499cm\",\"spaceBefore\":\"4.502cm\"}}},{\"name\":\"insertListStyle\",\"listStyleId\":\"Numbering_20_3\",\"listDefinition\":{\"listLevel0\":{\"levelText\":\"%1\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"3cm\"},\"listLevel1\":{\"levelText\":\"%2\",\"listStartValue\":\"2\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"3cm\",\"spaceBefore\":\"3.001cm\"},\"listLevel2\":{\"levelText\":\"%3\",\"listStartValue\":\"3\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"3cm\",\"spaceBefore\":\"6.001cm\"},\"listLevel3\":{\"levelText\":\"%4\",\"listStartValue\":\"4\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"3cm\",\"spaceBefore\":\"9.002cm\"},\"listLevel4\":{\"levelText\":\"%5\",\"listStartValue\":\"5\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"3cm\",\"spaceBefore\":\"12.002cm\"},\"listLevel5\":{\"levelText\":\"%6\",\"listStartValue\":\"6\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"3cm\",\"spaceBefore\":\"15.002cm\"},\"listLevel6\":{\"levelText\":\"%7\",\"listStartValue\":\"7\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"3cm\",\"spaceBefore\":\"18.003cm\"},\"listLevel7\":{\"levelText\":\"%8\",\"listStartValue\":\"8\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"3cm\",\"spaceBefore\":\"21.003cm\"},\"listLevel8\":{\"levelText\":\"%9\",\"listStartValue\":\"9\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"3cm\",\"spaceBefore\":\"24.003cm\"},\"listLevel9\":{\"levelText\":\"%10\",\"listStartValue\":\"10\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"3cm\",\"spaceBefore\":\"27.004cm\"}}},{\"name\":\"insertListStyle\",\"listStyleId\":\"Numbering_20_5\",\"listDefinition\":{\"listLevel0\":{\"levelText\":\"%1.\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.4cm\"},\"listLevel1\":{\"levelText\":\"%1.%2.\",\"listStartValue\":\"2\",\"numberFormat\":\"decimal\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.651cm\",\"spaceBefore\":\"0.45cm\"},\"listLevel2\":{\"levelText\":\"%3)\",\"listStartValue\":\"3\",\"numberFormat\":\"lowerLetter\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.45cm\",\"spaceBefore\":\"1.1cm\"},\"listLevel3\":{\"levelText\":\"\\u2022\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.395cm\",\"spaceBefore\":\"1.605cm\"},\"listLevel4\":{\"levelText\":\"\\u2022\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.395cm\",\"spaceBefore\":\"2cm\"},\"listLevel5\":{\"levelText\":\"\\u2022\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.395cm\",\"spaceBefore\":\"2.395cm\"},\"listLevel6\":{\"levelText\":\"\\u2022\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.395cm\",\"spaceBefore\":\"2.791cm\"},\"listLevel7\":{\"levelText\":\"\\u2022\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.395cm\",\"spaceBefore\":\"3.186cm\"},\"listLevel8\":{\"levelText\":\"\\u2022\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.395cm\",\"spaceBefore\":\"3.581cm\"},\"listLevel9\":{\"levelText\":\"\\u2022\",\"numberFormat\":\"bullet\",\"styleId\":\"Numbering_20_Symbols\",\"minLabelWidth\":\"0.395cm\",\"spaceBefore\":\"3.976cm\"}}},{\"attrs\":{\"page\":{\"height\":29699,\"numberFormat\":\"1\",\"indentLeft\":2000,\"marginTop\":2000,\"indentRight\":2000,\"marginBottom\":2000,\"printOrientation\":\"portrait\",\"width\":20999}},\"name\":\"setDocumentAttributes\"},{\"name\":\"insertFontDescription\",\"fontName\":\"Times New Roman\",\"family\":\"'Times New Roman'\",\"pitch\":\"variable\"},{\"name\":\"insertFontDescription\",\"fontName\":\"Lucida Sans Unicode\",\"family\":\"'Lucida Sans Unicode'\",\"pitch\":\"variable\"},{\"name\":\"insertFontDescription\",\"fontName\":\"Tahoma\",\"family\":\"Tahoma\",\"pitch\":\"variable\"},{\"name\":\"insertFontDescription\",\"fontName\":\"Mangal1\",\"family\":\"Mangal\"},{\"name\":\"insertFontDescription\",\"fontName\":\"Times New Roman\",\"family\":\"'Times New Roman'\",\"pitch\":\"variable\"},{\"name\":\"insertFontDescription\",\"fontName\":\"Arial\",\"family\":\"Arial\",\"pitch\":\"variable\"},{\"name\":\"insertFontDescription\",\"fontName\":\"Mangal\",\"family\":\"Mangal\",\"pitch\":\"variable\"},{\"name\":\"insertFontDescription\",\"fontName\":\"Microsoft YaHei\",\"family\":\"'Microsoft YaHei'\",\"pitch\":\"variable\"},{\"name\":\"insertFontDescription\",\"fontName\":\"SimSun\",\"family\":\"SimSun\",\"pitch\":\"variable\"},{\"name\":\"insertParagraph\",\"start\":[0],\"attrs\":{\"paragraph\":{}}},{\"text\":\"1\",\"start\":[0,0],\"name\":\"insertText\"},{\"name\":\"insertParagraph\",\"start\":[0,1],\"attrs\":{\"paragraph\":{}}},{\"text\":\"222\",\"start\":[0,1,0],\"name\":\"insertText\"},{\"name\":\"insertParagraph\",\"start\":[0,1,3],\"attrs\":{\"paragraph\":{}}},{\"text\":\"3\",\"start\":[0,1,3,0],\"name\":\"insertText\"},{\"name\":\"insertParagraph\",\"start\":[0,1,3,1],\"attrs\":{\"paragraph\":{}}},{\"text\":\"Svante\",\"start\":[0,1,3,1,0],\"name\":\"insertText\"},{\"text\":\"3\",\"start\":[0,1,3,2],\"name\":\"insertText\"},{\"text\":\"222\",\"start\":[0,1,4],\"name\":\"insertText\"},{\"text\":\"1\",\"start\":[0,2],\"name\":\"insertText\"},{\"name\":\"insertParagraph\",\"start\":[1],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}}}]}"; 
		try {
//			//**********LOAD
			
//			// read the (known) operation from the test document
//			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));
//			JSONObject ops = doc.getOperations();
//			LOG.log(Level.INFO, "The Ops are: {0}", ops.toString());
//
//			//**********APPLY
			OdfOperationDocument doc2 = new OdfOperationDocument();
			int opCount = doc2.applyOperations(OPS);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE		
			File testFile = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_1);
			doc2.getDocument().save(testFile);

			//**********RELOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc3 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_1)));
			JSONObject ops2 = doc3.getOperations();
			LOG.log(Level.INFO, "The reloaded Ops are:{0}", ops2.toString());						
			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());			
			Assert.assertTrue(ops2.toString(true).equals(EXPECTED_OPS.toString()));
		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}		
	
	@Test
	@Ignore
	public void importNestedSpansChanges() {
		final String SOURCE_FILE_NAME_TRUNC = "feature_attributes_character_MSO15";
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
		final String TARGET_FILE_NAME_1 = "_OUT.odt";


		final String OPERATIONS = 
		 "[{\"name\":\"setAttributes\",\"start\":[3,0],\"attrs\":{\"character\":{\"fontName\":\"Times New Roman\"}},\"end\":[3,26]}, "
		+ "{\"name\":\"setAttributes\",\"start\":[3,0],\"attrs\":{\"character\":{\"fontSize\":6}},\"end\":[3,26]}, "
		+ "{\"name\":\"setAttributes\",\"start\":[5,0],\"attrs\":{\"character\":{\"fontName\":\"Courier New\"}},\"end\":[5,26]}, "
		+ "{\"name\":\"setAttributes\",\"start\":[5,0],\"attrs\":{\"character\":{\"fontSize\":20}},\"end\":[5,26]}, "
		+ "{\"name\":\"setAttributes\",\"start\":[5,0],\"attrs\":{\"character\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"92D050\"}}},\"end\":[5,26]}, "
		+ "{\"name\":\"setAttributes\",\"start\":[3,0],\"attrs\":{\"character\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"FF0000\"}}},\"end\":[3,26]}, "
		+ "{\"name\":\"setAttributes\",\"start\":[0,4],\"attrs\":{\"character\":{\"fontName\":\"Impact\"}},\"end\":[0,13]}, "
		+ "{\"name\":\"insertText\",\"text\":\"X\",\"start\":[1,8]},"
		+ "{\"name\":\"setAttributes\",\"start\":[0,6],\"attrs\":{\"character\":{\"fontSize\":32}},\"end\":[0,10]},"
		+ "]";

				
//		final String OPERATIONS = "[{\"name\":\"insertText\",\"text\":\"NewText\",\"start\":[0,0]},"
//				+ "{\"name\":\"setAttributes\",\"start\":[0],\"attrs\":{"
//				+ "\"paragraph\":{"
//				+ "\"borderLeft\":{\"style\":\"single\",\"width\":17,\"space\":140,\"color\":{\"type\":\"auto\"}},"
//				+ "\"borderRight\":{\"style\":\"single\",\"width\":17,\"space\":140,\"color\":{\"type\":\"auto\"}},"
//				+ "\"borderTop\":{\"style\":\"single\"},"
//				+ "\"borderBottom\":{\"style\":\"none\"},"
//				+ "\"borderInside\":{\"style\":\"none\"}},"
//				+ "\"character\":{"
//				+ "\"color\":{\"type\":\"auto\"},"
//				+ "\"fillColor\":{\"type\":\"rgb\",\"value\":\"000000\"}}}"
//				+ "},"
//				+ "]";

		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));
			
			//**********APPLY
			int opCount = doc.applyOperations(OPERATIONS);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE		
			File testFile = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_1);
			doc.getDocument().save(testFile);

			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());

//			// read the (known) operation from the test document			
//			OdfContentDom contentDom2 = doc2.getDocument().getContentDom();
//			XPath xpath = contentDom2.getXPath();
//			Node rootNode = contentDom2.getRootElement();
//
//			// heading with no automatic properties should only bear a style reference
//			TextHElement header1 = (TextHElement) xpath.evaluate(".//text:h[1]", rootNode, XPathConstants.NODE);
//			if (header1 == null || !header1.getTextStyleNameAttribute().equals("Heading2")) {
//				Assert.fail("The first heading does not have the expected style 'Heading2'!");
//			}
//
//			TextHElement header = (TextHElement) xpath.evaluate(".//text:h[contains(text(), 'Paragraph Borders Outside')]", rootNode, XPathConstants.NODE);
//			if (header == null) {
//				Assert.fail("The test heading with 'Paragraph Borders Outside' could not be found!");
//			}
//			Node nextSibling = header.getNextSibling();
//			while (!(nextSibling instanceof OdfElement)) {
//				nextSibling = header.getNextSibling();
//			}
//			TextPElement testParagraph = (TextPElement) nextSibling;
//			OdfStyleProperty borderProp = OdfParagraphProperties.Border;
//			OdfStyleProperty borderBottomProp = OdfParagraphProperties.BorderBottom;
//			OdfStyleProperty borderLeftProp = OdfParagraphProperties.BorderLeft;
//			OdfStyleProperty borderRightProp = OdfParagraphProperties.BorderRight;
//			OdfStyleProperty borderTopProp = OdfParagraphProperties.BorderTop;
////			String border = testParagraph.getProperty(borderProp);
//			String borderBottom = testParagraph.getProperty(borderBottomProp);
//			String borderLeft = testParagraph.getProperty(borderLeftProp);
//			String borderRight = testParagraph.getProperty(borderRightProp);
//			String borderTop = testParagraph.getProperty(borderTopProp);

//			System.out.println("STYLENAME: " + testParagraph.getStyleName());
//			
////			System.out.println("******************************CONTENT:" + nextSibling.getTextContent());
//			System.out.println("******************************border:" + border);
//			System.out.println("******************************borderBottom:" + borderBottom);
//			System.out.println("******************************borderLeft:" + borderLeft);
//			System.out.println("******************************borderRight:" + borderRight);
//			System.out.println("******************************borderTop:" + borderTop);


//			NodeList header = odfContent2.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "h");
//			Node node2 = header.
//			String paragraphText2 = node2.getTextContent();			


		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}


	@Test
	@Ignore
	public void style_LineBreakTest() {
		final String SOURCE_FILE_NAME_TRUNC = "EasyList";
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
		final String TARGET_FILE_NAME_1 = "_OUT_1.odt";


//		final String OPERATIONS = "[{\"name\":\"insertText\",\"text\":\"NewText\",\"start\":[0,0]},"
//				+ "{\"name\":\"setAttributes\",\"start\":[0],\"attrs\":{"
//				+ "\"paragraph\":{"
//				+ "\"borderLeft\":{\"style\":\"single\",\"width\":17,\"space\":140,\"color\":{\"type\":\"auto\"}},"
//				+ "\"borderRight\":{\"style\":\"single\",\"width\":17,\"space\":140,\"color\":{\"type\":\"auto\"}},"
//				+ "\"borderTop\":{\"style\":\"single\"},"
//				+ "\"borderBottom\":{\"style\":\"none\"},"
//				+ "\"borderInside\":{\"style\":\"none\"}},"
//				+ "\"character\":{"
//				+ "\"color\":{\"type\":\"auto\"},"
//				+ "\"fillColor\":{\"type\":\"rgb\",\"value\":\"000000\"}}}"
//				+ "},"
//				//				+ "{\"name\":\"setAttributes\",\"start\":[0],\"attrs\":{" 
//				//				+"\"character\":{"
//				//					+"\"color\":{\"type\":\"rgb\",\"value\":\"000000\"}}}" 
//				//				+ "}"
//				+ "]";


//		final String OPERATIONS = "[{\"name\":\"insertText\",\"text\":\"NewText4\",\"start\":[0,0]}," 
//				+ "{\"name\":\"setAttributes\",\"start\":[1],\"attrs\":{\"paragraph\":{"
//				+ "\"borderLeft\":{\"style\":\"single\",\"width\":17,\"space\":140,\"color\":{\"type\":\"rgb\",\"value\":\"000000\"}},"
//				+ "\"borderRight\":{\"style\":\"single\",\"width\":17,\"space\":140,\"color\":{\"type\":\"rgb\",\"value\":\"000000\"}},"
//				+ "\"borderTop\":{\"style\":\"single\",\"width\":17,\"space\":140,\"color\":{\"type\":\"rgb\",\"value\":\"000000\"}},"
//				+ "\"borderBottom\":{\"style\":\"single\",\"width\":17,\"space\":140,\"color\":{\"type\":\"rgb\",\"value\":\"000000\"}},"
//				+ "\"borderInside\":{\"style\":\"single\",\"width\":17,\"space\":140,\"color\":{\"type\":\"rgb\",\"value\":\"000000\"}}}}}]";

		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));
			JSONObject ops = doc.getOperations();
			LOG.log(Level.INFO, "The Ops are: {0}", ops.toString());


//			//**********APPLY
//			int opCount = doc.applyOperations(OPERATIONS);
//			LOG.log(Level.INFO, "opCount: {0}", opCount);
//
//			//**********SAVE		
//			File testFile = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_1);
//			doc.getDocument().save(testFile);
//
//			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());
//
//			// read the (known) operation from the test document			
//			OdfOperationDocument doc2 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_1)));
//			OdfContentDom contentDom2 = doc2.getDocument().getContentDom();
//			XPath xpath = contentDom2.getXPath();
//			Node rootNode = contentDom2.getRootElement();
//
//			// heading with no automatic properties should only bear a style reference
//			TextPElement paraWithBorder = (TextPElement) xpath.evaluate(".//text:p[1]", rootNode, XPathConstants.NODE);
//			if (paraWithBorder == null) {
//				Assert.fail("The first heading does not have the expected style 'Heading2'!");
//			}
//			String borderTopProperty = paraWithBorder.getAutomaticStyle().getProperty(StyleParagraphPropertiesElement.BorderTop);
//			if (!borderTopProperty.contains("solid")) {
//				Assert.fail("The second paragraph should have an automatic top border style 'solid'!");
//			}
		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}
	
	@Test
	@Ignore
	public void style_HeadingStandardTest() {
		final String SOURCE_FILE_NAME_TRUNC = "Larissa";
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
		final String TARGET_FILE_NAME_1 = "_OUT_1.odt";


		final String OPERATIONS = "[{\"name\":\"insertText\",\"text\":\"NewText\",\"start\":[0,0]},"
				+ "{\"name\":\"setAttributes\",\"start\":[0],\"attrs\":{"
				+ "\"paragraph\":{"
				+ "\"borderLeft\":{\"style\":\"single\",\"width\":17,\"space\":140,\"color\":{\"type\":\"auto\"}},"
				+ "\"borderRight\":{\"style\":\"single\",\"width\":17,\"space\":140,\"color\":{\"type\":\"auto\"}},"
				+ "\"borderTop\":{\"style\":\"single\"},"
				+ "\"borderBottom\":{\"style\":\"none\"},"
				+ "\"borderInside\":{\"style\":\"none\"}},"
				+ "\"character\":{"
				+ "\"color\":{\"type\":\"auto\"},"
				+ "\"fillColor\":{\"type\":\"rgb\",\"value\":\"000000\"}}}"
				+ "},"
				//				+ "{\"name\":\"setAttributes\",\"start\":[0],\"attrs\":{" 
				//				+"\"character\":{"
				//					+"\"color\":{\"type\":\"rgb\",\"value\":\"000000\"}}}" 
				//				+ "}"
				+ "]";
//		final String OPERATIONS = "[{\"name\":\"insertText\",\"text\":\"NewText4\",\"start\":[0,0]}," 
//				+ "{\"name\":\"setAttributes\",\"start\":[1],\"attrs\":{\"paragraph\":{"
//				+ "\"borderLeft\":{\"style\":\"single\",\"width\":17,\"space\":140,\"color\":{\"type\":\"rgb\",\"value\":\"000000\"}},"
//				+ "\"borderRight\":{\"style\":\"single\",\"width\":17,\"space\":140,\"color\":{\"type\":\"rgb\",\"value\":\"000000\"}},"
//				+ "\"borderTop\":{\"style\":\"single\",\"width\":17,\"space\":140,\"color\":{\"type\":\"rgb\",\"value\":\"000000\"}},"
//				+ "\"borderBottom\":{\"style\":\"single\",\"width\":17,\"space\":140,\"color\":{\"type\":\"rgb\",\"value\":\"000000\"}},"
//				+ "\"borderInside\":{\"style\":\"single\",\"width\":17,\"space\":140,\"color\":{\"type\":\"rgb\",\"value\":\"000000\"}}}}}]";

		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));
			JSONObject ops = doc.getOperations();
			LOG.log(Level.INFO, "The Ops are: {0}", ops.toString());


//			//**********APPLY
//			int opCount = doc.applyOperations(OPERATIONS);
//			LOG.log(Level.INFO, "opCount: {0}", opCount);
//
//			//**********SAVE		
//			File testFile = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_1);
//			doc.getDocument().save(testFile);
//
//			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());
//
//			// read the (known) operation from the test document			
//			OdfOperationDocument doc2 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_1)));
//			OdfContentDom contentDom2 = doc2.getDocument().getContentDom();
//			XPath xpath = contentDom2.getXPath();
//			Node rootNode = contentDom2.getRootElement();
//
//			// heading with no automatic properties should only bear a style reference
//			TextPElement paraWithBorder = (TextPElement) xpath.evaluate(".//text:p[1]", rootNode, XPathConstants.NODE);
//			if (paraWithBorder == null) {
//				Assert.fail("The first heading does not have the expected style 'Heading2'!");
//			}
//			String borderTopProperty = paraWithBorder.getAutomaticStyle().getProperty(StyleParagraphPropertiesElement.BorderTop);
//			if (!borderTopProperty.contains("solid")) {
//				Assert.fail("The second paragraph should have an automatic top border style 'solid'!");
//			}
		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

//	@Test
//	public void borderPropertyTest() {
//
//		JSONObject testOutput;
//		testOutput = JsonOperationProducer.createBorderMap("0.0069in    solid #000000");
//		if (!isValid(testOutput)) {
//			Assert.fail("NOOooooooooooooooo1!!!" + testOutput);
//		}
//
//
//		testOutput = JsonOperationProducer.createBorderMap("0.0069in    solid     #000000");
//		if (!isValid(testOutput)) {
//			Assert.fail("NOOooooooooooooooo2!!!" + testOutput);
//		}
//
//
//		testOutput = JsonOperationProducer.createBorderMap("    solid 0.0069in     #000000");
//		if (!isValid(testOutput)) {
//			Assert.fail("NOOooooooooooooooo3!!!" + testOutput);
//		}
//
//
//		testOutput = JsonOperationProducer.createBorderMap("#000000 0.0069in    solid     ");
//		if (!isValid(testOutput)) {
//			Assert.fail("NOOooooooooooooooo4!!!" + testOutput);
//		}
//
//
//		testOutput = JsonOperationProducer.createBorderMap("0.0069in #000000     solid     ");
//		if (!isValid(testOutput)) {
//			Assert.fail("NOOooooooooooooooo5!!!" + testOutput);
//		}
//
//
//		testOutput = JsonOperationProducer.createBorderMap("0.0069in       #000000  solid");
//		if (!isValid(testOutput)) {
//			Assert.fail("NOOooooooooooooooo6!!!" + testOutput);
//		}
//
//
//	}
//
//	// !{"color":{"type":"rgb","value":"000000"},"style":"single","width":18}
//	private boolean isValid(JSONObject border) {
//		boolean isValid = false;
//		try {
//			JSONObject color = border.getJSONObject("color");
//			isValid = 
//					color.getString("type").equals("rgb") &&
//					color.getString("value").equals("000000")
//					&& border.getInt("width") == 18
//					&& border.getString("style").equals("single");
//		} catch (JSONException ex) {
//
//			Assert.fail("NOOooo???!!!" + border);
//			Logger.getLogger(OperationJsonTest.class.getName()).log(Level.SEVERE, null, ex);
//		}
//		return isValid;
//	}

	// [{"name":"setAttributes","start":[1],"attrs":{"paragraph":{"borderLeft":{"style":"single","width":17,"space":140,"color":{"type":"auto"}},"borderRight":{"style":"single","width":17,"space":140,"color":{"type":"auto"}},"borderTop":{"style":"none"},"borderBottom":{"style":"none"},"borderInside":{"style":"none"}}}}]
	@Test
	@Ignore
	public void opsCopy() {
		final String SOURCE_FILE_NAME_TRUNC = "Seasonal Fruits2_en";
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
		final String TARGET_FILE_NAME_1 = "_OUT_1.odt";

		final String OPERATIONS = "["
				+ "{\"name\":\"insertText\",\"text\":\"1\",\"start\":[0,0]},"
				+ "{\"name\":\"insertText\",\"text\":\"2\",\"start\":[0,1]},"
				+ "{\"name\":\"insertText\",\"text\":\"3\",\"start\":[0,2]},"
				+ "{\"name\":\"insertText\",\"text\":\"4\",\"start\":[0,3]},"
				+ "{\"name\":\"insertText\",\"text\":\"5\",\"start\":[0,4]}"
				+ "]";


		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));


			//**********APPLY
			int opCount = doc.applyOperations(OPERATIONS);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE		
			File testFile = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_1);
			doc.getDocument().save(testFile);

			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());


		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void merge_split() {
		final String SOURCE_FILE_NAME_TRUNC = "Seasonal Fruits2_en";
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
		final String TARGET_FILE_NAME_1 = "_OUT_1.odt";
		final String TARGET_FILE_NAME_2 = "_OUT_2.odt";

		final String OPERATIONS_1 = "[{\"name\":\"splitParagraph\",\"start\":[6,687]},"
				+ "{\"name\":\"insertStyleSheet\",\"attrs\":{\"wholeTable\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":100}},\"table\":{\"borderTop\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderBottom\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderInsideHor\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderInsideVert\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderLeft\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderRight\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"}}},\"next\":null},\"type\":\"table\",\"styleId\":\"TableGrid\",\"styleName\":\"Table Grid\",\"parent\":null,\"uiPriority\":59},"
				+ "{\"name\":\"insertTable\",\"start\":[7],\"attrs\":{\"table\":{\"tableGrid\":[1000,1000],\"width\":\"auto\",\"style\":\"TableGrid\"}}},"
				+ "{\"name\":\"insertRows\",\"start\":[7,0],\"count\":2,\"insertDefaultCells\":true},"
				+ "{\"name\":\"splitParagraph\",\"start\":[8,0]},"
				+ "{\"name\":\"insertText\",\"text\":\"1\",\"start\":[8,0]},"
				+ "{\"name\":\"insertText\",\"text\":\"2\",\"start\":[8,1]},"
				+ "{\"name\":\"insertText\",\"text\":\"3\",\"start\":[8,2]},"
				+ "{\"name\":\"insertText\",\"text\":\"4\",\"start\":[8,3]},"
				+ "{\"name\":\"insertText\",\"text\":\"5\",\"start\":[8,4]}"
				+ "]";

		final String OPERATIONS_2 = "[{\"name\":\"splitParagraph\",\"start\":[8,5]},"
				+ "{\"name\":\"setAttributes\",\"start\":[9],\"attrs\":{\"paragraph\":{}}},"
				+ "{\"name\":\"insertText\",\"text\":\"6\",\"start\":[9,0]},"
				+ "{\"name\":\"insertText\",\"text\":\"7\",\"start\":[9,1]},"
				+ "{\"name\":\"insertText\",\"text\":\"8\",\"start\":[9,2]},"
				+ "{\"name\":\"insertText\",\"text\":\"9\",\"start\":[9,3]},"
				+ "{\"name\":\"insertText\",\"text\":\"0\",\"start\":[9,4]}"
				+ "]";



		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));

			//**********APPLY
			int opCount = doc.applyOperations(OPERATIONS_1);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE		
			File testFile = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_1);
			doc.getDocument().save(testFile);

			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());



			// read the (known) operation from the test document
			OdfOperationDocument doc_1 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_1)));

			//**********APPLY
			int opCount_1 = doc_1.applyOperations(OPERATIONS_2);
			LOG.log(Level.INFO, "opCount: {0}", opCount_1);

			//**********SAVE		
			File testFile_1 = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_2);
			doc_1.getDocument().save(testFile_1);



			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile_1.getAbsolutePath());

		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void loadInvalidODF_emptyAttribute() {
		final String SOURCE_FILE_NAME_TRUNC = "Seasonal Fruits2_en";
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
		final String TARGET_FILE_NAME = "_OUT.odt";

		final String OPERATIONS = "[{\"name\":\"splitParagraph\",\"start\":[6,468]},"
				+ "{\"name\":\"insertStyleSheet\",\"attrs\":{\"wholeTable\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":100}},\"table\":{\"borderTop\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderBottom\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderInsideHor\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderInsideVert\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderLeft\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderRight\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"}}},\"next\":null},\"type\":\"table\",\"styleId\":\"TableGrid\",\"styleName\":\"Table Grid\",\"parent\":null,\"uiPriority\":59},"
				+ "{\"name\":\"insertTable\",\"start\":[7],\"attrs\":{\"table\":{\"tableGrid\":[1000,1000,1000],\"width\":\"auto\",\"style\":\"TableGrid\"}}},"
				+ "{\"name\":\"insertRows\",\"start\":[7,0],\"count\":3,\"insertDefaultCells\":true},"
				+ "{\"name\":\"insertParagraph\",\"start\":[7,0,0,0]},"
				+ "{\"name\":\"insertText\",\"text\":\"1\",\"start\":[7,0,0,0,0]},"
				+ "{\"name\":\"insertParagraph\",\"start\":[7,0,1,0]},"
				+ "{\"name\":\"insertText\",\"text\":\"2\",\"start\":[7,0,1,0,0]},"
				+ "{\"name\":\"insertParagraph\",\"start\":[7,0,2,0]},"
				+ "{\"name\":\"insertText\",\"text\":\"3\",\"start\":[7,0,2,0,0]},"
				+ "{\"name\":\"insertColumn\",\"start\":[7],\"tableGrid\":[750,750,750,750],\"gridPosition\":1,\"insertMode\":\"behind\"},"
				+ "{\"name\":\"setAttributes\",\"attrs\":{\"table\":{\"tableGrid\":[750,750,750,750]}},\"start\":[7]},"
				+ "{\"name\":\"insertParagraph\",\"start\":[7,0,2,0]},"
				+ "{\"name\":\"insertText\",\"text\":\"a\",\"start\":[7,0,2,0,0]},"
				+ "{\"name\":\"insertColumn\",\"start\":[7],\"tableGrid\":[600,600,600,600,600],\"gridPosition\":1,\"insertMode\":\"behind\"},"
				+ "{\"name\":\"setAttributes\",\"attrs\":{\"table\":{\"tableGrid\":[600,600,600,600,600]}},\"start\":[7]},"
				+ "{\"name\":\"insertParagraph\",\"start\":[7,0,2,0]},"
				+ "{\"name\":\"insertText\",\"text\":\"b\",\"start\":[7,0,2,0,0]},"
				+ "{\"name\":\"insertColumn\",\"start\":[7],\"tableGrid\":[498,498,498,498,498,498],\"gridPosition\":1,\"insertMode\":\"behind\"},"
				+ "{\"name\":\"setAttributes\",\"attrs\":{\"table\":{\"tableGrid\":[498,498,498,498,498,498]}},\"start\":[7]},"
				+ "{\"name\":\"insertParagraph\",\"start\":[7,0,2,0]},"
				+ "{\"name\":\"insertText\",\"text\":\"c\",\"start\":[7,0,2,0,0]},"
				+ "{\"name\":\"deleteColumns\",\"start\":[7],\"startGrid\":3,\"endGrid\":3},"
				+ "{\"name\":\"setAttributes\",\"attrs\":{\"table\":{\"tableGrid\":[498,498,498,498,498]}},\"start\":[7]}"
				+ "]";

		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));

			//**********APPLY
			int opCount = doc.applyOperations(OPERATIONS);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE		
			File testFile = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME);
			doc.getDocument().save(testFile);
			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());

		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void insertColumn() {
		final String SOURCE_FILE_NAME_TRUNC = "table_1x3_paragraph_background-MSO2013-LO3_6";
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
		final String TARGET_FILE_NAME = "_OUT4.odt";

		final String OPERATIONS = "[{\"name\":\"insertColumn\",\"start\":[0],\"tableGrid\":[9,9,9,73],\"gridPosition\":1,\"insertMode\":\"behind\"},"
				+ //"{\"name\":\"setAttributes\",\"attrs\":{\"table\":{\"tableGrid\":[9,9,9,73]}},\"start\":[0]}," + 
				"{\"name\":\"insertColumn\",\"start\":[0],\"tableGrid\":[8,8,8,8,67],\"gridPosition\":1,\"insertMode\":\"behind\"},"
				+ // "{\"name\":\"setAttributes\",\"attrs\":{\"table\":{\"tableGrid\":[8,8,8,8,67]}},\"start\":[0]}," + 
				"{\"name\":\"insertColumn\",\"start\":[0],\"tableGrid\":[7,7,7,7,7,62],\"gridPosition\":1,\"insertMode\":\"behind\"},"
				+ // "{\"name\":\"setAttributes\",\"attrs\":{\"table\":{\"tableGrid\":[7,7,7,7,7,62]}},\"start\":[0]}," +
				// "{\"name\":\"deleteColumns\",\"start\":[0],\"startGrid\":3,\"endGrid\":3},"+
				// "{\"name\":\"setAttributes\",\"attrs\":{\"table\":{\"tableGrid\":[7,7,7,7,62]}},\"start\":[0]}"+
				"]";

		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));

			//**********APPLY
			int opCount = doc.applyOperations(OPERATIONS);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE		
			File testFile = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME);
			doc.getDocument().save(testFile);
			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());

		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void roundTripParagraphBorder() {
		final String SOURCE_FILE_NAME_TRUNC = "feature_attributes_paragraph_MSO2013"; //_doc-AO
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
		final String TARGET_FILE_NAME_1 = "_OUT_2.odt";



		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));

			//**********GET OPS
			JSONObject ops = doc.getOperations();

			//**********APPLY
			OdfOperationDocument doc2 = new OdfOperationDocument();
			int opCount = doc2.applyOperations(ops);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE		
			File testFile = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME_1);
			doc2.getDocument().save(testFile);

			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());

			// read the (known) operation from the test document			
			OdfContentDom contentDom2 = doc2.getDocument().getContentDom();
			XPath xpath = contentDom2.getXPath();
			Node rootNode = contentDom2.getRootElement();

			// heading with no automatic properties should only bear a style reference
			TextHElement header1 = (TextHElement) xpath.evaluate(".//text:h[1]", rootNode, XPathConstants.NODE);
			if (header1 == null || !header1.getTextStyleNameAttribute().equals("Heading2")) {
				Assert.fail("The first heading does not have the expected style 'Heading2'!");
			}

			TextHElement header = (TextHElement) xpath.evaluate(".//text:h[contains(text(), 'Paragraph Borders Outside')]", rootNode, XPathConstants.NODE);
			if (header == null) {
				Assert.fail("The test heading with 'Paragraph Borders Outside' could not be found!");
			}
			Node nextSibling = header.getNextSibling();
			while (!(nextSibling instanceof OdfElement)) {
				nextSibling = header.getNextSibling();
			}
			TextPElement testParagraph = (TextPElement) nextSibling;
			OdfStyleProperty borderProp = OdfParagraphProperties.Border;
			OdfStyleProperty borderBottomProp = OdfParagraphProperties.BorderBottom;
			OdfStyleProperty borderLeftProp = OdfParagraphProperties.BorderLeft;
			OdfStyleProperty borderRightProp = OdfParagraphProperties.BorderRight;
			OdfStyleProperty borderTopProp = OdfParagraphProperties.BorderTop;
//			String border = testParagraph.getProperty(borderProp);
//			String borderBottom = testParagraph.getProperty(borderBottomProp);
//			String borderLeft = testParagraph.getProperty(borderLeftProp);
//			String borderRight = testParagraph.getProperty(borderRightProp);
//			String borderTop = testParagraph.getProperty(borderTopProp);

//			System.out.println("STYLENAME: " + testParagraph.getStyleName());
//			
////			System.out.println("******************************CONTENT:" + nextSibling.getTextContent());
//			System.out.println("******************************border:" + border);
//			System.out.println("******************************borderBottom:" + borderBottom);
//			System.out.println("******************************borderLeft:" + borderLeft);
//			System.out.println("******************************borderRight:" + borderRight);
//			System.out.println("******************************borderTop:" + borderTop);


//			NodeList header = odfContent2.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "h");
//			Node node2 = header.
//			String paragraphText2 = node2.getTextContent();			


		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void deleteColumn2() {
		final String SOURCE_FILE_NAME_TRUNC = "Tabelle1";
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
		final String TARGET_FILE_NAME = "_OUT.odt";

		final String OPERATIONS = "[{\"name\":\"insertStyleSheet\",\"attrs\":{\"wholeTable\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":100}},\"table\":{\"borderTop\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderBottom\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderInsideHor\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderInsideVert\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderLeft\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderRight\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"}}},\"next\":null},\"type\":\"table\",\"styleId\":\"TableGrid\",\"styleName\":\"Table Grid\",\"parent\":null,\"uiPriority\":59},{\"name\":\"insertTable\",\"start\":[1],\"attrs\":{\"table\":{\"tableGrid\":[1000,1000,1000],\"width\":\"auto\",\"style\":\"TableGrid\"}}},{\"name\":\"insertRows\",\"start\":[1,0],\"count\":2,\"insertDefaultCells\":true}]";

		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));

			//**********APPLY
			int opCount = doc.applyOperations(OPERATIONS);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE		
			File testFile = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME);
			doc.getDocument().save(testFile);
			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());

		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void insertColumn2() {
		final String SOURCE_FILE_NAME_TRUNC = "table_1x3_paragraph_background-MSO2013-LO3_6";
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
		final String TARGET_FILE_NAME = "_OUT2.odt";

		final String OPERATIONS = "[{\"name\":\"insertColumn\",\"start\":[0],\"tableGrid\":[6,6,45,45],\"gridPosition\":1,\"insertMode\":\"behind\"}]";
		// ,{\"name\":\"setAttributes\",\"attrs\":{\"table\":{\"tableGrid\":[6,6,45,45]}},\"start\":[0]},{\"name\":\"deleteColumns\",\"start\":[0],\"startGrid\":1,\"endGrid\":2},{\"name\":\"setAttributes\",\"attrs\":{\"table\":{\"tableGrid\":[6,45]}},\"start\":[0]}

		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));

			//**********APPLY
			int opCount = doc.applyOperations(OPERATIONS);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE		
			File testFile = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME);
			doc.getDocument().save(testFile);
			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());

		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void insertTable() {
		final String SOURCE_FILE_NAME_TRUNC = "Tabelle1";
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
		final String TARGET_FILE_NAME = "_OUT.odt";

		final String OPERATIONS = "[{\"name\":\"insertStyleSheet\",\"attrs\":{\"wholeTable\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":100}},\"table\":{\"borderTop\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderBottom\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderInsideHor\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderInsideVert\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderLeft\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"},\"borderRight\":{\"color\":{\"type\":\"auto\"},\"width\":17,\"style\":\"single\"}}},\"next\":null},\"type\":\"table\",\"styleId\":\"TableGrid\",\"styleName\":\"Table Grid\",\"parent\":null,\"uiPriority\":59},{\"name\":\"insertTable\",\"start\":[1],\"attrs\":{\"table\":{\"tableGrid\":[1000,1000,1000],\"width\":\"auto\",\"style\":\"TableGrid\"}}},{\"name\":\"insertRows\",\"start\":[1,0],\"count\":2,\"insertDefaultCells\":true}]";

		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));

			//**********APPLY
			int opCount = doc.applyOperations(OPERATIONS);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE		
			File testFile = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME);
			doc.getDocument().save(testFile);
			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());

		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}
//	Warum ist die eingefügte Zelle breiter als die anderen?
//		
//	<table:table-row table:style-name="TableRow144">
//		<table:table-cell table:style-name="TableCell145">
//			<text:p text:style-name="P146"/>
//		</table:table-cell>
//		<table:table-cell table:style-name="TableCell147">
//			<text:p text:style-name="P148">2</text:p>
//		</table:table-cell>
//		<table:table-cell table:style-name="TableCell149">
//			<text:p text:style-name="P150"/>
//		</table:table-cell>
//		<table:table-cell table:style-name="TableCell151">
//			<text:p text:style-name="P152"/>
//		</table:table-cell>
//		<table:table-cell table:style-name="TableCell153">
//			<text:p text:style-name="P154"/>
//		</table:table-cell>
//	</table:table-row>
//	<table:table-row table:style-name="TableRow144">
//		<table:table-cell table:style-name="TableCell145"/>
//		<table:table-cell table:style-name="TableCell147"/>
//		<table:table-cell table:style-name="TableCell149"/>
//		<table:table-cell table:style-name="TableCell151"/>
//		<table:table-cell table:style-name="TableCell153"/>
//	</table:table-row>
//

	@Test
	@Ignore
	public void deleteRowInsertRow() {
		final String SOURCE_FILE_NAME_TRUNC = "Tabelle1";
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
		final String TARGET_FILE_NAME = "_OUT.odt";

		final String OPERATIONS = "[{\"name\":\"delete\",\"start\":[2,2,2,0,1]},{\"name\":\"insertRows\",\"start\":[2,2,2,0,3],\"count\":1,\"insertDefaultCells\":false,\"referenceRow\":2}]";

		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));

			//**********APPLY
			int opCount = doc.applyOperations(OPERATIONS);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE		
			File testFile = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME);
			doc.getDocument().save(testFile);
			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());

		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void test_getAllTemplateStyles() {
		final String TARGET_TRUNC_STRING = "MyHeading1";
		final String TARGET_SUFFIX_STRING = ".odt";

		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + TARGET_SUFFIX_STRING)));

			JSONObject ops = doc.getOperations();
		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void deleteStyleSheet() {
		final String SOURCE_FILE_NAME_TRUNC = "Tabelle1";
		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
		final String TARGET_FILE_NAME = "_OUT.odt";

		final String STYLE_NAME = "DefaultParagraphFont";
		final String STYLE_FAMILY = "character";

		final String ADD_TEXT_STYLES = "[{\"name\":\"deleteStyleSheet\",\"type\":\"" + STYLE_FAMILY + "\",\"styleId\":\"" + STYLE_NAME + "\"}]";

		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + SOURCE_FILE_NAME_SUFFIX)));
			OdfOfficeStyles styles = doc.getDocument().getDocumentStyles();
			OdfStyle oldStyle = styles.getStyle(STYLE_NAME, Component.getFamily(STYLE_FAMILY));
			Assert.assertNotNull(oldStyle);

			//**********APPLY
			int opCount = doc.applyOperations(ADD_TEXT_STYLES);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			OdfOfficeStyles styles2 = doc.getDocument().getDocumentStyles();
			OdfStyle oldStyle2 = styles2.getStyle(STYLE_NAME, Component.getFamily(STYLE_FAMILY));
			Assert.assertNull(oldStyle2);

			//**********SAVE		
			File testFile = ResourceUtilities.newTestOutputFile(SOURCE_FILE_NAME_TRUNC + TARGET_FILE_NAME);
			doc.getDocument().save(testFile);
			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());


		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void testFormatOperation_importTable() {
		final String TARGET_TRUNC_STRING = "Tabelle1";

		final String TARGET_SUFFIX_STRING = ".odt";
		final String TEST_NAME = "_OUT.odt";
		final String ADD_TEXT_STYLES = "[{\"name\":\"insertText\",\"text\":\"N\",\"start\":[0,0]},{\"name\":\"insertText\",\"text\":\"e\",\"start\":[0,1]},{\"name\":\"insertText\",\"text\":\"i\",\"start\":[0,2]},{\"name\":\"insertText\",\"text\":\"n\",\"start\":[0,3]},{\"name\":\"insertText\",\"text\":\" \",\"start\":[0,4]},{\"name\":\"insertText\",\"text\":\"e\",\"start\":[0,5]},{\"name\":\"insertText\",\"text\":\"r\",\"start\":[0,6]},{\"name\":\"insertText\",\"text\":\"s\",\"start\":[0,7]},{\"name\":\"insertText\",\"text\":\"t\",\"start\":[0,8]},{\"name\":\"insertText\",\"text\":\"e\",\"start\":[0,9]},{\"name\":\"insertText\",\"text\":\"r\",\"start\":[0,10]},{\"name\":\"insertText\",\"text\":\" \",\"start\":[0,11]},{\"name\":\"insertText\",\"text\":\"H\",\"start\":[0,12]},{\"name\":\"insertText\",\"text\":\"e\",\"start\":[0,13]},{\"name\":\"insertText\",\"text\":\"a\",\"start\":[0,14]},{\"name\":\"insertText\",\"text\":\"d\",\"start\":[0,15]},{\"name\":\"insertText\",\"text\":\"i\",\"start\":[0,16]},{\"name\":\"insertText\",\"text\":\"n\",\"start\":[0,17]},{\"name\":\"insertText\",\"text\":\"g\",\"start\":[0,18]},"
				+ "{\"name\":\"insertStyleSheet\",\"attrs\":{\"character\":{\"color\":{\"type\":\"scheme\",\"value\":\"accent1\",\"transformations\":[{\"type\":\"shade\",\"value\":74902}],\"fallbackValue\":\"376092\"},\"bold\":true,\"fontSize\":14},\"paragraph\":{\"outlineLevel\":0},\"next\":\"Normal\"},\"type\":\"paragraph\",\"styleId\":\"heading 1\",\"styleName\":\"Heading 1\",\"parent\":\"Normal\",\"uiPriority\":9},"
				+ "{\"name\":\"setAttributes\",\"start\":[0],\"attrs\":{\"paragraph\":{\"alignment\":null,\"fillColor\":null,\"lineHeight\":null,\"indentLevel\":null,\"numId\":null,\"outlineLevel\":null,\"tabStops\":null,\"borderLeft\":null,\"borderRight\":null,\"borderTop\":null,\"borderBottom\":null,\"borderInside\":null,\"indentFirstLine\":null,\"indentLeft\":null,\"indentRight\":null,\"marginTop\":null,\"marginBottom\":null,\"contextualSpacing\":null,\"style\":\"heading 1\"},\"character\":{\"fontName\":null,\"fontSize\":null,\"bold\":null,\"italic\":null,\"underline\":null,\"strike\":null,\"vertAlign\":null,\"color\":null,\"fillColor\":null,\"language\":null,\"url\":null}}}"
				+ "{\"name\":\"deleteStyleSheet\",\"type\":\"text\",\"styleId\":\"DefaultParagraphFont\"}]";
		// WORKING REMOVAL OF STYLES: final String ADD_TEXT_STYLES = "[{\"name\":\"setAttributes\",\"start\":[1],\"end\":[1],\"attrs\":{\"paragraph\":{\"style\":\"Normal\"}}},{\"name\":\"splitParagraph\",\"start\":[1,4]},{\"name\":\"insertText\",\"text\":\"W\",\"start\":[2,0]},{\"name\":\"insertText\",\"text\":\"U\",\"start\":[2,1]},{\"name\":\"insertText\",\"text\":\"F\",\"start\":[2,2]},{\"name\":\"insertText\",\"text\":\"F\",\"start\":[2,3]},{\"name\":\"insertStyleSheet\",\"attrs\":{\"character\":{\"color\":{\"type\":\"scheme\",\"value\":\"accent1\",\"fallbackValue\":\"4F81BD\"},\"bold\":true,\"fontSize\":13},\"paragraph\":{\"outlineLevel\":1},\"next\":\"Normal\"},\"type\":\"paragraph\",\"styleId\":\"heading 2\",\"styleName\":\"Heading 2\",\"parent\":\"Normal\",\"uiPriority\":9}]";		
// final String ADD_TEXT_STYLES = "[{\"name\":\"setAttributes\",\"start\":[1],\"end\":[1],\"attrs\":{\"paragraph\":{\"style\":\"Normal\"}}},{\"name\":\"splitParagraph\",\"start\":[1,306]},{\"name\":\"setAttributes\",\"start\":[2],\"attrs\":{\"paragraph\":{}}},{\"name\":\"insertText\",\"text\":\"W\",\"start\":[2,0]},{\"name\":\"insertText\",\"text\":\"U\",\"start\":[2,1]},{\"name\":\"insertText\",\"text\":\"F\",\"start\":[2,2]},{\"name\":\"insertText\",\"text\":\"F\",\"start\":[2,3]},{\"name\":\"insertStyleSheet\",\"attrs\":{\"character\":{\"color\":{\"type\":\"scheme\",\"value\":\"accent1\",\"fallbackValue\":\"4F81BD\"},\"bold\":true,\"fontSize\":13},\"paragraph\":{\"outlineLevel\":1},\"next\":\"Normal\"},\"type\":\"paragraph\",\"styleId\":\"heading 2\",\"styleName\":\"Heading 2\",\"parent\":\"Normal\",\"uiPriority\":9},{\"name\":\"setAttributes\",\"start\":[2],\"attrs\":{\"paragraph\":{\"alignment\":null,\"fillColor\":null,\"lineHeight\":null,\"indentLevel\":null,\"numId\":null,\"outlineLevel\":null,\"tabStops\":null,\"borderLeft\":null,\"borderRight\":null,\"borderTop\":null,\"borderBottom\":null,\"borderInside\":null,\"indentFirstLine\":null,\"indentLeft\":null,\"indentRight\":null,\"marginTop\":null,\"marginBottom\":null,\"contextualSpacing\":null,\"style\":\"heading 2\"},\"character\":{\"fontName\":null,\"fontSize\":null,\"bold\":null,\"italic\":null,\"underline\":null,\"strike\":null,\"vertAlign\":null,\"color\":null,\"fillColor\":null,\"language\":null,\"url\":null}}}]";		
//		final String ADD_TEXT_STYLES = "[{\"name\":\"setAttributes\",\"start\":[2,0,2,0,0,0,0,2],\"attrs\":{\"character\":{\"bold\":true}},\"end\":[2,0,2,0,0,0,0,4]},{\"name\":\"setAttributes\",\"start\":[2,0,2,0,0,0,0,3],\"attrs\":{\"character\":{\"italic\":true}},\"end\":[2,0,2,0,0,0,0,5]},{\"name\":\"setAttributes\",\"start\":[1,39],\"attrs\":{\"character\":{\"underline\":true}},\"end\":[1,54]},{\"name\":\"setAttributes\",\"start\":[1,120],\"attrs\":{\"character\":{\"italic\":true}},\"end\":[1,129]},{\"name\":\"insertText\",\"text\":\"1\",\"start\":[1,4]}]";
		final String ADD_SMALL_TABLE_OPS = "[{\"name\":\"insertRows\",\"start\":[2,0,2,0,1],\"count\":1,\"insertDefaultCells\":false,\"referenceRow\":0},{\"name\":\"insertParagraph\",\"start\":[2,0,2,0,1,0,0]},{\"name\":\"insertText\",\"text\":\"A\",\"start\":[2,0,2,0,1,0,0,0]},{\"name\":\"delete\",\"start\":[2,0,2,0,1,0,0,0],\"end\":[2,0,2,0,1,0,0,0]},{\"name\":\"delete\",\"start\":[2,0,2,0,1,0,0]},{\"name\":\"insertParagraph\",\"start\":[2,0,2,0,1,0,0]},{\"name\":\"insertText\",\"text\":\"ü\",\"start\":[2,0,2,0,1,0,0,0]},{\"name\":\"insertText\",\"text\":\"Svante2\",\"start\":[0,0]}]";
//final String ADD_SMALL_TABLE_OPS = "[{\"name\":\"insertRows\",\"start\":[2,0,2,0,1],\"count\":1,\"insertDefaultCells\":false,\"referenceRow\":0},{\"name\":\"insertParagraph\",\"start\":[2,0,2,0,1,0,0]},{\"name\":\"insertText\",\"text\":\"A\",\"start\":[2,0,2,0,1,0,0,0]},{\"name\":\"insertText\",\"text\":\"Svante3\",\"start\":[0,0]}]";
//final String ADD_SMALL_TABLE_OPS = "[{\"name\":\"insertText\",\"text\":\"Svante1\",\"start\":[0,0]}]";
// SMALLER				final String ADD_SMALL_TABLE_OPS = "[{\"name\":\"insertRows\",\"start\":[2,0,2,0,1],\"count\":1,\"insertDefaultCells\":false,\"referenceRow\":0}]";
		// Text insertion operations to add the text "Svante"
		//final String ADD_SVANTE_OPS = "[{\"start\":[1,0],\"name\":\"insertText\",\"text\":\"S\"},{\"start\":[1,1],\"name\":\"insertText\",\"text\":\"v\"},{\"start\":[1,2],\"name\":\"insertText\",\"text\":\"a\"},{\"start\":[1,3],\"name\":\"insertText\",\"text\":\"n\"},{\"start\":[1,4],\"name\":\"insertText\",\"text\":\"t\"},{\"start\":[1,5],\"name\":\"insertText\",\"text\":\"e\"},{\"start\":[1,6],\"name\":\"insertText\",\"text\":\",\"},{\"start\":[1,7],\"name\":\"insertText\",\"text\":\" \"}]";		
//		final String ADD_SMALL_TABLE_OPS = "[{\"attrs\":{\"page\":[{\"marginLeft\":2499,\"marginRight\":2499,\"numberFormat\":\"1\",\"printOrientation\":\"portrait\",\"marginBottom\":2000,\"width\":21001,\"height\":29700,\"marginTop\":2499,\"writingMode\":\"lr-tb\"}]},\"name\":\"setDocumentAttributes\"},{\"attrs\":{\"table\":{\"marginLeft\":0,\"width\":5798,\"tableGrid\":[10,10,80]}},\"start\":[0],\"name\":\"insertTable\"},{\"start\":[0,0],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"fillColor\":{\"type\":\"rgb\",\"value\":\"0070c0\"},\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[0,0,0],\"name\":\"insertCells\"},{\"attrs\":{\"character\":{\"italic\":false,\"bold\":false,\"fillColor\":{\"type\":\"rgb\",\"value\":\"auto\"},\"underline\":false,\"fontName\":\"Calibri\",\"fontSize\":10,\"vertAlign\":\"0% 100%\"},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"padding\":0,\"fillColor\":{\"type\":\"rgb\",\"value\":\"auto\"},\"border\":{\"style\":\"none\"},\"writingMode\":\"lr-tb\"}},\"type\":\"paragraph\",\"name\":\"insertStyleSheet\",\"styleId\":\"default_paragraph_style\"},{\"attrs\":{\"character\":{\"fontSize\":11},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"115\"},\"marginBottom\":357,\"marginTop\":0}},\"type\":\"paragraph\",\"name\":\"insertStyleSheet\",\"default\":true,\"parent\":\"default_paragraph_style\",\"styleId\":\"Normal3\"},{\"attrs\":{},\"type\":\"paragraph\",\"name\":\"insertStyleSheet\",\"parent\":\"Normal3\",\"styleId\":\"Normal2\"},{\"attrs\":{},\"type\":\"paragraph\",\"name\":\"insertStyleSheet\",\"parent\":\"Normal2\",\"styleId\":\"Normal1\"},{\"attrs\":{\"character\":{\"fontSize\":11},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"115\"},\"marginBottom\":356,\"marginTop\":0}},\"type\":\"paragraph\",\"name\":\"insertStyleSheet\",\"parent\":\"Normal1\",\"styleId\":\"Normal\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\",\"marginTop\":0}},\"start\":[0,0,0,0],\"name\":\"insertParagraph\"},{\"start\":[0,0,0,0,0],\"name\":\"insertText\",\"text\":\"A1\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\",\"fillColor\":{\"type\":\"rgb\",\"value\":\"00b050\"},\"marginTop\":0}},\"start\":[0,0,0,1],\"name\":\"insertParagraph\"},{\"start\":[0,0,0,1,0],\"name\":\"insertText\",\"text\":\"B1\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"fillColor\":{\"type\":\"rgb\",\"value\":\"ff0000\"},\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[0,0,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\",\"marginTop\":0}},\"start\":[0,0,1,0],\"name\":\"insertParagraph\"},{\"start\":[0,0,1,0,0],\"name\":\"insertText\",\"text\":\"A2\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\",\"marginTop\":0}},\"start\":[0,0,1,1],\"name\":\"insertParagraph\"},{\"start\":[0,0,1,1,0],\"name\":\"insertText\",\"text\":\"B2\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"fillColor\":{\"type\":\"rgb\",\"value\":\"ff0000\"},\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[0,0,2],\"name\":\"insertCells\"},{\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"ffc000\"}},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\",\"marginTop\":0}},\"start\":[0,0,2,0],\"name\":\"insertParagraph\"},{\"start\":[0,0,2,0,0],\"name\":\"insertText\",\"text\":\"A3\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\",\"marginTop\":0}},\"start\":[0,0,2,1],\"name\":\"insertParagraph\"},{\"start\":[0,0,2,1,0],\"name\":\"insertText\",\"text\":\"        \"},{\"start\":[0,0,2,1,8],\"name\":\"insertText\",\"text\":\"         \"},{\"start\":[0,0,2,1,17],\"name\":\"insertText\",\"text\":\"B3\"},{\"start\":[0,0,2,1,19],\"name\":\"insertText\",\"text\":\"        \"},{\"start\":[0,0,2,1,27],\"name\":\"insertText\",\"text\":\"       \"},{\"attrs\":{},\"type\":\"character\",\"name\":\"insertStyleSheet\",\"styleName\":\"Default Paragraph Font\",\"default\":true,\"parent\":\"default_character_style\",\"styleId\":\"Default_20_Paragraph_20_Font\"},{\"attrs\":{},\"start\":[0,0,2,1,8],\"name\":\"setAttributes\",\"end\":[0,0,2,1,26]},{\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"ffc000\"}}},\"start\":[0,0,2,1,17],\"name\":\"setAttributes\",\"end\":[0,0,2,1,18]},{\"attrs\":{\"paragraph\":{\"style\":\"Normal\"}},\"start\":[1],\"name\":\"insertParagraph\"}]";
		//final String ADD_TABLE_OPS = "[{\"attrs\":{\"character\":{\"italic\":false,\"bold\":false,\"fillColor\":{\"type\":\"rgb\",\"value\":\"auto\"},\"fontName\":\"Calibri\",\"fontSize\":11},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"115\"},\"marginBottom\":353,\"padding\":0,\"fillColor\":{\"type\":\"rgb\",\"value\":\"auto\"},\"border\":{\"style\":\"none\"},\"writingMode\":\"lr-tb\"}},\"type\":\"paragraph\",\"name\":\"insertStyleSheet\",\"styleId\":\"default_paragraph_style\"},{\"attrs\":{\"paragraph\":{\"style\":\"Normal\"}},\"start\":[0],\"name\":\"insertParagraph\"},{\"attrs\":{\"paragraph\":{\"style\":\"Normal\"}},\"start\":[1],\"name\":\"insertParagraph\"},{\"start\":[1,0],\"name\":\"insertText\",\"text\":\"Zank, Gezeter, Klientelpolitik: Die griechische Regierung hat nun zwar ein Sparpaket verabscheidet. Dennoch gibt sie ein katastrophales Bild ab. Beinahe hat sie sich in den Verhandlungen um das 11,5-Milliarden-Euro-Paket wieder zerlegt. Griechenland ist kurz davor, auch seine zweite Chance zu verspielen.\"},{\"attrs\":{\"table\":{\"marginLeft\":0,\"width\":16249,\"tableGrid\":[33,33,33]}},\"start\":[2],\"name\":\"insertTable\"},{\"start\":[2,0],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,0,0],\"name\":\"insertCells\"},{\"attrs\":{\"table\":{\"marginLeft\":0,\"width\":5008,\"tableGrid\":[50,50]}},\"start\":[2,0,0,0],\"name\":\"insertTable\"},{\"start\":[2,0,0,0,0],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,0,0,0,0,0],\"name\":\"insertCells\"},{\"attrs\":{\"character\":{\"bold\":true},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,0,0,0,0,0,0],\"name\":\"insertParagraph\"},{\"start\":[2,0,0,0,0,0,0,0],\"name\":\"insertText\",\"text\":\"Text\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,0,0,0,0,1],\"name\":\"insertCells\"},{\"attrs\":{\"character\":{\"italic\":true},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,0,0,0,0,1,0],\"name\":\"insertParagraph\"},{\"start\":[2,0,0,0,0,1,0,0],\"name\":\"insertText\",\"text\":\"Text\"},{\"start\":[2,0,0,0,1],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,0,0,0,1,0],\"name\":\"insertCells\"},{\"attrs\":{\"character\":{\"underline\":true},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,0,0,0,1,0,0],\"name\":\"insertParagraph\"},{\"start\":[2,0,0,0,1,0,0,0],\"name\":\"insertText\",\"text\":\"Text\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,0,0,0,1,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,0,0,0,1,1,0],\"name\":\"insertParagraph\"},{\"start\":[2,0,0,0,1,1,0,0],\"name\":\"insertText\",\"text\":\"Text\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,0,0,1],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,0,1],\"name\":\"insertCells\"},{\"attrs\":{\"character\":{\"fontName\":\"Times New Roman\",\"fontSize\":12},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":176,\"marginTop\":176}},\"type\":\"paragraph\",\"name\":\"insertStyleSheet\",\"styleName\":\"Normal (Web)\",\"default\":true,\"parent\":\"default_paragraph_style\",\"styleId\":\"NormalWeb\"},{\"attrs\":{\"paragraph\":{\"style\":\"NormalWeb\"}},\"start\":[2,0,1,0],\"name\":\"insertParagraph\"},{\"start\":[2,0,1,0,0],\"name\":\"insertText\",\"text\":\"Dass der eher eindimensionale Nationalstürmertyp Gomez den früheren\"},{\"start\":[2,0,1,0,67],\"name\":\"insertText\",\"text\":\" \"},{\"start\":[2,0,1,0,68],\"name\":\"insertText\",\"text\":\"Nationalstürmer\"},{\"start\":[2,0,1,0,83],\"name\":\"insertText\",\"text\":\" \"},{\"start\":[2,0,1,0,84],\"name\":\"insertText\",\"text\":\"Hoeneß nicht grenzenlos begeistert, das hatte der Klubpatron schon Frühjahr geäußert, als Meister\"},{\"start\":[2,0,1,0,181],\"name\":\"insertText\",\"text\":\" \"},{\"start\":[2,0,1,0,182],\"name\":\"insertText\",\"text\":\"Dortmund\"},{\"start\":[2,0,1,0,190],\"name\":\"insertText\",\"text\":\" \"},{\"start\":[2,0,1,0,191],\"name\":\"insertText\",\"text\":\"davonzog. Gomez bewege sich zu wenig, kritisierte Hoeneß - eine Ansicht, die der mit ihm freundschaftlich verbundene\"},{\"start\":[2,0,1,0,307],\"name\":\"insertText\",\"text\":\" \"},{\"start\":[2,0,1,0,308],\"name\":\"insertText\",\"text\":\"Amateur-Trainer\"},{\"start\":[2,0,1,0,323],\"name\":\"insertText\",\"text\":\" \"},{\"start\":[2,0,1,0,324],\"name\":\"insertText\",\"text\":\"Mehmet Scholl während der EM als TV-Experte (\"wundgelegen\") praktischerweise zuspitzte. Die neue Debatte begann nun am Wochenende, als Hoeneß, wie er selbst sagt, \"in einem\"},{\"start\":[2,0,1,0,496],\"name\":\"insertText\",\"text\":\" \"},{\"start\":[2,0,1,0,497],\"name\":\"insertText\",\"text\":\"Bierzelt\"},{\"start\":[2,0,1,0,505],\"name\":\"insertText\",\"text\":\" \"},{\"start\":[2,0,1,0,506],\"name\":\"insertText\",\"text\":\"bei einem Fantreffen im bayerischen Wald\" über Gomez urteilte, dieser sei \"gut, aber nicht sehr gut\". Tags darauf hat der Präsident zielsicher nachgelegt, als er Gomez die Niederlage gegen Chelsea \"},{\"start\":[2,0,1,0,703],\"name\":\"insertText\",\"text\":\"zuschanzte\"},{\"attrs\":{\"character\":{\"italic\":true,\"bold\":true}},\"start\":[2,0,1,0,68],\"name\":\"setAttributes\",\"end\":[2,0,1,0,82]},{\"attrs\":{\"character\":{\"bold\":true,\"underline\":true}},\"start\":[2,0,1,0,308],\"name\":\"setAttributes\",\"end\":[2,0,1,0,322]},{\"attrs\":{\"character\":{\"italic\":true,\"underline\":true}},\"start\":[2,0,1,0,497],\"name\":\"setAttributes\",\"end\":[2,0,1,0,504]},{\"attrs\":{},\"start\":[2,0,1,0,703],\"name\":\"setAttributes\",\"end\":[2,0,1,0,712]},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,0,1,1],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,0,2],\"name\":\"insertCells\"},{\"attrs\":{\"table\":{\"marginLeft\":0,\"width\":5018,\"tableGrid\":[20,24,37,20]}},\"start\":[2,0,2,0],\"name\":\"insertTable\"},{\"start\":[2,0,2,0,0],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,0,2,0,0,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,0,2,0,0,0,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,0,2,0,0,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,0,2,0,0,1,0],\"name\":\"insertParagraph\"},{\"start\":[2,0,2,0,0,1,0,0],\"name\":\"insertText\",\"text\":\"Text\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,0,2,0,0,2],\"name\":\"insertCells\"},{\"attrs\":{\"table\":{\"marginLeft\":0,\"width\":1469,\"tableGrid\":[73,27]}},\"start\":[2,0,2,0,0,2,0],\"name\":\"insertTable\"},{\"start\":[2,0,2,0,0,2,0,0],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,0,2,0,0,2,0,0,0],\"name\":\"insertCells\"},{\"attrs\":{\"character\":{\"italic\":true,\"bold\":true,\"underline\":true},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,0,2,0,0,2,0,0,0,0],\"name\":\"insertParagraph\"},{\"start\":[2,0,2,0,0,2,0,0,0,0,0],\"name\":\"insertText\",\"text\":\"Text\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,0,2,0,0,2,0,0,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,0,2,0,0,2,0,0,1,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,0,2,0,0,2,1],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,0,2,0,0,3],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,0,2,0,0,3,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,0,2,1],\"name\":\"insertParagraph\"},{\"start\":[2,1],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,1,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,1,0,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,1,1],\"name\":\"insertCells\"},{\"attrs\":{\"table\":{\"marginLeft\":0,\"width\":5009,\"tableGrid\":[33,33,33]}},\"start\":[2,1,1,0],\"name\":\"insertTable\"},{\"start\":[2,1,1,0,0],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,1,1,0,0,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,1,1,0,0,0,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,1,1,0,0,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,1,1,0,0,1,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,1,1,0,0,2],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,1,1,0,0,2,0],\"name\":\"insertParagraph\"},{\"start\":[2,1,1,0,1],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,1,1,0,1,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,1,1,0,1,0,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,1,1,0,1,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,1,1,0,1,1,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,1,1,0,1,2],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,1,1,0,1,2,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,1,1,1],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,1,2],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,1,2,0],\"name\":\"insertParagraph\"},{\"start\":[2,2],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,0],\"name\":\"insertCells\"},{\"attrs\":{\"table\":{\"marginLeft\":0,\"width\":5008,\"tableGrid\":[100]}},\"start\":[2,2,0,0],\"name\":\"insertTable\"},{\"start\":[2,2,0,0,0],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,0,0,0,0],\"name\":\"insertCells\"},{\"attrs\":{\"character\":{\"underline\":true},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,0,0,0,0,0],\"name\":\"insertParagraph\"},{\"start\":[2,2,0,0,0,0,0,0],\"name\":\"insertText\",\"text\":\"Gomez bewege sich zu wenig\"},{\"start\":[2,2,0,0,1],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,0,0,1,0],\"name\":\"insertCells\"},{\"attrs\":{\"character\":{\"underline\":true},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,0,0,1,0,0],\"name\":\"insertParagraph\"},{\"start\":[2,2,0,0,1,0,0,0],\"name\":\"insertText\",\"text\":\"Gomez bewege sich zu wenig\"},{\"start\":[2,2,0,0,2],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,0,0,2,0],\"name\":\"insertCells\"},{\"attrs\":{\"character\":{\"underline\":true},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,0,0,2,0,0],\"name\":\"insertParagraph\"},{\"start\":[2,2,0,0,2,0,0,0],\"name\":\"insertText\",\"text\":\"Gomez bewege sich zu wenig\"},{\"start\":[2,2,0,0,3],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,0,0,3,0],\"name\":\"insertCells\"},{\"attrs\":{\"character\":{\"bold\":true,\"underline\":true},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,0,0,3,0,0],\"name\":\"insertParagraph\"},{\"start\":[2,2,0,0,3,0,0,0],\"name\":\"insertText\",\"text\":\"Gomez bewege sich zu wenig\"},{\"start\":[2,2,0,0,4],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,0,0,4,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,0,0,4,0,0],\"name\":\"insertParagraph\"},{\"start\":[2,2,0,0,4,0,0,0],\"name\":\"insertText\",\"text\":\"Gomez bewege sich zu wenig\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,0,1],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,1],\"name\":\"insertCells\"},{\"attrs\":{\"table\":{\"marginLeft\":0,\"width\":5009,\"tableGrid\":[100]}},\"start\":[2,2,1,0],\"name\":\"insertTable\"},{\"start\":[2,2,1,0,0],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,1,0,0,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,1,0,0,0,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,1,1],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2],\"name\":\"insertCells\"},{\"attrs\":{\"table\":{\"marginLeft\":0,\"width\":5009,\"tableGrid\":[20,20,20,20,20]}},\"start\":[2,2,2,0],\"name\":\"insertTable\"},{\"start\":[2,2,2,0,0],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,0,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,0,0,0],\"name\":\"insertParagraph\"},{\"start\":[2,2,2,0,0,0,0,0],\"name\":\"insertText\",\"text\":\"1\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,0,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,0,1,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,0,2],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,0,2,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,0,3],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,0,3,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,0,4],\"name\":\"insertCells\"},{\"attrs\":{\"character\":{\"bold\":true},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,0,4,0],\"name\":\"insertParagraph\"},{\"start\":[2,2,2,0,0,4,0,0],\"name\":\"insertText\",\"text\":\"5\"},{\"start\":[2,2,2,0,1],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,1,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,1,0,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,1,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,1,1,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,1,2],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,1,2,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,1,3],\"name\":\"insertCells\"},{\"attrs\":{\"character\":{\"bold\":true},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,1,3,0],\"name\":\"insertParagraph\"},{\"start\":[2,2,2,0,1,3,0,0],\"name\":\"insertText\",\"text\":\"4\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,1,4],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,1,4,0],\"name\":\"insertParagraph\"},{\"start\":[2,2,2,0,2],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,2,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,2,0,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,2,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,2,1,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,2,2],\"name\":\"insertCells\"},{\"attrs\":{\"character\":{\"bold\":true},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,2,2,0],\"name\":\"insertParagraph\"},{\"start\":[2,2,2,0,2,2,0,0],\"name\":\"insertText\",\"text\":\"3\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,2,3],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,2,3,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,2,4],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,2,4,0],\"name\":\"insertParagraph\"},{\"start\":[2,2,2,0,3],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,3,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,3,0,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,3,1],\"name\":\"insertCells\"},{\"attrs\":{\"character\":{\"bold\":true},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,3,1,0],\"name\":\"insertParagraph\"},{\"start\":[2,2,2,0,3,1,0,0],\"name\":\"insertText\",\"text\":\"2\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,3,2],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,3,2,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,3,3],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,3,3,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,3,4],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,3,4,0],\"name\":\"insertParagraph\"},{\"start\":[2,2,2,0,4],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,4,0],\"name\":\"insertCells\"},{\"attrs\":{\"character\":{\"bold\":true},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,4,0,0],\"name\":\"insertParagraph\"},{\"start\":[2,2,2,0,4,0,0,0],\"name\":\"insertText\",\"text\":\"1\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,4,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,4,1,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,4,2],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,4,2,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,4,3],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,4,3,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,2,2,0,4,4],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,0,4,4,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,2,2,1],\"name\":\"insertParagraph\"},{\"start\":[2,3],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,0,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1],\"name\":\"insertCells\"},{\"attrs\":{\"table\":{\"marginLeft\":0,\"width\":5018,\"tableGrid\":[10,10,10,10,10,10,10,10,10,10]}},\"start\":[2,3,1,0],\"name\":\"insertTable\"},{\"start\":[2,3,1,0,0],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,0,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,0,0,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,0,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,0,1,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,0,2],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,0,2,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,0,3],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,0,3,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,0,4],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,0,4,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,0,5],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,0,5,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,0,6],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,0,6,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,0,7],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,0,7,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,0,8],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,0,8,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,0,9],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,0,9,0],\"name\":\"insertParagraph\"},{\"start\":[2,3,1,0,1],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,1,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,1,0,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,1,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,1,1,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,1,2],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,1,2,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,1,3],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,1,3,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,1,4],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,1,4,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,1,5],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,1,5,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,1,6],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,1,6,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,1,7],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,1,7,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,1,8],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,1,8,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,1,9],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,1,9,0],\"name\":\"insertParagraph\"},{\"start\":[2,3,1,0,2],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,2,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,2,0,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,2,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,2,1,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,2,2],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,2,2,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,2,3],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,2,3,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,2,4],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,2,4,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,2,5],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,2,5,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,2,6],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,2,6,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,2,7],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,2,7,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,2,8],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,2,8,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,2,9],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,2,9,0],\"name\":\"insertParagraph\"},{\"start\":[2,3,1,0,3],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,3,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,3,0,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,3,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,3,1,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,3,2],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,3,2,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,3,3],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,3,3,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,3,4],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,3,4,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,3,5],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,3,5,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,3,6],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,3,6,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,3,7],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,3,7,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,3,8],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,3,8,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,3,9],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,3,9,0],\"name\":\"insertParagraph\"},{\"start\":[2,3,1,0,4],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,4,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,4,0,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,4,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,4,1,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,4,2],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,4,2,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,4,3],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,4,3,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,4,4],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,4,4,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,4,5],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,4,5,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,4,6],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,4,6,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,4,7],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,4,7,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,4,8],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,4,8,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,4,9],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,4,9,0],\"name\":\"insertParagraph\"},{\"start\":[2,3,1,0,5],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,5,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,5,0,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,5,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,5,1,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,5,2],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,5,2,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,5,3],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,5,3,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,5,4],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,5,4,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,5,5],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,5,5,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,5,6],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,5,6,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,5,7],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,5,7,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,5,8],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,5,8,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,5,9],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,5,9,0],\"name\":\"insertParagraph\"},{\"start\":[2,3,1,0,6],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,6,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,6,0,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,6,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,6,1,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,6,2],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,6,2,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,6,3],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,6,3,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,6,4],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,6,4,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,6,5],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,6,5,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,6,6],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,6,6,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,6,7],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,6,7,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,6,8],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,6,8,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,6,9],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,6,9,0],\"name\":\"insertParagraph\"},{\"start\":[2,3,1,0,7],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,7,0],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,7,0,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,7,1],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,7,1,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,7,2],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,7,2,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,7,3],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,7,3,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,7,4],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,7,4,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,7,5],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,7,5,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,7,6],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,7,6,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,7,7],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,7,7,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,7,8],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,7,8,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,1,0,7,9],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,0,7,9,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,1,1],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"paddingTop\":0,\"paddingLeft\":191,\"paddingBottom\":0,\"border\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"style\":\"solid\",\"width\":18},\"paddingRight\":191,\"writingMode\":\"lr-tb\"}},\"start\":[2,3,2],\"name\":\"insertCells\"},{\"attrs\":{\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":\"100\"},\"marginBottom\":0,\"style\":\"Normal\"}},\"start\":[2,3,2,0],\"name\":\"insertParagraph\"},{\"attrs\":{\"paragraph\":{\"style\":\"Normal\"}},\"start\":[3],\"name\":\"insertParagraph\"},{\"attrs\":{\"paragraph\":{\"style\":\"Normal\"}},\"start\":[4],\"name\":\"insertParagraph\"},{\"start\":[4,0],\"name\":\"insertText\",\"text\":\"Die genauen Gründe für den grußlosen Abschied von Sportdirektor Christian Nerlinger beim FC Bayern werden wohl unter Verschluss bleiben, \"nicht ein schlechtes Wort\" werde es \"über den Christian geben\", das hatte ja Präsident\"},{\"start\":[4,224],\"name\":\"insertText\",\"text\":\" \"},{\"start\":[4,225],\"name\":\"insertText\",\"text\":\"Uli Hoeneß\"},{\"start\":[4,235],\"name\":\"insertText\",\"text\":\" \"},{\"start\":[4,236],\"name\":\"insertText\",\"text\":\"bei der Präsentation des neuen Sportvorstands Matthias Sammer vor knapp einem Monat verfügt.\"},{\"attrs\":{\"paragraph\":{\"style\":\"Normal\"}},\"start\":[5],\"name\":\"insertParagraph\"},{\"attrs\":{\"paragraph\":{\"style\":\"NormalWeb\"}},\"start\":[6],\"name\":\"insertParagraph\"},{\"start\":[6,0],\"name\":\"insertText\",\"text\":\"Unabhängig von diversen Nachlässigkeiten, die Sammers Vorgänger angelastet wurden, hat vielleicht auch einfach jemand schuld sein müssen an zwei Spielzeiten ohne Titel und an der größten sportlichen Enttäuschung, die Hoeneß zu verdauen hat: die Heimniederlage im Champions-League-Finale gegen Chelsea. Inzwischen hat man aber den Eindruck, mit einem einzigen Schuldigen sei es nicht getan im Königlich Bayerischen Amtsgericht.\"},{\"start\":[6,426],\"name\":\"insertText\",\"text\":\" \"},{\"start\":[6,427],\"name\":\"insertText\",\"text\":\"Mario Gomez, 27, dürfte diesen Eindruck jedenfalls haben. Über ihn hat Hoeneß zu Wochenbeginn gesagt: \"Wenn er sehr gut wäre, wären wir jetzt Champions-League-Sieger.\"\"},{\"attrs\":{\"paragraph\":{\"style\":\"NormalWeb\"}},\"start\":[7],\"name\":\"insertParagraph\"},{\"start\":[7,0],\"name\":\"insertText\",\"text\":\"Hoeneß, 60, sagt, was er denkt, anders als die meisten im selten authentischen Fußballbetrieb. Dass er einen seiner Profis aber öffentlich und fortgesetzt kritisiert, ist ungewöhnlich. Weil sich die Frage stellt, wieso er das Kapital des Klubs schwächt und nebenbei das Gemüt des Profis, der mit den Zukäufen Mario Mandzukic und Claudio Pizarro schon genug Misstrauen ausgesprochen bekam - trotz 41 Pflichtspieltoren in der Vorsaison, darunter 17 Mal der jeweils erste Münchner Treffer.\"},{\"attrs\":{\"paragraph\":{\"style\":\"Normal\"}},\"start\":[8],\"name\":\"insertParagraph\"}]";
//		final String TARGET_TRUNC_STRING = "table_1x3_paragraph_background-MSO2013-LO3_6";
// PARA TOO MUCH -->		final String ADD_TABLE_OPS = "[{\"start\":[2,0],\"name\":\"insertText\",\"text\":\"http://192.168.0.240/ox7\"},{\"start\":[2],\"name\":\"mergeParagraph\"},{\"start\":[2,0],\"name\":\"deleteText\",\"end\":[2,23]},{\"start\":[1],\"name\":\"mergeParagraph\"},{\"start\":[1,0],\"name\":\"insertText\",\"text\":\"http://192.168.0.240/ox7\"},{\"start\":[1,0],\"name\":\"deleteText\",\"end\":[1,23]},{\"start\":[1,0],\"name\":\"insertText\",\"text\":\"http://192.168.0.240/ox7\"},{\"start\":[1,0],\"name\":\"deleteText\",\"end\":[1,23]},{\"start\":[0],\"name\":\"insertParagraph\"},{\"start\":[2,0],\"name\":\"insertText\",\"text\":\"http://192.168.0.240/ox7\"},{\"start\":[2,0],\"name\":\"deleteText\",\"end\":[2,23]},{\"start\":[2,0],\"name\":\"splitParagraph\"},{\"start\":[3],\"attrs\":{\"paragraph\":{}},\"name\":\"setAttributes\"},{\"start\":[3,0],\"name\":\"splitParagraph\"},{\"start\":[3],\"attrs\":{\"character\":{\"color\":null,\"italic\":null,\"language\":null,\"url\":null,\"bold\":null,\"style\":null,\"underline\":null,\"fillColor\":null,\"fontName\":null,\"fontSize\":null},\"paragraph\":{\"lineHeight\":null,\"indentLevel\":null,\"outlineLevel\":null,\"numId\":null,\"indentRight\":null,\"borderRight\":null,\"contextualSpacing\":null,\"tabStops\":null,\"alignment\":null,\"indentLeft\":null,\"indentFirstLine\":null,\"borderLeft\":null,\"borderBottom\":null,\"marginBottom\":null,\"borderTop\":null,\"fillColor\":null,\"style\":null,\"marginTop\":null,\"borderInside\":null}},\"name\":\"setAttributes\"},{\"attrs\":{\"table\":{\"width\":5798,\"tableGrid\":[10,10,80]}},\"start\":[4],\"name\":\"insertTable\"},{\"start\":[4,0],\"name\":\"insertRows\"},{\"attrs\":{\"cell\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"0070c0\"}}},\"start\":[4,0,0],\"name\":\"insertCells\",\"count\":1},{\"start\":[4,0,0,0],\"attrs\":{\"character\":{\"color\":null,\"italic\":null,\"language\":null,\"url\":null,\"bold\":null,\"style\":null,\"underline\":null,\"fillColor\":null,\"fontName\":null,\"fontSize\":null},\"paragraph\":{\"lineHeight\":null,\"indentLevel\":null,\"outlineLevel\":null,\"numId\":null,\"indentRight\":null,\"borderRight\":null,\"contextualSpacing\":null,\"tabStops\":null,\"alignment\":null,\"indentLeft\":null,\"indentFirstLine\":null,\"borderLeft\":null,\"borderBottom\":null,\"marginBottom\":null,\"borderTop\":null,\"fillColor\":null,\"style\":null,\"marginTop\":null,\"borderInside\":null}},\"name\":\"setAttributes\"},{\"start\":[4,0,0,0],\"attrs\":{\"paragraph\":{\"marginBottom\":0,\"marginTop\":0}},\"name\":\"setAttributes\"},{\"start\":[4,0,0,0,0],\"name\":\"insertText\",\"text\":\"A1\"},{\"attrs\":{\"paragraph\":{\"marginBottom\":0,\"fillColor\":{\"type\":\"rgb\",\"value\":\"00b050\"},\"marginTop\":0}},\"start\":[4,0,0,1],\"name\":\"insertParagraph\"},{\"start\":[4,0,0,1,0],\"name\":\"insertText\",\"text\":\"B1\"},{\"start\":[4,0,0,2],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"ff0000\"}}},\"start\":[4,0,1],\"name\":\"insertCells\",\"count\":1},{\"start\":[4,0,1,0],\"attrs\":{\"character\":{\"color\":null,\"italic\":null,\"language\":null,\"url\":null,\"bold\":null,\"style\":null,\"underline\":null,\"fillColor\":null,\"fontName\":null,\"fontSize\":null},\"paragraph\":{\"lineHeight\":null,\"indentLevel\":null,\"outlineLevel\":null,\"numId\":null,\"indentRight\":null,\"borderRight\":null,\"contextualSpacing\":null,\"tabStops\":null,\"alignment\":null,\"indentLeft\":null,\"indentFirstLine\":null,\"borderLeft\":null,\"borderBottom\":null,\"marginBottom\":null,\"borderTop\":null,\"fillColor\":null,\"style\":null,\"marginTop\":null,\"borderInside\":null}},\"name\":\"setAttributes\"},{\"start\":[4,0,1,0],\"attrs\":{\"paragraph\":{\"marginBottom\":0,\"marginTop\":0}},\"name\":\"setAttributes\"},{\"start\":[4,0,1,0,0],\"name\":\"insertText\",\"text\":\"A2\"},{\"attrs\":{\"paragraph\":{\"marginBottom\":0,\"marginTop\":0}},\"start\":[4,0,1,1],\"name\":\"insertParagraph\"},{\"start\":[4,0,1,1,0],\"name\":\"insertText\",\"text\":\"B2\"},{\"start\":[4,0,1,2],\"name\":\"insertParagraph\"},{\"attrs\":{\"cell\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"ff0000\"}}},\"start\":[4,0,2],\"name\":\"insertCells\",\"count\":1},{\"start\":[4,0,2,0],\"attrs\":{\"character\":{\"color\":null,\"italic\":null,\"language\":null,\"url\":null,\"bold\":null,\"style\":null,\"underline\":null,\"fillColor\":null,\"fontName\":null,\"fontSize\":null},\"paragraph\":{\"lineHeight\":null,\"indentLevel\":null,\"outlineLevel\":null,\"numId\":null,\"indentRight\":null,\"borderRight\":null,\"contextualSpacing\":null,\"tabStops\":null,\"alignment\":null,\"indentLeft\":null,\"indentFirstLine\":null,\"borderLeft\":null,\"borderBottom\":null,\"marginBottom\":null,\"borderTop\":null,\"fillColor\":null,\"style\":null,\"marginTop\":null,\"borderInside\":null}},\"name\":\"setAttributes\"},{\"start\":[4,0,2,0],\"attrs\":{\"paragraph\":{\"marginBottom\":0,\"marginTop\":0}},\"name\":\"setAttributes\"},{\"start\":[4,0,2,0,0],\"name\":\"insertText\",\"text\":\"A3\"},{\"attrs\":{\"paragraph\":{\"marginBottom\":0,\"marginTop\":0}},\"start\":[4,0,2,1],\"name\":\"insertParagraph\"},{\"start\":[4,0,2,1,0],\"name\":\"insertText\",\"text\":\"               \"},{\"start\":[4,0,2,1,8],\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"ffc000\"}}},\"name\":\"setAttributes\"},{\"start\":[4,0,2,2],\"name\":\"insertParagraph\"}]";

		//final String EXPECTED_TEXT = "0-Ntalic27-Bold-italic-underline51-Bold-underline68-Bold-italic-underline293-Bold100-Normal!!";
		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + TARGET_SUFFIX_STRING)));
//			System.out.println("doc.getDocument().getContentDom().toString() - BEFORE\n" + doc.getDocument().getContentDom().toString());

			//**********APPLY
			int opCount = doc.applyOperations(ADD_TEXT_STYLES);//int opCount = doc.applyOperations(ADD_SMALL_TABLE_OPS);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE		
			File testFile = ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + TEST_NAME);
//			System.out.println("doc.getDocument().getContentDom().toString() - AFTER\n" + doc.getDocument().getContentDom().toString());
			doc.getDocument().save(testFile);
			LOG.log(Level.INFO, "***Saved:\n\t{0}", testFile.getAbsolutePath());


		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void loadTable() {
		//final String TARGET_TRUNC_STRING = "MultiStyles(repaired document)-MSO2013";
		//final String TARGET_TRUNC_STRING = "MultiStylesSimple-MSO2013";
		// final String TARGET_TRUNC_STRING = "MultiStylesSimple_SingleLine-MSO2013";
		// final String TARGET_TRUNC_STRING = "text-color-from-paragraph";
		//final String TARGET_TRUNC_STRING = "crazy";

		final String TARGET_TRUNC_STRING = "OOStyledTable";
		//final String TARGET_TRUNC_STRING = "table_1x3_paragraph_background-MSO2013-LO3_6";
		// final String TARGET_TRUNC_STRING = "table_10x10_paragraph_background-MSO2013-LO3_6-mini";
		// final String TARGET_TRUNC_STRING = "table_10x10_paragraph-MS2013-LibreOffice3_6-columns";
		// final String TARGET_TRUNC_STRING = "table_10x10_paragraph-MS2013";
		//final String TARGET_TRUNC_STRING = "table-column-delete-with-merge-2-times";
		final String TARGET_SUFFIX_STRING = ".odt";
//      final String TEST_NAME = "_tableOps.odt";
//       final String MULTIPLE_PARA_DELETE_CROSS_PARA_1 = "[{\"name\":\"deleteParagraph\",\"start\":[3]},{\"name\":\"deleteParagraph\",\"start\":[3]},{\"name\":\"deleteText\",\"start\":[3,0],\"end\":[3,0]},{\"name\":\"mergeParagraph\",\"start\":[2]}]";
//final String MULTIPLE_PARA_DELETE_CROSS_PARA_1 = "[{\"name\":\"deleteParagraph\",\"start\":[3]}]";		
		//,{\"name\":\"deleteParagraph\",\"start\":[3]},{\"name\":\"deleteText\",\"start\":[3,0],\"end\":[3,0]},{\"name\":\"mergeParagraph\",\"start\":[2]}
//		final String MULTIPLE_PARA_DELETE_CROSS_PARA_2 = "[{\"name\":\"setAttribute\",\"attr\":\"italic\",\"value\":true,\"start\":[11,0],\"end\":[11,121]}]";
//		final String MULTIPLE_PARA_DELETE_CROSS_PARA_3 = "[{\"name\":\"setAttribute\",\"attr\":\"underline\",\"value\":true,\"start\":[11,0],\"end\":[11,121]}]";



		//final String EXPECTED_TEXT = "0-Ntalic27-Bold-italic-underline51-Bold-underline68-Bold-italic-underline293-Bold100-Normal!!";
		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + TARGET_SUFFIX_STRING)));

			JSONObject ops = doc.getOperations();
//			final String JSON_REFERENCE_OPERATIONS_BIBLE_SHORT = "{\"operations\":[{\"name\":\"initDocument\"},{\"start\":[0],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:1 Am Anfang schuf Gott Himmel und Erde.\",\"start\":[0,0],\"name\":\"insertText\"},{\"start\":[1],\"name\":\"insertParagraph\"},{\"start\":[2],\"name\":\"insertParagraph\"},{\"start\":[3],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:2 Und die Erde war wüst und leer, und es war finster auf der Tiefe; und der Geist Gottes schwebte auf dem Wasser.\",\"start\":[3,0],\"name\":\"insertText\"},{\"start\":[4],\"name\":\"insertParagraph\"},{\"start\":[5],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:3 Und Gott sprach: Es werde Licht! Und es ward Licht.\",\"start\":[5,0],\"name\":\"insertText\"},{\"start\":[6],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:4 Und Gott sah, daß das Licht gut war. Da schied Gott das Licht von der Finsternis \",\"start\":[6,0],\"name\":\"insertText\"},{\"start\":[7],\"name\":\"insertParagraph\"},{\"start\":[8],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:5 und nannte das Licht Tag und die Finsternis Nacht. Da ward aus Abend und Morgen der erste Tag.\",\"start\":[8,0],\"name\":\"insertText\"},{\"start\":[9],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:6 Und Gott sprach: Es werde eine Feste zwischen den Wassern, und die sei ein Unterschied zwischen den Wassern.\",\"start\":[9,0],\"name\":\"insertText\"},{\"start\":[10],\"name\":\"insertParagraph\"},{\"start\":[11],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:7 Da machte Gott die Feste und schied das Wasser unter der Feste von dem Wasser über der Feste. Und es geschah al\",\"start\":[11,0],\"name\":\"insertText\"},{\"text\":\"so\",\"start\":[11,119],\"name\":\"insertText\"},{\"text\":\".\",\"start\":[11,121],\"name\":\"insertText\"},{\"start\":[11,0],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"bold\",\"end\":[11,119]},{\"start\":[11,0],\"name\":\"setAttribute\",\"value\":true,\"attr\":\"italic\",\"end\":[11,119]},{\"start\":[11,0],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"underline\",\"end\":[11,119]},{\"start\":[11,119],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"bold\",\"end\":[11,121]},{\"start\":[11,119],\"name\":\"setAttribute\",\"value\":true,\"attr\":\"italic\",\"end\":[11,121]},{\"start\":[11,119],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"underline\",\"end\":[11,121]},{\"start\":[12],\"name\":\"insertParagraph\"},{\"start\":[13],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:8 Und Gott nannte die Feste Himmel. Da ward aus Abend und Morgen der andere Tag.\",\"start\":[13,0],\"name\":\"insertText\"},{\"start\":[14],\"name\":\"insertParagraph\"},{\"start\":[15],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:9 Und Gott sprach: Es sammle sich das Wasser unter dem Himmel an besondere Örter, daß man das Trockene sehe. Und es geschah also.\",\"start\":[15,0],\"name\":\"insertText\"},{\"start\":[16],\"name\":\"insertParagraph\"},{\"start\":[17],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:10 Und Gott nannte das Trockene Erde, und die Sammlung der Wasser nannte er Meer. Und Gott sah, daß es gut war.\",\"start\":[17,0],\"name\":\"insertText\"},{\"start\":[18],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:11 Und Gott sprach: Es lasse die Erde aufgehen Gras und Kraut, das sich besame, und fruchtbare Bäume, da ein jeglicher nach seiner Art Frucht trage und habe seinen eigenen Samen bei sich selbst auf Erden. Und es geschah also.\",\"start\":[18,0],\"name\":\"insertText\"},{\"start\":[19],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:12 Und die Erde ließ aufgehen Gras und Kraut, das sich besamte, ein jegliches nach seiner Art, und Bäume, die da Frucht trugen und ihren eigenen Samen bei sich selbst hatten, ein jeglicher nach seiner Art. Und Gott sah, daß es gut war.\",\"start\":[19,0],\"name\":\"insertText\"}]}";
//			if (!ops.toString().equals(JSON_REFERENCE_OPERATIONS_BIBLE_SHORT)) {
//				String error = "The opererations had been:\n" + ops.toString() + "\ninstead of the expected\n" + JSON_REFERENCE_OPERATIONS_BIBLE_SHORT;
//				LOG.severe(error);
//				Assert.fail(error);
//			}


//			
//			//**********APPLY
//			int opCount = doc.applyOperations(MULTIPLE_PARA_DELETE_CROSS_PARA_1);
//			LOG.log(Level.INFO, "opCount: {0}", opCount);
//
//			//**********SAVE			
//			doc.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + TEST_NAME));
//			LOG.info("***Saved:" + TARGET_TRUNC_STRING + TEST_NAME);

//
//			//**********LOAD
//			OdfOperationDocument doc2 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + TEST_NAME)));
//
//			//**********APPLY
//			int opCount2 = doc2.applyOperations(MULTIPLE_PARA_DELETE_CROSS_PARA_2);
//			LOG.log(Level.INFO, "opCount: {0}", opCount2);
//
//			//**********SAVE			
//			doc2.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + "2" + TEST_NAME));
//			LOG.info("***Saved:" + TARGET_TRUNC_STRING + "2" + TEST_NAME);
//
//
//			//**********LOAD
//			OdfOperationDocument doc3 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + "2" + TEST_NAME)));
//
//			//**********APPLY
//			int opCount3 = doc3.applyOperations(MULTIPLE_PARA_DELETE_CROSS_PARA_3);
//			LOG.log(Level.INFO, "opCount: {0}", opCount3);
//
//
//			//**********SAVE			
//			doc3.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + "3" + TEST_NAME));
//			LOG.info("***Saved:" + TARGET_TRUNC_STRING + "3" + TEST_NAME);
//
//
//			//**********TEST
//			OdfContentDom odfContent3 = doc3.getDocument().getContentDom();
//			NodeList lst3 = odfContent3.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
//			Node node3 = lst3.item(11);
//			String paragraphText3 = node3.getTextContent();
//
//			final String EXPECTED_TEXT = "Gen 1:7 Da machte Gott die Feste und schied das Wasser unter der Feste von dem Wasser über der Feste. Und es geschah also.";
//			Assert.assertTrue("The text was not concatenated correctly! It should be " + EXPECTED_TEXT + ", instead the text is '" + paragraphText3 + "'", paragraphText3.equals(EXPECTED_TEXT));			
//			JSONObject ops = doc3.getOperations();
//			final String JSON_REFERENCE_OPERATIONS_BIBLE_SHORT = "{\"operations\":[{\"name\":\"initDocument\"},{\"start\":[0],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:1 Am Anfang schuf Gott Himmel und Erde.\",\"start\":[0,0],\"name\":\"insertText\"},{\"start\":[1],\"name\":\"insertParagraph\"},{\"start\":[2],\"name\":\"insertParagraph\"},{\"start\":[3],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:2 Und die Erde war wüst und leer, und es war finster auf der Tiefe; und der Geist Gottes schwebte auf dem Wasser.\",\"start\":[3,0],\"name\":\"insertText\"},{\"start\":[4],\"name\":\"insertParagraph\"},{\"start\":[5],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:3 Und Gott sprach: Es werde Licht! Und es ward Licht.\",\"start\":[5,0],\"name\":\"insertText\"},{\"start\":[6],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:4 Und Gott sah, daß das Licht gut war. Da schied Gott das Licht von der Finsternis \",\"start\":[6,0],\"name\":\"insertText\"},{\"start\":[7],\"name\":\"insertParagraph\"},{\"start\":[8],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:5 und nannte das Licht Tag und die Finsternis Nacht. Da ward aus Abend und Morgen der erste Tag.\",\"start\":[8,0],\"name\":\"insertText\"},{\"start\":[9],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:6 Und Gott sprach: Es werde eine Feste zwischen den Wassern, und die sei ein Unterschied zwischen den Wassern.\",\"start\":[9,0],\"name\":\"insertText\"},{\"start\":[10],\"name\":\"insertParagraph\"},{\"start\":[11],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:7 Da machte Gott die Feste und schied das Wasser unter der Feste von dem Wasser über der Feste. Und es geschah al\",\"start\":[11,0],\"name\":\"insertText\"},{\"text\":\"so\",\"start\":[11,119],\"name\":\"insertText\"},{\"text\":\".\",\"start\":[11,121],\"name\":\"insertText\"},{\"start\":[11,0],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"bold\",\"end\":[11,119]},{\"start\":[11,0],\"name\":\"setAttribute\",\"value\":true,\"attr\":\"italic\",\"end\":[11,119]},{\"start\":[11,0],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"underline\",\"end\":[11,119]},{\"start\":[11,119],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"bold\",\"end\":[11,121]},{\"start\":[11,119],\"name\":\"setAttribute\",\"value\":true,\"attr\":\"italic\",\"end\":[11,121]},{\"start\":[11,119],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"underline\",\"end\":[11,121]},{\"start\":[12],\"name\":\"insertParagraph\"},{\"start\":[13],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:8 Und Gott nannte die Feste Himmel. Da ward aus Abend und Morgen der andere Tag.\",\"start\":[13,0],\"name\":\"insertText\"},{\"start\":[14],\"name\":\"insertParagraph\"},{\"start\":[15],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:9 Und Gott sprach: Es sammle sich das Wasser unter dem Himmel an besondere Örter, daß man das Trockene sehe. Und es geschah also.\",\"start\":[15,0],\"name\":\"insertText\"},{\"start\":[16],\"name\":\"insertParagraph\"},{\"start\":[17],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:10 Und Gott nannte das Trockene Erde, und die Sammlung der Wasser nannte er Meer. Und Gott sah, daß es gut war.\",\"start\":[17,0],\"name\":\"insertText\"},{\"start\":[18],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:11 Und Gott sprach: Es lasse die Erde aufgehen Gras und Kraut, das sich besame, und fruchtbare Bäume, da ein jeglicher nach seiner Art Frucht trage und habe seinen eigenen Samen bei sich selbst auf Erden. Und es geschah also.\",\"start\":[18,0],\"name\":\"insertText\"},{\"start\":[19],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:12 Und die Erde ließ aufgehen Gras und Kraut, das sich besamte, ein jegliches nach seiner Art, und Bäume, die da Frucht trugen und ihren eigenen Samen bei sich selbst hatten, ein jeglicher nach seiner Art. Und Gott sah, daß es gut war.\",\"start\":[19,0],\"name\":\"insertText\"}]}";
//			if (!ops.toString().equals(JSON_REFERENCE_OPERATIONS_BIBLE_SHORT)) {
//				String error = "The opererations had been:\n" + ops.toString() + "\ninstead of the expected\n" + JSON_REFERENCE_OPERATIONS_BIBLE_SHORT;
//				LOG.severe(error);
//				Assert.fail(error);
//			}


//			if(ops == null || ops.length() < 2){
//				Assert.fail("Not sufficient operations were received!");
//			}			

		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void testFormatOperation_DEMO_crossParagraphDelete() {
		final String TARGET_TRUNC_STRING = "bible_short";
		final String TARGET_SUFFIX_STRING = ".odt";
		final String TEST_NAME = "_DEMO_crossParagraphDelete.odt";

		final String MULTIPLE_PARA_DELETE_CROSS_PARA_1 = "[{\"name\":\"deleteParagraph\",\"start\":[3]},{\"name\":\"deleteParagraph\",\"start\":[3]},{\"name\":\"deleteText\",\"start\":[3,0],\"end\":[3,0]},{\"name\":\"mergeParagraph\",\"start\":[2]}]";
//final String MULTIPLE_PARA_DELETE_CROSS_PARA_1 = "[{\"name\":\"deleteParagraph\",\"start\":[3]}]";		
		//,{\"name\":\"deleteParagraph\",\"start\":[3]},{\"name\":\"deleteText\",\"start\":[3,0],\"end\":[3,0]},{\"name\":\"mergeParagraph\",\"start\":[2]}
//		final String MULTIPLE_PARA_DELETE_CROSS_PARA_2 = "[{\"name\":\"setAttribute\",\"attr\":\"italic\",\"value\":true,\"start\":[11,0],\"end\":[11,121]}]";
//		final String MULTIPLE_PARA_DELETE_CROSS_PARA_3 = "[{\"name\":\"setAttribute\",\"attr\":\"underline\",\"value\":true,\"start\":[11,0],\"end\":[11,121]}]";

		//final String EXPECTED_TEXT = "0-Ntalic27-Bold-italic-underline51-Bold-underline68-Bold-italic-underline293-Bold100-Normal!!";
		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + TARGET_SUFFIX_STRING)));

			//**********APPLY
			int opCount = doc.applyOperations(MULTIPLE_PARA_DELETE_CROSS_PARA_1);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE			
			doc.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + TEST_NAME));
			LOG.info("***Saved:" + TARGET_TRUNC_STRING + TEST_NAME);

//
//			//**********LOAD
//			OdfOperationDocument doc2 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + TEST_NAME)));
//
//			//**********APPLY
//			int opCount2 = doc2.applyOperations(MULTIPLE_PARA_DELETE_CROSS_PARA_2);
//			LOG.log(Level.INFO, "opCount: {0}", opCount2);
//
//			//**********SAVE			
//			doc2.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + "2" + TEST_NAME));
//			LOG.info("***Saved:" + TARGET_TRUNC_STRING + "2" + TEST_NAME);
//
//
//			//**********LOAD
//			OdfOperationDocument doc3 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + "2" + TEST_NAME)));
//
//			//**********APPLY
//			int opCount3 = doc3.applyOperations(MULTIPLE_PARA_DELETE_CROSS_PARA_3);
//			LOG.log(Level.INFO, "opCount: {0}", opCount3);
//
//
//			//**********SAVE			
//			doc3.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + "3" + TEST_NAME));
//			LOG.info("***Saved:" + TARGET_TRUNC_STRING + "3" + TEST_NAME);
//
//
//			//**********TEST
//			OdfContentDom odfContent3 = doc3.getDocument().getContentDom();
//			NodeList lst3 = odfContent3.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
//			Node node3 = lst3.item(11);
//			String paragraphText3 = node3.getTextContent();
//
//			final String EXPECTED_TEXT = "Gen 1:7 Da machte Gott die Feste und schied das Wasser unter der Feste von dem Wasser über der Feste. Und es geschah also.";
//			Assert.assertTrue("The text was not concatenated correctly! It should be " + EXPECTED_TEXT + ", instead the text is '" + paragraphText3 + "'", paragraphText3.equals(EXPECTED_TEXT));			
//			JSONObject ops = doc3.getOperations();
//			final String JSON_REFERENCE_OPERATIONS_BIBLE_SHORT = "{\"operations\":[{\"name\":\"initDocument\"},{\"start\":[0],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:1 Am Anfang schuf Gott Himmel und Erde.\",\"start\":[0,0],\"name\":\"insertText\"},{\"start\":[1],\"name\":\"insertParagraph\"},{\"start\":[2],\"name\":\"insertParagraph\"},{\"start\":[3],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:2 Und die Erde war wüst und leer, und es war finster auf der Tiefe; und der Geist Gottes schwebte auf dem Wasser.\",\"start\":[3,0],\"name\":\"insertText\"},{\"start\":[4],\"name\":\"insertParagraph\"},{\"start\":[5],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:3 Und Gott sprach: Es werde Licht! Und es ward Licht.\",\"start\":[5,0],\"name\":\"insertText\"},{\"start\":[6],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:4 Und Gott sah, daß das Licht gut war. Da schied Gott das Licht von der Finsternis \",\"start\":[6,0],\"name\":\"insertText\"},{\"start\":[7],\"name\":\"insertParagraph\"},{\"start\":[8],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:5 und nannte das Licht Tag und die Finsternis Nacht. Da ward aus Abend und Morgen der erste Tag.\",\"start\":[8,0],\"name\":\"insertText\"},{\"start\":[9],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:6 Und Gott sprach: Es werde eine Feste zwischen den Wassern, und die sei ein Unterschied zwischen den Wassern.\",\"start\":[9,0],\"name\":\"insertText\"},{\"start\":[10],\"name\":\"insertParagraph\"},{\"start\":[11],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:7 Da machte Gott die Feste und schied das Wasser unter der Feste von dem Wasser über der Feste. Und es geschah al\",\"start\":[11,0],\"name\":\"insertText\"},{\"text\":\"so\",\"start\":[11,119],\"name\":\"insertText\"},{\"text\":\".\",\"start\":[11,121],\"name\":\"insertText\"},{\"start\":[11,0],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"bold\",\"end\":[11,119]},{\"start\":[11,0],\"name\":\"setAttribute\",\"value\":true,\"attr\":\"italic\",\"end\":[11,119]},{\"start\":[11,0],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"underline\",\"end\":[11,119]},{\"start\":[11,119],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"bold\",\"end\":[11,121]},{\"start\":[11,119],\"name\":\"setAttribute\",\"value\":true,\"attr\":\"italic\",\"end\":[11,121]},{\"start\":[11,119],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"underline\",\"end\":[11,121]},{\"start\":[12],\"name\":\"insertParagraph\"},{\"start\":[13],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:8 Und Gott nannte die Feste Himmel. Da ward aus Abend und Morgen der andere Tag.\",\"start\":[13,0],\"name\":\"insertText\"},{\"start\":[14],\"name\":\"insertParagraph\"},{\"start\":[15],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:9 Und Gott sprach: Es sammle sich das Wasser unter dem Himmel an besondere Örter, daß man das Trockene sehe. Und es geschah also.\",\"start\":[15,0],\"name\":\"insertText\"},{\"start\":[16],\"name\":\"insertParagraph\"},{\"start\":[17],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:10 Und Gott nannte das Trockene Erde, und die Sammlung der Wasser nannte er Meer. Und Gott sah, daß es gut war.\",\"start\":[17,0],\"name\":\"insertText\"},{\"start\":[18],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:11 Und Gott sprach: Es lasse die Erde aufgehen Gras und Kraut, das sich besame, und fruchtbare Bäume, da ein jeglicher nach seiner Art Frucht trage und habe seinen eigenen Samen bei sich selbst auf Erden. Und es geschah also.\",\"start\":[18,0],\"name\":\"insertText\"},{\"start\":[19],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:12 Und die Erde ließ aufgehen Gras und Kraut, das sich besamte, ein jegliches nach seiner Art, und Bäume, die da Frucht trugen und ihren eigenen Samen bei sich selbst hatten, ein jeglicher nach seiner Art. Und Gott sah, daß es gut war.\",\"start\":[19,0],\"name\":\"insertText\"}]}";
//			if (!ops.toString().equals(JSON_REFERENCE_OPERATIONS_BIBLE_SHORT)) {
//				String error = "The opererations had been:\n" + ops.toString() + "\ninstead of the expected\n" + JSON_REFERENCE_OPERATIONS_BIBLE_SHORT;
//				LOG.severe(error);
//				Assert.fail(error);
//			}

		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void testFormatOperation_DEMO_crossParagraphMultiFormat() {
		final String TARGET_TRUNC_STRING = "bible_short";
		final String TARGET_SUFFIX_STRING = ".odt";
		final String TEST_NAME = "_DEMO_crossParagraphMultiFormat.odt";
		//final String MULTIPLE_PARA_FORMAT_CROSS_PARA = "[{\"name\":\"setAttribute\",\"attr\":\"bold\",\"value\":true,\"start\":[5,0],\"end\":[5,59]},{\"name\":\"setAttribute\",\"attr\":\"bold\",\"value\":true,\"start\":[6,0],\"end\":[6,89]},{\"name\":\"setAttribute\",\"attr\":\"bold\",\"value\":true,\"start\":[7,0],\"end\":[7,0]},{\"name\":\"setAttribute\",\"attr\":\"bold\",\"value\":true,\"start\":[8,0],\"end\":[8,102]},{\"name\":\"setAttribute\",\"attr\":\"bold\",\"value\":true,\"start\":[9,0],\"end\":[9,116]},{\"name\":\"setAttribute\",\"attr\":\"bold\",\"value\":true,\"start\":[10,0],\"end\":[10,0]},{\"name\":\"setAttribute\",\"attr\":\"bold\",\"value\":true,\"start\":[11,0],\"end\":[11,121]},{\"name\":\"setAttribute\",\"attr\":\"italic\",\"value\":true,\"start\":[5,0],\"end\":[5,59]},{\"name\":\"setAttribute\",\"attr\":\"italic\",\"value\":true,\"start\":[6,0],\"end\":[6,89]},{\"name\":\"setAttribute\",\"attr\":\"italic\",\"value\":true,\"start\":[7,0],\"end\":[7,0]},{\"name\":\"setAttribute\",\"attr\":\"italic\",\"value\":true,\"start\":[8,0],\"end\":[8,102]},{\"name\":\"setAttribute\",\"attr\":\"italic\",\"value\":true,\"start\":[9,0],\"end\":[9,116]},{\"name\":\"setAttribute\",\"attr\":\"italic\",\"value\":true,\"start\":[10,0],\"end\":[10,0]},{\"name\":\"setAttribute\",\"attr\":\"italic\",\"value\":true,\"start\":[11,0],\"end\":[11,121]},{\"name\":\"setAttribute\",\"attr\":\"underline\",\"value\":true,\"start\":[5,0],\"end\":[5,59]},{\"name\":\"setAttribute\",\"attr\":\"underline\",\"value\":true,\"start\":[6,0],\"end\":[6,89]},{\"name\":\"setAttribute\",\"attr\":\"underline\",\"value\":true,\"start\":[7,0],\"end\":[7,0]},{\"name\":\"setAttribute\",\"attr\":\"underline\",\"value\":true,\"start\":[8,0],\"end\":[8,102]},{\"name\":\"setAttribute\",\"attr\":\"underline\",\"value\":true,\"start\":[9,0],\"end\":[9,116]},{\"name\":\"setAttribute\",\"attr\":\"underline\",\"value\":true,\"start\":[10,0],\"end\":[10,0]},{\"name\":\"setAttribute\",\"attr\":\"underline\",\"value\":true,\"start\":[11,0],\"end\":[11,121]}]";
		final String MULTIPLE_PARA_FORMAT_CROSS_PARA_1 = "[{\"name\":\"setAttribute\",\"attr\":\"bold\",\"value\":true,\"start\":[11,0],\"end\":[11,119]}]";
		final String MULTIPLE_PARA_FORMAT_CROSS_PARA_2 = "[{\"name\":\"setAttribute\",\"attr\":\"italic\",\"value\":true,\"start\":[11,0],\"end\":[11,121]}]";
		final String MULTIPLE_PARA_FORMAT_CROSS_PARA_3 = "[{\"name\":\"setAttribute\",\"attr\":\"underline\",\"value\":true,\"start\":[11,0],\"end\":[11,121]}]";



		//final String EXPECTED_TEXT = "0-Ntalic27-Bold-italic-underline51-Bold-underline68-Bold-italic-underline293-Bold100-Normal!!";
		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + TARGET_SUFFIX_STRING)));

			//**********APPLY
			int opCount = doc.applyOperations(MULTIPLE_PARA_FORMAT_CROSS_PARA_1);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE			
			doc.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + TEST_NAME));
			LOG.info("***Saved:" + TARGET_TRUNC_STRING + TEST_NAME);


			//**********LOAD
			OdfOperationDocument doc2 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + TEST_NAME)));

			//**********APPLY
			int opCount2 = doc2.applyOperations(MULTIPLE_PARA_FORMAT_CROSS_PARA_2);
			LOG.log(Level.INFO, "opCount: {0}", opCount2);

			//**********SAVE			
			doc2.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + "2" + TEST_NAME));
			LOG.info("***Saved:" + TARGET_TRUNC_STRING + "2" + TEST_NAME);


			//**********LOAD
			OdfOperationDocument doc3 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + "2" + TEST_NAME)));

			//**********APPLY
			int opCount3 = doc3.applyOperations(MULTIPLE_PARA_FORMAT_CROSS_PARA_3);
			LOG.log(Level.INFO, "opCount: {0}", opCount3);


			//**********SAVE			
			doc3.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + "3" + TEST_NAME));
			LOG.info("***Saved:" + TARGET_TRUNC_STRING + "3" + TEST_NAME);


			//**********TEST
			OdfContentDom odfContent3 = doc3.getDocument().getContentDom();
			NodeList lst3 = odfContent3.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
			Node node3 = lst3.item(11);
			String paragraphText3 = node3.getTextContent();

			final String EXPECTED_TEXT = "Gen 1:7 Da machte Gott die Feste und schied das Wasser unter der Feste von dem Wasser über der Feste. Und es geschah also.";
			Assert.assertTrue("The text was not concatenated correctly! It should be " + EXPECTED_TEXT + ", instead the text is '" + paragraphText3 + "'", paragraphText3.equals(EXPECTED_TEXT));
			JSONObject ops = doc3.getOperations();
			final String JSON_REFERENCE_OPERATIONS_BIBLE_SHORT = "{\"operations\":[{\"name\":\"initDocument\"},{\"start\":[0],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:1 Am Anfang schuf Gott Himmel und Erde.\",\"start\":[0,0],\"name\":\"insertText\"},{\"start\":[1],\"name\":\"insertParagraph\"},{\"start\":[2],\"name\":\"insertParagraph\"},{\"start\":[3],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:2 Und die Erde war wüst und leer, und es war finster auf der Tiefe; und der Geist Gottes schwebte auf dem Wasser.\",\"start\":[3,0],\"name\":\"insertText\"},{\"start\":[4],\"name\":\"insertParagraph\"},{\"start\":[5],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:3 Und Gott sprach: Es werde Licht! Und es ward Licht.\",\"start\":[5,0],\"name\":\"insertText\"},{\"start\":[6],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:4 Und Gott sah, daß das Licht gut war. Da schied Gott das Licht von der Finsternis \",\"start\":[6,0],\"name\":\"insertText\"},{\"start\":[7],\"name\":\"insertParagraph\"},{\"start\":[8],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:5 und nannte das Licht Tag und die Finsternis Nacht. Da ward aus Abend und Morgen der erste Tag.\",\"start\":[8,0],\"name\":\"insertText\"},{\"start\":[9],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:6 Und Gott sprach: Es werde eine Feste zwischen den Wassern, und die sei ein Unterschied zwischen den Wassern.\",\"start\":[9,0],\"name\":\"insertText\"},{\"start\":[10],\"name\":\"insertParagraph\"},{\"start\":[11],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:7 Da machte Gott die Feste und schied das Wasser unter der Feste von dem Wasser über der Feste. Und es geschah al\",\"start\":[11,0],\"name\":\"insertText\"},{\"text\":\"so\",\"start\":[11,119],\"name\":\"insertText\"},{\"text\":\".\",\"start\":[11,121],\"name\":\"insertText\"},{\"start\":[11,0],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"bold\",\"end\":[11,119]},{\"start\":[11,0],\"name\":\"setAttribute\",\"value\":true,\"attr\":\"italic\",\"end\":[11,119]},{\"start\":[11,0],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"underline\",\"end\":[11,119]},{\"start\":[11,119],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"bold\",\"end\":[11,121]},{\"start\":[11,119],\"name\":\"setAttribute\",\"value\":true,\"attr\":\"italic\",\"end\":[11,121]},{\"start\":[11,119],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"underline\",\"end\":[11,121]},{\"start\":[12],\"name\":\"insertParagraph\"},{\"start\":[13],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:8 Und Gott nannte die Feste Himmel. Da ward aus Abend und Morgen der andere Tag.\",\"start\":[13,0],\"name\":\"insertText\"},{\"start\":[14],\"name\":\"insertParagraph\"},{\"start\":[15],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:9 Und Gott sprach: Es sammle sich das Wasser unter dem Himmel an besondere Örter, daß man das Trockene sehe. Und es geschah also.\",\"start\":[15,0],\"name\":\"insertText\"},{\"start\":[16],\"name\":\"insertParagraph\"},{\"start\":[17],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:10 Und Gott nannte das Trockene Erde, und die Sammlung der Wasser nannte er Meer. Und Gott sah, daß es gut war.\",\"start\":[17,0],\"name\":\"insertText\"},{\"start\":[18],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:11 Und Gott sprach: Es lasse die Erde aufgehen Gras und Kraut, das sich besame, und fruchtbare Bäume, da ein jeglicher nach seiner Art Frucht trage und habe seinen eigenen Samen bei sich selbst auf Erden. Und es geschah also.\",\"start\":[18,0],\"name\":\"insertText\"},{\"start\":[19],\"name\":\"insertParagraph\"},{\"text\":\"Gen 1:12 Und die Erde ließ aufgehen Gras und Kraut, das sich besamte, ein jegliches nach seiner Art, und Bäume, die da Frucht trugen und ihren eigenen Samen bei sich selbst hatten, ein jeglicher nach seiner Art. Und Gott sah, daß es gut war.\",\"start\":[19,0],\"name\":\"insertText\"}]}";
			if (!ops.toString().equals(JSON_REFERENCE_OPERATIONS_BIBLE_SHORT)) {
				String error = "The opererations had been:\n" + ops.toString() + "\ninstead of the expected\n" + JSON_REFERENCE_OPERATIONS_BIBLE_SHORT;
				LOG.severe(error);
				Assert.fail(error);
			}

		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore//Svante
	public void testFormatOperation_DEMO_crossParagraphFormat() {
		final String TEST_INPUT_DOC = "FruitDepot-SeasonalFruits3.odt";
		final String TEST_NAME = "_DEMO_crossParagraphFormat.odt";
		final String MULTIPLE_PARA_FORMAT_CROSS_PARA = "[{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"bold\",\"start\":[1,15],\"end\":[1,1014]}]";


		//final String EXPECTED_TEXT = "0-Ntalic27-Bold-italic-underline51-Bold-underline68-Bold-italic-underline293-Bold100-Normal!!";
		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TEST_INPUT_DOC)));


			//**********APPLY
			int opCount = doc.applyOperations(MULTIPLE_PARA_FORMAT_CROSS_PARA);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE			
			doc.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING + TEST_NAME));
			LOG.info("***Saved:" + TARGET_DEMO_STRING + TEST_NAME);

			//**********TEST
			OdfOperationDocument doc2 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING + TEST_NAME)));
			OdfContentDom odfContent2 = doc2.getDocument().getContentDom();
			NodeList lst2 = odfContent2.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
			Node node2 = lst2.item(0);
			String paragraphText2 = node2.getTextContent();

			//	Assert.assertTrue("The text was not concatenated correctly! It should be " + EXPECTED_TEXT + ", instead the text is '" + paragraphText2 + "'", paragraphText2.equals(EXPECTED_TEXT));
			JSONObject ops = doc2.getOperations();
			final String JSON_REFERENCE_OPERATIONS_DEMO_OLD = "{\"operations\":[{\"name\":\"initDocument\"},{\"start\":[0],\"name\":\"insertParagraph\"},{\"text\":\"Seasonal Fruits\",\"start\":[0,0],\"name\":\"insertText\"},{\"start\":[1],\"name\":\"insertParagraph\"},{\"text\":\"Ich bin Blindte\",\"start\":[1,0],\"name\":\"insertText\"},{\"text\":\"xt. Von Geburt an. Es hat lange, bis ich begriffen habe, was es bedeutet, ein blinder Text zu sein: Man macht keinen Sinn. Man wirkt hier und da aus dem Zusammenhang gerissen. Oft wird man gar nicht erst gelesen. Aber bin ich deshalb ein schlechter Text?\\rIch weiß, dass ich nie die Chance haben werde im Stern zu erscheinen. Aber bin ich darum weniger wichtig? Ich bin blind! Aber ich bin gerne Text. Und sollten Sie mich jetzt tatsächlich zu Ende lesen, dann habe ich etwas geschafft, was den meisten \"normalen\" Texten nicht gelingt. Ich bin Blindtext. Von Geburt an. Es hat lange gedauert, bis ich begriffen habe, was es bedeutet, ein blinder Text zu sein: Man macht keinen Sinn. Man wirkt heir und da aus dem Zusammenhang gerissen. Oft wird man gar nicht erst gelesen. Aber bin ich darum weniger wichtig? Ich bin blind! Aber ich bin gerne Text. Und sollten Sie mich jetzt tatsächlich zu Ende lesen, dann habe ich etwas geschafft, was den meisten \"normalen\" Texten nicht gelingt. Ich bin Blindtext\",\"start\":[1,15],\"name\":\"insertText\"},{\"text\":\". \\r\\r\",\"start\":[1,1014],\"name\":\"insertText\"},{\"start\":[1,15],\"name\":\"setAttribute\",\"value\":true,\"attr\":\"bold\",\"end\":[1,1014]},{\"start\":[1,15],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"italic\",\"end\":[1,1014]},{\"start\":[1,15],\"name\":\"setAttribute\",\"value\":false,\"attr\":\"underline\",\"end\":[1,1014]},{\"start\":[2],\"name\":\"insertParagraph\"},{\"text\":\"Ich bin blind! Aber ich bin gerne Text. Und sollten Sie mich jetzt tatsächlich zu Ende lesen, dann habe ich etwas geschafft, was den meisten \"normalen\" Texten nicht gelingt. Ich bin Blindtext. Von Geburt an. Es hat lange gedauert, bis ich begriffen habe, was es bedeutet, ein blinder Text zu sein: Man macht keinen Sinn. Man wirkt heir und da aus dem Zusammenhang gerissen. Oft wird man gar nicht erst gelesen. Aber bin ich darum weniger wichtig? Ich bin blind! Aber ich bin gerne Text. Und sollten Sie mich jetzt tatsächlich zu Ende lesen, dann habe ich etwas geschafft, was den meisten \"normalen\" Texten nicht gelingt. Ich bin Blindtext. \\r\\r\",\"start\":[2,0],\"name\":\"insertText\"},{\"start\":[3],\"name\":\"insertParagraph\"},{\"start\":[4],\"name\":\"insertParagraph\"},{\"text\":\"Von Geburt an. Es hat lange gedauert, bis ich begriffen habe, was es bedeutet, ein blinder Text zu sein: Man macht keinen Sinn. Man wirkt heir und da aus dem Zusammenhang gerissen. Oft wird man gar nicht erst gelesen. Aber bin ich darum weniger wichtig? Ich bin blind! Aber ich bin gerne Text. Und sollten Sie mich jetzt tatsächlich zu Ende lesen, dann habe ich etwas geschafft, was den meisten \"normalen\" Texten nicht gelingt. \",\"start\":[4,0],\"name\":\"insertText\"},{\"start\":[5],\"name\":\"insertParagraph\"},{\"start\":[6],\"name\":\"insertParagraph\"},{\"start\":[7],\"name\":\"insertParagraph\"},{\"start\":[8],\"name\":\"insertParagraph\"},{\"start\":[9],\"name\":\"insertParagraph\"},{\"start\":[10],\"name\":\"insertParagraph\"},{\"text\":\"Ich bin Blindtext. Von Geburt an. Es hat lange, bis ich begriffen habe, was es bedeutet, ein blinder Text zu sein: Man macht keinen Sinn. Man wirkt hier und da aus dem Zusammenhang gerissen. Oft wird man gar nicht erst gelesen. Aber bin ich deshalb ein schlechter Text?\\r\",\"start\":[10,0],\"name\":\"insertText\"},{\"start\":[11],\"name\":\"insertParagraph\"},{\"text\":\"\\rIch weiß, dass ich nie die Chance haben werde im Stern zu erscheinen. Aber bin ich darum weniger wichtig? Ich bin blind! Aber ich bin gerne Text. Und sollten Sie mich jetzt tatsächlich zu Ende lesen, dann habe ich etwas geschafft, was den meisten \"normalen\" Texten nicht gelingt. Ich bin Blindtext.\",\"start\":[11,0],\"name\":\"insertText\"},{\"start\":[12],\"name\":\"insertParagraph\"},{\"start\":[13],\"name\":\"insertParagraph\"},{\"start\":[14],\"name\":\"insertParagraph\"},{\"start\":[15],\"name\":\"insertParagraph\"},{\"start\":[16],\"name\":\"insertParagraph\"},{\"start\":[17],\"name\":\"insertParagraph\"},{\"start\":[18],\"name\":\"insertParagraph\"},{\"start\":[19],\"name\":\"insertParagraph\"},{\"start\":[20],\"name\":\"insertParagraph\"},{\"start\":[21],\"name\":\"insertParagraph\"}]}";
			if (!ops.toString().equals(JSON_REFERENCE_OPERATIONS_DEMO_OLD)) {
				String error = "The opererations had been:\n" + ops.toString() + "\ninstead of the expected\n" + JSON_REFERENCE_OPERATIONS_DEMO_OLD;
				LOG.severe(error);
				Assert.fail(error);
			}


		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void testFormatOperation_crossParagraphFormat() {
		final String TEST_NAME = "_crossParagraphFormat.odt";
		final String MULTIPLE_PARA_FORMAT_CROSS_PARA = "[{\"name\":\"setAttribute\",\"value\":false,\"attr\":\"bold\",\"start\":[0,17],\"end\":[2,22]}]";


		//final String EXPECTED_TEXT = "0-Ntalic27-Bold-italic-underline51-Bold-underline68-Bold-italic-underline293-Bold100-Normal!!";
		try {
			//**********LOAD
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(MULTIPLE_PARAGRAPH_SOURCE)));


			//**********APPLY
			int opCount = doc.applyOperations(MULTIPLE_PARA_FORMAT_CROSS_PARA);
			LOG.log(Level.INFO, "opCount: {0}", opCount);

			//**********SAVE			
			doc.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING + TEST_NAME));
			LOG.info("***Saved:" + TARGET_DEMO_STRING + TEST_NAME);

			//**********TEST
			OdfOperationDocument doc2 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING + TEST_NAME)));
			OdfContentDom odfContent2 = doc2.getDocument().getContentDom();
			NodeList lst2 = odfContent2.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
			Node node2 = lst2.item(0);
			String paragraphText2 = node2.getTextContent();

			//	Assert.assertTrue("The text was not concatenated correctly! It should be " + EXPECTED_TEXT + ", instead the text is '" + paragraphText2 + "'", paragraphText2.equals(EXPECTED_TEXT));



		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void testFormatOperation() {
		final String TARGET_TRUNC_STRING = "formatEverywhere";
		final String TARGET_SUFFIX_STRING = ".odt";
		final String TEST_NAME = "formatEverywhere.odt";
		//final String SIMPLE_FORMAT = "[{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"italic\",\"start\":[0,1],\"end\":[0,3]}]";						
		//final String FORMAT_WITHIN_EXISTING = "[{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"italic\",\"start\":[0,5],\"end\":[0,10]},{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"bold\",\"start\":[0,6],\"end\":[0,9]}]";				
		//final String NESTED_FORMAT = "[{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"italic\",\"start\":[0,5],\"end\":[0,10]},{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"bold\",\"start\":[0,6],\"end\":[0,9]}]";		
		final String OVERLAPPING_FORMAT_1 = "[{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"italic\",\"start\":[0,5],\"end\":[0,10]}]";
		final String OVERLAPPING_FORMAT_2 = "[{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"bold\",\"start\":[0,6],\"end\":[0,11]}]";
		final String OVERLAPPING_FORMAT_3 = "[{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"bold\",\"start\":[0,6],\"end\":[0,11]},{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"underline\",\"start\":[0,7],\"end\":[0,12]}]";

		try {
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(MULTIPLE_PARAGRAPH_SOURCE)));
			int opCount = doc.applyOperations(OVERLAPPING_FORMAT_1);
			LOG.log(Level.INFO, "opCount: {0}", opCount);
			doc.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + TEST_NAME));

			//**********LOAD			
			OdfOperationDocument doc2 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + TEST_NAME)));

			//**********APPLY
			int opCount2 = doc2.applyOperations(OVERLAPPING_FORMAT_2);
			LOG.log(Level.INFO, "opCount: {0}", opCount2);


			//**********TEST			
			OdfContentDom odfContent2 = doc2.getDocument().getContentDom();
			NodeList lst2 = odfContent2.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
			Node node2 = lst2.item(0);
			//String paragraphText2 = node2.getTextContent();


			//**********SAVE			
			doc2.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + "2" + TEST_NAME));
			LOG.info("***Saved:" + TARGET_TRUNC_STRING + "2" + TEST_NAME);



			//**********LOAD
			OdfOperationDocument doc3 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + "2" + TEST_NAME)));

			//**********APPLY
			int opCount3 = doc3.applyOperations(OVERLAPPING_FORMAT_3);
			LOG.log(Level.INFO, "opCount: {0}", opCount3);


			//**********SAVE			
			doc3.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_TRUNC_STRING + "3" + TEST_NAME));
			LOG.info("***Saved:" + TARGET_TRUNC_STRING + "3" + TEST_NAME);



			//Assert.assertTrue("The text was not concatenated correctly! It should be " + EXPECTED_TEXT + ", instead the text is '" + paragraphText2 + "'", paragraphText2.equals(EXPECTED_TEXT));



		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void testSplitOperation() {
		final String TEST_NAME = "splitParagraph.odt";
		final String MULTIPLE_SPAN_DELETE_CROSS_PARA = "[{\"name\":\"splitParagraph\",\"start\":[0,3]}]";
		final String FIRST_EXPECTED_TEXT = "0-N";
		final String SECOND_EXPECTED_TEXT = "ormal8-Bold14-BoldItalic27-Bold-italic-underline51-Bold-underline68-Bold-italic-underline293-Bold100-Normal!!";

		try {
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(MULTIPLE_PARAGRAPH_SOURCE)));
			int opCount = doc.applyOperations(MULTIPLE_SPAN_DELETE_CROSS_PARA);
			LOG.log(Level.INFO, "opCount: {0}", opCount);
			doc.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING + TEST_NAME));

			OdfOperationDocument doc2 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING + TEST_NAME)));
			OdfContentDom odfContent2 = doc2.getDocument().getContentDom();
			NodeList lst2 = odfContent2.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
			Node firstParagraph = lst2.item(0);
			String firstParagraphText = firstParagraph.getTextContent();
			Node secondParagraph = lst2.item(1);
			String secondParagraphText = secondParagraph.getTextContent();
			Assert.assertTrue("The text was not split! The first paragraph should be '" + FIRST_EXPECTED_TEXT + "', instead the text is '" + firstParagraphText + "'", firstParagraphText.equals(FIRST_EXPECTED_TEXT));
			Assert.assertTrue("The text was not split! The second paragraph should be '" + SECOND_EXPECTED_TEXT + "', instead the text is '" + secondParagraphText + "'", secondParagraphText.equals(SECOND_EXPECTED_TEXT));

		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void testDeleteOperation_crossParagraphDelete() {
		final String TEST_NAME = "_crossParagraphDelete.odt";
		final String MULTIPLE_SPAN_DELETE_CROSS_PARA = "[{\"name\":\"deleteText\",\"start\":[0,3],\"end\":[2,22]}]";
		try {
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(MULTIPLE_PARAGRAPH_SOURCE)));
			int opCount = doc.applyOperations(MULTIPLE_SPAN_DELETE_CROSS_PARA);
			LOG.log(Level.INFO, "opCount: {0}", opCount);
			doc.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING + TEST_NAME));

			OdfOperationDocument doc2 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING + TEST_NAME)));
			OdfContentDom odfContent2 = doc2.getDocument().getContentDom();
			NodeList lst2 = odfContent2.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
			Node node2 = lst2.item(0);
			String paragraphText2 = node2.getTextContent();
			final String EXPECTED_TEXT = "0-Ntalic27-Bold-italic-underline51-Bold-underline68-Bold-italic-underline293-Bold100-Normal!!";
			Assert.assertTrue("The text was not concatenated correctly! It should be " + EXPECTED_TEXT + ", instead the text is '" + paragraphText2 + "'", paragraphText2.equals(EXPECTED_TEXT));

			lst2 = odfContent2.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
			node2 = lst2.item(1);
			paragraphText2 = node2.getTextContent();
			final String EXPECTED_TEXT2 = "Svantestext";
			Assert.assertTrue("The text was not concatenated correctly! It should be \n'" + EXPECTED_TEXT2 + "', instead the text is \n'" + paragraphText2 + "'", paragraphText2.equals(EXPECTED_TEXT2));


		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void testDeleteOperation_innerDelete() {

		final String TEST_NAME = "innerDelete.odt";
		try {
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(MULTIPLE_SPAN_SOURCE)));
			int opCount = doc.applyOperations(MULTIPLE_SPAN_DELETE_WITHIN);
			LOG.log(Level.INFO, "opCount: {0}", opCount);
			doc.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING + TEST_NAME));
//			ODF XML of test paragraph:
//			<text:p text:style-name="P2">Seasonal juicy uicy Fruits</text:p>

			OdfOperationDocument doc2 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING + TEST_NAME)));
			OdfContentDom odfContent2 = doc2.getDocument().getContentDom();
			NodeList lst2 = odfContent2.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
			Node node2 = lst2.item(0);
			String paragraphText2 = node2.getTextContent();
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++			Assert.assertTrue("The very first paragraph was not inserted! It should be hold " + NEW_TEXT_BY_STRING + ", instead the text is '" + paragraphText2 + "'", paragraphText2.equals(NEW_TEXT_BY_STRING));
//			int opCount2 = doc2.applyOperations(STRING_REFERENCE_OPERATIONS_A);
//			LOG.info("opCount2: " + opCount2);
//			doc2.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING2));
//			LOG.info("Saved " + TARGET_DEMO_STRING2);
//////			<text:p text:style-name="P2">Seasonal juicy uicy Fruits</text:p>
////			{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"bold\",\"start\":[0,1],\"end\":[0,15]}
//// 			<text:p text:style-name="P2">S<text:span text:style-name="T1">easonal juicy </text:span>uicy Fruits</text:p>
//
//			OdfOperationDocument doc3 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING2)));
//			int opCount3 = doc3.applyOperations(STRING_REFERENCE_OPERATIONS_C);
//
//			OdfContentDom odfContent3 = doc3.getDocument().getContentDom();
//			NodeList lst3 = odfContent3.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
//			Node node3 = lst3.item(0);
//			String paragraphText3 = node3.getTextContent();
////			Assert.assertTrue("The first paragraph was not inserted! It should be hold " + NEW_TEXT_BY_STRING2 + ", instead the text is '" + paragraphText3 + "'", paragraphText3.equals(NEW_TEXT_BY_STRING2));
//			doc3.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING3));
//			LOG.info("Saved " + TARGET_DEMO_STRING3);
////			<text:p text:style-name="P2">S<text:span text:style-name="T1">easonal juicy </text:span>uicy Fruits</text:p>
////			{\"name\":\"deleteText\",\"start\":[0,14],\"end\":[0,20]}
//			

		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void testPropertyOperation() {
		final String TEST_NAME = "_addstyles.odt";
		try {
			// read the (known) operation from the test document
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(MULTIPLE_SPAN_SOURCE)));
			int opCount = doc.applyOperations(STRING_REFERENCE_OPERATIONS_A);
			LOG.info("opCount: " + opCount);
			doc.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING + TEST_NAME));
//			<text:p text:style-name="P2">Seasonal juicy uicy Fruits</text:p>

			OdfOperationDocument doc2 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING + TEST_NAME)));
			OdfContentDom odfContent2 = doc2.getDocument().getContentDom();
			NodeList lst2 = odfContent2.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
			Node node2 = lst2.item(0);
			String paragraphText2 = node2.getTextContent();
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++			Assert.assertTrue("The very first paragraph was not inserted! It should be hold " + NEW_TEXT_BY_STRING + ", instead the text is '" + paragraphText2 + "'", paragraphText2.equals(NEW_TEXT_BY_STRING));
//			int opCount2 = doc2.applyOperations(STRING_REFERENCE_OPERATIONS_A);
//			LOG.info("opCount2: " + opCount2);
//			doc2.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING2));
//			LOG.info("Saved " + TARGET_DEMO_STRING2);
//////			<text:p text:style-name="P2">Seasonal juicy uicy Fruits</text:p>
////			{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"bold\",\"start\":[0,1],\"end\":[0,15]}
//// 			<text:p text:style-name="P2">S<text:span text:style-name="T1">easonal juicy </text:span>uicy Fruits</text:p>
//
//			OdfOperationDocument doc3 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING2)));
//			int opCount3 = doc3.applyOperations(STRING_REFERENCE_OPERATIONS_C);
//
//			OdfContentDom odfContent3 = doc3.getDocument().getContentDom();
//			NodeList lst3 = odfContent3.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
//			Node node3 = lst3.item(0);
//			String paragraphText3 = node3.getTextContent();
////			Assert.assertTrue("The first paragraph was not inserted! It should be hold " + NEW_TEXT_BY_STRING2 + ", instead the text is '" + paragraphText3 + "'", paragraphText3.equals(NEW_TEXT_BY_STRING2));
//			doc3.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING3));
//			LOG.info("Saved " + TARGET_DEMO_STRING3);
////			<text:p text:style-name="P2">S<text:span text:style-name="T1">easonal juicy </text:span>uicy Fruits</text:p>
////			{\"name\":\"deleteText\",\"start\":[0,14],\"end\":[0,20]}
//			

		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void testApplyOperationsbyString() {
		final String TEST_NAME = "_delete-and-bold.odt";
		try {
			// read the (known) operation from the test document
			//**********LOAD
			OdfOperationDocument doc = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(SOURCE_DEMO_2)));

			//**********APPLY
			//OPS:	"[{\"name\":\"initDocument\"},{\"name\":\"insertText\",\"text\":\"juicy \",\"start\":[0,9]},{\"name\":\"insertText\",\"text\":\"u\",\"start\":[0,10]},{\"name\":\"insertText\",\"text\":\"i\",\"start\":[0,11]},{\"name\":\"insertText\",\"text\":\"c\",\"start\":[0,12]},{\"name\":\"insertText\",\"text\":\"y\",\"start\":[0,13]},{\"name\":\"insertText\",\"text\":\" \",\"start\":[0,14]}]";
			int opCount = doc.applyOperations(STRING_REFERENCE_OPERATIONS);
			LOG.info("opCount: " + opCount);

			//**********SAVE
			//OUT:			<text:p text:style-name="P2">Seasonal juicy uicy Fruits</text:p>
			doc.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING + TEST_NAME));
			LOG.info("***Saved:" + TARGET_DEMO_STRING + TEST_NAME);

			//**********TEST
			// get text content of first text:p
			OdfContentDom odfContent1 = doc.getDocument().getContentDom();
			NodeList lst1 = odfContent1.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
			Node node1 = lst1.item(0);
			String paraText1 = node1.getTextContent();

			final String NEW_PARAGRAPH_TEXT = "Seasonal juicy uicy Fruits";
			Assert.assertTrue("The first paragraph was not inserted! It should be hold:\n'" + NEW_PARAGRAPH_TEXT + "', instead the text is:\n'" + paraText1 + "'", paraText1.equals(NEW_PARAGRAPH_TEXT));


			//**********LOAD
			//			<text:p text:style-name="P2">Seasonal juicy uicy Fruits</text:p>
			OdfOperationDocument doc2 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING + TEST_NAME)));

			//**********APPLY
			//			{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"bold\",\"start\":[0,1],\"end\":[0,15]}	
			int opCount2 = doc2.applyOperations(STRING_REFERENCE_OPERATIONS2);
			LOG.info("opCount2: " + opCount2);

			//**********SAVE
			// 			<text:p text:style-name="P2">S<text:span text:style-name="OX_POC_1">easonal juicy </text:span>uicy Fruits</text:p>
			doc2.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING2 + TEST_NAME));
			LOG.info("***Saved2:" + TARGET_DEMO_STRING2 + TEST_NAME);

			//**********TEST
			// Get text content of first text:span
			OdfContentDom odfContent2 = doc2.getDocument().getContentDom();
			NodeList lst2 = odfContent2.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "span");
			Node node2 = lst2.item(0);
			String spanText2 = node2.getTextContent();
			final String NEW_SPAN_TEXT = "easonal juicy ";
			Assert.assertTrue("The first span was not formatted correctly! It should be hold:\n'" + NEW_SPAN_TEXT + "', instead the text is:\n'" + spanText2 + "'", spanText2.equals(NEW_SPAN_TEXT));
			// 			<text:p text:style-name="P2">S<text:span text:style-name="OX_POC_1">easonal juicy </text:span>uicy Fruits</text:p>

			//**********LOAD
			OdfOperationDocument doc3 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING2 + TEST_NAME)));
			// 			<text:p text:style-name="P2">S<text:span text:style-name="OX_POC_1">easonal juicy </text:span>uicy Fruits</text:p>			

			//**********APPLY
			final String STRING_REFERENCE_OPERATIONS3 = "[{\"name\":\"initDocument\"},{\"name\":\"deleteText\",\"start\":[0,8],\"end\":[0,21]}]";
			int opCount3 = doc3.applyOperations(STRING_REFERENCE_OPERATIONS3);
//			{\"name\":\"deleteText\",\"start\":[0,14],\"end\":[0,21]}			

			//**********TEST
			OdfContentDom odfContent3 = doc3.getDocument().getContentDom();
			NodeList lst3a = odfContent3.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
			Node node3a = lst3a.item(0);
			String paragraphText3 = node3a.getTextContent();
			// <text:p text:style-name="P2">S<text:span text:style-name="OX_POC_1">easonal</text:span>ruits</text:p>
			final String NEW_TEXT_BY_STRING2 = "Seasonalruits";
			Assert.assertTrue("The first paragraph was not inserted! It should be hold " + NEW_TEXT_BY_STRING2 + ", instead the text is '" + paragraphText3 + "'", paragraphText3.equals(NEW_TEXT_BY_STRING2));

			// Get text content of first text:span			
			NodeList lst3b = odfContent3.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "span");
			Node node3b = lst3b.item(0);
			String spanText3 = node3b.getTextContent();
			final String NEW_SPAN_TEXT3 = "easonal";
			Assert.assertTrue("The first span was not formatted correctly! It should be hold:\n'" + NEW_SPAN_TEXT3 + "', instead the text is:\n'" + spanText3 + "'", spanText3.equals(NEW_SPAN_TEXT3));
			//**********SAVE
			// <text:p text:style-name="P2">S<text:span text:style-name="OX_POC_1">easonal</text:span>ruits</text:p>
			doc3.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING3 + TEST_NAME));
			LOG.info("***Saved3:" + TARGET_DEMO_STRING3 + TEST_NAME);



			//**********LOAD			
			OdfOperationDocument doc4 = new OdfOperationDocument(new FileInputStream(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING3 + TEST_NAME)));
			// <text:p text:style-name="P2">S<text:span text:style-name="OX_POC_1">easonal</text:span>ruits</text:p>
			//**********APPLY
			//final String STRING_REFERENCE_OPERATIONS4 = "[{\"name\":\"setAttribute\",\"value\":true,\"attr\":\"bold\",\"start\":[0,1],\"end\":[0,15]},{\"name\":\"deleteText\",\"start\":[0,12],\"end\":[0,19]}]";
			final String STRING_REFERENCE_OPERATIONS4 = "[{\"name\":\"setAttribute\",\"value\":false,\"attr\":\"bold\",\"start\":[0,3],\"end\":[0,6]}]";
			// <text:p text:style-name="P2">S<text:span text:style-name="OX_POC_1">ea<text:span text:style-name="OX_POC_0">son</text:span>al</text:span>ruits</text:p>  RIGHT!!

			int opCount4 = doc4.applyOperations(STRING_REFERENCE_OPERATIONS4);
			LOG.info("pCount4: " + opCount4);

			//**********SAVE
			doc4.getDocument().save(ResourceUtilities.newTestOutputFile(TARGET_DEMO_STRING4 + TEST_NAME));
			LOG.info("Saved " + TARGET_DEMO_STRING4 + TEST_NAME);

			//**********TEST
			OdfContentDom odfContent4 = doc4.getDocument().getContentDom();
			NodeList lst4 = odfContent4.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "span");
			Node node4 = lst4.item(1);
			String spanText4 = node4.getTextContent();

			final String NEW_SPAN_TEXT4 = "son";
			Assert.assertTrue("The second was not inserted! It should be hold:\n'" + NEW_SPAN_TEXT4 + "', instead the text is:\n'" + spanText4 + "'", spanText4.equals(NEW_SPAN_TEXT4));

		} catch (Throwable e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void testGetOperations4Demo() {
		try {
			OdfDocument odfDocument = OdfDocument.loadDocument(ResourceUtilities.getAbsolutePath(SOURCE_DEMO));
			JSONObject ops = odfDocument.getOperations();
			LOG.log(Level.INFO, "The Ops are: {0}", ops.toString());
			if (!ops.toString().equals(JSON_REFERENCE_OPERATIONS_DEMO)) {
				String error = "The opererations had been:\n" + ops.toString() + "\ninstead of the expected\n" + JSON_REFERENCE_OPERATIONS_DEMO;
				LOG.severe(error);
				Assert.fail(error);
			}
		} catch (Exception e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void testGetOperations() {
		try {
			OdfDocument odfDocument = OdfDocument.loadDocument(ResourceUtilities.getAbsolutePath(MULTIPLE_SPAN_SOURCE));
			JSONObject ops = odfDocument.getOperations();
			if (!ops.toString().equals(JSON_REFERENCE_OPERATIONS)) {
				String error = "The opererations had been:\n" + ops.toString() + "\ninstead of the expected\n" + JSON_REFERENCE_OPERATIONS;
				LOG.severe(error);
				Assert.fail(error);
			}
		} catch (Exception e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}

	@Test
	@Ignore
	public void testApplyOperationsDocument() {
		try {
			// read the (known) operation from the test document
			OdfDocument odfDocument = OdfDocument.loadDocument(ResourceUtilities.getAbsolutePath(MULTIPLE_SPAN_SOURCE));
			JSONObject ops = odfDocument.getOperations();
			if (!ops.toString().equals(JSON_REFERENCE_OPERATIONS)) {
				String error = "The opererations had been:\n" + ops.toString() + "\ninstead of the expected\n" + JSON_REFERENCE_OPERATIONS;
				LOG.severe(error);
				Assert.fail(error);
			}

			// Apply a change
			//ToDo OX -- is a JSONOBJECT initialized as follows?
			// odfDocument.applyOperations(new JSONObject(JSON_CHANGE_OPERATIONS));
			Component tree1 = odfDocument.getRootComponent();
//FIXME
//JsonOperationConsumer.insertText(tree1, 0, 30, "BEFORE_BOLD");
//JsonOperationConsumer.insertText(tree1, 0, 1, "First");
//JsonOperationConsumer.insertText(tree1, 0, 1, "Second");
//JsonOperationConsumer.insertText(tree1, 0, 2, "Third");
			odfDocument.save(ResourceUtilities.newTestOutputFile(TARGET_1));
			odfDocument = OdfDocument.loadDocument(ResourceUtilities.getAbsolutePath(TARGET_1));
			OdfContentDom odfContent = odfDocument.getContentDom();
			NodeList lst = odfContent.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
			Node node = lst.item(0);
			String paragraphText = node.getTextContent();
			Assert.assertTrue("The text was not correct inserted! It should be hold " + REFERENCE_PARAGRAPH_TEXT + ", instead the text is '" + paragraphText + "'", paragraphText.equals(REFERENCE_PARAGRAPH_TEXT));
		} catch (Exception ex) {
			Logger.getLogger(OperationJsonTest.class.getName()).log(Level.SEVERE, null, ex);
		}
	}

	@Test
	@Ignore
	public void testApplyOperationsDemoDocument() {
		try {
			// read the (known) operation from the test document
			OdfDocument odfDocument = OdfDocument.loadDocument(ResourceUtilities.getAbsolutePath(SOURCE_DEMO));
			JSONObject ops = odfDocument.getOperations();
			if (!ops.toString().equals(JSON_REFERENCE_OPERATIONS_DEMO)) {
				String error = "The opererations had been:\n" + ops.toString() + "\ninstead of the expected\n" + JSON_REFERENCE_OPERATIONS_DEMO;
				LOG.severe(error);
				Assert.fail(error);
			}

			// Apply a change
			//ToDo OX -- is a JSONOBJECT initialized as follows?
			// odfDocument.applyOperations(new JSONObject(JSON_CHANGE_OPERATIONS));			
			Component tree1 = odfDocument.getRootComponent();
			// start with 22 components
			int componentCount1a = tree1.componentLength();
			LOG.log(Level.FINE, "Before insertion - {0}", componentCount1a);
//FIXME			
//// before insertion - last component index 21
//JsonOperationConsumer.insertParagraph(tree1, 0);
//// before insertion - last component index 22
//JsonOperationConsumer.insertParagraph(tree1, 3);
//// before insertion - last component index 23 
//JsonOperationConsumer.insertParagraph(tree1, 24);
//int componentCount2a = tree1.size();
//// continue with 25 components		
//JsonOperationConsumer.insertText(tree1, 0, 0, NEW_TEXT);
//JsonOperationConsumer.insertText(tree1, 3, 0, NEW_TEXT);
//JsonOperationConsumer.insertText(tree1, 24, 0, NEW_TEXT);
//LOG.log(Level.FINE, "After insertion - {0}", componentCount2a);

			odfDocument.save(ResourceUtilities.newTestOutputFile(TARGET_DEMO_1));

			// Test for existance of change
			odfDocument = OdfDocument.loadDocument(ResourceUtilities.getAbsolutePath(TARGET_DEMO_1));
			OdfContentDom odfContent = odfDocument.getContentDom();
			Component tree2 = odfDocument.getRootComponent();
			int componentCount2b = tree2.componentLength();
			LOG.log(Level.FINE, "After reload - {0}", componentCount2b);
			NodeList lst = odfContent.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
			Node node = lst.item(0);
			String paragraphText = node.getTextContent();
			Assert.assertTrue("The first paragraph was not inserted! It should be hold " + NEW_TEXT + ", instead the text is '" + paragraphText + "'", paragraphText.equals(NEW_TEXT));
//OfficeTextElement root2 = (OfficeTextElement) odfDocument.getContentRoot();
//TextPElement lastP = (TextPElement) root2.getLastChild();
//Assert.assertTrue("The last paragraph was not inserted!It should has the style name 'Text_20_body' instead it has the style name '" + lastP.getStyleName() + "'", lastP.getStyleName().equals("Text_20_body"));


////			//FIXME
////            // before next deletion 25 components		
////            JsonOperationConsumer.deleteParagraph(tree2, 0);
////            // before next deletion 24 components - new para was added as 3rd but is now 2nd
////            JsonOperationConsumer.deleteParagraph(tree2, 2);
////            // before next deletion 23 components		
////            JsonOperationConsumer.deleteParagraph(tree2, 22);
////			


////TextPElement lastP2 = (TextPElement) root2.getLastChild();
////int componentCount1b = tree2.size();
////LOG.log(Level.FINE, "After deletion - {0}", componentCount1b);
////odfDocument.save(ResourceUtilities.newTestOutputFile(TARGET_DEMO_2));
////Assert.assertTrue("The last paragraph was not rmoved!It should has the style name 'P1' instead it has the style name '" + lastP2.getStyleName() + "'", lastP2.getStyleName().equals("P1"));
////Assert.assertTrue("The number in the start was " + componentCount1a + " and the number in end was '" + componentCount1b + "'", componentCount1a == componentCount1b);
////Assert.assertTrue("The number before saving was " + componentCount2a + " and the number after reload was '" + componentCount2b + "'", componentCount2a == componentCount2b);
		} catch (Exception e) {
			Logger.getLogger(LoadSaveTest.class.getName()).log(Level.SEVERE, e.getMessage(), e);
			Assert.fail(e.getMessage());
		}
	}
}