/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.client;

import java.util.UUID;

import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.office.calcengine.JCalcDocument;

//=============================================================================
public class CalcEngineHandleGenerator
{
	//-------------------------------------------------------------------------
	public static final String JSONKEY_DOCUMENT_HANDLE = "document-handle";
	
	//-------------------------------------------------------------------------
	private CalcEngineHandleGenerator ()
	{}

	//-------------------------------------------------------------------------
	public static String newHandle ()
	    throws Exception
	{
		final String sHandle = UUID.randomUUID().toString();
		return sHandle;
	}

	//-------------------------------------------------------------------------
	public static boolean validateHandle (final String sHandle)
	    throws Exception
	{
		try
		{
			UUID.fromString(sHandle);
			return true;
		}
		catch (Throwable ex)
		{}

		return false;
	}

	//-------------------------------------------------------------------------
	/** @return the corresponding document handle of the given JSON expression.
	 * 
	 *  @param  aJson [IN]
	 *  		the JSON expression to be parsed here.
	 * 
	 *  @throws an exception in case JSON expression couldn't be parsed successfully. 
	 */
	public static String fromJSON (final JSONObject aJson)
		throws Exception
	{
        final String sHandle = aJson.getString(JSONKEY_DOCUMENT_HANDLE);
        validateHandle (sHandle);
        return sHandle;
	}

    //-------------------------------------------------------------------------
	/** @return the corresponding document handle of the given JSON expression.
	 * 
	 *  @param  sJson [IN]
	 *  		the JSON expression to be parsed here.
	 * 
	 *  @throws an exception in case JSON expression couldn't be parsed successfully. 
	 */
    public static String fromJSON (final String sJson)
		throws Exception
    {
        final String sHandle = fromJSON (new JSONObject(sJson));
        return sHandle;
    }

    //-------------------------------------------------------------------------
	/** @return the JSON expression of the given document handle.
     *  
	 *  @param 	sHandle [IN]
	 *  		the document handle.
	 * 
     *  @note return NULL in case json expression couldnt be created successfully.
	 */
    public static String toJSON (final String sHandle)
   		throws Exception
    {
    	validateHandle (sHandle);

        JSONObject aJson = new JSONObject();
        aJson.put(JSONKEY_DOCUMENT_HANDLE, sHandle);

        final String sJson = aJson.toString();
        return sJson;
    }
}
