/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.client.impl;

import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

import com.openexchange.office.calcengine.CalcEngineNativeWrapper;
import com.openexchange.office.calcengine.JOperation;
import com.openexchange.office.calcengine.client.CalcEngineHandleGenerator;
import com.openexchange.office.calcengine.client.ICalcEngineClient;

//=============================================================================
/** Run the calc engine inline within the current process.
 *  Call chain will be the following :
 *  
 *  <ul>
 *  <li>calli</li>
 *  <li>-> ICalcEngineClient</li>
 *  <li>-> CalcEngineClientInline</li>
 *  <li>-> CalcDocumentNativeWrapper</li>
 *  <li>-> JCalcDocumentWrapper (JNI)</li>
 *  <li>...</li>
 *  <li>-> (JNI) libcalcengine.so</li>
 *  </ul>
 */
public class CalcEngineClientInline implements ICalcEngineClient
{
    //-------------------------------------------------------------------------
    private static final Log LOG = LogFactory.getLog(CalcEngineClientInline.class);

    //-------------------------------------------------------------------------
	private static final boolean IGNORE_ERRORS = true;
	
    //-------------------------------------------------------------------------
    private CalcEngineClientInline ()
        throws Exception
    {}
    
    //-------------------------------------------------------------------------
    public synchronized static CalcEngineClientInline create()
        throws Exception
    {
    	return new CalcEngineClientInline ();
    }

    //-------------------------------------------------------------------------
    @Override
    public String createDocument()
        throws Exception
    {
        String sHandle = CalcEngineHandleGenerator.newHandle();
        mem_Engine ().createDocument(sHandle);
        return sHandle;
    };
    
    //-------------------------------------------------------------------------
    @Override
    public void destroyDocument(final String sHandle)
        throws Exception
    {
        boolean bOK = mem_Engine ().destroyDocument(sHandle);
        
        if (! bOK)
        	impl_handleError ("Operation failed with FALSE.");
    };

    //-------------------------------------------------------------------------
    @Override
    public String executeOperation(final String sHandle       ,
                                   final String sOperationJSON)
        throws Exception
    {
        impl_validateHandleAndFail (sHandle);
        JOperation    aOp     = new JOperation    (new JSONObject(sOperationJSON));
        boolean       bOK     = mem_Engine ().executeOperation(sHandle, aOp);
        
        if (! bOK)
        	impl_handleError ("Operation failed with FALSE.");

        String sResultJSON = aOp.getResult().toString();
        return sResultJSON;
    };
    
    //-------------------------------------------------------------------------
    @Override
    public String getVersion() 
        throws Exception
    {
        return mem_Engine ().getVersion();
    }
    //-------------------------------------------------------------------------
    private void impl_validateHandleAndFail (final String sHandle)
        throws Exception
    {
        Validate.isTrue(CalcEngineHandleGenerator.validateHandle(sHandle), "'"+sHandle+"' is an invalid handle.");
    }
    
    //-------------------------------------------------------------------------
    private void impl_handleError (final String sMessage)
        throws Exception
    {
    	if (IGNORE_ERRORS)
    		LOG.error (sMessage);
    	else
    		throw new Exception (sMessage);
    }
    
    //-------------------------------------------------------------------------
    private CalcEngineNativeWrapper mem_Engine ()
       throws Exception
    {
        if (m_aEngine == null)
            m_aEngine = new CalcEngineNativeWrapper ();
        return m_aEngine;
    }
    
    //-------------------------------------------------------------------------
    private CalcEngineNativeWrapper m_aEngine = null;
}