/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/format/documentstyles',
    ['io.ox/office/framework/model/format/documentstyles'
    ], function (DocumentStyles) {

    'use strict';

    var // default values of spreadsheet document attributes
        SPREADSHEET_DOCUMENT_ATTRIBUTES = {};

    // class SpreadsheetDocumentStyles ========================================

    /**
     * Provides the style sheet containers for all attribute families used in a
     * spreadsheet document, and other containers collecting special formatting
     * information for the spreadsheet document.
     *
     * @constructor
     *
     * @extends DocumentStyles
     *
     * @param {SpreadsheetApplication} app
     *  The root application instance.
     */
    function SpreadsheetDocumentStyles(app) {

        // base constructor ---------------------------------------------------

        DocumentStyles.call(this, app, SPREADSHEET_DOCUMENT_ATTRIBUTES);

        // initialization -----------------------------------------------------

    } // class SpreadsheetDocumentStyles

    // exports ================================================================

    // derive this class from class DocumentStyles
    return DocumentStyles.extend({ constructor: SpreadsheetDocumentStyles });

});
