/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth.filters;

import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import net.oauth.OAuthProblemException;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oauth.data.OAuthContext;
import org.apache.cxf.rs.security.oauth.filters.AbstractAuthFilter;
import org.apache.cxf.rs.security.oauth.filters.OAuthInfo;
import org.apache.cxf.security.SecurityContext;

@Provider
public class OAuthRequestFilter
extends AbstractAuthFilter
implements RequestHandler {
    @Context
    private MessageContext mc;

    public Response handleRequest(Message m, ClassResourceInfo resourceClass) {
        try {
            OAuthInfo info = this.handleOAuthRequest(this.mc.getHttpServletRequest());
            this.setSecurityContext(m, info);
        }
        catch (OAuthProblemException e) {
            return Response.status((int)401).header("WWW-Authenticate", (Object)"OAuth").build();
        }
        catch (Exception e) {
            return Response.status((int)401).header("WWW-Authenticate", (Object)"OAuth").build();
        }
        return null;
    }

    private void setSecurityContext(Message m, OAuthInfo info) {
        SecurityContext sc = this.createSecurityContext(this.mc.getHttpServletRequest(), info);
        m.setContent(SecurityContext.class, sc);
        m.setContent(OAuthContext.class, this.createOAuthContext(info));
    }
}

