/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.io.UnsupportedEncodingException;
import org.glassfish.grizzly.http.util.DataChunk;

public final class Method {
    public static final Method OPTIONS = new Method("OPTIONS", PayloadExpectation.ALLOWED);
    public static final Method GET = new Method("GET", PayloadExpectation.NOT_ALLOWED);
    public static final Method HEAD = new Method("HEAD", PayloadExpectation.NOT_ALLOWED);
    public static final Method POST = new Method("POST", PayloadExpectation.ALLOWED);
    public static final Method PUT = new Method("PUT", PayloadExpectation.ALLOWED);
    public static final Method DELETE = new Method("DELETE", PayloadExpectation.NOT_ALLOWED);
    public static final Method TRACE = new Method("TRACE", PayloadExpectation.NOT_ALLOWED);
    public static final Method CONNECT = new Method("CONNECT", PayloadExpectation.NOT_ALLOWED);
    public static final Method PATCH = new Method("PATCH", PayloadExpectation.ALLOWED);
    private final String methodString;
    private final byte[] methodBytes;
    private final PayloadExpectation payloadExpectation;

    public static Method CUSTOM(String methodName) {
        return Method.CUSTOM(methodName, PayloadExpectation.ALLOWED);
    }

    public static Method CUSTOM(String methodName, PayloadExpectation payloadExpectation) {
        return new Method(methodName, payloadExpectation);
    }

    public static Method parseDataChunk(DataChunk methodC) {
        return Method.valueOf(methodC);
    }

    public static Method valueOf(DataChunk methodC) {
        if (methodC.equals(GET.getMethodString())) {
            return GET;
        }
        if (methodC.equals(POST.getMethodString())) {
            return POST;
        }
        if (methodC.equals(HEAD.getMethodString())) {
            return HEAD;
        }
        if (methodC.equals(PUT.getMethodString())) {
            return PUT;
        }
        if (methodC.equals(DELETE.getMethodString())) {
            return DELETE;
        }
        if (methodC.equals(TRACE.getMethodString())) {
            return TRACE;
        }
        if (methodC.equals(CONNECT.getMethodString())) {
            return CONNECT;
        }
        if (methodC.equals(OPTIONS.getMethodString())) {
            return OPTIONS;
        }
        if (methodC.equals(PATCH.getMethodString())) {
            return PATCH;
        }
        return Method.CUSTOM(methodC.toString());
    }

    public static Method valueOf(String method) {
        if (method.equals(GET.getMethodString())) {
            return GET;
        }
        if (method.equals(POST.getMethodString())) {
            return POST;
        }
        if (method.equals(HEAD.getMethodString())) {
            return HEAD;
        }
        if (method.equals(PUT.getMethodString())) {
            return PUT;
        }
        if (method.equals(DELETE.getMethodString())) {
            return DELETE;
        }
        if (method.equals(TRACE.getMethodString())) {
            return TRACE;
        }
        if (method.equals(CONNECT.getMethodString())) {
            return CONNECT;
        }
        if (method.equals(OPTIONS.getMethodString())) {
            return OPTIONS;
        }
        if (method.equals(PATCH.getMethodString())) {
            return PATCH;
        }
        return Method.CUSTOM(method.toString());
    }

    private Method(String methodString, PayloadExpectation payloadExpectation) {
        this.methodString = methodString;
        try {
            this.methodBytes = methodString.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        this.payloadExpectation = payloadExpectation;
    }

    public String getMethodString() {
        return this.methodString;
    }

    public byte[] getMethodBytes() {
        return this.methodBytes;
    }

    public PayloadExpectation getPayloadExpectation() {
        return this.payloadExpectation;
    }

    public String toString() {
        return this.methodString;
    }

    public boolean matchesMethod(String method) {
        return this.methodString.equals(method);
    }

    public static enum PayloadExpectation {
        ALLOWED,
        NOT_ALLOWED,
        UNDEFINED;

    }
}

