/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.api;

import com.facebook.api.ApplicationProperty;
import com.facebook.api.BatchQuery;
import com.facebook.api.ErrorCode;
import com.facebook.api.ExtensibleClient;
import com.facebook.api.FacebookException;
import com.facebook.api.FacebookMethod;
import com.facebook.api.IFacebookMethod;
import com.facebook.api.MarketListingCategory;
import com.facebook.api.MarketListingSubcategory;
import com.facebook.api.Pair;
import com.facebook.api.schema.Listing;
import com.facebook.api.schema.MarketplaceGetListingsResponse;
import com.facebook.api.schema.MarketplaceGetSubCategoriesResponse;
import com.facebook.api.schema.MarketplaceSearchResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.json.JSONArray;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class FacebookXmlRestClient
extends ExtensibleClient<Document> {
    protected boolean namespaceAware = true;
    private static final Map<FacebookMethod, String> RETURN_TYPES = new HashMap<FacebookMethod, String>();

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean v) {
        this.namespaceAware = v;
    }

    public FacebookXmlRestClient(String apiKey, String secret) {
        super(apiKey, secret);
    }

    public FacebookXmlRestClient(String apiKey, String secret, int connectionTimeout) {
        super(apiKey, secret, connectionTimeout);
    }

    public FacebookXmlRestClient(String apiKey, String secret, String sessionKey) {
        super(apiKey, secret, sessionKey);
    }

    public FacebookXmlRestClient(String apiKey, String secret, String sessionKey, int connectionTimeout) {
        super(apiKey, secret, sessionKey, connectionTimeout);
    }

    public FacebookXmlRestClient(String serverAddr, String apiKey, String secret, String sessionKey) throws MalformedURLException {
        super(serverAddr, apiKey, secret, sessionKey);
    }

    public FacebookXmlRestClient(String serverAddr, String apiKey, String secret, String sessionKey, int connectionTimeout) throws MalformedURLException {
        super(serverAddr, apiKey, secret, sessionKey, connectionTimeout);
    }

    public FacebookXmlRestClient(URL serverUrl, String apiKey, String secret, String sessionKey) {
        super(serverUrl, apiKey, secret, sessionKey);
    }

    public FacebookXmlRestClient(URL serverUrl, String apiKey, String secret, String sessionKey, int connectionTimeout) {
        super(serverUrl, apiKey, secret, sessionKey, connectionTimeout, -1);
    }

    public FacebookXmlRestClient(URL serverUrl, String apiKey, String secret, String sessionKey, int connectionTimeout, int readTimeout) {
        super(serverUrl, apiKey, secret, sessionKey, connectionTimeout, readTimeout);
    }

    @Override
    public String getResponseFormat() {
        return "xml";
    }

    @Override
    public String extractString(Document d) {
        if (d == null) {
            return null;
        }
        return d.getFirstChild().getTextContent();
    }

    @Override
    public String auth_getSession(String authToken) throws FacebookException, IOException {
        if (null != this._sessionKey) {
            return this._sessionKey;
        }
        Document d = (Document)this.callMethod((IFacebookMethod)FacebookMethod.AUTH_GET_SESSION, new Pair<String, String>("auth_token", authToken.toString()));
        this._sessionKey = d.getElementsByTagName("session_key").item(0).getFirstChild().getTextContent();
        this._userId = Integer.parseInt(d.getElementsByTagName("uid").item(0).getFirstChild().getTextContent());
        this._expires = Long.parseLong(d.getElementsByTagName("expires").item(0).getFirstChild().getTextContent());
        if (this._isDesktop) {
            this._sessionSecret = d.getElementsByTagName("secret").item(0).getFirstChild().getTextContent();
        }
        return this._sessionKey;
    }

    @Override
    protected Document parseCallResult(InputStream data, IFacebookMethod method) throws FacebookException, IOException {
        try {
            NodeList errors;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(this.namespaceAware);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(data);
            doc.normalizeDocument();
            FacebookXmlRestClient.stripEmptyTextNodes(doc);
            if (this.isDebug()) {
                FacebookXmlRestClient.printDom(doc, method.methodName() + "| ");
            }
            if ((errors = doc.getElementsByTagName("error_response")).getLength() > 0) {
                int errorCode = Integer.parseInt(errors.item(0).getFirstChild().getFirstChild().getTextContent());
                String message = errors.item(0).getFirstChild().getNextSibling().getTextContent();
                throw new FacebookException(errorCode, message);
            }
            return doc;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Trouble configuring XML Parser", ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException("Trouble parsing XML from facebook", ex);
        }
    }

    @Override
    protected URL extractURL(Document doc) throws IOException {
        if (doc == null) {
            return null;
        }
        String url = doc.getFirstChild().getTextContent();
        return null == url || "".equals(url) ? null : new URL(url);
    }

    @Override
    protected int extractInt(Document doc) {
        if (doc == null) {
            return 0;
        }
        return Integer.parseInt(doc.getFirstChild().getTextContent());
    }

    @Override
    protected Long extractLong(Document doc) {
        if (doc == null) {
            return 0L;
        }
        return Long.parseLong(doc.getFirstChild().getTextContent());
    }

    private static void stripEmptyTextNodes(Node n) {
        NodeList children = n.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node c = children.item(i);
            if (!c.hasChildNodes() && c.getNodeType() == 3 && c.getTextContent().trim().length() == 0) {
                n.removeChild(c);
                --i;
                --length;
                children = n.getChildNodes();
                continue;
            }
            FacebookXmlRestClient.stripEmptyTextNodes(c);
        }
    }

    public static void printDom(Node n, String prefix) {
        String outString = prefix;
        outString = n.getNodeType() == 3 ? outString + "'" + n.getTextContent().trim() + "'" : outString + n.getNodeName();
        if (DEBUG) {
            System.out.println(outString);
        }
        NodeList children = n.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            FacebookXmlRestClient.printDom(children.item(i), prefix + "  ");
        }
    }

    @Override
    public String data_getUserPreference(Integer prefId) throws FacebookException, IOException {
        throw new FacebookException(ErrorCode.GEN_UNKNOWN_METHOD, "The FacebookJsonRestClient does not support this API call.  Please use an instance of FacebookRestClient instead.");
    }

    @Override
    public Map<Integer, String> data_getUserPreferences() throws FacebookException, IOException {
        throw new FacebookException(ErrorCode.GEN_UNKNOWN_METHOD, "The FacebookJsonRestClient does not support this API call.  Please use an instance of FacebookRestClient instead.");
    }

    @Override
    public void data_setUserPreference(Integer prefId, String value) throws FacebookException, IOException {
        throw new FacebookException(ErrorCode.GEN_UNKNOWN_METHOD, "The FacebookJsonRestClient does not support this API call.  Please use an instance of FacebookRestClient instead.");
    }

    @Override
    public void data_setUserPreferences(Map<Integer, String> values, boolean replace) throws FacebookException, IOException {
        throw new FacebookException(ErrorCode.GEN_UNKNOWN_METHOD, "The FacebookJsonRestClient does not support this API call.  Please use an instance of FacebookRestClient instead.");
    }

    @Override
    public List<Listing> marketplace_getListings(List<Long> listingIds, List<Long> uids) throws FacebookException, IOException {
        this.marketplace_getListings(listingIds, uids);
        MarketplaceGetListingsResponse resp = (MarketplaceGetListingsResponse)this.getResponsePOJO();
        return resp.getListing();
    }

    @Override
    public List<String> marketplace_getSubCategories() throws FacebookException, IOException {
        this.marketplace_getSubCategories(null);
        MarketplaceGetSubCategoriesResponse resp = (MarketplaceGetSubCategoriesResponse)this.getResponsePOJO();
        return resp.getMarketplaceSubcategory();
    }

    @Override
    public List<Listing> marketplace_search(MarketListingCategory category, MarketListingSubcategory subcategory, String searchTerm) throws FacebookException, IOException {
        this.marketplace_search(category.getName(), subcategory.getName(), (CharSequence)searchTerm);
        MarketplaceSearchResponse resp = (MarketplaceSearchResponse)this.getResponsePOJO();
        return resp.getListing();
    }

    @Override
    public String admin_getAppPropertiesAsString(Collection<ApplicationProperty> properties) throws FacebookException, IOException {
        if (this._isDesktop) {
            throw new FacebookException(ErrorCode.GEN_PERMISSIONS_ERROR, "Desktop applications cannot use 'admin.getAppProperties'");
        }
        JSONArray props = new JSONArray();
        for (ApplicationProperty property : properties) {
            props.put((Object)property.getName());
        }
        Document d = (Document)this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_APP_PROPERTIES, new Pair<String, String>("properties", props.toString()));
        return this.extractString(d);
    }

    @Override
    public List<? extends Object> executeBatch(boolean serial) throws FacebookException, IOException {
        this.batchMode = false;
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<BatchQuery> buffer = new ArrayList<BatchQuery>();
        while (!this.queries.isEmpty()) {
            buffer.add((BatchQuery)this.queries.remove(0));
            if (buffer.size() != 15 && !this.queries.isEmpty()) continue;
            Document doc = (Document)this.batch_run(this.encodeMethods(buffer), serial);
            NodeList responses = doc.getElementsByTagName("batch_run_response_elt");
            for (int count = 0; count < responses.getLength(); ++count) {
                String response = FacebookXmlRestClient.extractNodeString(responses.item(count));
                try {
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document respDoc = builder.parse(new ByteArrayInputStream(response.getBytes("UTF-8")));
                    String type = RETURN_TYPES.get(((BatchQuery)buffer.get(count)).getMethod());
                    if (type.equals("default")) {
                        result.add(respDoc);
                        continue;
                    }
                    if (type.equals("string")) {
                        result.add(this.extractString(respDoc));
                        continue;
                    }
                    if (type.equals("bool")) {
                        result.add(this.extractBoolean(respDoc));
                        continue;
                    }
                    if (type.equals("int")) {
                        result.add(this.extractInt(respDoc));
                        continue;
                    }
                    if (type.equals("long")) {
                        result.add(Long.valueOf(this.extractInt(respDoc)));
                        continue;
                    }
                    result.add(null);
                    continue;
                }
                catch (Exception ignored) {
                    if (result.size() >= count + 1) continue;
                    result.add(null);
                }
            }
        }
        return result;
    }

    public static String extractNodeString(Node d) {
        if (d == null) {
            return null;
        }
        return d.getFirstChild().getTextContent();
    }

    static {
        Method[] candidates = FacebookXmlRestClient.class.getMethods();
        block0: for (FacebookMethod method : EnumSet.allOf(FacebookMethod.class)) {
            String name = method.methodName();
            name = name.substring(name.indexOf(".") + 1);
            name = name.replace(".", "_");
            for (Method candidate : candidates) {
                if (!candidate.getName().equalsIgnoreCase(name)) continue;
                String typeName = candidate.getReturnType().getName().toLowerCase();
                if (typeName.indexOf("document") != -1) {
                    RETURN_TYPES.put(method, "default");
                    continue block0;
                }
                if (typeName.indexOf("string") != -1) {
                    RETURN_TYPES.put(method, "string");
                    continue block0;
                }
                if (typeName.indexOf("bool") != -1) {
                    RETURN_TYPES.put(method, "bool");
                    continue block0;
                }
                if (typeName.indexOf("long") != -1) {
                    RETURN_TYPES.put(method, "long");
                    continue block0;
                }
                if (typeName.indexOf("int") != -1) {
                    RETURN_TYPES.put(method, "int");
                    continue block0;
                }
                if (typeName.indexOf("applicationpropertyset") != -1 || typeName.indexOf("list") != -1 || typeName.indexOf("url") != -1 || typeName.indexOf("map") != -1 || typeName.indexOf("object") != -1) {
                    RETURN_TYPES.put(method, "default");
                    continue block0;
                }
                RETURN_TYPES.put(method, "void");
                continue block0;
            }
        }
    }
}

