/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.api;

import com.facebook.api.ApplicationProperty;
import com.facebook.api.BatchQuery;
import com.facebook.api.ErrorCode;
import com.facebook.api.ExtensibleClient;
import com.facebook.api.FacebookException;
import com.facebook.api.FacebookMethod;
import com.facebook.api.IFacebookMethod;
import com.facebook.api.MarketListingCategory;
import com.facebook.api.MarketListingSubcategory;
import com.facebook.api.Pair;
import com.facebook.api.schema.Listing;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookJsonRestClient
extends ExtensibleClient<Object> {
    private static final Map<FacebookMethod, String> RETURN_TYPES = new HashMap<FacebookMethod, String>();

    public FacebookJsonRestClient(String apiKey, String secret) {
        super(apiKey, secret);
    }

    public FacebookJsonRestClient(String apiKey, String secret, int connectionTimeout) {
        super(apiKey, secret, connectionTimeout);
    }

    public FacebookJsonRestClient(String apiKey, String secret, String sessionKey) {
        super(apiKey, secret, sessionKey);
    }

    public FacebookJsonRestClient(String apiKey, String secret, String sessionKey, int connectionTimeout) {
        super(apiKey, secret, sessionKey, connectionTimeout);
    }

    public FacebookJsonRestClient(String serverAddr, String apiKey, String secret, String sessionKey) throws MalformedURLException {
        super(serverAddr, apiKey, secret, sessionKey);
    }

    public FacebookJsonRestClient(String serverAddr, String apiKey, String secret, String sessionKey, int connectionTimeout) throws MalformedURLException {
        super(serverAddr, apiKey, secret, sessionKey, connectionTimeout);
    }

    public FacebookJsonRestClient(URL serverUrl, String apiKey, String secret, String sessionKey) {
        super(serverUrl, apiKey, secret, sessionKey);
    }

    public FacebookJsonRestClient(URL serverUrl, String apiKey, String secret, String sessionKey, int connectionTimeout) {
        super(serverUrl, apiKey, secret, sessionKey, connectionTimeout, -1);
    }

    public FacebookJsonRestClient(URL serverUrl, String apiKey, String secret, String sessionKey, int connectionTimeout, int readTimeout) {
        super(serverUrl, apiKey, secret, sessionKey, connectionTimeout, readTimeout);
    }

    @Override
    public String getResponseFormat() {
        return "json";
    }

    @Override
    public String extractString(Object val) {
        if (val == null) {
            return null;
        }
        try {
            return (String)val;
        }
        catch (ClassCastException cce) {
            this.logException(cce);
            return null;
        }
    }

    @Override
    public String auth_getSession(String authToken) throws FacebookException, IOException {
        if (null != this._sessionKey) {
            return this._sessionKey;
        }
        JSONObject d = (JSONObject)this.callMethod((IFacebookMethod)FacebookMethod.AUTH_GET_SESSION, new Pair<String, String>("auth_token", authToken.toString()));
        try {
            this._sessionKey = (String)d.get("session_key");
            Object uid = d.get("uid");
            Object expires = d.get("expires");
            try {
                this._userId = (Long)uid;
            }
            catch (ClassCastException cce) {
                this._userId = Long.parseLong((String)uid);
            }
            try {
                this._expires = Long.parseLong(expires.toString());
            }
            catch (ClassCastException cce) {
                this._expires = Long.parseLong((String)expires);
            }
            if (this.isDesktop()) {
                this._sessionSecret = (String)d.get("secret");
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        return this._sessionKey;
    }

    @Override
    protected Object parseCallResult(InputStream data, IFacebookMethod method) throws FacebookException, IOException {
        Object json;
        block15: {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(data, "UTF-8"));
            StringBuffer buffer = new StringBuffer();
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
            String jsonResp = new String(buffer);
            json = null;
            if (this.rawResponse.matches("[\\{\\[].*[\\}\\]]")) {
                try {
                    if (this.rawResponse.matches("\\{.*\\}")) {
                        json = new JSONObject(jsonResp);
                        break block15;
                    }
                    json = new JSONArray(jsonResp);
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
            } else {
                if (this.rawResponse.startsWith("\"")) {
                    this.rawResponse = this.rawResponse.substring(1);
                }
                if (this.rawResponse.endsWith("\"")) {
                    this.rawResponse = this.rawResponse.substring(0, this.rawResponse.length() - 1);
                }
                try {
                    json = Long.parseLong(this.rawResponse);
                }
                catch (Exception e) {
                    json = this.rawResponse;
                }
            }
        }
        if (this.isDebug()) {
            this.log(method.methodName() + ": " + (null != json ? json.toString() : "null"));
        }
        if (json instanceof JSONObject) {
            JSONObject jsonObj = json;
            try {
                Object errorCode = jsonObj.get("error_code");
                if (errorCode != null) {
                    String message = (String)jsonObj.get("error_msg");
                    Integer code = errorCode instanceof Integer ? (Integer)errorCode : Integer.valueOf(((Long)errorCode).intValue());
                    throw new FacebookException(code, message);
                }
            }
            catch (JSONException ignored) {
                // empty catch block
            }
        }
        return json;
    }

    @Override
    protected URL extractURL(Object url) throws IOException {
        if (url == null) {
            return null;
        }
        if (!(url instanceof String)) {
            return null;
        }
        return null == url || "".equals(url) ? null : new URL((String)url);
    }

    @Override
    protected int extractInt(Object val) {
        if (val == null) {
            return 0;
        }
        try {
            if (val instanceof String) {
                return Integer.parseInt((String)val);
            }
            if (val instanceof Long) {
                return ((Long)val).intValue();
            }
            return (Integer)val;
        }
        catch (ClassCastException cce) {
            this.logException(cce);
            return 0;
        }
    }

    @Override
    protected boolean extractBoolean(Object val) {
        if (val == null) {
            return false;
        }
        try {
            if (val instanceof String) {
                return val != null && (val.equals("true") || val.equals("1"));
            }
            return (Long)val == 1L;
        }
        catch (ClassCastException cce) {
            this.logException(cce);
            return false;
        }
    }

    @Override
    protected Long extractLong(Object val) {
        if (val == null) {
            return 0L;
        }
        try {
            if (val instanceof String) {
                return Long.parseLong((String)val);
            }
            return (Long)val;
        }
        catch (ClassCastException cce) {
            this.logException(cce);
            return null;
        }
    }

    @Override
    public String data_getUserPreference(Integer prefId) throws FacebookException, IOException {
        throw new FacebookException(ErrorCode.GEN_UNKNOWN_METHOD, "The FacebookJsonRestClient does not support this API call.  Please use an instance of FacebookRestClient instead.");
    }

    @Override
    public Map<Integer, String> data_getUserPreferences() throws FacebookException, IOException {
        throw new FacebookException(ErrorCode.GEN_UNKNOWN_METHOD, "The FacebookJsonRestClient does not support this API call.  Please use an instance of FacebookRestClient instead.");
    }

    @Override
    public void data_setUserPreference(Integer prefId, String value) throws FacebookException, IOException {
        throw new FacebookException(ErrorCode.GEN_UNKNOWN_METHOD, "The FacebookJsonRestClient does not support this API call.  Please use an instance of FacebookRestClient instead.");
    }

    @Override
    public void data_setUserPreferences(Map<Integer, String> values, boolean replace) throws FacebookException, IOException {
        throw new FacebookException(ErrorCode.GEN_UNKNOWN_METHOD, "The FacebookJsonRestClient does not support this API call.  Please use an instance of FacebookRestClient instead.");
    }

    @Override
    public List<Listing> marketplace_getListings(List<Long> listingIds, List<Long> uids) throws FacebookException, IOException {
        throw new FacebookException(ErrorCode.GEN_UNKNOWN_METHOD, "The FacebookJsonRestClient does not support this API call.  Please use an instance of FacebookRestClient instead.");
    }

    @Override
    public List<String> marketplace_getSubCategories() throws FacebookException, IOException {
        throw new FacebookException(ErrorCode.GEN_UNKNOWN_METHOD, "The FacebookJsonRestClient does not support this API call.  Please use an instance of FacebookRestClient instead.");
    }

    @Override
    public List<Listing> marketplace_search(MarketListingCategory category, MarketListingSubcategory subcategory, String searchTerm) throws FacebookException, IOException {
        throw new FacebookException(ErrorCode.GEN_UNKNOWN_METHOD, "The FacebookJsonRestClient does not support this API call.  Please use an instance of FacebookRestClient instead.");
    }

    @Override
    public String admin_getAppPropertiesAsString(Collection<ApplicationProperty> properties) throws FacebookException, IOException {
        if (this._isDesktop) {
            throw new FacebookException(ErrorCode.GEN_PERMISSIONS_ERROR, "Desktop applications cannot use 'admin.getAppProperties'");
        }
        JSONArray props = new JSONArray();
        for (ApplicationProperty property : properties) {
            props.put((Object)property.getName());
        }
        this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_APP_PROPERTIES, new Pair<String, String>("properties", props.toString()));
        return this.rawResponse;
    }

    @Override
    public List<? extends Object> executeBatch(boolean serial) throws FacebookException, IOException {
        this.batchMode = false;
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<BatchQuery> buffer = new ArrayList<BatchQuery>();
        while (!this.queries.isEmpty()) {
            buffer.add((BatchQuery)this.queries.remove(0));
            if (buffer.size() != 15 && !this.queries.isEmpty()) continue;
            JSONArray doc = (JSONArray)this.batch_run(this.encodeMethods(buffer), serial);
            for (int count = 0; count < doc.length(); ++count) {
                try {
                    String type;
                    String response = (String)doc.get(count);
                    if (response.startsWith("\"")) {
                        response = response.substring(1, response.length() - 1);
                    }
                    if ((type = RETURN_TYPES.get(((BatchQuery)buffer.get(count)).getMethod())).equals("default")) {
                        if (response.matches("\\{.*\\}")) {
                            result.add(new JSONObject(response.replace("\\", "")));
                            continue;
                        }
                        result.add(new JSONArray(response));
                        continue;
                    }
                    if (type.equals("string")) {
                        result.add(response);
                        continue;
                    }
                    if (type.equals("bool")) {
                        result.add(this.extractBoolean(response));
                        continue;
                    }
                    if (type.equals("int")) {
                        result.add(this.extractInt(response));
                        continue;
                    }
                    if (type.equals("long")) {
                        result.add(this.extractLong(response));
                        continue;
                    }
                    result.add(null);
                    continue;
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                    if (result.size() >= count + 1) continue;
                    result.add(null);
                }
            }
        }
        return result;
    }

    static {
        Method[] candidates = FacebookJsonRestClient.class.getMethods();
        block0: for (FacebookMethod method : EnumSet.allOf(FacebookMethod.class)) {
            String name = method.methodName();
            name = name.substring(name.indexOf(".") + 1);
            name = name.replace(".", "_");
            for (Method candidate : candidates) {
                if (!candidate.getName().equalsIgnoreCase(name)) continue;
                String typeName = candidate.getReturnType().getName().toLowerCase();
                if (typeName.indexOf("object") != -1) {
                    RETURN_TYPES.put(method, "default");
                    continue block0;
                }
                if (typeName.indexOf("string") != -1) {
                    RETURN_TYPES.put(method, "string");
                    continue block0;
                }
                if (typeName.indexOf("bool") != -1) {
                    RETURN_TYPES.put(method, "bool");
                    continue block0;
                }
                if (typeName.indexOf("long") != -1) {
                    RETURN_TYPES.put(method, "long");
                    continue block0;
                }
                if (typeName.indexOf("int") != -1) {
                    RETURN_TYPES.put(method, "int");
                    continue block0;
                }
                if (typeName.indexOf("applicationpropertyset") != -1 || typeName.indexOf("list") != -1 || typeName.indexOf("url") != -1 || typeName.indexOf("map") != -1 || typeName.indexOf("object") != -1) {
                    RETURN_TYPES.put(method, "default");
                    continue block0;
                }
                RETURN_TYPES.put(method, "void");
                continue block0;
            }
        }
    }
}

